/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model;

import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.GeoNamesLine;
import org.tip.flatdb4geonames.model.index.FeatureClass;
import org.tip.flatdb4geonames.model.index.FeatureClasses;

public class GeoNamesLines
extends ArrayList<GeoNamesLine> {
    private static final long serialVersionUID = 8370145125552994190L;
    private static Logger logger = LoggerFactory.getLogger(GeoNamesLines.class);

    public GeoNamesLines() {
    }

    public GeoNamesLines(int capacity) {
        super(capacity);
    }

    public boolean containsGeoNameId(long geoNameId) {
        boolean result = this.getByGeoNameId(geoNameId) != null;
        return result;
    }

    public GeoNamesLines getByFeatureClass(FeatureClass criteria) {
        GeoNamesLines result = new GeoNamesLines();
        for (GeoNamesLine toponym : this) {
            if (toponym.getFeatureClass() != criteria) continue;
            result.add(toponym);
        }
        return result;
    }

    public GeoNamesLines getByFeatureClasses(FeatureClasses criteria) {
        GeoNamesLines result = new GeoNamesLines();
        for (GeoNamesLine toponym : this) {
            if (!criteria.contains(toponym.getFeatureClass())) continue;
            result.add(toponym);
        }
        return result;
    }

    public GeoNamesLine getByGeoNameId(long geoNameId) {
        boolean ended = false;
        Iterator iterator = this.iterator();
        GeoNamesLine result = null;
        while (!ended) {
            if (iterator.hasNext()) {
                GeoNamesLine line = (GeoNamesLine)iterator.next();
                if (line.getGeoNameId() != geoNameId) continue;
                ended = true;
                result = line;
                continue;
            }
            ended = true;
            result = null;
        }
        return result;
    }
}

