/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model;

import fr.devinsy.util.StringList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesException;
import org.tip.flatdb4geonames.model.GeoNamesLine;
import org.tip.flatdb4geonames.model.GeoNamesLines;
import org.tip.flatdb4geonames.model.index.FeatureClass;

public class GeoNamesLineParser {
    private static Logger logger = LoggerFactory.getLogger(GeoNamesLineParser.class);

    public static GeoNamesLine parse(String source) throws FlatDB4GeoNamesException {
        GeoNamesLine result = new GeoNamesLine();
        String[] tokens = source.split("\t");
        if (!NumberUtils.isDigits((String)tokens[0])) {
            throw new FlatDB4GeoNamesException("Bad line format.");
        }
        result.setGeoNameId(Long.parseLong(tokens[0]));
        result.setName(tokens[1]);
        result.setAsciiName(tokens[2]);
        String[] stringArray = tokens[3].split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String alternateName = stringArray[n2];
            if (StringUtils.isNotBlank((CharSequence)alternateName)) {
                result.getAlternateNames().add(alternateName);
            }
            ++n2;
        }
        if (StringUtils.isNotBlank((CharSequence)tokens[4])) {
            result.setLatitude(Double.parseDouble(tokens[4]));
            result.setLongitude(Double.parseDouble(tokens[5]));
        }
        result.setFeatureClass(FeatureClass.valueOfCode(tokens[6]));
        result.setFeatureCode(tokens[7]);
        result.setCountryCode(tokens[8]);
        stringArray = tokens[9].split(",");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String alternateCountryCode = stringArray[n2];
            if (StringUtils.isNotBlank((CharSequence)alternateCountryCode)) {
                result.getAlternateCountryCodes().add(alternateCountryCode);
            }
            ++n2;
        }
        if (StringUtils.isNotBlank((CharSequence)tokens[10])) {
            result.setAdminCode1(tokens[10]);
        }
        if (StringUtils.isNotBlank((CharSequence)tokens[11])) {
            result.setAdminCode2(tokens[11]);
        }
        if (StringUtils.isNotBlank((CharSequence)tokens[12])) {
            result.setAdminCode3(tokens[12]);
        }
        if (StringUtils.isNotBlank((CharSequence)tokens[13])) {
            result.setAdminCode4(tokens[13]);
        }
        if (StringUtils.isNotBlank((CharSequence)tokens[14])) {
            result.setPopulation(Long.parseLong(tokens[14]));
        }
        if (StringUtils.isNotBlank((CharSequence)tokens[15])) {
            result.setElevation(Integer.parseInt(tokens[15]));
        }
        if (StringUtils.isNotBlank((CharSequence)tokens[16])) {
            result.setElevation(Integer.parseInt(tokens[16]));
        }
        result.setTimeZone(tokens[17]);
        result.setModificationDate(tokens[18]);
        return result;
    }

    public static GeoNamesLines parse(StringList lines) throws FlatDB4GeoNamesException {
        GeoNamesLines result;
        if (lines == null) {
            result = new GeoNamesLines();
        } else {
            result = new GeoNamesLines(lines.size());
            for (String line : lines) {
                result.add(GeoNamesLineParser.parse(line));
            }
        }
        return result;
    }
}

