/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.gui;

import fr.devinsy.util.StringList;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.gui.util.GUIToolBox;
import org.tip.flatdb4geonames.gui.views.FlatDB4GeoNamesWindow;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesException;

public final class FlatDB4GeoNamesGUI {
    private static Logger logger = LoggerFactory.getLogger(FlatDB4GeoNamesGUI.class);
    private File homeDirectory;

    private FlatDB4GeoNamesGUI() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable exception) {
                if (exception instanceof OutOfMemoryError) {
                    logger.error(exception.getMessage(), exception);
                    String message = "Java ran out of memory! Increase it.";
                    JOptionPane.showMessageDialog(null, message, "Error", 0);
                } else if (exception instanceof FlatDB4GeoNamesException) {
                    logger.error(exception.getMessage(), exception);
                    JOptionPane.showMessageDialog(null, exception.getMessage(), "Warning", 2);
                } else {
                    logger.error(exception.getMessage(), exception);
                    StringList message = new StringList();
                    message.append("A system error occured: ");
                    message.appendln(exception.getMessage());
                    message.appendln("Call developer.");
                    JOptionPane.showMessageDialog(null, message.toString(), "System Error", 0);
                }
            }
        });
        this.homeDirectory = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".flatdb4geonames");
        if (!this.homeDirectory.exists()) {
            this.homeDirectory.mkdir();
            logger.info("Home directory created: " + this.homeDirectory.getAbsolutePath());
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        logger.info("System lookAndFeel property: {}", (Object)System.getProperty("swing.defaultlaf"));
        logger.info("Available lookAndFeel: {}", (Object)GUIToolBox.availableLookAndFeels().toString());
        logger.info("System lookAndFeel: {}", (Object)UIManager.getSystemLookAndFeelClassName());
        logger.info("Current lookAndFeel: {}", (Object)UIManager.getLookAndFeel().getName());
        if (!StringUtils.equals((CharSequence)UIManager.getSystemLookAndFeelClassName(), (CharSequence)"javax.swing.plaf.metal.MetalLookAndFeel")) {
            try {
                logger.info("Metal LAF setted and system LAF detected, try to set system LAF.");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                logger.info("Failed to set the system LookAndFeel.");
            }
        } else if (GUIToolBox.availableLookAndFeels().toString().contains("GTK+")) {
            try {
                logger.info("Metal LAF setted and GTK+ LAF detected, try to set GTK+ LAF.");
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
            catch (Exception exception) {
                logger.info("Failed to set the system LookAndFeel.");
            }
        }
        logger.info("Activated lookAndFeel: " + UIManager.getLookAndFeel().getName());
    }

    public void exit() {
        System.exit(0);
    }

    public void run() {
        new FlatDB4GeoNamesWindow().setVisible(true);
    }

    public static FlatDB4GeoNamesGUI instance() {
        FlatDB4GeoNamesGUI result = SingletonLoader.instance;
        return result;
    }

    /* synthetic */ FlatDB4GeoNamesGUI(FlatDB4GeoNamesGUI flatDB4GeoNamesGUI) {
        this();
    }

    private static class SingletonLoader {
        private static final FlatDB4GeoNamesGUI instance = new FlatDB4GeoNamesGUI(null);

        private SingletonLoader() {
        }
    }
}

