/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.cli;

import fr.devinsy.util.StringList;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesException;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesFactory;
import org.tip.flatdb4geonames.model.GeoNamesFlatDatabase;
import org.tip.flatdb4geonames.model.GeoNamesLine;
import org.tip.flatdb4geonames.model.GeoNamesLines;
import org.tip.flatdb4geonames.util.BuildInformation;
import org.tip.flatdb4geonames.util.ToolBox;

public class FlatDB4GeoNamesCLI {
    private static Logger logger = LoggerFactory.getLogger(FlatDB4GeoNamesCLI.class);

    public static void println(GeoNamesLines results) {
        for (GeoNamesLine result : results) {
            System.out.println("-------------------------------------------");
            System.out.println(result.toLine());
        }
    }

    public static void run(String[] args) throws IOException, FlatDB4GeoNamesException {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable exception) {
                if (exception instanceof OutOfMemoryError) {
                    System.err.println("Java ran out of memory! Increase it.");
                    logger.error(exception.getMessage(), exception);
                } else if (exception instanceof FlatDB4GeoNamesException) {
                    System.err.println(exception.getMessage());
                    logger.error(exception.getMessage(), exception);
                } else {
                    System.err.println("A system error occured: " + exception.getMessage());
                    System.err.println("Please, call developers.");
                    logger.error(exception.getMessage(), exception);
                }
            }
        });
        logger.debug("args={}{}", (Object)args.length, (Object)StringList.toStringWithBrackets((String[])args));
        if (args.length == 0) {
            FlatDB4GeoNamesCLI.showHelp();
        } else if (ToolBox.matchAny(args[0], "-h", "-help", "--help")) {
            if (args.length != 1) {
                System.err.println("Bad parameters: " + StringList.toStringWithBrackets((String[])args));
            }
            FlatDB4GeoNamesCLI.showHelp();
        } else if (StringUtils.equals((CharSequence)args[0], (CharSequence)"download")) {
            if (args.length == 1) {
                FlatDB4GeoNamesFactory.downloadGeoNamesFiles(new File(System.getProperty("user.dir")));
            } else if (args.length == 2) {
                FlatDB4GeoNamesFactory.downloadGeoNamesFiles(ToolBox.normalizePath(args[1]));
            } else {
                System.err.println("Bad parameters: " + StringList.toStringWithBrackets((String[])args));
                FlatDB4GeoNamesCLI.showHelp();
            }
        } else if (StringUtils.equals((CharSequence)args[0], (CharSequence)"buildIndex")) {
            if (args.length == 1) {
                FlatDB4GeoNamesFactory.buildIndex(new File(System.getProperty("user.dir")));
            } else if (args.length == 2) {
                FlatDB4GeoNamesFactory.buildIndex(ToolBox.normalizePath(args[1]));
            } else {
                System.err.println("Bad parameters: " + StringList.toStringWithBrackets((String[])args));
                FlatDB4GeoNamesCLI.showHelp();
            }
        } else if (StringUtils.equals((CharSequence)args[0], (CharSequence)"create")) {
            if (args.length == 1) {
                FlatDB4GeoNamesFactory.create(new File(System.getProperty("user.dir")));
            } else if (args.length == 2) {
                FlatDB4GeoNamesFactory.create(ToolBox.normalizePath(args[1]));
            } else {
                System.err.println("Bad parameters: " + StringList.toStringWithBrackets((String[])args));
                FlatDB4GeoNamesCLI.showHelp();
            }
        } else if (StringUtils.equals((CharSequence)args[0], (CharSequence)"search")) {
            if (args.length == 2) {
                GeoNamesFlatDatabase database = FlatDB4GeoNamesFactory.open(new File(System.getProperty("user.dir")));
                GeoNamesLines results = database.search(args[1]);
                FlatDB4GeoNamesCLI.println(results);
                database.close();
            } else if (args.length == 3) {
                GeoNamesFlatDatabase database = FlatDB4GeoNamesFactory.open(ToolBox.normalizePath(args[1]));
                GeoNamesLines results = database.search(args[2]);
                FlatDB4GeoNamesCLI.println(results);
                database.close();
            } else {
                System.err.println("Bad parameters: " + StringList.toStringWithBrackets((String[])args));
                FlatDB4GeoNamesCLI.showHelp();
            }
        } else {
            System.err.println("Bad parameters: " + StringList.toStringWithBrackets((String[])args));
            FlatDB4GeoNamesCLI.showHelp();
        }
    }

    public static void showHelp() {
        StringList message = new StringList();
        message.append("FlatDB4GeoNames, version ").append(new BuildInformation().version());
        message.append(", JVM ").append(System.getProperty("java.version"));
        message.append(", ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append(" ").append(System.getProperty("sun.arch.data.model")).appendln("bits");
        message.appendln();
        message.appendln("FlatDB4GeoNames provides an easy, local and fast Java access to GeoNames data.");
        message.appendln();
        message.appendln("Usage:");
        message.appendln("        flatdb4geonames                                  run FlatDB4GeoNames GUI");
        message.appendln("        flatdb4geonames [ -h | -help | --help\u00a0]          display this help message");
        message.appendln("        flatdb4geonames download [directory]             download GeoNames files");
        message.appendln("        flatdb4geonames buildIndex [directory]           build FlatDB4GeoNames indexes");
        message.appendln("        flatdb4geonames create [directory]               download + buildIndex");
        message.appendln("        flatdb4geonames search [directory] input         search input in FlatDB4GeoNames database");
        message.appendln();
        message.appendln("If directory is not set, the current directory is defined as the FlatDB4GeoNames database location.");
        System.out.println(message.toString());
    }
}

