package org.tip.puck.spacetime.workers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.graphs.GeoNetworkUtils;
import org.tip.puck.geo2.Geography2;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.workers.GeocodingWorker;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphMaker;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphReporter;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.matrix.Matrix;
import org.tip.puck.matrix.MatrixStatistics.Indicator;
import org.tip.puck.matrix.MatrixStatistics.Mode;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator.Sorting;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.RelationWorker;
import org.tip.puck.net.relations.workers.RelationWorker.TransformationType;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Intervals;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionCriteria.PartitionType;
import org.tip.puck.partitions.PartitionCriteria.SizeFilter;
import org.tip.puck.partitions.PartitionCriteria.ValueFilter;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportChart.GraphType;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.CorrelationMatrix;
import org.tip.puck.spacetime.EventTriangle;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.EgoRelationSequence;
import org.tip.puck.spacetime.EgoRelationSequences;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.Sequences;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria.CensusType;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria.EgoNetworksOperation;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria.ParcoursNetworksOperation;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria.RelationClassificationType;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria.SequenceReportType;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria.TrajectoriesOperation;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

import fr.devinsy.util.StringList;

/**
 * 
 * @author Klaus Hamberger
 * 
 */
public class SequenceReporter {

	private static StringList getStories(final Relation event) {
		StringList result;

		result = new StringList();

		for (Attribute attribute : event.attributes()) {
			String story = "";
			if (attribute.getLabel().contains("NOTE")) {
				String[] label = attribute.getLabel().split("_");
				if (label.length > 1 && StringUtils.isNumeric(label[1])) {
					int id = Integer.parseInt(label[1]);
					Individual indi = event.getIndividuals().getById(id);
					story += indi.signature() + ": ";
				}
				story += attribute.getValue();
				result.appendln(story);
			}
		}

		//
		return result;
	}
	

	/**
	 * 
	 * @param segmentation
	 * @param criteria
	 * @param bundle
	 * @return
	 */
	public static Report reportDiscontinuousItineraries(final Segmentation segmentation, final SpaceTimeCriteria criteria, final ResourceBundle bundle) {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		int errorCount = 0;
		StringList errors = new StringList();

		//
		result = new Report();
		result.setTitle("Discontinuous Itineraries");
		result.setOrigin("Control reporter");
		result.setTarget(segmentation.getLabel());

		for (EgoRelationSequence itinerary : SequenceMaker.createPersonalSequences(segmentation, criteria).toSortedList()) {
			EgoRelationSequences partials = SequenceWorker.split(itinerary);
			if (partials.size() > 1) {
				errorCount++;
				errors.appendln(itinerary.getEgo().signature());
				int j = 0;
				for (EgoRelationSequence partial : partials) {
					if (partial.getStations().size() != 0 && j > 0) {
						errors.appendln(partial.getFirstTime() + "\t" + partial.getStations().get(partial.getFirstTime()));
					}
					j++;
				}
				errors.appendln();
			}
		}

		//
		errors.add(0, errorCount + " " + Report.translate(bundle, "Discontinuous Itineraries") + "\n");
		result.outputs().append(errors.toString());

		//
		result.setStatus(errorCount);

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;
	}
	
	/**
	 * 
	 * @param segmentation
	 * @param criteria
	 * @param bundle
	 * @return
	 */
	public static Report reportUnknownRelations(final Segmentation segmentation, final SpaceTimeCriteria criteria, final ResourceBundle bundle) {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		int errorCount = 0;
		StringList errors = new StringList();

		//
		result = new Report();
		result.setTitle("Unknown Relations");
		result.setOrigin("Control reporter");
		result.setTarget(segmentation.getLabel());
		
		Map<Individual,Individuals> unknownRelations = new TreeMap<Individual,Individuals>();
				
		for (EgoRelationSequence itinerary : SequenceMaker.createPersonalSequences(segmentation, criteria).toSortedList()) {
			
			SequenceCensus census = new SequenceCensus(itinerary, criteria);
			
/*			Set<Individual> alters = new HashSet<Individual>();
			for (Relation event : itinerary.getEvents().values()){
				for (Individual alter : event.getIndividuals()){
					alters.add(alter);
				}
			}
			Map<Individual,List<String>> relationsByAlter = NetUtils.getAlterRelations1(itinerary.getEgo(),alters,ToolBox.stringsToInts(criteria.getPattern()),criteria.getRelationModelNames(), criteria.getChainClassification(),null);*/
			
			
			for (Individual alter : census.getAllAlters()){
				if (census.getRelationsByAlter().get(alter).size()==0){
					Individuals unknowns = unknownRelations.get(itinerary.getEgo());
					if (unknowns==null){
						unknowns = new Individuals();
						unknownRelations.put(itinerary.getEgo(), unknowns);
					}
					unknowns.put(alter);
					errorCount++;
				}
			}
		}

		//
		errors.add(0, errorCount + " " + Report.translate(bundle, "Unknown Relations") + "\n");
		for (Individual ego : unknownRelations.keySet()){
			for (Individual alter: unknownRelations.get(ego).toSortedList()){
				errors.add(ego+"\t"+alter+"\n");
			}
		}

		result.outputs().append(errors.toString());

		//
		result.setStatus(errorCount);

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;
	}
	

	/**
	 * 
	 * @param segmentation
	 * @param criteria
	 * @param bundle
	 * @return
	 * @throws PuckException 
	 */
	public static Report reportDiscontinuousBiographies(final Net net, final Segmentation segmentation, final SpaceTimeCriteria criteria, final ResourceBundle bundle) throws PuckException {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		int errorCount = 0;
		StringList errors = new StringList();

		//
		result = new Report();
		result.setTitle("Discontinuous Itineraries");
		result.setOrigin("Control reporter");
		result.setTarget(segmentation.getLabel());

		for (EgoRelationSequence itinerary : SequenceMaker.createBiographies(net, segmentation, criteria).toSortedList()) {
			EgoRelationSequences partials = SequenceWorker.split(itinerary);
			if (partials.size() > 1) {
				errorCount++;
				errors.appendln(itinerary.getEgo().signature());
				int j = 0;
				for (EgoRelationSequence partial : partials) {
					if (partial.getStations().size() != 0 && j > 0) {
						errors.appendln(partial.getFirstTime() + "\t" + partial.getStations().get(partial.getFirstTime()));
					}
					j++;
				}
				errors.appendln();
			}
		}

		//
		errors.add(0, errorCount + " " + Report.translate(bundle, "Discontinuous Itineraries") + "\n");
		result.outputs().append(errors.toString());

		//
		result.setStatus(errorCount);

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;
	}

	/**
	 * 
	 * @param segmentation
	 * @param criteria
	 * @param bundle
	 * @return
	 */
	public static Report reportMissingTestimonies(final Segmentation segmentation, final MissingTestimoniesCriteria criteria, final ResourceBundle bundle) {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		int errorCount = 0;
		StringList errors = new StringList();

		//
		result = new Report();
		result.setTitle("Missing Testimonies");
		result.setOrigin("Control reporter");
		result.setTarget(segmentation.getLabel());

		for (Relation event : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName())) {
			for (Individual witness : event.getIndividuals(criteria.getEgoRoleName())) {
				if (segmentation.getCurrentIndividuals().contains(witness)) {
					boolean missing = true;
					for (Attribute attribute : event.attributes()) {
						if (attribute.getLabel().contains("NOTE")) {
							String signature = witness.getId()+":";
							if (attribute.getValue().contains(signature)){
								missing = false;
								break;
							}
						}
					}
					if (missing) {
						errorCount++;
						errors.appendln(witness.signature() + "\t" + event.getTypedId() + "\t" + event.getName());
					}
				}
			}
		}

		//
		errors.add(0, errorCount + " " + Report.translate(bundle, "Missing Testimonies") + "\n");
		result.outputs().append(errors.toString());

		//
		result.setStatus(errorCount);

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;
	}

	
	/**
	 * 
	 * @param segmentation
	 * @param censusType
	 * @return
	 * @throws PuckException
	 */
	public static Report reportGeneralSequenceCensus(final Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		result = new Report("General ");
		result.setOrigin("Sequence reporter");

		// Create Reports
		Report overallReport = new Report("Survey");
		Report diagramReport = new Report("Diagrams");
		Report detailReport = new Report("Details");

		// Create Partition charts and tables
		List<ReportChart> charts = new ArrayList<ReportChart>();
		List<ReportTable> tables = new ArrayList<ReportTable>();

		// Get (coherent) itineraries
		EgoRelationSequences sequences = new EgoRelationSequences();
		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
			sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
		}

		// Proceed census
		SequencesCensus census = new SequencesCensus(sequences, censusCriteria);

		// Make overall report and diagrams
		overallReport.outputs().appendln(
			"Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");

		// Set partition criteria
		for (String label : censusCriteria.getCensusOperationLabels()) {

			PartitionCriteria partitionCriteria = new PartitionCriteria(label);
			// partitionCriteria.setValueFilter(ValueFilter.NULL);

			/*			if (label.contains("PROFILE")){
							partitionCriteria.setType(PartitionType.PARTIALIZATION);
						} */

			if (label.equals("NREVENTS") || label.contains("NRSTATIONS")) {
				partitionCriteria.setType(PartitionType.FREE_GROUPING);
				partitionCriteria.setIntervals(PartitionMaker.getIntervals("1 5 10 15 20 25"));
				// partitionCriteria.setCumulationType(CumulationType.DESCENDANT);
			} else if (label.contains("AGEFIRST")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(5.);
			} else if (label.equals("ECCENTRICITY")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(-100.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY")
					|| label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS")
					|| label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(1.);
			} else {
				partitionCriteria.setType(PartitionType.RAW);
			}

			ReportChart chart = null;

			if (!label.contains("ALTERS") && !label.contains("PROFILE")&& !label.equals("MEAN_NR_MOVES")) {
				NumberedValues values = census.getValues(label);
				
				Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);

				PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
				chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);

				if (label.substring(0, 3).equals("AGE")) {

					partitionCriteria.setType(PartitionType.RAW);
					partitionCriteria.setSizeFilter(SizeFilter.HOLES);
					partitionCriteria.setValueFilter(ValueFilter.NULL);

					partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);

					if (partition.maxValue() != null) {
						ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
						charts.add(survivalChart);
					} else {
						System.err.println(label + " no max value");
					}
				}

				NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());

				overallReport.outputs().append(label + "\t");
				for (int gender = 0; gender < 3; gender++) {
					String sum = "";
					if (label.startsWith("NR")) {
						sum = new Double(genderedValues[gender].sum()).intValue() + "";
					}
					overallReport.outputs().append(
							MathUtils.round(genderedValues[gender].average(), 2) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t"
									+ values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
				}
				overallReport.outputs().appendln();

			}
			
			if (label.equals("MEAN_NR_MOVES")){
				Map<Value,Double[]> map = census.getMeanNrMoves();
				chart = StatisticsReporter.createMapChart(map, label, new String[]{"MALE","FEMALE"}, GraphType.STACKED_BARS);
			}

			if (chart != null) {
				charts.add(chart);
				ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
				tables.add(table);
				if (!label.contains("EVENTS_") && !label.contains("RELATIONS")) {
//					tables.add(ReportTable.normalize(table));
				}
			}
		}
		overallReport.outputs().appendln();

		// Create detailed report
		detailReport.outputs().append("Nr\tEgo\tGender");
		for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
			detailReport.outputs().append("\t" + partitionLabel);
		}
		detailReport.outputs().appendln();

		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {

			if (census.getValues("NREVENTS").get(ego.getId()) != null){
				detailReport.outputs().append(ego.getId() + "\t" + ego + "\t" + ego.getGender());
				for (String label : censusCriteria.getCensusOperationLabels()) {
					detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
				}
				detailReport.outputs().appendln();
			}
		}

		// Manage the number of chart by line.
		for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
			diagramReport.outputs().append(charts.get(chartIndex));
			if (chartIndex % 4 == 3) {
				diagramReport.outputs().appendln();
			}
		}

		// Add chart tables.
		for (ReportTable table : tables) {
			diagramReport.outputs().appendln(table.getTitle());
			diagramReport.outputs().appendln(table);
		}

		// Finalize reports
		result.outputs().append(overallReport);
		result.outputs().append(diagramReport);
		result.outputs().append(detailReport);

		// addPajekData

		Map<String, StringList> pajekBuffers = census.getPajekBuffers();

		for (String title : pajekBuffers.keySet()) {

			StringList pajekBuffer = pajekBuffers.get(title);
			if (pajekBuffer.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
				ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}
		}

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;

	}
	

	/**
	 * 
	 * @param segmentation
	 * @param censusType
	 * @return
	 * @throws PuckException
	 */
	public static Report reportEgoNetworksCensus(final Segmentation segmentation, final SpaceTimeCriteria censusCriteria) throws PuckException {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		result = new Report("Ego Networks");
		result.setOrigin("Sequence reporter");

		// Create Reports
		Report overallReport = new Report("Survey");
		Report diagramReport = new Report("Diagrams");
		Report detailReport = new Report("Details");
		Report componentReport = null;
		
		if (censusCriteria.getEgoNetworksOperations().contains(EgoNetworksOperation.COHESION)){
			componentReport = new Report("Components");
		}
		
		// Create Partition charts and tables
		List<ReportChart> charts = new ArrayList<ReportChart>();
		List<ReportTable> tables = new ArrayList<ReportTable>();

		// Get (coherent) itineraries
		EgoRelationSequences sequences = new EgoRelationSequences();
		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
			sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
		}

		// Proceed census
		SequencesCensus census = new SequencesCensus(sequences, censusCriteria);

		// Make overall report and diagrams
		overallReport
				.outputs()
				.appendln(
						"Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");

		// Set partition criteria
		for (String label : censusCriteria.getCensusOperationLabels()) {

			PartitionCriteria partitionCriteria = new PartitionCriteria(label);
			// partitionCriteria.setValueFilter(ValueFilter.NULL);

			/*			if (label.contains("PROFILE")){
							partitionCriteria.setType(PartitionType.PARTIALIZATION);
						} */

			if (label.equals("NREVENTS")) {
				partitionCriteria.setType(PartitionType.RAW);
				// partitionCriteria.setCumulationType(CumulationType.DESCENDANT);
			} else if (label.contains("AGEFIRST")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(5.);
			} else if (label.equals("ECCENTRICITY")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(-100.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY")
					|| label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS")
					|| label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(1.);
			} else {
				partitionCriteria.setType(PartitionType.RAW);
			}

			ReportChart chart = null;

			if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
				NumberedValues values = census.getValues(label);

				Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);

				PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
				chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);

				if (label.substring(0, 3).equals("AGE")) {

					partitionCriteria.setType(PartitionType.RAW);
					partitionCriteria.setSizeFilter(SizeFilter.HOLES);
					partitionCriteria.setValueFilter(ValueFilter.NULL);

					partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);

					if (partition.maxValue() != null) {
						ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
						charts.add(survivalChart);
					} else {
						System.err.println(label + " no max value");
					}
				}

				NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());

				overallReport.outputs().append(label + "\t");
				for (int gender = 0; gender < 3; gender++) {
					String sum = "";
					if (label.startsWith("NR")) {
						sum = new Double(genderedValues[gender].sum()).intValue() + "";
					}
					overallReport.outputs().append(
							MathUtils.round(genderedValues[gender].average(), 2) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t"
									+ values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
				}
				overallReport.outputs().appendln();

			}

			if (chart != null) {
				charts.add(chart);
					ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
					tables.add(table);
					if (!label.contains("EVENTS_") && !label.contains("RELATIONS")) {
//						tables.add(ReportTable.normalize(table));
				}

			}

		}
		overallReport.outputs().appendln();

		// Create detailed report
		detailReport.outputs().append("Nr\tEgo\tGender");
		for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
				detailReport.outputs().append("\t" + partitionLabel);
		}
		
		Map<String,Map<Value, Double[]>> componentChartMaps = new TreeMap<String, Map<Value, Double[]>>();
		Map<String,Map<Value, Double[]>> componentChartSizeMaps = new TreeMap<String, Map<Value, Double[]>>();
		for (String networkTitle : censusCriteria.getNetworkTitles()){
			componentChartMaps.put(networkTitle,new TreeMap<Value, Double[]>());
			componentChartSizeMaps.put(networkTitle,new TreeMap<Value, Double[]>());
		}

		detailReport.outputs().appendln();
		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {

			if (census.getValues("SIZE").get(ego.getId()) != null) {
				detailReport.outputs().append(ego.getId() + "\t" + ego + "\t" + ego.getGender());
				for (String label : censusCriteria.getCensusOperationLabels()) {
						detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
				}
				detailReport.outputs().appendln();
			}
			
			if (censusCriteria.getEgoNetworksOperations().contains(EgoNetworksOperation.COHESION)){

				for (String networkTitle : censusCriteria.getNetworkTitles()) {
					Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(networkTitle);
					Map<Value,Double[]> componentChartMap = componentChartMaps.get(networkTitle);
					Map<Value,Double[]> componentChartSizeMap = componentChartSizeMaps.get(networkTitle);
					
					if (componentsMap != null) {
						Partition<Node<Individual>> components = componentsMap.get(ego.getId());

						componentReport.outputs().appendln("Components " + networkTitle);
						componentReport.outputs().appendln(ego + "\t" + components.size());
						int i = 1;
						for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
							componentReport.outputs().appendln(
									"\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
							i++;
						}
						componentReport.outputs().appendln();

						for (Value value : components.getValues()) {
							Double[] map = componentChartMap.get(value);
							Double[] map2 = componentChartSizeMap.get(value);
							if (map == null) {
								map = new Double[]{0.,0.,0.};
								componentChartMap.put(value, map);
								map2 = new Double[]{0.,0.,0.};
								componentChartSizeMap.put(value, map2);
							}
							map[ego.getGender().toInt()]+=1.;
							map[2]+=1.;
							map2[ego.getGender().toInt()]+=components.getCluster(value).size();
							map2[2]+=components.getCluster(value).size();
						}
					}
				}
			}
		}
		
		for (String networkTitle : censusCriteria.getNetworkTitles()) {
			
			Map<Value,Double[]> componentChartMap = componentChartMaps.get(networkTitle);
			Map<Value,Double[]> componentChartSizeMap = componentChartSizeMaps.get(networkTitle);
			for (Value value: componentChartMap.keySet()){
				Double[] sums = componentChartSizeMap.get(value);
				for (int i=0;i<3;i++){
					sums[i]=new Double(sums[i]/componentChartMap.get(value)[i]);
				}
			}

			ReportChart componentChart = StatisticsReporter.createMapChart(componentChartMap, "COMPONENTS",new String[]{"MALE","FEMALE"}, GraphType.STACKED_BARS);
			charts.add(componentChart);
			tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
			
			ReportChart componentSizeChart = StatisticsReporter.createMapChart(componentChartSizeMap, "COMPONENTS",new String[]{"MALE","FEMALE"}, GraphType.STACKED_BARS);
			charts.add(componentSizeChart);
			tables.add(ReportTable.transpose(componentSizeChart.createReportTableWithSum()));

	/*			if (census.getRelationConnectionMatrix() != null) {
				for (ReportChart chart : census.getRelationConnectionMatrix().getCharts()) {
					charts.add(chart);
				}
				tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
			}*/
		}

		// Manage the number of chart by line.
		for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
			diagramReport.outputs().append(charts.get(chartIndex));
			if (chartIndex % 4 == 3) {
				diagramReport.outputs().appendln();
			}
		}

		// Add chart tables.
		for (ReportTable table : tables) {
			diagramReport.outputs().appendln(table.getTitle());
			diagramReport.outputs().appendln(table);
		}

		// Finalize reports
		result.outputs().append(overallReport);
		result.outputs().append(diagramReport);
		result.outputs().append(detailReport);
		
		if (componentReport!=null){
			result.outputs().append(componentReport);
		}

		// addPajekData
		
		if (censusCriteria.getEgoNetworksOperations().contains(EgoNetworksOperation.EXPORT_EGO_NETWORKS)){

			Map<String, StringList> pajekBuffers = census.getPajekBuffers();

			for (String title : pajekBuffers.keySet()) {

				StringList pajekBuffer = pajekBuffers.get(title);
				if (pajekBuffer.length() != 0) {
					File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
					ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
					rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

					result.outputs().appendln();
					result.outputs().append(rawData);
				}
			}
		
		}

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;

	}

	/**
	 * 
	 * @param segmentation
	 * @param censusType
	 * @return
	 * @throws PuckException
	 */
	public static Report reportParcoursNetworksCensus(final Segmentation segmentation, final SpaceTimeCriteria censusCriteria) throws PuckException {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		result = new Report("Parcours Networks");
		result.setOrigin("Sequence reporter");

		// Create Reports
		Report overallReport = new Report("Survey");
		Report diagramReport = new Report("Diagrams");
		Report detailReport = new Report("Details");
		Report componentReport = null;
		
		if (censusCriteria.getParcoursNetworksOperations().contains(ParcoursNetworksOperation.COHESION)){
			componentReport = new Report("Components");
		}
		
		// Create Partition charts and tables
		List<ReportChart> charts = new ArrayList<ReportChart>();
		List<ReportTable> tables = new ArrayList<ReportTable>();

		// Get (coherent) itineraries
		EgoRelationSequences sequences = new EgoRelationSequences();
		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
			sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
		}

		// Proceed census
		SequencesCensus census = new SequencesCensus(sequences, censusCriteria);

		// Make overall report and diagrams
		overallReport
				.outputs()
				.appendln(
						"Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");

		// Set partition criteria
		for (String label : censusCriteria.getCensusOperationLabels()) {

			PartitionCriteria partitionCriteria = new PartitionCriteria(label);
			// partitionCriteria.setValueFilter(ValueFilter.NULL);

			/*			if (label.contains("PROFILE")){
							partitionCriteria.setType(PartitionType.PARTIALIZATION);
						} */

			if (label.equals("NREVENTS")) {
				partitionCriteria.setType(PartitionType.RAW);
				// partitionCriteria.setCumulationType(CumulationType.DESCENDANT);
			} else if (label.contains("AGEFIRST")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(5.);
			} else if (label.equals("ECCENTRICITY")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(-100.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY")
					|| label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS")
					|| label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(1.);
			} else {
				partitionCriteria.setType(PartitionType.RAW);
			}

			ReportChart chart = null;

			if (label.contains("SIMILARITY")) {
				RelationClassificationType relationClassificationType = RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
				Map<Value, Double[]> similaritiesMap = census.getSimilaritiesMap(relationClassificationType);
				chart = StatisticsReporter.createMapChart(similaritiesMap, label, new String[] { "HH", "FH", "HF", "FF", "All" }, GraphType.LINES);

				for (Value key : similaritiesMap.keySet()) {
					overallReport.outputs().appendln(label + "_" + key + "\t" + MathUtils.percent(similaritiesMap.get(key)[4], 100));
				}

			} else if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
				NumberedValues values = census.getValues(label);

				Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);

				PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
				chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);

				if (label.substring(0, 3).equals("AGE")) {

					partitionCriteria.setType(PartitionType.RAW);
					partitionCriteria.setSizeFilter(SizeFilter.HOLES);
					partitionCriteria.setValueFilter(ValueFilter.NULL);

					partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);

					if (partition.maxValue() != null) {
						ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
						charts.add(survivalChart);
					} else {
						System.err.println(label + " no max value");
					}
				}

				NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());

				overallReport.outputs().append(label + "\t");
				for (int gender = 0; gender < 3; gender++) {
					String sum = "";
					if (label.startsWith("NR")) {
						sum = new Double(genderedValues[gender].sum()).intValue() + "";
					}
					overallReport.outputs().append(
							MathUtils.round(genderedValues[gender].average(), 2) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t"
									+ values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
				}
				overallReport.outputs().appendln();

			}

			if (chart != null) {
				charts.add(chart);
				if (label.equals("SIMILARITY")) {
					tables.add(ReportTable.transpose(chart.createReportTable()));
				} else {
					ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
					tables.add(table);
					if (!label.contains("EVENTS_") && !label.contains("RELATIONS")) {
						tables.add(ReportTable.normalize(table));
					}
				}

			}

		}
		overallReport.outputs().appendln();
		
		// Add parcours network statistics
		
		Map<String,Map<String,Map<String,Value>>> parcoursNetworkStatistics = census.getParcoursNetworkStatistics();
		
		List<String> clusterValues = new ArrayList<String>(parcoursNetworkStatistics.keySet());
		
		if (parcoursNetworkStatistics!=null){
			overallReport.outputs().appendln("Parcours Network Statistics");

			String headLine = null;
			boolean first = true;
			
			for (String nodeLabel : parcoursNetworkStatistics.get("Total").keySet()){
				String line = nodeLabel;
				headLine = "Node";
				
				for (String genderLabel : clusterValues){
					Map<String,Value> statistics = parcoursNetworkStatistics.get(genderLabel).get(nodeLabel);
					for (String statisticsLabel : censusCriteria.getNodeStatisticsLabels()){
						if (first){
							headLine+="\t"+statisticsLabel+" ("+genderLabel+")";
						}
						if (statistics!=null){
							line+="\t"+statistics.get(statisticsLabel);
						} else {
							line+="\t";
						}
					}
				}
				if (first){
					overallReport.outputs().appendln(headLine);
					first = false;
				}
				overallReport.outputs().appendln(line);
			}
		}

		// Create detailed report
		detailReport.outputs().append("Nr\tEgo\tGender");
		for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
			if (partitionLabel.contains("SIMILARITY")) {
				RelationClassificationType relationClassificationType = RelationClassificationType.valueOf(partitionLabel.substring(partitionLabel
						.lastIndexOf("_") + 1));
				detailReport.outputs().append(
						"\tSIMILARITY_PARENT_" + relationClassificationType + "\tSIMILARITY_CHILD_" + relationClassificationType + "\tSIMILARITY_SIBLING_"
								+ relationClassificationType + "\tSIMILARITY_SPOUSE_" + relationClassificationType);
			} else {
				detailReport.outputs().append("\t" + partitionLabel);
			}
		}

		Map<String,Map<Value, Double[]>> componentChartMaps = new TreeMap<String, Map<Value, Double[]>>();
		for (String networkTitle : censusCriteria.getNetworkTitles()){
			componentChartMaps.put(networkTitle,new TreeMap<Value, Double[]>());
		}

		detailReport.outputs().appendln();
		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {

			if ((census.getValues("NREVENTS").get(ego.getId()) != null)){
				detailReport.outputs().append(ego.getId() + "\t" + ego + "\t" + ego.getGender());
				for (String label : censusCriteria.getCensusOperationLabels()) {
					if (label.contains("SIMILARITY")) {
						Value value = census.getValues(label).get(ego.getId());
						Map<Value, Double[]> indiSimilaritiesMap = value.mapValue();
						String[] keys = new String[] { "PARENT", "CHILD", "SIBLING", "SPOUSE" };
						for (String key : keys) {
							Double[] sim = indiSimilaritiesMap.get(new Value(key));
							if (sim != null) {
								detailReport.outputs().append("\t" + MathUtils.round(sim[4], 2));
							}
						}
					} else {
						detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
					}
				}
				detailReport.outputs().appendln();
			}

			if (componentReport!=null){

				for (String networkTitle : censusCriteria.getNetworkTitles()) {
					Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(networkTitle);
					Map<Value,Double[]> componentChartMap = componentChartMaps.get(networkTitle);
					if (componentsMap != null) {
						Partition<Node<Individual>> components = componentsMap.get(ego.getId());

						componentReport.outputs().appendln("Components " + networkTitle);
						componentReport.outputs().appendln(ego + "\t" + components.size());
						int i = 1;
						for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
							componentReport.outputs().appendln(
									"\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
							i++;
						}
						componentReport.outputs().appendln();

						for (Value value : components.getValues()) {
							Double[] map = componentChartMap.get(value);
							if (map == null) {
								map = new Double[]{0.,0.,0.};
								componentChartMap.put(value, map);
							}
							map[ego.getGender().toInt()]+=+ 1.;
							map[2]+=+ 1.;
						}
					}
				}
			}
		}

		for (String networkTitle : censusCriteria.getNetworkTitles()) {
			ReportChart componentChart = StatisticsReporter.createMapChart(componentChartMaps.get(networkTitle),"COMPONENTS", new String[]{"MALE","FEMALE"}, GraphType.STACKED_BARS);
			charts.add(componentChart);
			tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));

			if (census.getRelationConnectionMatrix() != null) {
				for (ReportChart chart : census.getRelationConnectionMatrix().getCharts()) {
					charts.add(chart);
				}
				tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
			}
		}
		

		// Manage the number of chart by line.
		for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
			diagramReport.outputs().append(charts.get(chartIndex));
			if (chartIndex % 4 == 3) {
				diagramReport.outputs().appendln();
			}
		}

		// Add chart tables.
		for (ReportTable table : tables) {
			diagramReport.outputs().appendln(table.getTitle());
			diagramReport.outputs().appendln(table);
		}

		// Finalize reports
		result.outputs().append(overallReport);
		result.outputs().append(diagramReport);
		result.outputs().append(detailReport);

			result.outputs().append(componentReport);

		// addPajekData
		
		Map<String, StringList> pajekBuffers = census.getPajekBuffers();

		for (String title : pajekBuffers.keySet()) {

			StringList pajekBuffer = pajekBuffers.get(title);
			if (pajekBuffer.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
				ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}
		}

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;

	}

	/**
	 * 
	 * @param segmentation
	 * @param censusType
	 * @return
	 * @throws PuckException
	 */
	public static Report reportTrajectoriesCensus(final Segmentation segmentation, final SpaceTimeCriteria censusCriteria) throws PuckException {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		result = new Report("Trajectories");
		result.setOrigin("Sequence reporter");

		// Create Reports
		Report overallReport = new Report("Survey");
		Report diagramReport = new Report("Diagrams");
		Report detailReport = new Report("Details");
		Report treeReport = null;
				
		if (censusCriteria.getTrajectoriesOperations().contains(TrajectoriesOperation.LIST_TREES)){
			treeReport = new Report("Trees");
			
		}


		// Create Partition charts and tables
		List<ReportChart> charts = new ArrayList<ReportChart>();
		List<ReportTable> tables = new ArrayList<ReportTable>();

		// Get (coherent) itineraries
		EgoRelationSequences sequences = new EgoRelationSequences();
		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
			sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
		}

		// Proceed census
		SequencesCensus census = new SequencesCensus(sequences, censusCriteria);

		// Make overall report and diagrams
		overallReport
				.outputs()
				.appendln(
						"Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");

		// Set partition criteria
		for (String label : censusCriteria.getCensusOperationLabels()) {

			PartitionCriteria partitionCriteria = new PartitionCriteria(label);
			// partitionCriteria.setValueFilter(ValueFilter.NULL);

			/*			if (label.contains("PROFILE")){
							partitionCriteria.setType(PartitionType.PARTIALIZATION);
						} */

			if (label.equals("NREVENTS") || label.contains("NRSTATIONS")) {
				partitionCriteria.setType(PartitionType.RAW);
//				partitionCriteria.setType(PartitionType.FREE_GROUPING);
//				partitionCriteria.setIntervals(PartitionMaker.getIntervals("1 5 10 15 20 25"));
				// partitionCriteria.setCumulationType(CumulationType.DESCENDANT);
			} else if (label.contains("AGEFIRST")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(5.);
			} else if (label.equals("ECCENTRICITY")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(-100.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY")
					|| label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS")
					|| label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(1.);
			} else {
				partitionCriteria.setType(PartitionType.RAW);
			}

			ReportChart chart = null;

			if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
				NumberedValues values = census.getValues(label);

				Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);

				PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
				chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);

				if (label.substring(0, 3).equals("AGE")) {

					partitionCriteria.setType(PartitionType.RAW);
					partitionCriteria.setSizeFilter(SizeFilter.HOLES);
					partitionCriteria.setValueFilter(ValueFilter.NULL);

					partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);

					if (partition.maxValue() != null) {
						ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
						charts.add(survivalChart);
					} else {
						System.err.println(label + " no max value");
					}
				}

				NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());

				overallReport.outputs().append(label + "\t");
				for (int gender = 0; gender < 3; gender++) {
					String sum = "";
					if (label.startsWith("NR")) {
						sum = new Double(genderedValues[gender].sum()).intValue() + "";
					}
					overallReport.outputs().append(
							MathUtils.round(genderedValues[gender].average(), 2) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t"
									+ values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
				}
				overallReport.outputs().appendln();

			}

			if (chart != null) {
				charts.add(chart);
					ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
					tables.add(table);
					if (!label.contains("EVENTS_") && !label.contains("RELATIONS")) {
						tables.add(ReportTable.normalize(table));
					}

			}

		}
		overallReport.outputs().appendln();

		// Create detailed report
		
		Map<String, StringList> rStateBuffers = new TreeMap<String,StringList>();
		Map<String, StringList> rEventBuffers = new TreeMap<String,StringList>();
		Map<String, Integer> rSizes = new TreeMap<String,Integer>();
		
		NumberedValues dateProfiles = census.getValues("PROFILE_"+censusCriteria.getDateLabel());
		NumberedValues ageProfiles = census.getValues("PROFILE_AGE");
		
		detailReport.outputs().append("Nr\tEgo\tGender");
		for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
				detailReport.outputs().append("\t" + partitionLabel);
				
				if (partitionLabel.contains("PROFILE")){
					rStateBuffers.put(partitionLabel.substring(8),new StringList());
					rSizes.put(partitionLabel.substring(8),0);
					StringList rEventBuffer = new StringList();
					rEventBuffer.appendln("Id\tStep\tDate\tAge\t"+partitionLabel.substring(8));
					rEventBuffers.put(partitionLabel.substring(8),rEventBuffer);
				}
		}

		detailReport.outputs().appendln();
		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {

			if (census.getValues("NREVENTS").get(ego.getId()) != null) {
				
				detailReport.outputs().append(ego.getId() + "\t" + ego + "\t" + ego.getGender());
				List<String> dates = (List<String>)dateProfiles.get(ego.getId()).listValue();
				List<String> ages = (List<String>)ageProfiles.get(ego.getId()).listValue();
				
				for (String label : censusCriteria.getCensusOperationLabels()) {
					Value value = census.getValues(label).get(ego.getId());
						detailReport.outputs().append("\t" + value);
						
						if (label.contains("PROFILE")){
							StringList rStateBuffer = rStateBuffers.get(label.substring(8));
							StringList rEventBuffer = rEventBuffers.get(label.substring(8));

							int rSize = rSizes.get(label.substring(8));
									
							String rStateLine = ego.getId() + "\t" + ego + "\t" + ego.getGender();
							List<String> rItems = (List<String>)value.listValue();
							
							if (rItems.size()>rSize){
								rSizes.put(label.substring(8), rItems.size());
							}
							int time = 0;
							for (String rItem: rItems){
								rStateLine += "\t"+rItem;
								rEventBuffer.appendln(ego.getId()+"\t"+time+"\t"+dates.get(time)+"\t"+ages.get(time)+"\t"+rItem);
								time++;
							}
							rStateBuffer.append(rStateLine);
						}
				}
				detailReport.outputs().appendln();
			}


		// SequenceAnalysis

			for (RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()) {

				if (censusCriteria.getNetworkTitles().contains("Event Type Network")) {

					CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix(relationClassificationType.toString());

					if (eventSequenceMatrix != null) {
						for (ReportChart chart : eventSequenceMatrix.getCharts()) {
							charts.add(chart);
						}
						tables.add(eventSequenceMatrix.getTable("Event Type Sequences"));
						
					}

					overallReport.outputs().appendln();
					overallReport.outputs().appendln("Sequence Network Statistics " + relationClassificationType);
					overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");

					for (Gender gender : Gender.values()) {
						GraphProfile<Cluster<String>> profile = eventSequenceMatrix.getProfile(gender);

						String centralReferents = "";
						for (Cluster<String> centralReferent : profile.getCentralReferents()) {
							centralReferents += centralReferent.getValue() + " ";
						}
						double maxBetweenness = profile.getMaxBetweenness();
						double density = profile.density();
						double endo = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.NORMALIZED), 2);
						double endoExp = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.DIVERGENCE_NORMALIZED), 2);
						double conc = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.SIMPLE), 2);
						double concExp = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.DIVERGENCE), 2);
						double sym = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.SIMPLE), 2);
						double symExp = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.DIVERGENCE), 2);

						overallReport.outputs().appendln(
								gender + "\t" + density + "\t" + endo + "\t" + endoExp + "\t" + conc + "\t" + concExp + "\t" + sym + "\t" + symExp + "\t"
										+ centralReferents + "(" + maxBetweenness + ") betweenness centrality");
					}
					overallReport.outputs().appendln();

				}

				if (censusCriteria.getNetworkTitles().contains("Sequence Type Network")) {

					CorrelationMatrix subSequenceMatrix = census.getSubSequenceMatrix(relationClassificationType.toString());

					if (subSequenceMatrix != null) {
						charts.add(subSequenceMatrix.getRamificationChart());
					}
				}

				// reportSequencePartition(overallReport,"",census.getEventPartition(eventTypeName),census.getEventPairPartition(eventTypeName),census.nrSequences(),census.nrEvents());
				// reportSequenceTree(treeReport,"",census.getSequenceTypeNetwork(eventTypeName));

				/*				int maxPositions = census.getNrValues(eventType,eventType.toString());
										
								ReportChart diversityChart = StatisticsReporter.createDiversityChart(census.getDepthPartition(eventType.toString()), maxPositions);
								charts.add(diversityChart);*/
			}
		}
		

		// Manage the number of chart by line.
		for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
			diagramReport.outputs().append(charts.get(chartIndex));
			if (chartIndex % 4 == 3) {
				diagramReport.outputs().appendln();
			}
		}

		// Add chart tables.
		for (ReportTable table : tables) {
			diagramReport.outputs().appendln(table.getTitle());
			diagramReport.outputs().appendln(table);
		}

		// Finalize reports
		result.outputs().append(overallReport);
		result.outputs().append(diagramReport);
		result.outputs().append(detailReport);
		if (treeReport!=null){
			result.outputs().append(treeReport);
		}

		// addPajekData

		if (censusCriteria.getTrajectoriesOperations().contains(TrajectoriesOperation.EXPORT_EVENT_TYPE_NETWORK) || censusCriteria.getTrajectoriesOperations().contains(TrajectoriesOperation.EXPORT_SEQUENCE_TYPE_NETWORK)){
			
			Map<String, StringList> pajekBuffers = census.getPajekBuffers();

			for (String title : pajekBuffers.keySet()) {
				
				StringList pajekBuffer = pajekBuffers.get(title);
				if (pajekBuffer.length() != 0) {
										
					File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
					ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
					rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

					result.outputs().appendln();
					result.outputs().append(rawData);
				}
			}
		}
		
		// addRData

		if (censusCriteria.getTrajectoriesOperations().contains(TrajectoriesOperation.GENERAL)){
			
			for (String title : rStateBuffers.keySet()) {
				
				StringList rStateBuffer = rStateBuffers.get(title);
				StringList rStateBufferCompleted = new StringList();
				
				int rSize = rSizes.get(title);
				String rStateHeadLine = "Id\tName\tGender";
				for (int i=0;i<rSize;i++){
					rStateHeadLine+="\t"+title+i;
				}
				rStateBufferCompleted.appendln(rStateHeadLine);
				for (String rStateLine : rStateBuffer){
					String rStateLineCompleted = "";
					String[] rStateItems = rStateLine.split("\t");
					for (int i=0;i<3+rSize;i++){
						if (i<rStateItems.length){
							rStateLineCompleted+=rStateItems[i]+"\t";
						} else {
							rStateLineCompleted+="NA\t";
						}
					}
					rStateBufferCompleted.appendln(rStateLineCompleted);
				}
				
				if (rStateBuffer.length() != 0) {
					
					File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-States-" + title), ".txt");
					ReportRawData rawData = new ReportRawData("Export " + title + "s to RData (States)", "Text", "txt", targetFile);
					rawData.setData(PAJFile.convertToMicrosoftEndOfLine(rStateBufferCompleted.toString()));

					result.outputs().appendln();
					result.outputs().append(rawData);
				}
				
				StringList rEventBuffer = rEventBuffers.get(title);
				if (rEventBuffer.length() != 0) {
					
					File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Events-" + title), ".txt");
					ReportRawData rawData = new ReportRawData("Export " + title + "s to RData (Events)", "Text", "txt", targetFile);
					rawData.setData(PAJFile.convertToMicrosoftEndOfLine(rEventBuffer.toString()));

					result.outputs().appendln();
					result.outputs().append(rawData);
				}
			}
		}
		

		// draw graph
		
		
		
		
		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;

	}
	
	public static Graph<Place> getTrajectoryGraph (final Segmentation segmentation, final SpaceTimeCriteria censusCriteria) throws PuckException {
		Graph<Place> result;
		
		result = null;

		// Create Partition charts and tables
		List<ReportChart> charts = new ArrayList<ReportChart>();
		List<ReportTable> tables = new ArrayList<ReportTable>();

		// Get (coherent) itineraries
		EgoRelationSequences sequences = new EgoRelationSequences();
		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
			sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
		}

		// Proceed census
		SequencesCensus census = new SequencesCensus(sequences, censusCriteria);


		if (censusCriteria.getTrajectoriesOperations().contains(TrajectoriesOperation.DRAW)){
			
			CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix("PLACE");
			Graph<Cluster<String>> drawGraph = eventSequenceMatrix.getSequenceNetwork("PLACE", Gender.UNKNOWN);
			
			result = GeoNetworkUtils.createGeoNetwork(drawGraph, censusCriteria.getLevel());

		}
		//
		return result;


	}

    public static Graph<Place2> getTrajectoryGraph2 (Geography2 geography, final Segmentation segmentation, final SpaceTimeCriteria censusCriteria) throws PuckException {
        Graph<Place2> result;
        
        result = null;

        // Create Partition charts and tables
        List<ReportChart> charts = new ArrayList<ReportChart>();
        List<ReportTable> tables = new ArrayList<ReportTable>();

        // Get (coherent) itineraries
        EgoRelationSequences sequences = new EgoRelationSequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }

        // Proceed census
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);


        if (censusCriteria.getTrajectoriesOperations().contains(TrajectoriesOperation.DRAW)){
            
            CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix("PLACE");
            Graph<Cluster<String>> drawGraph = eventSequenceMatrix.getSequenceNetwork("PLACE", Gender.UNKNOWN);
            
            Graph<String> placeNameGraph = GeoNetworkUtils.createGeoNetwork2(drawGraph, censusCriteria.getLevel());
            
            result = GeocodingWorker.geocodeGraph(geography, placeNameGraph);

        }
        //
        return result;


    }



	/**
	 * 
	 * @param segmentation
	 * @param censusType
	 * @return
	 * @throws PuckException
	 */
	public static Report reportSequenceCensus(final Segmentation segmentation, final CensusType censusType) throws PuckException {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		result = new Report(censusType.toString());
		result.setOrigin("Sequence reporter");

		// Create Reports
		Report overallReport = new Report("Survey");
		Report diagramReport = new Report("Diagrams");
		Report detailReport = new Report("Details");
		Report componentReport = new Report("Components");
		Report treeReport = new Report("Trees");

		// Create Partition charts and tables
		List<ReportChart> charts = new ArrayList<ReportChart>();
		List<ReportTable> tables = new ArrayList<ReportTable>();

		// Set census criteria
		SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(censusType);

		// Get (coherent) itineraries
		EgoRelationSequences sequences = new EgoRelationSequences();
		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
			sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
		}

		// Proceed census
		SequencesCensus census = new SequencesCensus(sequences, censusCriteria);

		// Make overall report and diagrams
		// Generalize for all types of partitions (not only male and female)
		overallReport
				.outputs()
				.appendln(
						"Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");

		// Set partition criteria
		for (String label : censusCriteria.getCensusOperationLabels()) {

			PartitionCriteria partitionCriteria = new PartitionCriteria(label);
			// partitionCriteria.setValueFilter(ValueFilter.NULL);

			/*			if (label.contains("PROFILE")){
							partitionCriteria.setType(PartitionType.PARTIALIZATION);
						} */

			if (label.equals("NREVENTS")) {
				partitionCriteria.setType(PartitionType.RAW);
				// partitionCriteria.setCumulationType(CumulationType.DESCENDANT);
			} else if (label.contains("AGEFIRST")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(5.);
			} else if (label.equals("ECCENTRICITY")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(-100.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY")
					|| label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS")
					|| label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(1.);
			} else {
				partitionCriteria.setType(PartitionType.RAW);
			}

			ReportChart chart = null;

			if (label.contains("SIMILARITY")) {
				RelationClassificationType relationClassificationType = RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
				Map<Value, Double[]> similaritiesMap = census.getSimilaritiesMap(relationClassificationType);
				chart = StatisticsReporter.createMapChart(similaritiesMap, label, new String[] { "HH", "FH", "HF", "FF", "All" }, GraphType.LINES);

				for (Value key : similaritiesMap.keySet()) {
					overallReport.outputs().appendln(label + "_" + key + "\t" + MathUtils.percent(similaritiesMap.get(key)[4], 100));
				}

			} else if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
				NumberedValues values = census.getValues(label);

				Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);

				PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
				chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);

				if (label.substring(0, 3).equals("AGE")) {

					partitionCriteria.setType(PartitionType.RAW);
					partitionCriteria.setSizeFilter(SizeFilter.HOLES);
					partitionCriteria.setValueFilter(ValueFilter.NULL);

					partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);

					if (partition.maxValue() != null) {
						ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
						charts.add(survivalChart);
					} else {
						System.err.println(label + " no max value");
					}
				}

				NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());

				overallReport.outputs().append(label + "\t");
				for (int gender = 0; gender < 3; gender++) {
					String sum = "";
					if (label.startsWith("NR")) {
						sum = new Double(genderedValues[gender].sum()).intValue() + "";
					}
					overallReport.outputs().append(
							MathUtils.round(genderedValues[gender].average(), 2) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t"
									+ values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
				}
				overallReport.outputs().appendln();

			}

			if (chart != null) {
				charts.add(chart);
				if (label.equals("SIMILARITY")) {
					tables.add(ReportTable.transpose(chart.createReportTable()));
				} else {
					ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
					tables.add(table);
					if (!label.contains("EVENTS_") && !label.contains("RELATIONS")) {
						tables.add(ReportTable.normalize(table));
					}
				}

			}

		}
		overallReport.outputs().appendln();
		
		// Add parcours network statistics
		
		Map<String,Map<String,Map<String,Value>>> parcoursNetworkStatistics = census.getParcoursNetworkStatistics();
		
		if (parcoursNetworkStatistics!=null){
			overallReport.outputs().appendln("Parcours Network Statistics");
			
			for (String nodeLabel : parcoursNetworkStatistics.get("Total").keySet()){
				String line = nodeLabel;
				for (String statisticsLabel : parcoursNetworkStatistics.get("Total").get(nodeLabel).keySet()){
					for (String genderLabel : parcoursNetworkStatistics.keySet()){
						line+="\t"+parcoursNetworkStatistics.get(genderLabel).get(nodeLabel).get(statisticsLabel);
					}
				}
				overallReport.outputs().appendln(line);
			}
		}
		
		// Create detailed report
		detailReport.outputs().append("Nr\tEgo\tGender");
		for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
			if (partitionLabel.contains("SIMILARITY")) {
				RelationClassificationType relationClassificationType = RelationClassificationType.valueOf(partitionLabel.substring(partitionLabel
						.lastIndexOf("_") + 1));
				detailReport.outputs().append(
						"\tSIMILARITY_PARENT_" + relationClassificationType + "\tSIMILARITY_CHILD_" + relationClassificationType + "\tSIMILARITY_SIBLING_"
								+ relationClassificationType + "\tSIMILARITY_SPOUSE_" + relationClassificationType);
			} else {
				detailReport.outputs().append("\t" + partitionLabel);
			}
		}

		Map<Value, Double[]> componentChartMap = new TreeMap<Value, Double[]>();

		detailReport.outputs().appendln();
		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {

			if ((((censusType == CensusType.GENERAL) || (censusType == CensusType.PARCOURS) || (censusType == CensusType.PARCOURSNETWORKS)) && (census
					.getValues("NREVENTS").get(ego.getId()) != null))
					|| ((censusType == CensusType.EGONETWORKS) && (census.getValues("SIZE").get(ego.getId()) != null))) {
				detailReport.outputs().append(ego.getId() + "\t" + ego + "\t" + ego.getGender());
				for (String label : censusCriteria.getCensusOperationLabels()) {
					if (label.contains("SIMILARITY")) {
						Value value = census.getValues(label).get(ego.getId());
						Map<Value, Double[]> indiSimilaritiesMap = value.mapValue();
						String[] keys = new String[] { "PARENT", "CHILD", "SIBLING", "SPOUSE" };
						for (String key : keys) {
							Double[] sim = indiSimilaritiesMap.get(new Value(key));
							if (sim != null) {
								detailReport.outputs().append("\t" + MathUtils.round(sim[4], 2));
							}
						}
					} else {
						detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
					}
				}
				detailReport.outputs().appendln();
			}

			if ((censusType == CensusType.EGONETWORKS || censusType == CensusType.PARCOURSNETWORKS)) {

				for (String networkTitle : censusCriteria.getNetworkTitles()) {
					Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(networkTitle);
					if (componentsMap != null) {
						Partition<Node<Individual>> components = componentsMap.get(ego.getId());

						componentReport.outputs().appendln("Components " + networkTitle);
						componentReport.outputs().appendln(ego + "\t" + components.size());
						int i = 1;
						for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
							componentReport.outputs().appendln(
									"\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
							i++;
						}
						componentReport.outputs().appendln();

						for (Value value : components.getValues()) {
							Double[] map = componentChartMap.get(value);
							if (map == null) {
								map = new Double[]{0.,0.,0.};
								componentChartMap.put(value, map);
							}
							map[ego.getGender().toInt()]+=+ 1.;
							map[2]+=+ 1.;
						}
					}
				}
			}
		}

		if ((censusType == CensusType.EGONETWORKS || censusType == CensusType.PARCOURSNETWORKS)) {
			ReportChart componentChart = StatisticsReporter.createMapChart(componentChartMap,"COMPONENTS",new String[]{"MALE","FEMALE"}, GraphType.STACKED_BARS);
			charts.add(componentChart);
			tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));

			if (census.getRelationConnectionMatrix() != null) {
				for (ReportChart chart : census.getRelationConnectionMatrix().getCharts()) {
					charts.add(chart);
				}
				tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
			}

		}

		// SequenceAnalysis

		if (censusType == CensusType.PARCOURS) {

			for (RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()) {

				if (censusCriteria.getNetworkTitles().contains("Event Type Network")) {

					CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix(relationClassificationType.toString());

					if (eventSequenceMatrix != null) {
						for (ReportChart chart : eventSequenceMatrix.getCharts()) {
							charts.add(chart);
						}
						tables.add(eventSequenceMatrix.getTable("Event Type Sequences"));
					}

					overallReport.outputs().appendln();
					overallReport.outputs().appendln("Sequence Network Statistics " + relationClassificationType);
					overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");

					for (Gender gender : Gender.values()) {
						GraphProfile<Cluster<String>> profile = eventSequenceMatrix.getProfile(gender);

						String centralReferents = "";
						for (Cluster<String> centralReferent : profile.getCentralReferents()) {
							centralReferents += centralReferent.getValue() + " ";
						}
						double maxBetweenness = profile.getMaxBetweenness();
						double density = profile.density();
						double endo = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.NORMALIZED), 2);
						double endoExp = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.DIVERGENCE_NORMALIZED), 2);
						double conc = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.SIMPLE), 2);
						double concExp = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.DIVERGENCE), 2);
						double sym = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.SIMPLE), 2);
						double symExp = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.DIVERGENCE), 2);

						overallReport.outputs().appendln(
								gender + "\t" + density + "\t" + endo + "\t" + endoExp + "\t" + conc + "\t" + concExp + "\t" + sym + "\t" + symExp + "\t"
										+ centralReferents + "(" + maxBetweenness + ") betweenness centrality");
					}
					overallReport.outputs().appendln();

				}

				if (censusCriteria.getNetworkTitles().contains("Sequence Type Network")) {

					CorrelationMatrix subSequenceMatrix = census.getSubSequenceMatrix(relationClassificationType.toString());

					if (subSequenceMatrix != null) {
						charts.add(subSequenceMatrix.getRamificationChart());
					}
				}

				// reportSequencePartition(overallReport,"",census.getEventPartition(eventTypeName),census.getEventPairPartition(eventTypeName),census.nrSequences(),census.nrEvents());
				// reportSequenceTree(treeReport,"",census.getSequenceTypeNetwork(eventTypeName));

				/*				int maxPositions = census.getNrValues(eventType,eventType.toString());
										
								ReportChart diversityChart = StatisticsReporter.createDiversityChart(census.getDepthPartition(eventType.toString()), maxPositions);
								charts.add(diversityChart);*/
			}
		}

		// Manage the number of chart by line.
		for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
			diagramReport.outputs().append(charts.get(chartIndex));
			if (chartIndex % 4 == 3) {
				diagramReport.outputs().appendln();
			}
		}

		// Add chart tables.
		for (ReportTable table : tables) {
			diagramReport.outputs().appendln(table.getTitle());
			diagramReport.outputs().appendln(table);
		}

		// Finalize reports
		result.outputs().append(overallReport);
		result.outputs().append(diagramReport);
		result.outputs().append(detailReport);

		if (censusType == CensusType.EGONETWORKS || censusType == CensusType.PARCOURSNETWORKS) {
			result.outputs().append(componentReport);
		}
		if (censusType == CensusType.PARCOURS) {
			result.outputs().append(treeReport);
		}

		// addPajekData

		Map<String, StringList> pajekBuffers = census.getPajekBuffers();

		for (String title : pajekBuffers.keySet()) {

			StringList pajekBuffer = pajekBuffers.get(title);
			if (pajekBuffer.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
				ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}
		}

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;

	}


	/**
	 * 
	 * @param net
	 * @param segmentation
	 * @param censusCriteria
	 * @return
	 * @throws PuckException
	 */
	public static Report reportSequences(final Net net, final Segmentation segmentation, final SpaceTimeCriteria censusCriteria) throws PuckException {
		Report result;

		String spouseFilterLabel = "INTERV";

		//
		Chronometer chrono = new Chronometer();

		result = new Report("Sequence Report");
		result.setOrigin("Sequence reporter");

		// Initialize reports
		
		Report surveyReport = null;
		Report detailedReport = null;
		Report actorEventTableReport = null;
		Report interactionTableReport = null;
		Report biographyReport = null;
		Report extendedBiographyReport = null;
		
		List<Report> reports = new ArrayList<Report>();

		if (censusCriteria.getSequenceReportTypes().contains(SequenceReportType.ITINERARIES_SURVEY)){
			surveyReport = new Report("Survey");
			reports.add(surveyReport);
		}
		
		if (censusCriteria.getSequenceReportTypes().contains(SequenceReportType.ITINERARIES_DETAILS)){
			detailedReport = new Report("Details");
			reports.add(detailedReport);
		}
		
		if (censusCriteria.getSequenceReportTypes().contains(SequenceReportType.ACTOR_EVENT_TABLES)){
			actorEventTableReport = new Report("Actor-Event tables");
			reports.add(actorEventTableReport);
		}
		
		if (censusCriteria.getSequenceReportTypes().contains(SequenceReportType.INTERACTION_TABLES)){
			interactionTableReport = new Report("Interaction tables");
			reports.add(interactionTableReport);
		}

		// Initialize geography
		
		Geography geography = censusCriteria.getGeography();
		
		// Create sequences

		EgoRelationSequences sequences = new EgoRelationSequences();

		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {

			if (surveyReport!=null){
				surveyReport.outputs().appendln(ego.signature());
				surveyReport.outputs().appendln();
			}
			
			if (detailedReport!=null){
				detailedReport.outputs().appendln(ego.signature());
				detailedReport.outputs().appendln();
			}

			EgoRelationSequence sequence = SequenceMaker.createPersonalSequence(ego, censusCriteria);
			sequences.add(sequence);

			// Move to appropriate census!
			for (Individual spouse : ego.spouses()) {
				if (spouse.getAttributeValue(spouseFilterLabel) != null) {
					// surveyReport.outputs().appendln("Common events with spouse ("+spouse+"): "+SequenceWorker.getCommonEvents(ego,spouse,censusCriteria.getRelationModelName()).size());
				}
			}

			// Add role tables

			if (actorEventTableReport!=null){
				actorEventTableReport.outputs().append(SequenceWorker.roleTable(sequence));
			}
			
			if (interactionTableReport!=null){
				interactionTableReport.outputs().append(SequenceWorker.interactionTable(sequence));
			}

			// Create coherent subsequences

			EgoRelationSequences subSequences = SequenceWorker.split(sequence);

			for (EgoRelationSequence subSequence : subSequences) {

				if (subSequences.size() > 1) {
					if (surveyReport!=null){
						surveyReport.outputs().appendln(subSequence.getId());
					}
					if (detailedReport!=null){
						detailedReport.outputs().appendln(subSequence.getId());
					}
				}

				for (Ordinal key : subSequence.getStations().keySet()) {

					Relation event = subSequence.getStations().get(key);
					
					Place start = geography.getByHomonym(event.getAttributeValue("START_PLACE"));
					Place end = geography.getByHomonym(event.getAttributeValue("END_PLACE"));
					Place ancestor = geography.getCommonAncestor(start, end);
					GeoLevel commonLevel = null;
					String commonPlaceName = null;
					String startPlaceLabel = censusCriteria.getStartPlaceLabel();
					String endPlaceLabel = censusCriteria.getEndPlaceLabel();
					
					
					if (ancestor != null) {
						commonLevel = ancestor.getLevel();
						commonPlaceName = ancestor.getName();
					}

					String order = SequenceWorker.order(event, ego);

					if (surveyReport!=null){
						surveyReport.outputs().appendln(
								key + "\t" + order + "\t"+key.getYear()+"\t(" + subSequence.getEgoAge(key.getYear()) + ")\t" + event.getTypedId() + "\t"
										+ event.getAttributeValue(startPlaceLabel) + "\t" + event.getAttributeValue(endPlaceLabel) + "\t" + commonLevel + "\t("
										+ commonPlaceName + ")\t");
					}
					
					if (detailedReport!=null){
						detailedReport.outputs().appendln(
								key + "\t" + order  + "\t"+key.getYear()+ "\t(" + subSequence.getEgoAge(key.getYear()) + ")\t" + event.getTypedId() + "\t"
										+ event.getAttributeValue(startPlaceLabel) + "\t" + event.getAttributeValue(endPlaceLabel) + "\t" + commonLevel + "\t("
										+ commonPlaceName + ")\t");
						detailedReport.outputs().appendln();
						detailedReport.outputs().appendln(getStories(event));
					}

				}
				
				for (Report report : reports){
					report.outputs().appendln();
				}
			}
		}

		// Create sequences including life events

		if (censusCriteria.getSequenceReportTypes().contains(SequenceReportType.BIOGRAPHIES)){
			
			biographyReport = new Report("Biographies");
			reports.add(biographyReport);

			for (EgoRelationSequence biography : SequenceMaker.createBiographies(net, segmentation, censusCriteria).toSortedList()) {

				Individual ego = segmentation.getCurrentIndividuals().getById(biography.getId());

				biographyReport.outputs().appendln(ego.signature());
				for (Ordinal key : biography.getStations().keySet()) {
					Relation event = biography.getStation(key);
					biographyReport.outputs().appendln(
							key + "\t" + event.getRoles(ego).toString() + " (" + biography.getEgoAge(key.getYear()) + ")\t" + event.getName() + "\t"
									+ SequenceCensus.getEgoRolePartners(event, censusCriteria,ego));
				}
				biographyReport.outputs().appendln();
			}
		}
		
		// Create extended biographies

		if (censusCriteria.getSequenceReportTypes().contains(SequenceReportType.EXTENDED_BIOGRAPHIES)){

			extendedBiographyReport = new Report("Extended biographies");
			reports.add(extendedBiographyReport);

			for (EgoRelationSequence extendedBiography : SequenceMaker.createExtendedBiographies(net, segmentation, censusCriteria).toSortedList()) {

				Individual ego = segmentation.getCurrentIndividuals().getById(extendedBiography.getId());

				extendedBiographyReport.outputs().appendln(ego.signature());
				for (Ordinal key : extendedBiography.getStations().keySet()) {
					Relation event = extendedBiography.getStation(key);
					extendedBiographyReport.outputs().appendln(
							key + "\t" + event.getRoles(ego).toString() + " (" + extendedBiography.getEgoAge(key.getYear()) + ")\t" + event.getName() + " "
									+ SequenceCensus.getEgoRolePartners(event, censusCriteria,ego));
				}
				extendedBiographyReport.outputs().appendln();
			}
		}
		
		// Create Pajek File

		if (censusCriteria.getSequenceReportTypes().contains(SequenceReportType.EXPORT_RELATION_GRAPH)){
			
			Graph<Individual> graph = NetUtils.createRelationGraph(segmentation, censusCriteria.getRelationModelName());
			List<String> partitionLabels = new ArrayList<String>();

			StringList pajekBuffer = new StringList();
			pajekBuffer.addAll(PuckUtils.writePajekNetwork(graph, partitionLabels));
			pajekBuffer.appendln();


			if (pajekBuffer.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Relation Network"), ".paj");
				ReportRawData rawData = new ReportRawData("Export Relation Network to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}
		}

		for (Report report : reports){
			result.outputs().append(report);
		}

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;
	}

	/**
	 * 
	 * @param report
	 * @param value
	 * @param sequenceTypeNetwork
	 */
	private static void reportSequenceTree(final Report report, final String value, final Graph<Cluster<String>> sequenceTypeNetwork) {

		report.outputs().appendln("Sequence Tree " + value);
		Node<Cluster<String>> start = sequenceTypeNetwork.getNode(1);
		Stack<Node<Cluster<String>>> stack = new Stack<Node<Cluster<String>>>();
		report.outputs().appendln(start.getReferent() + "\t" + start.getReferent().size());
		stack.push(start);

		while (!stack.isEmpty()) {
			Node<Cluster<String>> node = stack.pop();
			for (Node<Cluster<String>> next : node.getOutNodes().toListSortedByLabel()) {
				report.outputs().appendln(next.getReferent() + "\t" + next.getReferent().size());
				stack.push(next);
			}
		}
		report.outputs().appendln();

	}


	/**
	 * 
	 * @param report
	 * @param segmentation
	 * @throws PuckException
	 */
	private static void reportTriangles(final Report report, final Segmentation segmentation) throws PuckException {

		Map<Integer, Partition<EventTriangle>> trianglesMap = new HashMap<Integer, Partition<EventTriangle>>();
		Partition<EventTriangle> allTriangles = new Partition<EventTriangle>();
		Partition<Individual> triangleTypes = new Partition<Individual>();

		// Get triangles

		for (Individual ego : segmentation.getCurrentIndividuals()) {
			Individuals individuals = ego.getRelated("Migevent");
			individuals.add(ego);
			Partition<EventTriangle> triangles = SequenceWorker.getTriangles(individuals, "Migevent");
			allTriangles.add(triangles);
			trianglesMap.put(ego.getId(), triangles);
			for (Cluster<EventTriangle> cluster : triangles.getClusters()) {
				triangleTypes.put(ego, cluster.getValue());
			}
		}

		// Report triangles
		Report trianglesReport = new Report("Triangles");
		trianglesReport.outputs().appendln("Type\tnrTriangles\tnrEgoNetworks");

		for (Cluster<EventTriangle> cluster : allTriangles.getClusters().toListSortedByValue()) {
			trianglesReport.outputs().appendln(cluster.getValue() + "\t" + cluster.size() + "\t" + triangleTypes.getCluster(cluster.getValue()).size());
		}
		trianglesReport.outputs().appendln();

		PartitionCriteria partitionCriteria = new PartitionCriteria("Triangles");
		ReportChart chart5 = StatisticsReporter.createPartitionChart(allTriangles, partitionCriteria, null);
		trianglesReport.outputs().appendln(chart5);

		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
			Partition<EventTriangle> triangles = trianglesMap.get(ego.getId());
			trianglesReport.outputs().appendln(ego + "\t" + triangles.size() + " types");
			for (Cluster<EventTriangle> cluster : triangles.getClusters().toListSortedByValue()) {
				trianglesReport.outputs().appendln(cluster.getValue() + "\t" + cluster.size());
				for (EventTriangle triangle : cluster.getItems()) {
					trianglesReport.outputs().appendln(triangle.getEventPattern());
				}
				trianglesReport.outputs().appendln();
			}
			trianglesReport.outputs().appendln();
		}
	}

	// Should be placed into control reporter (not specific for sequences)
	/**
	 * @param segmentation
	 * @param bundle
	 * @return
	 */
	public static Report reportUnknownPlaces(final Segmentation segmentation, final ResourceBundle bundle) {
		Report result;

		UnknownPlacesCriteria criteria = new UnknownPlacesCriteria();
		criteria.setIncludedIndividual(true);
		criteria.setIncludedAllRelations(true);

		result = reportUnknownPlaces(segmentation, criteria, bundle);

		//
		return result;
	}
	

	
	// Should be placed into control reporter (not specific for sequences)
	/**
	 * @param segmentation
	 * @param bundle
	 * @return
	 */
	public static Report reportUncodedPlaces(final Segmentation segmentation, final ResourceBundle bundle) {
		Report result;

		UnknownPlacesCriteria criteria = new UnknownPlacesCriteria();
		criteria.setIncludedIndividual(true);
		criteria.setIncludedAllRelations(true);

		result = reportUncodedPlaces(segmentation, criteria, bundle);

		//
		return result;
	}

	/**
	 * @param segmentation
	 * @param bundle
	 * @return
	 */
	public static Report reportUnknownPlaces(final Segmentation segmentation, final UnknownPlacesCriteria criteria, final ResourceBundle bundle) {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		Geography geography = Geography.getInstance();

		Partition<String> unknownPlaces = new Partition<String>();

		int errorCount = 0;
		StringList errors = new StringList();

		//
		if (criteria.isIncludedIndividual()) {
			//
			for (Individual individual : segmentation.getCurrentIndividuals()) {
				for (Attribute attribute : individual.attributes()) {
					if (attribute.getLabel().contains("PLAC")) {
						if (geography.getByHomonym(attribute.getValue()) == null) {
							unknownPlaces.put(attribute.getValue(), new Value(attribute.getLabel()));
							errorCount++;
						}
					}
				}
			}
		}

		//
		Relations relations;
		if (criteria.isIncludedAllRelations()) {
			//
			relations = segmentation.getCurrentRelations();

		} else if (criteria.getRelationNames().isEmpty()) {
			//
			relations = new Relations();

		} else {
			//
			relations = segmentation.getCurrentRelations().getByModelNames(criteria.getRelationNames());
		}

		for (Relation relation : relations) {
			for (Attribute attribute : relation.attributes()) {
				if (attribute.getLabel().contains("PLAC")) {
					if (geography.getByHomonym(attribute.getValue()) == null) {
						unknownPlaces.put(attribute.getValue(), new Value(attribute.getLabel()));
						errorCount++;
					}
				}
			}
		}

		for (Cluster<String> cluster : unknownPlaces.getClusters()) {
			errors.appendln(cluster.getValue().toString());
			for (String placeName : cluster.getItems()) {
				errors.appendln("\t" + placeName);
			}
			errors.appendln();
		}

		//
		result = new Report();
		result.setTitle("Unknown Places");
		result.setOrigin("Control reporter");
		result.setTarget(segmentation.getLabel());

		//
		errors.add(0, errorCount + " " + Report.translate(bundle, "Unknown Places") + "\n");
		result.outputs().append(errors.toString());

		//
		result.setStatus(errorCount);

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;
	}

	/**
	 * @param segmentation
	 * @param bundle
	 * @return
	 */
	public static Report reportUncodedPlaces(final Segmentation segmentation, final UnknownPlacesCriteria criteria, final ResourceBundle bundle) {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		Geography geography = Geography.getInstance();
		
		Partition<Place> uncodedPlaces = new Partition<Place>();

		int errorCount = 0;
		StringList errors = new StringList();

		//
		if (criteria.isIncludedIndividual()) {
			//
			for (Individual individual : segmentation.getCurrentIndividuals()) {
				for (Attribute attribute : individual.attributes()) {
					if (attribute.getLabel().contains("PLAC")) {
						Place place = geography.getByHomonym(attribute.getValue());
						if (place != null && place.getCoordinate()==null) {
							uncodedPlaces.put(place,new Value(place.getLevel()));
							Place sup = place.getSup();
							while (sup.getCoordinate()==null){
								uncodedPlaces.put(sup, new Value (sup.getLevel()));
								sup = sup.getSup();
							}
						}
					}
				}
			}
		}

		//
		Relations relations;
		if (criteria.isIncludedAllRelations()) {
			//
			relations = segmentation.getCurrentRelations();

		} else if (criteria.getRelationNames().isEmpty()) {
			//
			relations = new Relations();

		} else {
			//
			relations = segmentation.getCurrentRelations().getByModelNames(criteria.getRelationNames());
		}

		for (Relation relation : relations) {
			for (Attribute attribute : relation.attributes()) {
				if (attribute.getLabel().contains("PLAC")) {
					Place place = geography.getByHomonym(attribute.getValue());
					if (place != null && place.getCoordinate()==null) {
						uncodedPlaces.put(place,new Value(place.getLevel()));
						Place sup = place.getSup();
						while (sup.getCoordinate()==null){
							uncodedPlaces.put(sup, new Value (sup.getLevel()));
							sup = sup.getSup();
						}
					}
				}
			}
		}
				

		for (Cluster<Place> cluster : uncodedPlaces.getClusters().toListSortedByValue()) {
			errors.appendln(cluster.getValue().toString()+" "+cluster.size());
			errorCount+= cluster.size();
			List<String> toponyms = new ArrayList<String>();
			for (Place place : cluster.getItems()){
				toponyms.add(place.getToponym());
			}
			Collections.sort(toponyms);
			for (String toponym : toponyms){
				errors.appendln("\t" + toponym);
			}
			errors.appendln();
		}

		//
		result = new Report();
		result.setTitle("Uncoded Places");
		result.setOrigin("Control reporter");
		result.setTarget(segmentation.getLabel());

		//
		errors.add(0, errorCount + " " + Report.translate(bundle, "Uncoded Places") + "\n");
		result.outputs().append(errors.toString());

		//
		result.setStatus(errorCount);

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;
	}
	/**
	 * 
	 * @param cluster
	 * @return
	 */
	private static int sequenceNumber(final Cluster<String> cluster) {
		int result;

		Set<String> set = new HashSet<String>();

		for (String string : cluster.getItems()) {
			set.add(string.split("\\s")[0]);
		}

		result = set.size();

		//
		return result;
	}


	public static Report reportMembers(Sequence<Relations> slices, SpaceTimeCriteria criteria){
			Report result;
			
	//		Relations relations = slices.relations();
			
			result = new Report(criteria.getRelationModelName()+" Slices");
					
			StringList list = new StringList();
			
			Map<String,Individuals> membersByRelationId = slices.membersByRelationId();
	
			for (String idValue : slices.idValues()){
				list.appendln(idValue);
				list.appendln();
				
				List<Individual> members = membersByRelationId.get(idValue).toSortedList(Sorting.BIRT_YEAR);
				
				for (Individual member : members){
					list.append(member.signature()+" ("+IndividualValuator.lifeStatusAtYear(member, criteria.getReferenceYear())+")\t");
					
					for (Ordinal time : slices.getTimes()){
						
						String status = SequenceWorker.getStatus(slices, member, time, criteria);
	//					String status = slices.getById(id).statusByIndividuals().get(member);
						
						if (status!=null){
							list.append(status+"\t");
						} else {
							Integer deathYear = IndividualValuator.getDeathYear(member);
							Integer birthYear = IndividualValuator.getBirthYear(member);
							
							if (deathYear!=null && deathYear<=time.getYear()){
								list.append("+"+deathYear+"\t\t");
							} else if (birthYear!=null && birthYear>=time.getYear()){
								list.append("*"+birthYear+"\t\t");
							} else {
								list.append("?\t\t");
							}
						}
					}
					list.appendln();
					
				}
				list.appendln();
			}
			result.outputs().append(list);
			
			//
			return result;
			
		}


	public static Report reportIndividualDynamics(final Segmentation segmentation, final Sequence<Relations> slices, final SpaceTimeCriteria spaceTimeCriteria, final StatisticsCriteria statisticsCriteria) throws PuckException{
				Report result;
				
				if ((slices == null) || (statisticsCriteria == null)) {
					throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
				} else {
					result = new Report("Population Dynamics "+spaceTimeCriteria.getRelationModelName());
					Chronometer chrono = new Chronometer();
		
					result.setOrigin("Space reporter");
					
					List<Ordinal> times = slices.getTimes();
					
					List<ReportChart> charts = new ArrayList<ReportChart>(20);
					List<ReportTable> tables = new ArrayList<ReportTable>(20);
					
					SequenceStatistics<Sequence<Relations>,Relations> sequenceStatistics = new SequenceStatistics<Sequence<Relations>,Relations>(segmentation, slices, spaceTimeCriteria);
					Map<String,Map<Ordinal,Partition<Individual>>> census = sequenceStatistics.getDynamicIndividualCensus(spaceTimeCriteria, statisticsCriteria);
					
					for (int i=0;i<times.size()-1;i++){
						
						Ordinal startTime = times.get(i);
						Ordinal endTime = times.get(i+1);
						
						PartitionCriteria partitionCriteria = new PartitionCriteria();
						partitionCriteria.setLabel(spaceTimeCriteria.getRelationModelName()+" "+startTime+"-"+endTime);
						
	/*					Relations totalStartSpace = segmentation.getAllRelations().getByTime(spaceTimeCriteria.getDateLabel(), startTime.getYear());
						Relations totalEndSpace = segmentation.getAllRelations().getByTime(spaceTimeCriteria.getDateLabel(), endTime.getYear());
						
						Relations filteredStartSpace = slices.getStation(startTime);
						Relations filteredEndSpace = slices.getStation(endTime);
						
						Partition<Individual> partition = new Partition<Individual>();
						partition.setLabel(spaceTimeCriteria.getRelationModelName()+" "+startTime+"-"+endTime);
						
						PartitionCriteria partitionCriteria = new PartitionCriteria();
						partitionCriteria.setLabel(partition.getLabel());
						
						Individuals totalStartPopulation = totalStartSpace.getIndividuals();
						Individuals totalEndPopulation = totalEndSpace.getIndividuals();
						Individuals filteredStartPopulation = filteredStartSpace.getIndividuals();
						Individuals filteredEndPopulation = filteredEndSpace.getIndividuals();
						
						// Forward 
						
						Partition<Individual> destinations = new Partition<Individual>();
						destinations.setLabel("Destinations "+startTime+"/"+endTime);
						
						for (Individual individual : filteredStartSpace.getIndividuals().toSortedList()){
							if (IndividualValuator.lifeStatusAtYear(individual, endTime.getYear()).equals("DEAD")){
								partition.put(individual, new Value("DIED"));
							} else if (!totalEndPopulation.contains(individual)){
								partition.put(individual, new Value("UNKNOWN DESTINATION"));
							} else if (!filteredEndPopulation.contains(individual)){
								partition.put(individual, new Value("LEFT"));
								for (Relation destination : totalEndSpace.getByIndividual(individual)){
									destinations.put(individual,RelationValuator.get(destination,"PLACE",statisticsCriteria.getPlaceParameter()));
								}
							} else {
								Relation start = filteredStartSpace.getByIndividual(individual).getFirst();
								Relation end = filteredEndSpace.getByIndividual(individual).getFirst();
								String startUnit = start.getAttributeValue(slices.idLabel());
								if (startUnit==null){
									startUnit = start.getAttributeValue(spaceTimeCriteria.getPlaceLabel());
								}
								String endUnit = end.getAttributeValue(slices.idLabel());
								if (endUnit==null){
									endUnit = start.getAttributeValue(spaceTimeCriteria.getPlaceLabel());
								}
								if (!startUnit.equals(endUnit)){
									partition.put(individual, new Value("INTERNAL CHANGE"));
								} else {
									partition.put(individual, new Value("UNCHANGED"));
								}
							}
						}
						
						// Backward 
						
						Partition<Individual> origins = new Partition<Individual>();
						origins.setLabel("Origins "+startTime+"/"+endTime);
		
						for (Individual individual : filteredEndSpace.getIndividuals().toSortedList()){
							if (IndividualValuator.lifeStatusAtYear(individual, startTime.getYear()).equals("UNBORN")){
								partition.put(individual, new Value("NEWBORN"));
							} else if (!totalStartPopulation.contains(individual)){
								partition.put(individual, new Value("UNKNOWN ORIGIN"));
							} else if (!filteredStartPopulation.contains(individual)){
								partition.put(individual, new Value("ENTERED"));
								for (Relation origin : totalStartSpace.getByIndividual(individual)){
									origins.put(individual,RelationValuator.get(origin,"PLACE",statisticsCriteria.getPlaceParameter()));
								}
							} else if (!filteredStartSpace.getByIndividual(individual).equals(filteredEndSpace.getByIndividual(individual))){
		//						partition.put(individual, new Value("INTERNAL CHANGE2"));
							} else {
		//						partition.put(individual, new Value("UNCHANGED2"));
							}
						}*/
						
	/*					for (Cluster<Individual> cluster : destinations.getClusters()){
							System.out.println(cluster+"\t"+cluster.size()+"\t"+cluster.getItemsAsString());
						}*/
						
						ReportChart chartChanges = StatisticsReporter.createPartitionChart(census.get("MIGRATIONS").get(endTime), partitionCriteria, statisticsCriteria.getSplitCriteria());
						charts.add(chartChanges);
						
						ReportTable tableChanges = ReportTable.transpose(chartChanges.createReportTableWithSum());
						tables.add(tableChanges);
						
						ReportChart chartDestinations = StatisticsReporter.createPartitionChart(census.get("DESTINATIONS").get(startTime), partitionCriteria, statisticsCriteria.getSplitCriteria());
						charts.add(chartDestinations);
						
						ReportTable tableDestinations = ReportTable.transpose(chartDestinations.createReportTableWithSum());
						tables.add(tableDestinations);
						
						ReportChart chartOrigins = StatisticsReporter.createPartitionChart(census.get("ORIGINS").get(endTime), partitionCriteria, statisticsCriteria.getSplitCriteria());
						charts.add(chartOrigins);
						
						ReportTable tableOrigins = ReportTable.transpose(chartOrigins.createReportTableWithSum());
						tables.add(tableOrigins);
		
					}
					
					int nr = Math.min(4, 2*times.size());
					
					// Manage the number of chart by line.
					for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
						result.outputs().append(charts.get(chartIndex));
						if (chartIndex % nr == nr-1) {
							result.outputs().appendln();
						}
					}
		
					// Add chart tables.
					for (ReportTable table : tables) {
						result.outputs().appendln(table);
		
					}
					
					result.setTimeSpent(chrono.stop().interval());
				}
		
				//
				return result;
			}


	public static Report reportIndividualStatics(final Segmentation segmentation, final Sequence<Relations> slices, final SpaceTimeCriteria spaceTimeCriteria, final StatisticsCriteria criteria) throws PuckException{
			Report result;
			
			if (criteria == null) {
				throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
			} else {
				result = new Report("Population Statics "+spaceTimeCriteria.getRelationModelName());
				Chronometer chrono = new Chronometer();
	
				result.setOrigin("Relation reporter");
	//			result.setTarget(spaces.getLabel());
	
				// Compute charts and tables.
				for (PartitionCriteria partitionCriteria : criteria.getPartitionCriterias()) {
	
					if (StringUtils.isEmpty(partitionCriteria.getLabel())) {
						continue;
					}
	
					List<ReportChart> charts = new ArrayList<ReportChart>(20);
					List<ReportTable> tables = new ArrayList<ReportTable>(20);
					
					SequenceStatistics<Sequence<Relations>,Relations> sequenceStatistics = new SequenceStatistics<Sequence<Relations>,Relations>(segmentation, slices, spaceTimeCriteria);
					Map<Ordinal,Partition<Individual>> census = sequenceStatistics.getDatedIndividualCensus(spaceTimeCriteria, partitionCriteria);
					
					for (Ordinal time : slices.getTimes()){
						
						Partition<Individual> partition = census.get(time);
	
						/*
						String label = spaceTimeCriteria.getRelationModelName()+" "+time;
						Relations relations = slices.getStation(time);
						Partition<Individual> partition = new Partition<Individual>();
						
						if (partitionCriteria.getLabel().equals("REFERENT")){
	
							partitionCriteria.setLabelParameter(spaceTimeCriteria.getRelationModelName()+" "+spaceTimeCriteria.getEgoRoleName()+" "+time);
							Partition<Individual> prePartition = PartitionMaker.create(label, relations.getIndividuals(), relations, partitionCriteria);
							
							for (Individual ego : prePartition.getItemsAsList()){
								Value alterId = prePartition.getValue(ego);
								if (alterId!=null){
									List<String> alterRoles = NetUtils.getAlterRoles(ego, segmentation.getAllIndividuals().getById(alterId.intValue()), ToolBox.stringsToInts(spaceTimeCriteria.getPattern()), spaceTimeCriteria.getRelationModelNames(), spaceTimeCriteria.getChainClassification(), null, null);
									Collections.sort(alterRoles);
									partition.put(ego, new Value(alterRoles.toString()));
								}
							}
							
							
						} else {
							if (partitionCriteria.getLabel().equals("AGE") || partitionCriteria.getLabel().equals("MATRISTATUS")|| partitionCriteria.getLabel().equals("OCCUPATION")){
								partitionCriteria.setLabelParameter(time+"");
							} 
							partition = PartitionMaker.create(label, relations.getIndividuals(), relations, partitionCriteria);
						}*/
						//
	
						ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria());
						charts.add(chart);
						
						ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
						tables.add(table);
	
					}
					
					int nr = Math.min(4, slices.getNrStations());
					
					// Manage the number of chart by line.
					for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
						result.outputs().append(charts.get(chartIndex));
						if (chartIndex % nr == nr-1) {
							result.outputs().appendln();
						}
					}
	
					// Add chart tables.
					for (ReportTable table : tables) {
						result.outputs().appendln(table);
					}
				}
	
				result.setTimeSpent(chrono.stop().interval());
			}
	
			//
			return result;
		}


	public static Report reportEgoNetworks (Sequence<Relations> slices, final StatisticsCriteria criteria, final SpaceTimeCriteria spaceTimeCriteria) throws PuckException{
			Report result;
			
			if ((slices == null) || (criteria == null)) {
				throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
			} else {
				result = new Report("Ego Networks "+spaceTimeCriteria.getRelationModelName());
				Chronometer chrono = new Chronometer();
	
				result.setOrigin("Space reporter");
				
				SequencesCensus census = new SequencesCensus(slices.toSequencesByEgo(), spaceTimeCriteria);
				Individuals members = slices.getIndividuals();
				
				// Create Reports
				Report overallReport = new Report("Survey");
				Report diagramReport = new Report("Diagrams");
				Report detailReport = new Report("Details");
				Report componentReport = new Report("Components");
						
				// Create Partition charts and tables
				List<ReportChart> charts = new ArrayList<ReportChart>();
				List<ReportTable> tables = new ArrayList<ReportTable>();
					
				// Make overall report and diagrams
				overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
	
				// Set partition criteria 
				for (String label : spaceTimeCriteria.getCensusOperationLabels()){
					
					PartitionCriteria partitionCriteria = new PartitionCriteria(label);
					
					ReportChart chart = null;
					
					if (!label.contains("ALTERS") && !label.contains("PROFILE")){
						NumberedValues values = census.getValues(label);
						
						Partition<Relation> partition = PartitionMaker.create(label, slices.getStation(slices.getTimes().get(0)), values, partitionCriteria);
					
						PartitionCriteria splitCriteria = new PartitionCriteria(spaceTimeCriteria.getPartitionLabel());
						chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, null);
	
						overallReport.outputs().append(label+"\t");
						String sum = "";
						if (label.startsWith("NR")){
							sum = new Double(values.sum()).intValue()+"";
						}
						overallReport.outputs().append(MathUtils.round(values.average(),2)+"\t"+MathUtils.round(values.averagePositives(),2)+"\t"+values.median()+"\t"+values.max()+"\t"+sum+"\t");
						overallReport.outputs().appendln();
					}
				
					if (chart != null) {
						charts.add(chart);
						ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
						tables.add(table);
						if (!label.contains("EVENTS_") && !label.contains("RELATIONS")){
							tables.add(ReportTable.normalize(table));
						}
					}
				}
			
				overallReport.outputs().appendln();
			
				
			// Make overall report and diagrams
			overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
	
			// Set partition criteria 
			for (String label : spaceTimeCriteria.getCensusOperationLabels()){
				
				PartitionCriteria partitionCriteria = new PartitionCriteria(label);
	//			partitionCriteria.setValueFilter(ValueFilter.NULL);
				
	/*			if (label.contains("PROFILE")){
					partitionCriteria.setType(PartitionType.PARTIALIZATION);
				} */
				
				if (label.equals("NREVENTS")){
					partitionCriteria.setType(PartitionType.RAW);
	//				partitionCriteria.setCumulationType(CumulationType.DESCENDANT);
				} else if (label.contains("AGEFIRST")){
					partitionCriteria.setType(PartitionType.SIZED_GROUPING);
					partitionCriteria.setStart(0.);
					partitionCriteria.setSize(5.);
				} else if (label.equals("ECCENTRICITY")){
					partitionCriteria.setType(PartitionType.SIZED_GROUPING);
					partitionCriteria.setStart(-100.);
					partitionCriteria.setSize(20.);
				} else if (label.contains("COVERAGE") || label.contains("SAME")|| label.contains("NORM")|| label.contains("DENSITY")|| label.contains("BETWEENNESS") || label.contains("EFFICIENCY")|| label.contains("CONCENTRATION")){
					partitionCriteria.setType(PartitionType.SIZED_GROUPING);
					partitionCriteria.setStart(0.);
					partitionCriteria.setSize(20.);
				} else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS")|| label.contains("BROKERAGE")|| label.contains("EFFICIENT_SIZE")){
					partitionCriteria.setType(PartitionType.SIZED_GROUPING);
					partitionCriteria.setStart(0.);
					partitionCriteria.setSize(1.);
				} else {
					partitionCriteria.setType(PartitionType.RAW);
				}
				
				ReportChart chart = null;
				
				if (!label.contains("ALTERS") && !label.contains("PROFILE")){
					NumberedValues values = census.getValues(label);
					
					Partition<Individual> partition = PartitionMaker.create(label, members, values, partitionCriteria);
				
					PartitionCriteria splitCriteria = new PartitionCriteria(spaceTimeCriteria.getPartitionLabel());
					chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
	
					if (label.substring(0, 3).equals("AGE")){
						
						partitionCriteria.setType(PartitionType.RAW);
						partitionCriteria.setSizeFilter(SizeFilter.HOLES);
						partitionCriteria.setValueFilter(ValueFilter.NULL);
					
						partition = PartitionMaker.create(label, members, values, partitionCriteria);
						
						if (partition.maxValue()!=null){
							ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
							charts.add(survivalChart);
						} else {
							System.err.println(label+" no max value");
						}
					}
					
					NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, members);
					
					overallReport.outputs().append(label+"\t");
					for (int gender=0;gender<3;gender++){
						String sum = "";
						if (label.startsWith("NR")){
							sum = new Double(genderedValues[gender].sum()).intValue()+"";
						}
						overallReport.outputs().append(MathUtils.round(genderedValues[gender].average(),2)+"\t"+MathUtils.round(genderedValues[gender].averagePositives(),2)+"\t"+values.median()+"\t"+genderedValues[gender].max()+"\t"+sum+"\t");
					}
					overallReport.outputs().appendln();
					
				}
			
				if (chart != null) {
					charts.add(chart);
						ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
						tables.add(table);
						if (!label.contains("EVENTS_") && !label.contains("RELATIONS")){
							tables.add(ReportTable.normalize(table));
						}
					
	
				}
			
			}
			overallReport.outputs().appendln();
			
			// Create detailed report
			detailReport.outputs().append("Nr\tEgo\tGender");
			for (String partitionLabel : spaceTimeCriteria.getCensusOperationLabels()){
					detailReport.outputs().append("\t"+partitionLabel);
			}
			
			Map<String,Map<String,Double>> componentChartMap = new TreeMap<String,Map<String,Double>>();
			
			detailReport.outputs().appendln();
			for (Individual ego : members.toSortedList()){
							
				if (census.getValues("SIZE").get(ego.getId())!=null) {
					detailReport.outputs().append(ego.getId()+"\t"+ego+"\t"+ego.getGender());
					for (String label : spaceTimeCriteria.getCensusOperationLabels()){
							detailReport.outputs().append("\t"+census.getValues(label).get(ego.getId()));
					}
					detailReport.outputs().appendln();
				}
								
					for (String networkTitle : spaceTimeCriteria.getNetworkTitles()){
						Map<Integer,Partition<Node<Individual>>> componentsMap = census.getComponents(networkTitle);
						if (componentsMap!=null){
							Partition<Node<Individual>> components = componentsMap.get(ego.getId());
							
							componentReport.outputs().appendln("Components "+networkTitle);
							componentReport.outputs().appendln(ego+"\t"+components.size());
							int i=1;
							for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()){
								componentReport.outputs().appendln("\t"+i+"\t"+cluster.getValue()+"\t("+cluster.size()+")\t"+cluster.getItemsAsString());
								i++;
							}
							componentReport.outputs().appendln();
							
							for (Value value : components.getValues()){
								String label = value.toString();
								Map<String,Double> map = componentChartMap.get(label);
								if (map==null){
									map = new TreeMap<String,Double>();
									for (Gender gender : Gender.values()){
										map.put(gender.toString(), 0.);
									}
									componentChartMap.put(label, map);
								}
								map.put(ego.getGender().toString(), map.get(ego.getGender().toString())+1);
							}
						}
					}
				}
			
			
				ReportChart componentChart = StatisticsReporter.createChart("COMPONENTS", componentChartMap);
				charts.add(componentChart);
				tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
			
				if (census.getRelationConnectionMatrix()!=null){
					for (ReportChart chart : census.getRelationConnectionMatrix().getCharts()){
						charts.add(chart);
					}
					tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
				}
			
			
			// Manage the number of chart by line.
			for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
				diagramReport.outputs().append(charts.get(chartIndex));
				if (chartIndex % 4 == 3) {
					diagramReport.outputs().appendln();
				}
			}
			
			// Add chart tables.
			for (ReportTable table : tables) {
				diagramReport.outputs().appendln(table.getTitle());
				diagramReport.outputs().appendln(table);
			}
			
			// Finalize reports
			result.outputs().append(overallReport);
			result.outputs().append(diagramReport);
			result.outputs().append(detailReport);
			
			result.outputs().append(componentReport);
			
			//addPajekData
			
			Map<String,StringList> pajekBuffers = census.getPajekBuffers();
			
			for (String title : pajekBuffers.keySet()){
				
				StringList pajekBuffer = pajekBuffers.get(title);
				if (pajekBuffer.length() != 0) {
					File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(spaceTimeCriteria.getRelationModelName()), "-"+title), ".paj");
					ReportRawData rawData = new ReportRawData("Export "+title+"s to Pajek", "Pajek", "paj", targetFile);
					rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
	
					result.outputs().appendln();
					result.outputs().append(rawData);
				}
			}
			
	
			//
			result.setTimeSpent(chrono.stop().interval());
			}
	
			//
			return result;
		}


	public static Report reportGeneralSequenceCensus(final Sequence<Relations> slices, final StatisticsCriteria criteria, final SpaceTimeCriteria spaceTimeCriteria) throws PuckException{
				Report result;
				
				if ((slices == null) || (criteria == null)) {
					throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
				} else {
					result = new Report("Development Cycles "+spaceTimeCriteria.getRelationModelName());
					Chronometer chrono = new Chronometer();
		
					result.setOrigin("Space reporter");
					
	/*				SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria();
					
					censusCriteria.setCensusType(CensusType.PARCOURS);
					censusCriteria.addNetworkTitle("Event Type Network");
					censusCriteria.getMainRelationClassificationTypes().add(RelationClassificationType.TREES);
					censusCriteria.getEventTypes().add(RelationClassificationType.TREES);
					
					for (RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()){
						censusCriteria.getCensusOperationLabels().add("PROFILE_"+relationClassificationType);
						censusCriteria.getCensusOperationLabels().add("SUPPORT_"+relationClassificationType);
					}*/
		
					SequencesCensus census = new SequencesCensus(slices.toSequencesByIdValue(), spaceTimeCriteria);
					CensusType censusType = spaceTimeCriteria.getCensusType();
					
					// Create Reports
					Report overallReport = new Report("Survey");
					Report diagramReport = new Report("Diagrams");
					Report detailReport = new Report("Details");
					Report componentReport = new Report("Components");
					Report treeReport = new Report("Trees");
							
					// Create Partition charts and tables
					List<ReportChart> charts = new ArrayList<ReportChart>();
					List<ReportTable> tables = new ArrayList<ReportTable>();
						
					// Make overall report and diagrams
					overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
		
					// Set partition criteria 
					for (String label : spaceTimeCriteria.getCensusOperationLabels()){
						
						PartitionCriteria partitionCriteria = new PartitionCriteria(label);
						
						ReportChart chart = null;
						
						if (!label.contains("ALTERS") && !label.contains("PROFILE")){
							NumberedValues values = census.getValues(label);
							
							Partition<Relation> partition = PartitionMaker.create(label, slices.getStation(slices.getFirstTime()), values, partitionCriteria);
						
							PartitionCriteria splitCriteria = new PartitionCriteria(spaceTimeCriteria.getPartitionLabel());
							chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, null);
		
							overallReport.outputs().append(label+"\t");
								String sum = "";
								if (label.startsWith("NR")){
									sum = new Double(values.sum()).intValue()+"";
								}
								overallReport.outputs().append(MathUtils.round(values.average(),2)+"\t"+MathUtils.round(values.averagePositives(),2)+"\t"+values.median()+"\t"+values.max()+"\t"+sum+"\t");
							overallReport.outputs().appendln();
							
						}
					
						if (chart != null) {
							charts.add(chart);
								ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
								tables.add(table);
								if (!label.contains("EVENTS_") && !label.contains("RELATIONS")){
									tables.add(ReportTable.normalize(table));
								}
		
						}
					
					}
					overallReport.outputs().appendln();
					
					// Create detailed report
					detailReport.outputs().append("Nr\tEgo\tGender");
					for (String partitionLabel : spaceTimeCriteria.getCensusOperationLabels()){
							detailReport.outputs().append("\t"+partitionLabel);
					}
					
					detailReport.outputs().appendln();
					for (Sequence<Numberable> sequence: slices.toSequencesByIdValue()){
						
	//					Individual ego = sequence.getEgo();
						
						if ((((censusType==CensusType.GENERAL) || (censusType==CensusType.PARCOURS)))) {
							detailReport.outputs().append(ego.getLongId()+"\t"+ego);
							for (String label : spaceTimeCriteria.getCensusOperationLabels()){
								if (label.contains("SIMILARITY")){
									Value value = census.getValues(label).get(ego.getLongId());
									Map<Value,Double[]> indiSimilaritiesMap = (Map<Value,Double[]>)value.mapValue();
									String[] keys = new String[]{"PARENT","CHILD","SIBLING","SPOUSE"};
									for (String key : keys){
										Double[] sim = indiSimilaritiesMap.get(new Value(key));
										if (sim!=null){
											detailReport.outputs().append("\t"+MathUtils.round(sim[4], 2));
										}
									}
								} else {
									detailReport.outputs().append("\t"+census.getValues(label).get(ego.getLongId()));
								}
							}
							detailReport.outputs().appendln();
						}
						
					}
					
					
					// SequenceAnalysis
					
					if (censusType == CensusType.PARCOURS){
						
						for (RelationClassificationType relationClassificationType : spaceTimeCriteria.getMainRelationClassificationTypes()){
							
							if (spaceTimeCriteria.getNetworkTitles().contains("Event Type Network")){
		
								CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix(relationClassificationType.toString());
								
								if (eventSequenceMatrix!=null){
									eventSequenceMatrix.setUngendered(true);
									for (ReportChart chart : eventSequenceMatrix.getCharts()){
										charts.add(chart);
									}
									tables.add(eventSequenceMatrix.getTable("Event Type Sequences"));
								}
								
								overallReport.outputs().appendln();
								overallReport.outputs().appendln("Sequence Network Statistics "+relationClassificationType);
								overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
								
								for (Gender gender : Gender.values()){
									GraphProfile<Cluster<String>> profile = eventSequenceMatrix.getProfile(gender);
		
									String centralReferents = "";
									for (Cluster<String> centralReferent : profile.getCentralReferents()){
										centralReferents+=centralReferent.getValue()+" ";
									}
									double maxBetweenness = profile.getMaxBetweenness();
									double density = profile.density();
									double endo = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.NORMALIZED),2);
									double endoExp = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.DIVERGENCE_NORMALIZED),2);
									double conc = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.SIMPLE),2);
									double concExp = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.DIVERGENCE),2);
									double sym = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.SIMPLE),2);
									double symExp = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.DIVERGENCE),2);
		
									overallReport.outputs().appendln(gender+"\t"+density+"\t"+endo+"\t"+endoExp+"\t"+conc+"\t"+concExp+"\t"+sym+"\t"+symExp+"\t"+centralReferents +"("+maxBetweenness+") betweenness centrality");
								}
								overallReport.outputs().appendln();
		
							}
							
							if (spaceTimeCriteria.getNetworkTitles().contains("Sequence Type Network")){
		
								CorrelationMatrix subSequenceMatrix = census.getSubSequenceMatrix(relationClassificationType.toString());
								
								if (subSequenceMatrix!=null){
									charts.add(subSequenceMatrix.getRamificationChart());
								}
							}
							
							
		//					reportSequencePartition(overallReport,"",census.getEventPartition(eventTypeName),census.getEventPairPartition(eventTypeName),census.nrSequences(),census.nrEvents());
		//					reportSequenceTree(treeReport,"",census.getSequenceTypeNetwork(eventTypeName));
							
			/*				int maxPositions = census.getNrValues(eventType,eventType.toString());
									
							ReportChart diversityChart = StatisticsReporter.createDiversityChart(census.getDepthPartition(eventType.toString()), maxPositions);
							charts.add(diversityChart);*/
						}
					}
					
					// Manage the number of chart by line.
					for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
						diagramReport.outputs().append(charts.get(chartIndex));
						if (chartIndex % 4 == 3) {
							diagramReport.outputs().appendln();
						}
					}
					
					// Add chart tables.
					for (ReportTable table : tables) {
						diagramReport.outputs().appendln(table.getTitle());
						diagramReport.outputs().appendln(table);
					}
					
					// Finalize reports
					result.outputs().append(overallReport);
					result.outputs().append(diagramReport);
					result.outputs().append(detailReport);
					
					if (censusType == CensusType.EGONETWORKS || censusType ==CensusType.PARCOURSNETWORKS){
						result.outputs().append(componentReport);
					}
					if (censusType == CensusType.PARCOURS) {
						result.outputs().append(treeReport);
					}
					
					//addPajekData
					
					Map<String,StringList> pajekBuffers = census.getPajekBuffers();
					
					for (String title : pajekBuffers.keySet()){
						
						StringList pajekBuffer = pajekBuffers.get(title);
						if (pajekBuffer.length() != 0) {
							File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(spaceTimeCriteria.getRelationModelName()), "-"+title), ".paj");
							ReportRawData rawData = new ReportRawData("Export "+title+"s to Pajek", "Pajek", "paj", targetFile);
							rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
		
							result.outputs().appendln();
							result.outputs().append(rawData);
						}
					}
		
								
					
					result.setTimeSpent(chrono.stop().interval());
		
				}
					
		
				
				//
				return result;
			}


	public static Report reportItineraries (final Segmentation segmentation, final SpaceTimeCriteria criteria) throws PuckException{
			Report result;
			
			if ((segmentation == null) || (criteria.getRelationModelName() == null)) {
				throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
			} else {
				
				result = new Report("Itineraries "+criteria.getRelationModelName());
	
				Chronometer chrono = new Chronometer();
				
				result.setOrigin("Relation reporter");
				
				List<String> indicators = Arrays.asList(new String[]{"PLACE","REFERENT_CHAIN","REFERENT_CHAIN_TYPE","REFERENT_KIN","REFERENT_KIN_TYPE","REFERENT"});
				List<String> matrixIndicators = Arrays.asList(new String[]{"REFERENT_CHAIN","REFERENT_KIN"});
				
				Sequences houses = SequenceMaker.createRelationSequences(segmentation, criteria);
				SequenceStatistics<Sequence<Relation>,Relation> houseStatistics = new SequenceStatistics<Sequence<Relation>,Relation>(segmentation, houses, criteria, indicators);
				houseStatistics.putMemberValues(criteria);
	//			houseStatistics.getMemberValues(segmentation);
				
				Report reportCensus = new Report("Census");
				Report reportSequences = new Report("Sequences");
				Report reportMatrices = new Report("Matrices");
				
				Individuals members = houses.getIndividuals(segmentation);
				
				// Sequence report
				
				String headLine1 = "Id\tNAME\tGENDER\t";
				String dateLine1 = "\t\t\t";
				for (String indicator : indicators){
					
					headLine1 += indicator;
	
					for (Integer year : criteria.getDates()){
						
						headLine1 += "\t";
						dateLine1 += year+"\t";
					}
	
	//				headLine1 += "\t";
	//				dateLine1 += "TREND\t";
				}
				
				reportSequences.outputs().appendln(headLine1);
				reportSequences.outputs().appendln(dateLine1);
				
				for (Individual member : members.toSortedList()){
					String memberLine = member.getId()+"\t"+member.getName()+"\t"+member.getGender()+"\t";
					
					for (String indicator : indicators){
						
						for (Integer year : criteria.getDates()){
		
							Ordinal time = new Ordinal(year);
							Object value = houseStatistics.getValue(member, time, indicator);
	//						Object value = houseStatistics.getByIndividual(member, time, indicator);
							
							memberLine += value+"\t";
						}
					}
					reportSequences.outputs().appendln(memberLine);
				}
				
				// Census and Matrix report
				
				StringList pajekBuffer = new StringList();
	
				for (String matrixIndicator : matrixIndicators){
					
					reportMatrices.outputs().appendln("Transition Matrix "+matrixIndicator);
					reportMatrices.outputs().appendln();
					
					reportCensus.outputs().appendln(matrixIndicator+" Position Census");
					reportCensus.outputs().appendln();
					
					String headLine0 = "Position\t";
					for (Integer year : criteria.getDates()){
						headLine0 += year+"\t";
					}
					reportCensus.outputs().appendln(headLine0);
						
					Map<Ordinal,Partition<Individual>> individualValueCensuses = houseStatistics.getDatedIndividualCensus(segmentation, matrixIndicator);
					
					Map<Value,Double> meanValueFrequencies = houseStatistics.getMeanValueFrequencies(individualValueCensuses, members);
	//				Map<String,Double> meanValueFrequencies = houseStatistics.getMeanIndividualValueFrequencies(segmentation, matrixIndicator, criteria.getDates());
	
					Partition<Individual> individualSequenceCensus = houseStatistics.getSequenceCensus(individualValueCensuses, members);
	//				Partition<Individual> individualSequenceCensus = houseStatistics.getIndividualSequenceCensus(segmentation, matrixIndicator);
	
					for (Value value : meanValueFrequencies.keySet()){
						String valueLine = value+"";
						for (Integer year : criteria.getDates()){
							int count = 0;
							Cluster<Individual> cluster = individualValueCensuses.get(new Ordinal(year)).getCluster(new Value(value));
							if (cluster!=null){
								count += cluster.size();
							}
							valueLine += "\t"+count;
						}
						reportCensus.outputs().appendln(valueLine);
					}
					reportCensus.outputs().appendln();
	
					reportCensus.outputs().appendln(matrixIndicator+" Sequence Census");
					reportCensus.outputs().appendln();
					reportCensus.outputs().appendln("Sequence");
					
					int sequenceCount = individualSequenceCensus.itemsCount();
					
					for (Cluster<Individual> cluster : individualSequenceCensus.getClusters().toListSortedByDescendingSize()){
						reportCensus.outputs().appendln(cluster.getValue()+"\t"+cluster.size()+"\t"+MathUtils.percent(cluster.size(), sequenceCount));
					}
					reportCensus.outputs().appendln();
					
					Map<Ordinal,Partition<Individual>> census = houseStatistics.getDatedIndividualCensus(segmentation, matrixIndicator);
					Matrix matrix = houseStatistics.getTransitionMatrix(census, members);
					
	//				Matrix matrix = houseStatistics.getIndividualTransitionMatrix(segmentation, matrixIndicator);
					
					String headLine = "\t";
					for (int col=0;col<matrix.getRowDim();col++){
						headLine += matrix.getColLabel(col)+"\t";
					}
					reportMatrices.outputs().appendln(headLine);
					
					for (int row=0;row<matrix.getRowDim();row++){
						String rowLine = matrix.getRowLabel(row)+"\t";
						for (int col=0;col<matrix.getRowDim();col++){
							rowLine += matrix.getAsRowPercentage(row, col)+"\t";
						}
						reportMatrices.outputs().appendln(rowLine);
					}
					reportMatrices.outputs().appendln();
					
					// Transition graph
					
					Graph<Node<String>> transitionGraph = GraphMaker.createGraph("Transition Graph "+criteria.getRelationModelName()+" "+matrixIndicator, matrix, meanValueFrequencies, "MEAN");
							
	/*				Graph<Node<String>> transitionGraph = new Graph<Node<String>>("Transition Graph "+criteria.getRelationModelName()+" "+matrixIndicator);
					
					for (int row=0;row<matrix.getRowDim();row++){
						Node<String> node = new Node<String>(row,matrix.getRowLabel(row));
						Double mean = meanValueFrequencies.get(new Value(matrix.getRowLabel(row)));
						if (mean==null){
							node.setAttribute("MEAN","0.");
						} else {
							node.setAttribute("MEAN", mean+"");
						}
						transitionGraph.addNode(row,node);
					}
					
					for (int row=0;row<matrix.getRowDim();row++){
						for (int col=0;col<matrix.getRowDim();col++){
							if (matrix.get(row, col) > 0){
								transitionGraph.addArcWeight(row, col, matrix.get(row,col));
							}
						}
					}*/
					
					List<String> partitionLabels = new ArrayList<String>();
					partitionLabels.add("MEAN");
					pajekBuffer.addAll(PuckUtils.writePajekNetwork(transitionGraph, partitionLabels));
					pajekBuffer.appendln();
	
				}
				
				if (pajekBuffer.length() != 0) {
					File targetFile = ToolBox.setExtension(ToolBox.addToName(new File("Transition graphs_"), criteria.getRelationModelName()), ".paj");
					ReportRawData rawData = new ReportRawData("Export Transition Graphs to Pajek", "Pajek", "paj", targetFile);
					rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
	
					result.outputs().appendln();
					result.outputs().append(rawData);
				}
	
				result.outputs().append(reportCensus);
				result.outputs().append(reportSequences);
				result.outputs().append(reportMatrices);
			}
			//
			return result;
		}


	public static Report reportTreeStructure(final Segmentation segmentation, final SpaceTimeCriteria criteria, boolean reducedTrees) throws PuckException{
			Report result;
			
			if ((segmentation == null) || (criteria.getRelationModelName() == null)) {
				throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
			} else {
				
				result = new Report("Cluster Structure "+criteria.getRelationModelName());
				
				Chronometer chrono = new Chronometer();
				
				result.setOrigin("Relation reporter");
				
				List<String> indicators1 = Arrays.asList(new String[]{"GRAPH","SIZE","MAXDEPTH","MEANDEPTH","MEANINDEGREE","DIAMETER","NRCOMPONENTS","MAXCOMPONENT","CONCENTRATION"});			
				List<String> indicators2 = Arrays.asList(new String[]{"TREES_BY_ID","TREES_BY_GENDER","TREES_BY_KIN"});
				List<String> matrixIndicators = Arrays.asList(new String[]{"CHAIN","KIN"});		
				
				CensusCriteria censusCriteria = new CensusCriteria();
				censusCriteria.setPattern(criteria.getPattern());
				censusCriteria.setChainClassification(criteria.getChainClassification());
				censusCriteria.setRelationAttributeLabel(criteria.getLocalUnitLabel());
				censusCriteria.setRestrictionType(RestrictionType.ALL);
				censusCriteria.setSymmetryType(SymmetryType.INVERTIBLE);
				censusCriteria.setClosingRelation("TOTAL");
	
				Sequences<Relation> sequences = SequenceMaker.createRelationSequences(segmentation, criteria);
			
				SequenceStatistics<Sequence<Relation>,Relation> houseStatistics1 = new SequenceStatistics<Sequence<Relation>,Relation>(segmentation, sequences, criteria, indicators1);
				SequenceStatistics<Sequence<Relation>,Relation> houseStatistics2 = new SequenceStatistics<Sequence<Relation>,Relation>(segmentation, sequences, criteria, indicators2);
				SequenceStatistics<Sequence<Relation>,Relation> houseStatistics3 = new SequenceStatistics<Sequence<Relation>,Relation>(segmentation, sequences, criteria, new ArrayList<String>());
				SequenceStatistics<Sequence<Relation>,Relation> houseStatistics4 = new SequenceStatistics<Sequence<Relation>,Relation>(segmentation, sequences, criteria, new ArrayList<String>());
				SequenceStatistics<Sequence<Relation>,Relation> houseStatistics5 = new SequenceStatistics<Sequence<Relation>,Relation>(segmentation, sequences, criteria, new ArrayList<String>());
				SequenceStatistics<Sequence<Relation>,Relation> houseStatistics6 = new SequenceStatistics<Sequence<Relation>,Relation>(segmentation, sequences, criteria, null);
				
				houseStatistics1.putSequenceValues();
				houseStatistics2.putSequenceValues();
		
				Map<Ordinal,Partition<Sequence<Relation>>>  referentKinCensus = houseStatistics3.getDatedSequenceCensus("REFERENT_KIN", criteria);	
				Map<Ordinal,Partition<Sequence<Relation>>>  allKinCensus = houseStatistics4.getDatedSequenceCensus("ALL_KIN", criteria);	
				Map<Ordinal,Partition<Sequence<Relation>>>  referentChainCensus = houseStatistics5.getDatedSequenceCensus("REFERENT_CHAIN", criteria);	
	
	//			houseStatistics4.getAllKinCensus(segmentation, censusCriteria);	
	//			Map<Ordinal,Partition<Sequence<Relation>>>  referentChainCensus = houseStatistics5.getReferentChainCensus();	
	//			Map<Ordinal,Partition<Sequence<Relation>>>  referentKinCensus = houseStatistics3.getReferentKinCensus();	
	
				List<String> indicators3 = houseStatistics3.indicators();
				List<String> indicators4 = houseStatistics4.indicators();
				List<String> indicators5 = houseStatistics5.indicators();
				
				StringList pajekBuffer2 = new StringList();
				
				Partition<String> inFlows = houseStatistics6.getFlows("IN",criteria.getDateLabel());
				Partition<String> outFlows = houseStatistics6.getFlows("OUT",criteria.getDateLabel());
				Partition<String> allFlows = new Partition<String>();
				allFlows.add(inFlows);
				allFlows.add(outFlows);
				
				Report reportOverview = new Report("Overview");
				Report reportMetrics = new Report("Metrics");
				Report reportMorphology = new Report("Morphology");
				Report reportReferentKin = new Report("Referent kin census");
				Report reportKin = new Report("All kin census");
				Report reportReferentChain = new Report("Referent chain census");
				Report reportFlow = new Report("Flow census");
				
				for (Cluster<String> cluster : allFlows.getClusters().toListSortedByValue()){
					reportFlow.outputs().appendln(cluster.getValue());
					for (String item : cluster.getItems()){
						reportFlow.outputs().appendln("\t"+item);
					}
				}
				
				// ReferentChainCensus
				
				Set<Value> values = new HashSet<Value>();
				String timeLine = "Chain Types\t";
				String typeLine = "type\t";
				for (Ordinal time : referentChainCensus.keySet()){
					timeLine += time+"\t\t";
					typeLine += "#Houses\tHouses\t";
					Partition<Sequence<Relation>> partition = referentChainCensus.get(time);
					values.addAll(partition.getValues());
				}
				reportOverview.outputs().appendln(timeLine);
				reportOverview.outputs().appendln(typeLine);
	
				List<Value> valueList = new ArrayList<Value>(values);
				Collections.sort(valueList);
				
				for (Value value : valueList){
					String valueLine = value+"";
					for (Ordinal time : referentChainCensus.keySet()){
						Cluster<Sequence<Relation>> cluster = referentChainCensus.get(time).getCluster(value);
						if (cluster!=null){
							valueLine += "\t"+cluster.size()+"\t"+cluster.getItemsAsString();
						} else {
							valueLine += "\t0\t";
						}
					}
					reportOverview.outputs().appendln(valueLine);
				}
				reportOverview.outputs().appendln();
	
				// ReferentKinCensus
				
				Set<Value> values2 = new HashSet<Value>();
				String timeLine2 = "Kin Types\t";
				String typeLine2 = "type\t";
				for (Ordinal time : referentKinCensus.keySet()){
					timeLine2 += time+"\t\t";
					typeLine2 += "#Houses\tHouses\t";
					Partition<Sequence<Relation>> partition = referentKinCensus.get(time);
					values2.addAll(partition.getValues());
				}
				reportOverview.outputs().appendln(timeLine2);
				reportOverview.outputs().appendln(typeLine2);
	
				List<Value> valueList2 = new ArrayList<Value>(values2);
				Collections.sort(valueList2);
				
				for (Value value : valueList2){
					String valueLine = value+"";
					for (Ordinal time : referentKinCensus.keySet()){
						Cluster<Sequence<Relation>> cluster = referentKinCensus.get(time).getCluster(value);
						if (cluster!=null){
							valueLine += "\t"+cluster.size()+"\t"+cluster.getItemsAsString();
						} else {
							valueLine += "\t0\t";
						}
					}
					reportOverview.outputs().appendln(valueLine);
				}
				reportOverview.outputs().appendln();
	
				
				String headLine1 = "HOUSE\t";
				String dateLine1 = "\t";
				for (String indicator : indicators1){
					
					if (indicator.equals("GRAPH")){
						continue;
					}
					
					headLine1 += indicator;
	
					for (Integer year : criteria.getDates()){
						
						headLine1 += "\t";
						dateLine1 += year+"\t";
					}
	
					headLine1 += "\t";
					dateLine1 += "TREND\t";
				}
				
				reportMetrics.outputs().appendln(headLine1);
				reportMetrics.outputs().appendln(dateLine1);
				
				String headLine2 = "HOUSE\t";
				String dateLine2 = "\t";
				for (String indicator : indicators2){
					
					headLine2 += indicator;
	
					for (Integer year : criteria.getDates()){
						
						headLine2 += "\t";
						dateLine2 += year+"\t";
					}
	
	//				headLine1 += "\t";
	//				dateLine1 += "TREND\t";
				}
				
				reportMorphology.outputs().appendln(headLine2);
				reportMorphology.outputs().appendln(dateLine2);
	
				String headLine3 = "HOUSE\t";
				String dateLine3 = "\t";
				for (String indicator : indicators3){
					
					headLine3 += indicator;
	
					for (Integer year : criteria.getDates()){
						
						headLine3 += "\t";
						dateLine3 += year+"\t";
					}
	
					headLine3 += "\t";
					dateLine3 += "TREND\t";
				}
				
				reportReferentKin.outputs().appendln(headLine3);
				reportReferentKin.outputs().appendln(dateLine3);
	
				String headLine4 = "HOUSE\t";
				String dateLine4 = "\t";
				for (String indicator : indicators4){
					
					headLine4 += indicator;
	
					for (Integer year : criteria.getDates()){
						
						headLine4 += "\t";
						dateLine4 += year+"\t";
					}
	
					headLine4 += "\t";
					dateLine4 += "TREND\t";
				}
				
				reportKin.outputs().appendln(headLine4);
				reportKin.outputs().appendln(dateLine4);
	
				
				String headLine5 = "HOUSE\t";
				String dateLine5 = "\t";
				for (String indicator : indicators5){
					
					headLine5 += indicator;
	
					for (Integer year : criteria.getDates()){
						
						headLine5 += "\t";
						dateLine5 += year+"\t";
					}
	
					headLine5 += "\t";
					dateLine5 += "TREND\t";
				}
				
				reportReferentChain.outputs().appendln(headLine5);
				reportReferentChain.outputs().appendln(dateLine5);
	
				
				for (Sequence<Relation> house : sequences.toSortedList()){
					
					String houseLine1 = house+"\t";
					String houseLine2 = house+"\t";
					String houseLine3 = house+"\t";
					String houseLine4 = house+"\t";
					String houseLine5 = house+"\t";
	
					for (String indicator : indicators1){
						
						for (Integer year : criteria.getDates()){
		
							Ordinal time = new Ordinal(year);
							Value value = houseStatistics1.getValue(house, time, indicator);
	//						Value value = houseStatistics1.getBySequence(house, time, indicator);
							
							if (indicator.equals("GRAPH")) {
								
								if (value!=null) {
	
									List<String> partitionLabels = new ArrayList<String>();
									pajekBuffer2.addAll(PuckUtils.writePajekNetwork((Graph<Individual>)value.graphValue(), partitionLabels));
									pajekBuffer2.appendln();
	
								}
								
							} else if (value != null){
								
								houseLine1 += value+"\t";
								
							} else {
								
								houseLine1 += "\t";
	
							}
						}
						
						if (!indicator.equals("GRAPH")) {
							
							houseLine1 += houseStatistics1.getTrend(house, indicator)+"\t";
						
						}
					}
	
					for (String indicator : indicators2){
						
						for (Integer year : criteria.getDates()){
		
							Ordinal time = new Ordinal(year);
							Value value = houseStatistics2.getValue(house, time, indicator);
	//						Object value = houseStatistics2.getBySequence(house, time, indicator);
							
							if (value != null){
								
								houseLine2 += value+"\t";
								
							} else {
								
								houseLine2 += "\t";
	
							}
						}
					}
	
					for (String indicator : indicators3){
						
						for (Integer year : criteria.getDates()){
		
							Ordinal time = new Ordinal(year);
							Value value = houseStatistics3.getValue(house, time, indicator);
	//						Object value = houseStatistics3.getBySequence(house, time, indicator);
							
							if (value != null){
								
								houseLine3 += value+"\t";
								
							} else {
								
								houseLine3 += "\t";
	
							}
						}
						houseLine3 += houseStatistics3.getTrend(house, indicator)+"\t";
					}
	
					for (String indicator : indicators4){
						
						for (Integer year : criteria.getDates()){
		
							Ordinal time = new Ordinal(year);
							Value value = houseStatistics4.getValue(house, time, indicator);
	//						Value value = houseStatistics4.getBySequence(house, time, indicator);
							
	/*						if (value == null){
								value = 0.;
								houseStatistics4.put(house, time, indicator, value);
							} */
							houseLine4 += value+"\t";
						}
						houseLine4 += houseStatistics4.getTrend(house, indicator)+"\t";
					}
	
					for (String indicator : indicators5){
						
						for (Integer year : criteria.getDates()){
		
							Ordinal time = new Ordinal(year);
							Value value = houseStatistics5.getValue(house, time, indicator);
	//						Value value = houseStatistics5.getBySequence(house, time, indicator);
							
	/*						if (value == null){
								value = 0.;
								houseStatistics5.put(house, time, indicator, value);
							} */
							houseLine5 += value+"\t";
						}
						
						houseLine5 += houseStatistics5.getTrend(house, indicator)+"\t";
					}
	
					reportMetrics.outputs().appendln(houseLine1);
					reportMorphology.outputs().appendln(houseLine2);
					reportReferentKin.outputs().appendln(houseLine3);
					reportKin.outputs().appendln(houseLine4);
					reportReferentChain.outputs().appendln(houseLine5);
				}
	
				
				String endLine1 = "TOTAL\t";
				String endLine3 = "TOTAL\t";
				String endLine4 = "TOTAL\t";
				String endLine5 = "TOTAL\t";
				
				for (String indicator : indicators1){
	
					if (indicator.equals("GRAPH")) {
						continue;
					}
	
					for (Integer year : criteria.getDates()){
	
						Ordinal time = new Ordinal(year);
						Object value = houseStatistics1.meanOverSequences(time, indicator);
						
						if (value == null) {
							
							endLine1 += "\t";
							
						} else {
							
							endLine1 += value+"\t";
						}
					}
					
					endLine1 += houseStatistics1.getMeanTrend(indicator)+"\t";
				}
				reportMetrics.outputs().appendln(endLine1);
				
				for (String indicator : indicators3){
	
					for (Integer year : criteria.getDates()){
	
						Ordinal time = new Ordinal(year);
						Object value = houseStatistics3.meanOverSequences(time, indicator);
						
						if (value == null) {
							
							endLine3 += "\t";
							
						} else {
							
							endLine3 += value+"\t";
						}
					}
					
					endLine3 += houseStatistics3.getMeanTrend(indicator)+"\t";
				}
				reportReferentKin.outputs().appendln(endLine3);
	
				for (String indicator : indicators4){
	
					for (Integer year : criteria.getDates()){
	
						Ordinal time = new Ordinal(year);
						Object value = houseStatistics4.meanOverSequences(time, indicator);
						
						if (value == null) {
							
							endLine4 += "\t";
							
						} else {
							
							endLine4 += value+"\t";
						}
					}
					
					endLine4 += houseStatistics4.getMeanTrend(indicator)+"\t";
				}
				reportKin.outputs().appendln(endLine4);
	
				for (String indicator : indicators5){
	
					for (Integer year : criteria.getDates()){
	
						Ordinal time = new Ordinal(year);
						Object value = houseStatistics5.meanOverSequences(time, indicator);
						
						if (value == null) {
							
							endLine5 += "\t";
							
						} else {
							
							endLine5 += value+"\t";
						}
					}
					
					endLine5 += houseStatistics5.getMeanTrend(indicator)+"\t";
				}
				reportReferentChain.outputs().appendln(endLine5);
	
	
				// Matrix report
				
				StringList pajekBuffer1 = new StringList();
	
				for (String matrixIndicator : matrixIndicators){
					
					Report reportMatrices = new Report("Matrix_"+matrixIndicator);
					
					reportMatrices.outputs().appendln("Transition Matrix "+matrixIndicator);
					reportMatrices.outputs().appendln();
					
					SequenceStatistics<Sequence<Relation>,Relation> houseStatistics = null;
					Map<Ordinal,Partition<Sequence<Relation>>> sequenceCensus = null;
					
					if (matrixIndicator.equals("KIN")){
						houseStatistics = houseStatistics3;
						sequenceCensus = referentKinCensus;
					} else if (matrixIndicator.equals("CHAIN")){
						houseStatistics = houseStatistics5;
						sequenceCensus = referentChainCensus;
					}				
	
	//				Matrix matrix = houseStatistics.getHouseTransitionMatrix(census, criteria.getDates());
					Matrix matrix = houseStatistics.getTransitionMatrix(sequenceCensus,sequences);
					Map<Value,Double> meanValueFrequencies = houseStatistics.getMeanValueFrequencies(sequenceCensus,sequences);
					
					String headLine = "\t";
					for (int col=0;col<matrix.getRowDim();col++){
						headLine += matrix.getColLabel(col)+"\t";
					}
					reportMatrices.outputs().appendln(headLine);
					
					for (int row=0;row<matrix.getRowDim();row++){
						String rowLine = matrix.getRowLabel(row)+"\t";
						for (int col=0;col<matrix.getRowDim();col++){
							rowLine += matrix.getAsRowPercentage(row, col)+"\t";
						}
						reportMatrices.outputs().appendln(rowLine);
					}
					reportMatrices.outputs().appendln();
					
					// Transition graph
					
					Graph<Node<String>> transitionGraph = new Graph<Node<String>>("Transition Graph "+criteria.getRelationModelName()+" "+matrixIndicator);
					
					for (int row=0;row<matrix.getRowDim();row++){
						Node<String> node = new Node<String>(row,matrix.getRowLabel(row));
						if (meanValueFrequencies.get(new Value(matrix.getRowLabel(row)))==null){
							node.setAttribute("MEAN","0.");
						} else {
							node.setAttribute("MEAN", meanValueFrequencies.get(new Value(matrix.getRowLabel(row)))+"");
						}
						transitionGraph.addNode(row,node);
					}
					
					for (int row=0;row<matrix.getRowDim();row++){
						for (int col=0;col<matrix.getRowDim();col++){
							if (matrix.get(row, col) > 0){
								Link<Node<String>> arc = transitionGraph.addArc(row, col, matrix.get(row,col));
								TransformationType transformationType = RelationWorker.getTransformationType(matrix.getRowLabel(row).split("\\s"), matrix.getColLabel(col).split("\\s"));
								arc.setTag(transformationType.ordinal()+" "+transformationType);
							}
						}
					}
					
					List<String> partitionLabels = new ArrayList<String>();
					partitionLabels.add("MEAN");
					pajekBuffer1.addAll(PuckUtils.writePajekNetwork(transitionGraph, partitionLabels));
					pajekBuffer1.appendln();
	
					result.outputs().append(reportMatrices);
					
					// Strength Census
					
					result.outputs().append(GraphReporter.reportStrengthsByTags(transitionGraph));
				}
	
				if (pajekBuffer2.length() != 0) {
					File targetFile = ToolBox.setExtension(ToolBox.addToName(new File("Sponsor network "), criteria.getLocalUnitLabel()), ".paj");
					ReportRawData rawData = new ReportRawData("Export Sponsor Networks to Pajek", "Pajek", "paj", targetFile);
					rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer2.toString()));
	
					result.outputs().appendln();
					result.outputs().append(rawData);
				}
				
				if (pajekBuffer1.length() != 0) {
					File targetFile = ToolBox.setExtension(ToolBox.addToName(new File("Transition graphs_"), criteria.getLocalUnitLabel()), ".paj");
					ReportRawData rawData = new ReportRawData("Export Transition Graphs to Pajek", "Pajek", "paj", targetFile);
					rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer1.toString()));
	
					result.outputs().appendln();
					result.outputs().append(rawData);
				}
				
				
	
				result.outputs().append(reportOverview);
				result.outputs().append(reportMetrics);
				result.outputs().append(reportMorphology);
				result.outputs().append(reportReferentKin);
				result.outputs().append(reportKin);
				result.outputs().append(reportReferentChain);
				result.outputs().append(reportFlow);
				
				
	//			chainReport.outputs().appendln(relation+"\t"+relation.actors().size()+"\t"+RelationWorker.getLinkChainsAsString(relation, "GENDER", null)+"\t"+RelationWorker.getLinkChainsAsString(relation, "ID", null)+"\t"+RelationWorker.getLinkChainsAsString(relation, "KIN", criteria.getPattern()));
	//			result.outputs().append(chainReport);
	
				//
				result.setTimeSpent(chrono.stop().interval());
			}
		
			//
			return result;
		}

}
