/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import fr.devinsy.util.StringSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.census.workers.ChainValuator;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.workers.AttributeDescriptor;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.net.workers.ExpansionMode;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puckgui.PuckGUI;

public class SpaceTimeAnalysisInputDialog
extends JDialog {
    private static final long serialVersionUID = -7326870100552727961L;
    private static final Logger logger = LoggerFactory.getLogger(SpaceTimeAnalysisInputDialog.class);
    private RelationModels relationModels;
    private AttributeDescriptors attributeDescriptors;
    private Segmentation segmentation;
    private SpaceTimeCriteria dialogCriteria;
    private final JPanel contentPanel = new JPanel();
    private JComboBox cmbxRelationModel;
    private JComboBox cmbxEgoRole;
    private JComboBox cmbxDateLabel;
    private JSpinner spnrMaxAge;
    private JButton okButton;
    private JPanel alterRolesPanel;
    private JTextField txtfldDates;
    private JTextField txtfldMinimalPlaceNames;
    private JComboBox cmbxStartDateLabel;
    private JComboBox cmbxEndDateLabel;
    private JComboBox cmbxPlaceLabel;
    private JComboBox cmbxLocalUnitLabel;
    private JSpinner spnrMinAge;
    private JComboBox cmbxLevel;
    private JComboBox cmbxGeography;
    private JComboBox cmbxExpansionMode;
    private JComboBox cmbxFiliationType;
    private JComboBox cmbxStartPlaceLabel;
    private JComboBox cmbxEndPlaceLabel;
    private JComboBox cmbxDefaultReferentRoleName;
    private JPanel sequenceReportTypePanel;
    private JPanel sliceReportTypePanel;
    private JPanel circuitCensusCriteriaPanel;
    private JPanel alterRelationModelPanel;
    private JTextField txtfldPattern;
    private JComboBox cmbxChainClassification;
    private JTextField txtfldAlterFilterAttributeValue;
    private JTextField txtfldAlterFilterAttributeLabel;
    private JComboBox cmbxAlterFilterRole;
    private JComboBox cmbxIndividualClassificationType;
    private JPanel mainRelationClassificationTypePanel;
    private JPanel relationClassificationTypePanel;
    private JPanel trajectoriesClassificationTypePanel;
    private JPanel repotOptionsPanel;
    private JPanel sequenceGeneralStatisticsPanel;
    private JLabel lblMode;
    private JPanel sliceGeneralStatisticsPanel;
    private JPanel egoNetworksOperationPanel;
    private JScrollPane alterRolesScrollPane;
    private JPanel trajectoriesOperationsPanel;
    private JCheckBox chckbxTrajectoriesExportSequenceType;
    private JCheckBox chckbxTrajectoriesExportEvenType;
    private JCheckBox chckbxTrajectoriesListTrees;
    private JCheckBox chckbxTrajectoriesGeneral;
    private JCheckBox chckbxPNSGeneral;
    private JCheckBox chckbxPNSCentrality;
    private JCheckBox chckbxPNSCohesion;
    private JCheckBox chckbxPNSRelations;
    private JCheckBox chckbxPNSExportParcours;
    private JCheckBox chckbxPNSExportExtendedParcours;
    private JCheckBox chckbxPNSExportMultipleParcours;
    private JCheckBox chckbxPNSExportParcoursNetworks;
    private JCheckBox chckbxPNSExportSimilaryTrees;
    private JCheckBox chckbxTrajectoriesDraw;

    public SpaceTimeAnalysisInputDialog(Segmentation segmentation, RelationModels relationModels, AttributeDescriptors attributeDescriptors) {
        JCheckBox chckbx;
        Enum type;
        Object chckbx2;
        JCheckBox chckbx3;
        Enum type2;
        this.segmentation = segmentation;
        this.relationModels = relationModels;
        this.attributeDescriptors = attributeDescriptors;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Space-Time Analysis Input Dialog");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(SpaceTimeAnalysisInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SpaceTimeAnalysisInputDialog.this.dialogCriteria = null;
                SpaceTimeAnalysisInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 1150, 785);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"max(175dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(100dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JPanel panel = new JPanel();
        this.contentPanel.add((Component)panel, "1, 2, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblRelationModel = new JLabel("Relation Model:");
        panel.add((Component)lblRelationModel, "2, 1");
        this.cmbxRelationModel = new JComboBox<Object>(relationModels.nameList().sort().toArray());
        panel.add((Component)this.cmbxRelationModel, "4, 1");
        this.cmbxRelationModel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    SpaceTimeAnalysisInputDialog.this.updateRelationModel();
                }
            }
        });
        this.lblMode = new JLabel("XXXX");
        this.contentPanel.add((Component)this.lblMode, "3, 2, center, default");
        JPanel constructionOptionsPanel = new JPanel();
        constructionOptionsPanel.setBorder(new TitledBorder(null, "Constructions Options", 4, 2, null, null));
        this.contentPanel.add((Component)constructionOptionsPanel, "1, 4, fill, fill");
        constructionOptionsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(50dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblDateLabel = new JLabel("Date Label:");
        constructionOptionsPanel.add((Component)lblDateLabel, "2, 2, right, default");
        this.cmbxDateLabel = new JComboBox();
        constructionOptionsPanel.add((Component)this.cmbxDateLabel, "4, 2");
        JLabel lblStartDateLabel = new JLabel("Start Date Label:");
        constructionOptionsPanel.add((Component)lblStartDateLabel, "2, 4, right, default");
        this.cmbxStartDateLabel = new JComboBox();
        constructionOptionsPanel.add((Component)this.cmbxStartDateLabel, "4, 4");
        JLabel lblEndDateLabel = new JLabel("End Date Label:");
        constructionOptionsPanel.add((Component)lblEndDateLabel, "2, 6, right, default");
        this.cmbxEndDateLabel = new JComboBox();
        constructionOptionsPanel.add((Component)this.cmbxEndDateLabel, "4, 6");
        JLabel lblPlaceLabel = new JLabel("Place Label:");
        constructionOptionsPanel.add((Component)lblPlaceLabel, "2, 8, right, default");
        this.cmbxPlaceLabel = new JComboBox();
        constructionOptionsPanel.add((Component)this.cmbxPlaceLabel, "4, 8");
        JLabel lblStartPlaceLabel = new JLabel("Start Place Label:");
        constructionOptionsPanel.add((Component)lblStartPlaceLabel, "2, 10, right, default");
        this.cmbxStartPlaceLabel = new JComboBox();
        constructionOptionsPanel.add((Component)this.cmbxStartPlaceLabel, "4, 10, fill, default");
        JLabel lblEndPlaceLabel = new JLabel("End Place Label:");
        constructionOptionsPanel.add((Component)lblEndPlaceLabel, "2, 12, right, default");
        this.cmbxEndPlaceLabel = new JComboBox();
        constructionOptionsPanel.add((Component)this.cmbxEndPlaceLabel, "4, 12, fill, default");
        JLabel lblLocalUnitLabel = new JLabel("Local Unit Label:");
        constructionOptionsPanel.add((Component)lblLocalUnitLabel, "2, 14, right, default");
        this.cmbxLocalUnitLabel = new JComboBox();
        this.cmbxLocalUnitLabel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    SpaceTimeAnalysisInputDialog.this.updateSequenceSliceMode();
                }
            }
        });
        constructionOptionsPanel.add((Component)this.cmbxLocalUnitLabel, "4, 14");
        JLabel lblEgoRole = new JLabel("Ego Role:");
        constructionOptionsPanel.add((Component)lblEgoRole, "2, 16, right, default");
        this.cmbxEgoRole = new JComboBox();
        constructionOptionsPanel.add((Component)this.cmbxEgoRole, "4, 16");
        JLabel lblDefaultReferentRole = new JLabel("<html><div style=\"text-align: right;\">Default Referent<br/>Role Name</div></html>");
        constructionOptionsPanel.add((Component)lblDefaultReferentRole, "2, 18, right, default");
        this.cmbxDefaultReferentRoleName = new JComboBox();
        constructionOptionsPanel.add((Component)this.cmbxDefaultReferentRoleName, "4, 18");
        JLabel lblAlterRoles = new JLabel("Alter Roles:");
        constructionOptionsPanel.add((Component)lblAlterRoles, "2, 20, right, top");
        this.alterRolesScrollPane = new JScrollPane();
        this.alterRolesScrollPane.setVerticalScrollBarPolicy(22);
        constructionOptionsPanel.add((Component)this.alterRolesScrollPane, "4, 20, fill, fill");
        this.alterRolesPanel = new JPanel();
        this.alterRolesScrollPane.setViewportView(this.alterRolesPanel);
        this.alterRolesPanel.setLayout(new BoxLayout(this.alterRolesPanel, 1));
        JLabel lblDates = new JLabel("Dates:");
        constructionOptionsPanel.add((Component)lblDates, "2, 22, right, default");
        this.txtfldDates = new JTextField();
        this.txtfldDates.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                logger.debug("Focus lost on dates.");
                SpaceTimeAnalysisInputDialog.this.updateSequenceSliceMode();
            }
        });
        constructionOptionsPanel.add((Component)this.txtfldDates, "4, 22");
        this.txtfldDates.setColumns(10);
        JLabel lblGeography = new JLabel("Geography:");
        constructionOptionsPanel.add((Component)lblGeography, "2, 24, right, default");
        this.cmbxGeography = new JComboBox();
        this.cmbxGeography.setModel(new DefaultComboBoxModel<String>(new String[]{"Togo"}));
        constructionOptionsPanel.add((Component)this.cmbxGeography, "4, 24");
        JLabel lblLevel = new JLabel("Level:");
        constructionOptionsPanel.add((Component)lblLevel, "2, 26, right, default");
        this.cmbxLevel = new JComboBox();
        this.cmbxLevel.setModel(new DefaultComboBoxModel<GeoLevel>(GeoLevel.values()));
        constructionOptionsPanel.add((Component)this.cmbxLevel, "4, 26");
        JLabel lblMinimalPlaceNames = new JLabel("Minimal Place Names:");
        constructionOptionsPanel.add((Component)lblMinimalPlaceNames, "2, 28, right, default");
        this.txtfldMinimalPlaceNames = new JTextField();
        constructionOptionsPanel.add((Component)this.txtfldMinimalPlaceNames, "4, 28");
        this.txtfldMinimalPlaceNames.setColumns(10);
        JLabel lblMinAge = new JLabel("Min Age:");
        constructionOptionsPanel.add((Component)lblMinAge, "2, 30, right, default");
        this.spnrMinAge = new JSpinner();
        constructionOptionsPanel.add((Component)this.spnrMinAge, "4, 30");
        this.spnrMinAge.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        ((JSpinner.DefaultEditor)this.spnrMinAge.getEditor()).getTextField().setHorizontalAlignment(4);
        JLabel lblMaxAge = new JLabel("Max Age:");
        constructionOptionsPanel.add((Component)lblMaxAge, "2, 32, right, default");
        this.spnrMaxAge = new JSpinner();
        constructionOptionsPanel.add((Component)this.spnrMaxAge, "4, 32");
        this.spnrMaxAge.setModel(new SpinnerNumberModel(new Integer(1000), new Integer(0), null, new Integer(1)));
        ((JSpinner.DefaultEditor)this.spnrMaxAge.getEditor()).getTextField().setHorizontalAlignment(4);
        JLabel lblExpansionMode = new JLabel("Expansion Mode:");
        constructionOptionsPanel.add((Component)lblExpansionMode, "2, 34, right, default");
        this.cmbxExpansionMode = new JComboBox();
        this.cmbxExpansionMode.setModel(new DefaultComboBoxModel<ExpansionMode>(ExpansionMode.values()));
        constructionOptionsPanel.add((Component)this.cmbxExpansionMode, "4, 34");
        JLabel lblFiliationType = new JLabel("Filiation Type:");
        constructionOptionsPanel.add((Component)lblFiliationType, "2, 36, right, default");
        this.cmbxFiliationType = new JComboBox();
        this.cmbxFiliationType.setModel(new DefaultComboBoxModel<FiliationType>(FiliationType.values()));
        constructionOptionsPanel.add((Component)this.cmbxFiliationType, "4, 36");
        JPanel column2Panel = new JPanel();
        this.contentPanel.add((Component)column2Panel, "3, 4, fill, fill");
        column2Panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        this.repotOptionsPanel = new JPanel();
        column2Panel.add((Component)this.repotOptionsPanel, "1, 1");
        this.repotOptionsPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", 4, 2, null, new Color(51, 51, 51)), "Report Options", 4, 2, null, new Color(51, 51, 51)));
        this.repotOptionsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JLabel lblSequenceReportType = new JLabel("<html><div style=\"text-align: right;\">Sequence<br/>Report Type:</div></html>");
        this.repotOptionsPanel.add((Component)lblSequenceReportType, "2, 1, right, top");
        this.sequenceReportTypePanel = new JPanel();
        this.repotOptionsPanel.add((Component)this.sequenceReportTypePanel, "4, 1, fill, fill");
        this.sequenceReportTypePanel.setLayout(new BoxLayout(this.sequenceReportTypePanel, 1));
        Enum[] enumArray = SpaceTimeCriteria.SequenceReportType.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            type2 = enumArray[n2];
            chckbx3 = new JCheckBox(SpaceTimeAnalysisInputDialog.translate((SpaceTimeCriteria.SequenceReportType)type2));
            this.sequenceReportTypePanel.add(chckbx3);
            ++n2;
        }
        JLabel lblSliceReportType = new JLabel("<html><div style=\"text-align: right\">Slice Report<br/>Type:</div></html>");
        this.repotOptionsPanel.add((Component)lblSliceReportType, "2, 3, right, top");
        this.sliceReportTypePanel = new JPanel();
        this.repotOptionsPanel.add((Component)this.sliceReportTypePanel, "4, 3, fill, fill");
        this.sliceReportTypePanel.setLayout(new BoxLayout(this.sliceReportTypePanel, 1));
        enumArray = SpaceTimeCriteria.SliceReportType.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            type2 = enumArray[n2];
            chckbx3 = new JCheckBox(SpaceTimeAnalysisInputDialog.translate((SpaceTimeCriteria.SliceReportType)type2));
            this.sliceReportTypePanel.add(chckbx3);
            ++n2;
        }
        this.circuitCensusCriteriaPanel = new JPanel();
        this.circuitCensusCriteriaPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", 4, 2, null, new Color(51, 51, 51)), "Circuit Census Criteria", 4, 2, null, new Color(51, 51, 51)));
        column2Panel.add((Component)this.circuitCensusCriteriaPanel, "1, 3, fill, fill");
        this.circuitCensusCriteriaPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"min(40dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblCensysType = new JLabel("Pattern:");
        this.circuitCensusCriteriaPanel.add((Component)lblCensysType, "4, 1, right, default");
        this.txtfldPattern = new JTextField();
        this.circuitCensusCriteriaPanel.add((Component)this.txtfldPattern, "6, 1, fill, default");
        this.txtfldPattern.setColumns(10);
        JLabel lblChaineClassification = new JLabel("Chain Classification:");
        this.circuitCensusCriteriaPanel.add((Component)lblChaineClassification, "4, 3, right, default");
        this.cmbxChainClassification = new JComboBox<ChainValuator.ChainProperty>(new DefaultComboBoxModel<ChainValuator.ChainProperty>(ChainValuator.ChainProperty.values()));
        this.circuitCensusCriteriaPanel.add((Component)this.cmbxChainClassification, "6, 3, fill, default");
        JLabel lblRelationModels = new JLabel("Alter Relation Models:");
        this.circuitCensusCriteriaPanel.add((Component)lblRelationModels, "4, 5, right, top");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(22);
        this.circuitCensusCriteriaPanel.add((Component)scrollPane, "6, 5, fill, fill");
        this.alterRelationModelPanel = new JPanel();
        scrollPane.setViewportView(this.alterRelationModelPanel);
        this.alterRelationModelPanel.setLayout(new BoxLayout(this.alterRelationModelPanel, 1));
        JLabel lblAlterfilterrolename = new JLabel("Alter Filter Role:");
        this.circuitCensusCriteriaPanel.add((Component)lblAlterfilterrolename, "4, 7, right, default");
        this.cmbxAlterFilterRole = new JComboBox();
        this.circuitCensusCriteriaPanel.add((Component)this.cmbxAlterFilterRole, "6, 7, fill, default");
        JLabel lblAlterFilterAttribute = new JLabel("<html>Alter Filter<br/>Attribute Label:</html>");
        this.circuitCensusCriteriaPanel.add((Component)lblAlterFilterAttribute, "4, 9, right, default");
        this.txtfldAlterFilterAttributeLabel = new JTextField();
        this.txtfldAlterFilterAttributeLabel.setColumns(10);
        this.circuitCensusCriteriaPanel.add((Component)this.txtfldAlterFilterAttributeLabel, "6, 9, fill, default");
        JLabel lblAlterFilterAttribute_1 = new JLabel("<html>Alter Filter<br/>Attribute Value:</html>");
        this.circuitCensusCriteriaPanel.add((Component)lblAlterFilterAttribute_1, "4, 11, right, default");
        this.txtfldAlterFilterAttributeValue = new JTextField();
        this.txtfldAlterFilterAttributeValue.setColumns(10);
        this.circuitCensusCriteriaPanel.add((Component)this.txtfldAlterFilterAttributeValue, "6, 11, fill, default");
        JPanel partitionCriteriaPanel = new JPanel();
        column2Panel.add((Component)partitionCriteriaPanel, "1, 5");
        partitionCriteriaPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", 4, 2, null, new Color(51, 51, 51)), "Partition Criteria", 4, 2, null, new Color(51, 51, 51)));
        partitionCriteriaPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"min(60dlu;default)")}));
        JLabel lblIndividualClassificationType = new JLabel("<html><div style=\"text-align: right;\">Individual<br/>Classification Type:</div></html>");
        partitionCriteriaPanel.add((Component)lblIndividualClassificationType, "2, 1, right, default");
        StringList labels = IndividualValuator.getEndogenousAttributeLabels();
        labels.addAll((Collection)attributeDescriptors.findByScope(AttributeDescriptor.Scope.INDIVIDUALS).labels());
        labels.sort();
        this.cmbxIndividualClassificationType = new JComboBox<Object>(new DefaultComboBoxModel<Object>(labels.toArray()));
        partitionCriteriaPanel.add((Component)this.cmbxIndividualClassificationType, "4, 1, fill, default");
        JLabel lblRelationClassificationType = new JLabel("<html><div style=\"text-align: right;\">Relation<br/>Classification Type:</div<</html>");
        partitionCriteriaPanel.add((Component)lblRelationClassificationType, "2, 3, right, top");
        JScrollPane scrollPane2 = new JScrollPane();
        scrollPane2.setVerticalScrollBarPolicy(22);
        partitionCriteriaPanel.add((Component)scrollPane2, "4, 3, fill, fill");
        this.relationClassificationTypePanel = new JPanel();
        scrollPane2.setViewportView(this.relationClassificationTypePanel);
        this.relationClassificationTypePanel.setLayout(new BoxLayout(this.relationClassificationTypePanel, 1));
        SpaceTimeCriteria.RelationClassificationType[] relationClassificationTypeArray = SpaceTimeCriteria.RelationClassificationType.values();
        int n3 = relationClassificationTypeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            SpaceTimeCriteria.RelationClassificationType type3 = relationClassificationTypeArray[n4];
            chckbx2 = new JCheckBox(type3.toString());
            this.relationClassificationTypePanel.add((Component)chckbx2);
            ++n4;
        }
        JPanel generalStatisticsPanel22 = new JPanel();
        column2Panel.add((Component)generalStatisticsPanel22, "1, 7");
        generalStatisticsPanel22.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", 4, 2, null, new Color(51, 51, 51)), "General Statistics", 4, 2, null, new Color(51, 51, 51)));
        generalStatisticsPanel22.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode((String)"4dlu:grow")}));
        JLabel lblSequenceCensusOperation = new JLabel("Sequence Census Operation:");
        generalStatisticsPanel22.add((Component)lblSequenceCensusOperation, "2, 1");
        this.sequenceGeneralStatisticsPanel = new JPanel();
        generalStatisticsPanel22.add((Component)this.sequenceGeneralStatisticsPanel, "2, 3, fill, fill");
        this.sequenceGeneralStatisticsPanel.setLayout(new BoxLayout(this.sequenceGeneralStatisticsPanel, 0));
        chckbx2 = SpaceTimeCriteria.SequenceGeneralStatistics.values();
        int n5 = ((SpaceTimeCriteria.SequenceGeneralStatistics[])chckbx2).length;
        n3 = 0;
        while (n3 < n5) {
            type = chckbx2[n3];
            chckbx = new JCheckBox(type.name());
            this.sequenceGeneralStatisticsPanel.add(chckbx);
            ++n3;
        }
        JLabel lblSliceCensusOperation = new JLabel("Slice Census Operation:");
        generalStatisticsPanel22.add((Component)lblSliceCensusOperation, "2, 5");
        this.sliceGeneralStatisticsPanel = new JPanel();
        generalStatisticsPanel22.add((Component)this.sliceGeneralStatisticsPanel, "2, 7, fill, fill");
        this.sliceGeneralStatisticsPanel.setLayout(new BoxLayout(this.sliceGeneralStatisticsPanel, 0));
        chckbx2 = SpaceTimeCriteria.SliceGeneralStatistics.values();
        n5 = ((SpaceTimeCriteria.SliceGeneralStatistics[])chckbx2).length;
        n3 = 0;
        while (n3 < n5) {
            type = chckbx2[n3];
            chckbx = new JCheckBox(type.name());
            this.sliceGeneralStatisticsPanel.add(chckbx);
            ++n3;
        }
        JPanel column3Panel = new JPanel();
        this.contentPanel.add((Component)column3Panel, "5, 4, fill, fill");
        column3Panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode((String)"4dlu:grow")}));
        JPanel egoNetworkstatisticsPanel = new JPanel();
        column3Panel.add((Component)egoNetworkstatisticsPanel, "1, 1");
        egoNetworkstatisticsPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(0, 0, 255)), "", 4, 2, null, new Color(51, 51, 51)), "Ego Networks", 4, 2, null, new Color(51, 51, 51)));
        egoNetworkstatisticsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{RowSpec.decode((String)"default:grow")}));
        JLabel lblCensusOperationLabels_1 = new JLabel("Census Operation:");
        egoNetworkstatisticsPanel.add((Component)lblCensusOperationLabels_1, "2, 1, right, top");
        this.egoNetworksOperationPanel = new JPanel();
        egoNetworkstatisticsPanel.add((Component)this.egoNetworksOperationPanel, "4, 1, fill, fill");
        this.egoNetworksOperationPanel.setLayout(new BoxLayout(this.egoNetworksOperationPanel, 1));
        SpaceTimeCriteria.EgoNetworksOperation[] egoNetworksOperationArray = SpaceTimeCriteria.EgoNetworksOperation.values();
        int n6 = egoNetworksOperationArray.length;
        int generalStatisticsPanel22 = 0;
        while (generalStatisticsPanel22 < n6) {
            SpaceTimeCriteria.EgoNetworksOperation type4 = egoNetworksOperationArray[generalStatisticsPanel22];
            JCheckBox chckbx4 = new JCheckBox(type4.name());
            this.egoNetworksOperationPanel.add(chckbx4);
            ++generalStatisticsPanel22;
        }
        JPanel parcoursNetworkStatisticsPanel = new JPanel();
        parcoursNetworkStatisticsPanel.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 255)), "Parcours Network Statistics", 4, 2, null, new Color(51, 51, 51)));
        column3Panel.add((Component)parcoursNetworkStatisticsPanel, "1, 3, fill, fill");
        parcoursNetworkStatisticsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{RowSpec.decode((String)"min(60dlu;default):grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblMainRelationClassification = new JLabel("<html><div style=\"text-align: right\">Main Relation<br/>Classification Types:</div></html>");
        parcoursNetworkStatisticsPanel.add((Component)lblMainRelationClassification, "2, 1, right, top");
        scrollPane2 = new JScrollPane();
        scrollPane2.setVerticalScrollBarPolicy(22);
        parcoursNetworkStatisticsPanel.add((Component)scrollPane2, "4, 1, fill, fill");
        this.mainRelationClassificationTypePanel = new JPanel();
        scrollPane2.setViewportView(this.mainRelationClassificationTypePanel);
        this.mainRelationClassificationTypePanel.setLayout(new BoxLayout(this.mainRelationClassificationTypePanel, 1));
        SpaceTimeCriteria.RelationClassificationType[] relationClassificationTypeArray2 = SpaceTimeCriteria.RelationClassificationType.values();
        int n7 = relationClassificationTypeArray2.length;
        n6 = 0;
        while (n6 < n7) {
            SpaceTimeCriteria.RelationClassificationType type5 = relationClassificationTypeArray2[n6];
            chckbx2 = new JCheckBox(type5.toString());
            this.mainRelationClassificationTypePanel.add((Component)chckbx2);
            ++n6;
        }
        JPanel panel2 = new JPanel();
        parcoursNetworkStatisticsPanel.add((Component)panel2, "2, 3, fill, fill");
        panel2.setLayout(new BoxLayout(panel2, 1));
        JLabel label = new JLabel("Census Operation:");
        panel2.add(label);
        this.chckbxPNSGeneral = new JCheckBox("General");
        panel2.add(this.chckbxPNSGeneral);
        this.chckbxPNSCentrality = new JCheckBox("Centrality");
        panel2.add(this.chckbxPNSCentrality);
        this.chckbxPNSCohesion = new JCheckBox("Cohesion");
        panel2.add(this.chckbxPNSCohesion);
        this.chckbxPNSRelations = new JCheckBox("Relations");
        panel2.add(this.chckbxPNSRelations);
        panel2 = new JPanel();
        parcoursNetworkStatisticsPanel.add((Component)panel2, "4, 3, fill, fill");
        panel2.setLayout(new BoxLayout(panel2, 1));
        this.chckbxPNSExportParcours = new JCheckBox("Export Parcours");
        panel2.add(this.chckbxPNSExportParcours);
        this.chckbxPNSExportExtendedParcours = new JCheckBox("Export Extended Parcours");
        panel2.add(this.chckbxPNSExportExtendedParcours);
        this.chckbxPNSExportMultipleParcours = new JCheckBox("Export Multiple Parcours");
        panel2.add(this.chckbxPNSExportMultipleParcours);
        this.chckbxPNSExportParcoursNetworks = new JCheckBox("Export Parcours Networks");
        panel2.add(this.chckbxPNSExportParcoursNetworks);
        this.chckbxPNSExportSimilaryTrees = new JCheckBox("Export Similary Trees");
        panel2.add(this.chckbxPNSExportSimilaryTrees);
        JPanel typeNetworkStatisticsPanel = new JPanel();
        typeNetworkStatisticsPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(0, 0, 255)), "", 4, 2, null, new Color(51, 51, 51)), "Trajectories Statistics", 4, 2, null, new Color(51, 51, 51)));
        column3Panel.add((Component)typeNetworkStatisticsPanel, "1, 5, fill, fill");
        typeNetworkStatisticsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{RowSpec.decode((String)"min(60dlu;default):grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblMainRelationClassification_1 = new JLabel("<html><div style=\"text-align: right;\">Main Relation<br/>Classification Types:</div></html>");
        typeNetworkStatisticsPanel.add((Component)lblMainRelationClassification_1, "2, 1, right, top");
        scrollPane2 = new JScrollPane();
        typeNetworkStatisticsPanel.add((Component)scrollPane2, "4, 1, fill, fill");
        this.trajectoriesClassificationTypePanel = new JPanel();
        scrollPane2.setViewportView(this.trajectoriesClassificationTypePanel);
        this.trajectoriesClassificationTypePanel.setLayout(new BoxLayout(this.trajectoriesClassificationTypePanel, 1));
        this.mainRelationClassificationTypePanel.setLayout(new BoxLayout(this.mainRelationClassificationTypePanel, 1));
        relationClassificationTypeArray2 = SpaceTimeCriteria.RelationClassificationType.values();
        n7 = relationClassificationTypeArray2.length;
        n6 = 0;
        while (n6 < n7) {
            SpaceTimeCriteria.RelationClassificationType type6 = relationClassificationTypeArray2[n6];
            chckbx2 = new JCheckBox(type6.toString());
            this.trajectoriesClassificationTypePanel.add((Component)chckbx2);
            ++n6;
        }
        JLabel lblCensusOperations = new JLabel("Census Operations:");
        typeNetworkStatisticsPanel.add((Component)lblCensusOperations, "2, 3, right, top");
        this.trajectoriesOperationsPanel = new JPanel();
        typeNetworkStatisticsPanel.add((Component)this.trajectoriesOperationsPanel, "2, 5, 3, 1, right, fill");
        this.trajectoriesOperationsPanel.setLayout(new BoxLayout(this.trajectoriesOperationsPanel, 1));
        this.chckbxTrajectoriesGeneral = new JCheckBox("General");
        this.trajectoriesOperationsPanel.add(this.chckbxTrajectoriesGeneral);
        this.chckbxTrajectoriesListTrees = new JCheckBox("List Trees");
        this.trajectoriesOperationsPanel.add(this.chckbxTrajectoriesListTrees);
        this.chckbxTrajectoriesDraw = new JCheckBox("Draw");
        this.trajectoriesOperationsPanel.add(this.chckbxTrajectoriesDraw);
        this.chckbxTrajectoriesExportEvenType = new JCheckBox("Export Event Type Networks");
        this.trajectoriesOperationsPanel.add(this.chckbxTrajectoriesExportEvenType);
        this.chckbxTrajectoriesExportSequenceType = new JCheckBox("<html>Export Sequence Type Networks</html>");
        this.trajectoriesOperationsPanel.add(this.chckbxTrajectoriesExportSequenceType);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SpaceTimeAnalysisInputDialog.this.dialogCriteria = null;
                SpaceTimeAnalysisInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.okButton = new JButton("Launch");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SpaceTimeCriteria criteria = SpaceTimeAnalysisInputDialog.this.getCriteria();
                PuckGUI.instance().getPreferences().setSpaceTimeAnalysisCriteria(criteria);
                if (criteria.getRelationModelName() == null) {
                    String title = "Invalid input";
                    String message = "A relation model is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else if (criteria.getEgoRoleName() == null) {
                    String title = "Invalid input";
                    String message = "An ego role is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else if (criteria.getDateLabel() == null) {
                    String title = "Invalid input";
                    String message = "A valid date label is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    SpaceTimeAnalysisInputDialog.this.dialogCriteria = criteria;
                    SpaceTimeAnalysisInputDialog.this.dialogCriteria.setCensusParameters();
                    SpaceTimeAnalysisInputDialog.this.setVisible(false);
                }
            }
        });
        Component horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        JButton btnDefault = new JButton("Reset");
        btnDefault.setToolTipText("Reset Default Values");
        btnDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SpaceTimeCriteria criteria = new SpaceTimeCriteria();
                SpaceTimeAnalysisInputDialog.this.setCriteria(criteria);
            }
        });
        buttonPane.add(btnDefault);
        horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        for (RelationModel model : relationModels) {
            JCheckBox checkBox = new JCheckBox(model.getName());
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    logger.debug("checkbox changed.");
                    SpaceTimeAnalysisInputDialog.this.updateAlterRelationModel();
                }
            });
            this.alterRelationModelPanel.add(checkBox);
        }
        this.updateAlterRelationModel();
        this.setCriteria(PuckGUI.instance().getPreferences().getSpaceTimeAnalysisCriteria());
    }

    private StringList getAlterRelationModelNames() {
        StringList result = new StringList();
        Component[] componentArray = this.alterRelationModelPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            JCheckBox checkbox = (JCheckBox)component;
            if (checkbox.isSelected()) {
                result.add((Object)checkbox.getText());
            }
            ++n2;
        }
        logger.debug("alterRelationModel checked={}", (Object)result.toStringWithCommas());
        return result;
    }

    public SpaceTimeCriteria getCriteria() {
        Component component;
        SpaceTimeCriteria result = new SpaceTimeCriteria();
        logger.debug("========== getCriteria");
        result.setRelationModelName((String)this.cmbxRelationModel.getSelectedItem());
        logger.debug("RelationModelName=" + result.getEgoRoleName());
        result.setEgoRoleName((String)this.cmbxEgoRole.getSelectedItem());
        logger.debug("EgoRoleName=" + result.getEgoRoleName());
        result.setDateLabel((String)this.cmbxDateLabel.getSelectedItem());
        logger.debug("DateLabel=" + result.getDateLabel());
        result.setStartDateLabel((String)this.cmbxStartDateLabel.getSelectedItem());
        logger.debug("StartDateLabel=" + result.getStartDateLabel());
        result.setEndDateLabel((String)this.cmbxEndDateLabel.getSelectedItem());
        logger.debug("EndDateLabel=" + result.getEndDateLabel());
        result.setLocalUnitLabel((String)this.cmbxLocalUnitLabel.getSelectedItem());
        logger.debug("LocalUnitLabel=" + result.getLocalUnitLabel());
        result.setEgoRoleName((String)this.cmbxEgoRole.getSelectedItem());
        logger.debug("EgoRoleName=" + result.getEgoRoleName());
        result.setDefaultReferentRoleName((String)this.cmbxDefaultReferentRoleName.getSelectedItem());
        logger.debug("DefaultReferentRoleName=" + result.getDefaultReferentRoleName());
        result.getRoleNames().clear();
        Component[] componentArray = this.alterRolesPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component2 = componentArray[n2];
            if (((JCheckBox)component2).isSelected()) {
                result.getRoleNames().add((Object)((JCheckBox)component2).getText());
            }
            ++n2;
        }
        logger.debug("roleNames=" + result.getRoleNames().toStringWithCommas());
        if (this.txtfldDates.getText() == null) {
            result.setDates(new Integer[0]);
        } else {
            String[] tokens;
            StringList values = new StringList();
            String[] stringArray = tokens = this.txtfldDates.getText().split("[, ]");
            int n3 = tokens.length;
            int n4 = 0;
            while (n4 < n3) {
                String token = stringArray[n4];
                if (NumberUtils.isDigits((String)token)) {
                    values.add((Object)token);
                }
                ++n4;
            }
            Integer[] target = new Integer[values.size()];
            int index = 0;
            while (index < values.size()) {
                target[index] = new Integer((String)values.get(index));
                ++index;
            }
            result.setDates(target);
        }
        result.setLevel((GeoLevel)((Object)this.cmbxLevel.getSelectedItem()));
        if (StringUtils.isNotBlank((CharSequence)this.txtfldMinimalPlaceNames.getText())) {
            result.getMinimalPlaceNames().addAll((Collection)new StringList(this.txtfldMinimalPlaceNames.getText().split("[ ,]")));
        }
        logger.debug("minimalPlaceNames=" + result.getMinimalPlaceNames().toStringWithCommas());
        result.setMinAge((Integer)this.spnrMinAge.getValue());
        result.setMaxAge((Integer)this.spnrMaxAge.getValue());
        result.setExpansionMode((ExpansionMode)((Object)this.cmbxExpansionMode.getSelectedItem()));
        result.setFiliationType((FiliationType)((Object)this.cmbxFiliationType.getSelectedItem()));
        int index = 0;
        while (index < this.sequenceReportTypePanel.getComponentCount()) {
            JCheckBox checkbox = (JCheckBox)this.sequenceReportTypePanel.getComponent(index);
            if (checkbox.isSelected()) {
                result.getSequenceReportTypes().add(SpaceTimeCriteria.SequenceReportType.values()[index]);
            }
            ++index;
        }
        StringList buffer = new StringList();
        for (SpaceTimeCriteria.SequenceReportType type : result.getSequenceReportTypes()) {
            buffer.append(type.name());
        }
        logger.debug("SequenceReportTypes=" + buffer.toStringWithCommas());
        index = 0;
        while (index < this.sliceReportTypePanel.getComponentCount()) {
            JCheckBox checkbox = (JCheckBox)this.sliceReportTypePanel.getComponent(index);
            if (checkbox.isSelected()) {
                result.getSliceReportTypes().add(SpaceTimeCriteria.SliceReportType.values()[index]);
            }
            ++index;
        }
        buffer = new StringList();
        for (SpaceTimeCriteria.SliceReportType type : result.getSliceReportTypes()) {
            buffer.append(type.name());
        }
        logger.debug("SliceReportTypes=" + buffer.toStringWithCommas());
        result.setPattern(this.txtfldPattern.getText());
        result.setChainClassification(((ChainValuator.ChainProperty)((Object)this.cmbxChainClassification.getSelectedItem())).name());
        result.setRelationModelNames((List<String>)this.getAlterRelationModelNames());
        result.setAlterFilterRoleName((String)this.cmbxAlterFilterRole.getSelectedItem());
        result.setAlterAttributeLabel(this.txtfldAlterFilterAttributeLabel.getText());
        result.setAlterAttributeValue(this.txtfldAlterFilterAttributeValue.getText());
        logger.debug("[relationModelName={}][chaineClassification={}][alterRelationModelNames={}]", new Object[]{result.getRelationModelName(), result.getChainClassification(), new StringList(result.getRelationModelNames()).toStringWithCommas()});
        result.setPartitionLabel((String)this.cmbxIndividualClassificationType.getSelectedItem());
        logger.debug("individualClassificationType=" + result.getPartitionLabel());
        result.getRelationClassificationTypes().clear();
        index = 0;
        while (index < this.relationClassificationTypePanel.getComponentCount()) {
            JCheckBox checkbox = (JCheckBox)this.relationClassificationTypePanel.getComponent(index);
            if (checkbox.isSelected()) {
                result.getRelationClassificationTypes().add(SpaceTimeCriteria.RelationClassificationType.values()[index]);
            }
            ++index;
        }
        logger.debug("getRelationClassificationTypes.size=" + result.getRelationClassificationTypes().size());
        result.getSequenceGeneralStatistics().clear();
        componentArray = this.sequenceGeneralStatisticsPanel.getComponents();
        int n5 = componentArray.length;
        int checkbox = 0;
        while (checkbox < n5) {
            Component component3 = componentArray[checkbox];
            JCheckBox checkbox2 = (JCheckBox)component3;
            if (checkbox2.isSelected()) {
                result.getSequenceGeneralStatistics().add(SpaceTimeCriteria.SequenceGeneralStatistics.valueOf(checkbox2.getText()));
            }
            ++checkbox;
        }
        buffer = new StringList();
        for (SpaceTimeCriteria.SequenceGeneralStatistics type : result.getSequenceGeneralStatistics()) {
            buffer.append(type.name());
        }
        logger.debug("SequenceGeneralStatistics=" + buffer.toStringWithCommas());
        result.getSliceGeneralStatistics().clear();
        componentArray = this.sliceGeneralStatisticsPanel.getComponents();
        int n6 = componentArray.length;
        int type = 0;
        while (type < n6) {
            component = componentArray[type];
            JCheckBox checkbox3 = (JCheckBox)component;
            if (checkbox3.isSelected()) {
                result.getSliceGeneralStatistics().add(SpaceTimeCriteria.SliceGeneralStatistics.valueOf(checkbox3.getText()));
            }
            ++type;
        }
        buffer = new StringList();
        for (SpaceTimeCriteria.SliceGeneralStatistics type2 : result.getSliceGeneralStatistics()) {
            buffer.append(type2.name());
        }
        logger.debug("SliceGeneralStatistics=" + buffer.toStringWithCommas());
        result.getEgoNetworksOperations().clear();
        componentArray = this.egoNetworksOperationPanel.getComponents();
        int n7 = componentArray.length;
        int type2 = 0;
        while (type2 < n7) {
            component = componentArray[type2];
            JCheckBox checkbox4 = (JCheckBox)component;
            if (checkbox4.isSelected()) {
                result.getEgoNetworksOperations().add(SpaceTimeCriteria.EgoNetworksOperation.valueOf(checkbox4.getText()));
            }
            ++type2;
        }
        buffer = new StringList();
        for (SpaceTimeCriteria.EgoNetworksOperation type3 : result.getEgoNetworksOperations()) {
            buffer.append(type3.name());
        }
        logger.debug("EgoNetworksOperations=" + buffer.toStringWithCommas());
        result.getMainRelationClassificationTypes().clear();
        index = 0;
        while (index < this.mainRelationClassificationTypePanel.getComponentCount()) {
            JCheckBox checkbox5 = (JCheckBox)this.mainRelationClassificationTypePanel.getComponent(index);
            if (checkbox5.isSelected()) {
                result.getMainRelationClassificationTypes().add(SpaceTimeCriteria.RelationClassificationType.values()[index]);
            }
            ++index;
        }
        logger.debug("getMainRelationClassificationTypes.size=" + result.getMainRelationClassificationTypes().size());
        result.getParcoursNetworksOperations().clear();
        if (this.chckbxPNSGeneral.isSelected()) {
            result.getParcoursNetworksOperations().add(SpaceTimeCriteria.ParcoursNetworksOperation.GENERAL);
        }
        if (this.chckbxPNSCentrality.isSelected()) {
            result.getParcoursNetworksOperations().add(SpaceTimeCriteria.ParcoursNetworksOperation.CENTRALITY);
        }
        if (this.chckbxPNSCohesion.isSelected()) {
            result.getParcoursNetworksOperations().add(SpaceTimeCriteria.ParcoursNetworksOperation.COHESION);
        }
        if (this.chckbxPNSRelations.isSelected()) {
            result.getParcoursNetworksOperations().add(SpaceTimeCriteria.ParcoursNetworksOperation.RELATIONS);
        }
        if (this.chckbxPNSExportParcours.isSelected()) {
            result.getParcoursNetworksOperations().add(SpaceTimeCriteria.ParcoursNetworksOperation.EXPORT_PARCOURS);
        }
        if (this.chckbxPNSExportExtendedParcours.isSelected()) {
            result.getParcoursNetworksOperations().add(SpaceTimeCriteria.ParcoursNetworksOperation.EXPORT_EXTENDED_PARCOURS);
        }
        if (this.chckbxPNSExportMultipleParcours.isSelected()) {
            result.getParcoursNetworksOperations().add(SpaceTimeCriteria.ParcoursNetworksOperation.EXPORT_MULTIPLE_PARCOURS);
        }
        if (this.chckbxPNSExportParcoursNetworks.isSelected()) {
            result.getParcoursNetworksOperations().add(SpaceTimeCriteria.ParcoursNetworksOperation.EXPORT_PARCOURS_NETWORKS);
        }
        if (this.chckbxPNSExportSimilaryTrees.isSelected()) {
            result.getParcoursNetworksOperations().add(SpaceTimeCriteria.ParcoursNetworksOperation.EXPORT_SIMILARY_TREES);
        }
        logger.debug("getParcoursNetworksOperations.size=" + result.getParcoursNetworksOperations().size());
        result.getTrajectoriesRelationClassificationTypes().clear();
        index = 0;
        while (index < this.trajectoriesClassificationTypePanel.getComponentCount()) {
            JCheckBox checkbox6 = (JCheckBox)this.trajectoriesClassificationTypePanel.getComponent(index);
            if (checkbox6.isSelected()) {
                result.getTrajectoriesRelationClassificationTypes().add(SpaceTimeCriteria.RelationClassificationType.values()[index]);
            }
            ++index;
        }
        logger.debug("getTrajectoriesRelationClassificationTypes.size=" + result.getTrajectoriesRelationClassificationTypes().size());
        result.getTrajectoriesOperations().clear();
        if (this.chckbxTrajectoriesGeneral.isSelected()) {
            result.getTrajectoriesOperations().add(SpaceTimeCriteria.TrajectoriesOperation.GENERAL);
        }
        if (this.chckbxTrajectoriesListTrees.isSelected()) {
            result.getTrajectoriesOperations().add(SpaceTimeCriteria.TrajectoriesOperation.LIST_TREES);
        }
        if (this.chckbxTrajectoriesExportEvenType.isSelected()) {
            result.getTrajectoriesOperations().add(SpaceTimeCriteria.TrajectoriesOperation.EXPORT_EVENT_TYPE_NETWORK);
        }
        if (this.chckbxTrajectoriesExportSequenceType.isSelected()) {
            result.getTrajectoriesOperations().add(SpaceTimeCriteria.TrajectoriesOperation.EXPORT_SEQUENCE_TYPE_NETWORK);
        }
        if (this.chckbxTrajectoriesDraw.isSelected()) {
            result.getTrajectoriesOperations().add(SpaceTimeCriteria.TrajectoriesOperation.DRAW);
        }
        logger.debug("getTrajectoriesOperations.size=" + result.getTrajectoriesOperations().size());
        return result;
    }

    public SpaceTimeCriteria getDialogCriteria() {
        SpaceTimeCriteria result = this.dialogCriteria;
        return result;
    }

    public boolean isSequenceAnalysis() {
        boolean result = StringUtils.isBlank((CharSequence)this.txtfldDates.getText()) && StringUtils.isBlank((CharSequence)((String)this.cmbxLocalUnitLabel.getSelectedItem()));
        logger.debug("isSequence=" + result);
        return result;
    }

    private void setCriteria(SpaceTimeCriteria source) {
        if (source != null) {
            if (this.relationModels.isEmpty()) {
                this.cmbxRelationModel.setEnabled(false);
                this.okButton.setEnabled(false);
            } else {
                Object checkbox;
                this.cmbxRelationModel.setEnabled(true);
                this.okButton.setEnabled(true);
                logger.debug("==>" + source.getRelationModelName());
                this.cmbxRelationModel.setSelectedItem(source.getRelationModelName());
                if (this.cmbxRelationModel.getSelectedIndex() == -1) {
                    this.cmbxRelationModel.setSelectedIndex(0);
                }
                this.updateRelationModel();
                if (StringUtils.isNotBlank((CharSequence)source.getPlaceLabel())) {
                    this.cmbxPlaceLabel.setSelectedItem(source.getPlaceLabel());
                }
                if (StringUtils.isNotBlank((CharSequence)source.getLocalUnitLabel())) {
                    this.cmbxLocalUnitLabel.setSelectedItem(source.getLocalUnitLabel());
                }
                if (StringUtils.isNotBlank((CharSequence)source.getEgoRoleName())) {
                    this.cmbxEgoRole.setSelectedItem(source.getEgoRoleName());
                }
                if (StringUtils.isNotBlank((CharSequence)source.getDefaultReferentRoleName())) {
                    this.cmbxDefaultReferentRoleName.setSelectedItem(source.getDefaultReferentRoleName());
                }
                Component[] componentArray = this.alterRolesPanel.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component component = componentArray[n2];
                    checkbox = (Integer[])component;
                    if (source.getRoleNames().contains((Object)((AbstractButton)checkbox).getText()) || source.getRoleNames().contains((Object)"ALL")) {
                        ((AbstractButton)checkbox).setSelected(true);
                    } else {
                        ((AbstractButton)checkbox).setSelected(false);
                    }
                    ++n2;
                }
                if (source.getLevel() != null) {
                    this.cmbxLevel.setSelectedItem((Object)source.getLevel());
                }
                if (source.getDates() != null) {
                    StringList stringList = new StringList();
                    checkbox = source.getDates();
                    int n3 = ((Integer[])checkbox).length;
                    n = 0;
                    while (n < n3) {
                        Integer date = checkbox[n];
                        stringList.add((Object)("" + date));
                        ++n;
                    }
                    this.txtfldDates.setText(stringList.toStringWithCommas());
                } else {
                    this.txtfldDates.setText("");
                }
                if (source.getMinimalPlaceNames() != null) {
                    this.txtfldMinimalPlaceNames.setText(source.getMinimalPlaceNames().toStringWithCommas());
                }
                this.spnrMinAge.setValue(source.getMinAge());
                this.spnrMaxAge.setValue(source.getMaxAge());
                if (source.getExpansionMode() == null) {
                    this.cmbxExpansionMode.setSelectedItem((Object)ExpansionMode.RELATED);
                } else {
                    this.cmbxExpansionMode.setSelectedItem((Object)source.getExpansionMode());
                }
                if (source.getFiliationType() == null) {
                    this.cmbxFiliationType.setSelectedItem((Object)FiliationType.COGNATIC);
                } else {
                    this.cmbxFiliationType.setSelectedItem((Object)source.getFiliationType());
                }
                Component[] componentArray2 = this.sequenceReportTypePanel.getComponents();
                n = componentArray2.length;
                int n4 = 0;
                while (n4 < n) {
                    Component component = componentArray2[n4];
                    checkbox = (JCheckBox)component;
                    if (source.getSequenceReportTypes().contains((Object)SpaceTimeAnalysisInputDialog.translateToSequenceReportType(((AbstractButton)checkbox).getText()))) {
                        ((AbstractButton)checkbox).setSelected(true);
                    } else {
                        ((AbstractButton)checkbox).setSelected(false);
                    }
                    ++n4;
                }
                componentArray2 = this.sliceReportTypePanel.getComponents();
                n = componentArray2.length;
                n4 = 0;
                while (n4 < n) {
                    Component component = componentArray2[n4];
                    checkbox = (JCheckBox)component;
                    if (source.getSliceReportTypes().contains((Object)SpaceTimeAnalysisInputDialog.translateToSliceReportType(((AbstractButton)checkbox).getText()))) {
                        ((AbstractButton)checkbox).setSelected(true);
                    } else {
                        ((AbstractButton)checkbox).setSelected(false);
                    }
                    ++n4;
                }
                this.txtfldPattern.setText(source.getPattern());
                this.cmbxChainClassification.setSelectedItem((Object)ChainValuator.ChainProperty.valueOf(source.getChainClassification()));
                componentArray2 = this.alterRelationModelPanel.getComponents();
                n = componentArray2.length;
                n4 = 0;
                while (n4 < n) {
                    Component component = componentArray2[n4];
                    checkbox = (JCheckBox)component;
                    if (source.getRelationModelNames().contains(((AbstractButton)checkbox).getText())) {
                        ((AbstractButton)checkbox).setSelected(true);
                    } else {
                        ((AbstractButton)checkbox).setSelected(false);
                    }
                    ++n4;
                }
                this.txtfldAlterFilterAttributeLabel.setText(source.getAlterFilterAttributeLabel());
                this.txtfldAlterFilterAttributeValue.setText(source.getAlterFilterAttributeValue());
                this.cmbxAlterFilterRole.setSelectedItem(source.getAlterFilterRoleName());
                if (StringUtils.isNotBlank((CharSequence)source.getPartitionLabel())) {
                    this.cmbxIndividualClassificationType.setSelectedItem(source.getPartitionLabel());
                }
                componentArray2 = this.relationClassificationTypePanel.getComponents();
                n = componentArray2.length;
                n4 = 0;
                while (n4 < n) {
                    Component component = componentArray2[n4];
                    checkbox = (JCheckBox)component;
                    try {
                        if (source.getRelationClassificationTypes().contains((Object)SpaceTimeCriteria.RelationClassificationType.valueOf(((AbstractButton)checkbox).getText()))) {
                            ((AbstractButton)checkbox).setSelected(true);
                        } else {
                            ((AbstractButton)checkbox).setSelected(false);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        logger.debug("Unknown label");
                    }
                    ++n4;
                }
                componentArray2 = this.sequenceGeneralStatisticsPanel.getComponents();
                n = componentArray2.length;
                n4 = 0;
                while (n4 < n) {
                    Component component = componentArray2[n4];
                    checkbox = (JCheckBox)component;
                    if (source.getSequenceGeneralStatistics().contains((Object)SpaceTimeCriteria.SequenceGeneralStatistics.valueOf(((AbstractButton)checkbox).getText()))) {
                        ((AbstractButton)checkbox).setSelected(true);
                    } else {
                        ((AbstractButton)checkbox).setSelected(false);
                    }
                    ++n4;
                }
                componentArray2 = this.sliceGeneralStatisticsPanel.getComponents();
                n = componentArray2.length;
                n4 = 0;
                while (n4 < n) {
                    Component component = componentArray2[n4];
                    checkbox = (JCheckBox)component;
                    if (source.getSliceGeneralStatistics().contains((Object)SpaceTimeCriteria.SliceGeneralStatistics.valueOf(((AbstractButton)checkbox).getText()))) {
                        ((AbstractButton)checkbox).setSelected(true);
                    } else {
                        ((AbstractButton)checkbox).setSelected(false);
                    }
                    ++n4;
                }
                componentArray2 = this.egoNetworksOperationPanel.getComponents();
                n = componentArray2.length;
                n4 = 0;
                while (n4 < n) {
                    Component component = componentArray2[n4];
                    checkbox = (JCheckBox)component;
                    if (source.getEgoNetworksOperations().contains((Object)SpaceTimeCriteria.EgoNetworksOperation.valueOf(((AbstractButton)checkbox).getText()))) {
                        ((AbstractButton)checkbox).setSelected(true);
                    } else {
                        ((AbstractButton)checkbox).setSelected(false);
                    }
                    ++n4;
                }
                componentArray2 = this.mainRelationClassificationTypePanel.getComponents();
                n = componentArray2.length;
                n4 = 0;
                while (n4 < n) {
                    Component component = componentArray2[n4];
                    checkbox = (JCheckBox)component;
                    try {
                        if (source.getMainRelationClassificationTypes().contains((Object)SpaceTimeCriteria.RelationClassificationType.valueOf(((AbstractButton)checkbox).getText()))) {
                            ((AbstractButton)checkbox).setSelected(true);
                        } else {
                            ((AbstractButton)checkbox).setSelected(false);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        logger.debug("Unknown label");
                    }
                    ++n4;
                }
                this.chckbxPNSCentrality.setSelected(false);
                this.chckbxPNSCohesion.setSelected(false);
                this.chckbxPNSExportExtendedParcours.setSelected(false);
                this.chckbxPNSExportMultipleParcours.setSelected(false);
                this.chckbxPNSExportParcours.setSelected(false);
                this.chckbxPNSExportParcoursNetworks.setSelected(false);
                this.chckbxPNSExportSimilaryTrees.setSelected(false);
                this.chckbxPNSGeneral.setSelected(false);
                this.chckbxPNSRelations.setSelected(false);
                for (SpaceTimeCriteria.ParcoursNetworksOperation parcoursNetworksOperation : source.getParcoursNetworksOperations()) {
                    switch (parcoursNetworksOperation) {
                        case CENTRALITY: {
                            this.chckbxPNSCentrality.setSelected(true);
                            break;
                        }
                        case COHESION: {
                            this.chckbxPNSCohesion.setSelected(true);
                            break;
                        }
                        case EXPORT_EXTENDED_PARCOURS: {
                            this.chckbxPNSExportExtendedParcours.setSelected(true);
                            break;
                        }
                        case EXPORT_MULTIPLE_PARCOURS: {
                            this.chckbxPNSExportMultipleParcours.setSelected(true);
                            break;
                        }
                        case EXPORT_PARCOURS: {
                            this.chckbxPNSExportParcours.setSelected(true);
                            break;
                        }
                        case EXPORT_PARCOURS_NETWORKS: {
                            this.chckbxPNSExportParcoursNetworks.setSelected(true);
                            break;
                        }
                        case EXPORT_SIMILARY_TREES: {
                            this.chckbxPNSExportSimilaryTrees.setSelected(true);
                            break;
                        }
                        case GENERAL: {
                            this.chckbxPNSGeneral.setSelected(true);
                            break;
                        }
                        case RELATIONS: {
                            this.chckbxPNSRelations.setSelected(true);
                        }
                    }
                }
                componentArray2 = this.trajectoriesClassificationTypePanel.getComponents();
                n = componentArray2.length;
                int n5 = 0;
                while (n5 < n) {
                    Component component = componentArray2[n5];
                    checkbox = (JCheckBox)component;
                    try {
                        if (source.getTrajectoriesRelationClassificationTypes().contains((Object)SpaceTimeCriteria.RelationClassificationType.valueOf(((AbstractButton)checkbox).getText()))) {
                            ((AbstractButton)checkbox).setSelected(true);
                        } else {
                            ((AbstractButton)checkbox).setSelected(false);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        logger.debug("Unknown label");
                    }
                    ++n5;
                }
                this.chckbxTrajectoriesExportEvenType.setSelected(false);
                this.chckbxTrajectoriesExportSequenceType.setSelected(false);
                this.chckbxTrajectoriesGeneral.setSelected(false);
                this.chckbxTrajectoriesListTrees.setSelected(false);
                for (SpaceTimeCriteria.TrajectoriesOperation trajectoriesOperation : source.getTrajectoriesOperations()) {
                    switch (trajectoriesOperation) {
                        case EXPORT_EVENT_TYPE_NETWORK: {
                            this.chckbxTrajectoriesExportEvenType.setSelected(true);
                            break;
                        }
                        case EXPORT_SEQUENCE_TYPE_NETWORK: {
                            this.chckbxTrajectoriesExportSequenceType.setSelected(true);
                            break;
                        }
                        case GENERAL: {
                            this.chckbxTrajectoriesGeneral.setSelected(true);
                            break;
                        }
                        case LIST_TREES: {
                            this.chckbxTrajectoriesListTrees.setSelected(true);
                            break;
                        }
                        case DRAW: {
                            this.chckbxTrajectoriesDraw.setSelected(true);
                        }
                    }
                }
            }
        }
        this.updateSequenceSliceMode();
    }

    private void setEnabledAll(JPanel source, boolean value) {
        Component[] componentArray = source.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.setEnabled(value);
            ++n2;
        }
    }

    private void updateAlterRelationModel() {
        StringList currentRelationModelNames = this.getAlterRelationModelNames();
        StringSet roleNames = new StringSet();
        for (String relationModelName : currentRelationModelNames) {
            roleNames.addAll((Collection)this.relationModels.getByName(relationModelName).roles().nameList());
        }
        logger.debug("roleNames={}", (Object)roleNames.toStringList().toStringWithCommas());
        StringList target = new StringList();
        target.add((Object)"ALL");
        target.addAll((Collection)roleNames.toStringList().sort());
        this.cmbxAlterFilterRole.setModel(new DefaultComboBoxModel<Object>(target.toArray()));
    }

    private void updateRelationModel() {
        StringList actorAttributeLabels;
        StringList currentRoles;
        StringList optionalAttributeLabels;
        StringList attributeLabels;
        RelationModel currentRelationModel = this.relationModels.getByName((String)this.cmbxRelationModel.getSelectedItem());
        if (currentRelationModel == null) {
            attributeLabels = new StringList();
            optionalAttributeLabels = new StringList().append("");
            currentRoles = new StringList();
            actorAttributeLabels = new StringList();
        } else {
            currentRoles = currentRelationModel.roles().nameList().sort();
            attributeLabels = this.attributeDescriptors.findByRelationModelName(currentRelationModel.getName()).labels().sort();
            optionalAttributeLabels = new StringList().append("").append(attributeLabels);
            Actors actors = this.segmentation.getCurrentRelations().getActors();
            AttributeDescriptors actorAttributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(actors);
            actorAttributeLabels = actorAttributeDescriptors.labels().sort();
        }
        if (attributeLabels.isEmpty()) {
            this.cmbxDateLabel.setEnabled(false);
            this.cmbxPlaceLabel.setEnabled(false);
            this.cmbxStartPlaceLabel.setEnabled(false);
            this.cmbxEndPlaceLabel.setEnabled(false);
            this.cmbxLocalUnitLabel.setEnabled(false);
        } else {
            this.cmbxDateLabel.setEnabled(true);
            this.cmbxPlaceLabel.setEnabled(true);
            this.cmbxStartPlaceLabel.setEnabled(true);
            this.cmbxEndPlaceLabel.setEnabled(true);
            this.cmbxLocalUnitLabel.setEnabled(true);
            this.cmbxDateLabel.setModel(new DefaultComboBoxModel<Object>(attributeLabels.toArray()));
            this.cmbxDateLabel.setSelectedItem("DATE");
            this.cmbxPlaceLabel.setModel(new DefaultComboBoxModel<Object>(attributeLabels.toArray()));
            this.cmbxPlaceLabel.setSelectedItem("PLACE");
            this.cmbxStartPlaceLabel.setModel(new DefaultComboBoxModel<Object>(attributeLabels.toArray()));
            this.cmbxStartPlaceLabel.setSelectedItem("START_PLACE");
            this.cmbxEndPlaceLabel.setModel(new DefaultComboBoxModel<Object>(attributeLabels.toArray()));
            this.cmbxEndPlaceLabel.setSelectedItem("END_PLACE");
            this.cmbxLocalUnitLabel.setModel(new DefaultComboBoxModel<Object>(optionalAttributeLabels.toArray()));
        }
        if (actorAttributeLabels.isEmpty()) {
            this.cmbxStartDateLabel.setEnabled(false);
            this.cmbxEndDateLabel.setEnabled(false);
        } else {
            this.cmbxStartDateLabel.setEnabled(true);
            this.cmbxEndDateLabel.setEnabled(true);
            this.cmbxStartDateLabel.setModel(new DefaultComboBoxModel<Object>(actorAttributeLabels.toArray()));
            this.cmbxStartDateLabel.setSelectedItem("START_DATE");
            this.cmbxEndDateLabel.setModel(new DefaultComboBoxModel<Object>(actorAttributeLabels.toArray()));
            this.cmbxEndDateLabel.setSelectedItem("END_DATE");
        }
        if (currentRoles.isEmpty()) {
            this.cmbxEgoRole.setEnabled(false);
            this.cmbxDefaultReferentRoleName.setEnabled(false);
            this.alterRolesPanel.removeAll();
            this.alterRolesPanel.repaint();
        } else {
            this.cmbxEgoRole.setEnabled(true);
            this.cmbxDefaultReferentRoleName.setEnabled(true);
            this.cmbxEgoRole.setModel(new DefaultComboBoxModel<Object>(currentRoles.toArray()));
            this.cmbxDefaultReferentRoleName.setModel(new DefaultComboBoxModel<Object>(currentRoles.toArray()));
            this.alterRolesPanel.removeAll();
            for (String roleName : currentRoles) {
                JCheckBox checkbox = new JCheckBox(roleName);
                checkbox.setSelected(true);
                this.alterRolesPanel.add(checkbox);
            }
        }
    }

    private void updateSequenceSliceMode() {
        if (this.isSequenceAnalysis()) {
            this.lblMode.setText("SEQUENCES MODE ");
            this.setEnabledAll(this.sliceReportTypePanel, false);
            this.setEnabledAll(this.sequenceReportTypePanel, true);
            this.setEnabledAll(this.sequenceGeneralStatisticsPanel, true);
            this.setEnabledAll(this.sliceGeneralStatisticsPanel, false);
        } else {
            this.lblMode.setText("SLICES MODE ");
            this.setEnabledAll(this.sliceReportTypePanel, true);
            this.setEnabledAll(this.sequenceReportTypePanel, false);
            this.setEnabledAll(this.sequenceGeneralStatisticsPanel, false);
            this.setEnabledAll(this.sliceGeneralStatisticsPanel, true);
        }
    }

    public static void main(String[] args) {
        SpaceTimeAnalysisInputDialog.showDialog(null, null, null);
    }

    public static SpaceTimeCriteria showDialog(Segmentation segmentation, RelationModels relationModels, AttributeDescriptors attributeDescriptors) {
        SpaceTimeAnalysisInputDialog dialog = new SpaceTimeAnalysisInputDialog(segmentation, relationModels, attributeDescriptors);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        SpaceTimeCriteria result = dialog.getDialogCriteria();
        return result;
    }

    private static String translate(SpaceTimeCriteria.SequenceReportType type) {
        String result;
        if (type == null) {
            result = null;
        } else {
            switch (type) {
                case ITINERARIES_SURVEY: {
                    result = "Itineraries";
                    break;
                }
                case ITINERARIES_DETAILS: {
                    result = "Parcours Networks";
                    break;
                }
                case BIOGRAPHIES: {
                    result = "Biography";
                    break;
                }
                case EXTENDED_BIOGRAPHIES: {
                    result = "Extended Biographies";
                    break;
                }
                case ACTOR_EVENT_TABLES: {
                    result = "Actor-Event Tables";
                    break;
                }
                case INTERACTION_TABLES: {
                    result = "Interacton Tables";
                    break;
                }
                default: {
                    result = type.name();
                }
            }
        }
        return result;
    }

    private static String translate(SpaceTimeCriteria.SliceReportType type) {
        String result;
        if (type == null) {
            result = null;
        } else {
            switch (type) {
                case MEMBERSHIP: {
                    result = "Membership";
                    break;
                }
                default: {
                    result = type.name();
                }
            }
        }
        return result;
    }

    private static SpaceTimeCriteria.SequenceReportType translateToSequenceReportType(String type) {
        SpaceTimeCriteria.SequenceReportType result;
        if (type == null) {
            result = null;
        } else if (type.equals("Itineraries")) {
            result = SpaceTimeCriteria.SequenceReportType.ITINERARIES_SURVEY;
        } else if (type.equals("Parcours Networks")) {
            result = SpaceTimeCriteria.SequenceReportType.ITINERARIES_DETAILS;
        } else if (type.equals("Biography")) {
            result = SpaceTimeCriteria.SequenceReportType.BIOGRAPHIES;
        } else if (type.equals("Extended Biographies")) {
            result = SpaceTimeCriteria.SequenceReportType.EXTENDED_BIOGRAPHIES;
        } else if (type.equals("Actor-Event Tables")) {
            result = SpaceTimeCriteria.SequenceReportType.ACTOR_EVENT_TABLES;
        } else if (type.equals("Interacton Tables")) {
            result = SpaceTimeCriteria.SequenceReportType.INTERACTION_TABLES;
        } else {
            try {
                result = SpaceTimeCriteria.SequenceReportType.valueOf(type);
            }
            catch (Exception exception) {
                result = null;
            }
        }
        return result;
    }

    private static SpaceTimeCriteria.SliceReportType translateToSliceReportType(String type) {
        SpaceTimeCriteria.SliceReportType result;
        if (type == null) {
            result = null;
        } else if (type.equals("Membership")) {
            result = SpaceTimeCriteria.SliceReportType.MEMBERSHIP;
        } else {
            try {
                result = SpaceTimeCriteria.SliceReportType.valueOf(type);
            }
            catch (Exception exception) {
                result = null;
            }
        }
        return result;
    }
}

