/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.tip.puck.census.workers.ChainValuator;
import org.tip.puck.census.workers.KinshipChainsCriteria;

public class KinshipChainsInputDialog
extends JDialog {
    private static final long serialVersionUID = 2212434892206449348L;
    private final JPanel contentPanel = new JPanel();
    private static KinshipChainsCriteria defaultCriteria = new KinshipChainsCriteria();
    private KinshipChainsCriteria inputedCriteria;
    private JTextField txtfldAlterId;
    private JTextField txtfldMaximalDepth;
    private JTextField txtfldMaximalOrder;
    private JComboBox cmbbxChainClassification;

    public KinshipChainsInputDialog() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Kinship Chains Input");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(KinshipChainsInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                KinshipChainsInputDialog.this.inputedCriteria = null;
                KinshipChainsInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 284, 194);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblAlterId = new JLabel("Alter Id:");
        this.contentPanel.add((Component)lblAlterId, "2, 2, right, default");
        this.txtfldAlterId = new JTextField();
        this.contentPanel.add((Component)this.txtfldAlterId, "4, 2, fill, default");
        this.txtfldAlterId.setColumns(10);
        JLabel lblMaximalDepth = new JLabel("Maximal Depth:");
        this.contentPanel.add((Component)lblMaximalDepth, "2, 4, right, default");
        this.txtfldMaximalDepth = new JTextField();
        this.contentPanel.add((Component)this.txtfldMaximalDepth, "4, 4, fill, default");
        this.txtfldMaximalDepth.setColumns(10);
        JLabel lblMaximalOrder = new JLabel("Maximal Order:");
        this.contentPanel.add((Component)lblMaximalOrder, "2, 6, right, default");
        this.txtfldMaximalOrder = new JTextField();
        this.contentPanel.add((Component)this.txtfldMaximalOrder, "4, 6, fill, default");
        this.txtfldMaximalOrder.setColumns(10);
        JLabel lblChainClassification = new JLabel("Chain Classification:");
        this.contentPanel.add((Component)lblChainClassification, "2, 8, right, default");
        this.cmbbxChainClassification = new JComboBox();
        this.cmbbxChainClassification.setModel(new DefaultComboBoxModel<String>(new String[]{"SIMPLE"}));
        this.contentPanel.add((Component)this.cmbbxChainClassification, "4, 8, fill, default");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KinshipChainsInputDialog.this.inputedCriteria = null;
                KinshipChainsInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(NumberUtils.isNumber((String)KinshipChainsInputDialog.this.txtfldAlterId.getText().trim()) && NumberUtils.isNumber((String)KinshipChainsInputDialog.this.txtfldMaximalDepth.getText().trim()) && NumberUtils.isNumber((String)KinshipChainsInputDialog.this.txtfldMaximalOrder.getText().trim()))) {
                    String title = "Error computerum est";
                    String message = "Please, enter numeric value.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    KinshipChainsInputDialog.this.inputedCriteria = new KinshipChainsCriteria();
                    KinshipChainsInputDialog.this.inputedCriteria.setAlterId(Integer.parseInt(KinshipChainsInputDialog.this.txtfldAlterId.getText().trim()));
                    KinshipChainsInputDialog.this.inputedCriteria.setMaximalDepth(Integer.parseInt(KinshipChainsInputDialog.this.txtfldMaximalDepth.getText().trim()));
                    KinshipChainsInputDialog.this.inputedCriteria.setMaximalOrder(Integer.parseInt(KinshipChainsInputDialog.this.txtfldMaximalOrder.getText().trim()));
                    KinshipChainsInputDialog.this.inputedCriteria.setChainClassification((String)KinshipChainsInputDialog.this.cmbbxChainClassification.getSelectedItem());
                    defaultCriteria = KinshipChainsInputDialog.this.inputedCriteria;
                    KinshipChainsInputDialog.this.setVisible(false);
                }
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.cmbbxChainClassification.setModel(new DefaultComboBoxModel());
        this.setCriteria(defaultCriteria);
    }

    public KinshipChainsCriteria getCriteria() {
        KinshipChainsCriteria result = this.inputedCriteria;
        return result;
    }

    private void setCriteria(KinshipChainsCriteria source) {
        if (source != null) {
            if (source.getAlterId() == 0) {
                this.txtfldAlterId.setText("");
            } else {
                this.txtfldAlterId.setText(String.valueOf(source.getAlterId()));
            }
            if (source.getMaximalDepth() == 0) {
                this.txtfldMaximalDepth.setText("");
            } else {
                this.txtfldMaximalDepth.setText(String.valueOf(source.getMaximalDepth()));
            }
            if (source.getMaximalOrder() == 0) {
                this.txtfldMaximalOrder.setText("");
            } else {
                this.txtfldMaximalOrder.setText(String.valueOf(source.getMaximalOrder()));
            }
            Object[] endogenousLabels = ChainValuator.getEndogenousLabels();
            this.cmbbxChainClassification.setModel(new DefaultComboBoxModel<String>(endogenousLabels));
            int chainClassificationLabelIndex = ArrayUtils.indexOf((Object[])endogenousLabels, (Object)source.getChainClassification());
            if (chainClassificationLabelIndex == -1) {
                chainClassificationLabelIndex = ArrayUtils.indexOf((Object[])endogenousLabels, (Object)"SIMPLE");
            }
            this.cmbbxChainClassification.setSelectedIndex(chainClassificationLabelIndex);
        }
    }

    public static void main(String[] args) {
        KinshipChainsCriteria criteria = KinshipChainsInputDialog.showDialog();
        System.out.println("return=" + criteria.getAlterId());
        System.out.println("return=" + criteria.getMaximalDepth());
        System.out.println("return=" + criteria.getMaximalOrder());
        System.out.println("return=" + criteria.getChainClassification());
    }

    public static KinshipChainsCriteria showDialog() {
        KinshipChainsInputDialog dialog = new KinshipChainsInputDialog();
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        KinshipChainsCriteria result = dialog.getCriteria();
        return result;
    }
}

