/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.util.GenericFileFilter;
import org.tip.puckgui.views.ConfirmOverwriteDialog;

public class ExportBARFileSelector
extends JFileChooser {
    private static final long serialVersionUID = -8776305919634043940L;
    private static final Logger logger = LoggerFactory.getLogger(ExportBARFileSelector.class);

    public ExportBARFileSelector(File targetFile) {
        File file = targetFile == null || StringUtils.isBlank((CharSequence)targetFile.getAbsolutePath()) ? null : ToolBox.setExtension(targetFile, ".txt");
        this.setSelectedFile(file);
        this.setDialogTitle("Export to BAR format");
        this.setFileSelectionMode(0);
        this.setAcceptAllFileFilterUsed(false);
        this.setApproveButtonText("Export");
        this.setDialogType(2);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("BAR format files (*.ods, *.txt, *.xls)", "ods", "txt", "xls");
        this.addChoosableFileFilter(defaultFileFilter);
        this.addChoosableFileFilter(new GenericFileFilter("OpenDocumentFormat Spreadsheet (*.ods)", "ods"));
        this.addChoosableFileFilter(new GenericFileFilter("Text (*.txt)", "txt"));
        this.addChoosableFileFilter(new GenericFileFilter("Microsoft Excel (*.xls)", "xls"));
        this.setFileFilter(defaultFileFilter);
    }

    @Override
    public void approveSelection() {
        File targetFile = this.getSelectedFile();
        logger.debug("getCurrentDirectory(): {}", (Object)this.getCurrentDirectory());
        logger.debug("selectedFile={}", (Object)targetFile);
        if (StringUtils.isBlank((CharSequence)ToolBox.getExtension(targetFile))) {
            targetFile = new File(String.valueOf(targetFile.getAbsolutePath()) + ".txt");
        }
        if (!StringUtils.endsWithAny((CharSequence)ToolBox.getExtension(targetFile), (CharSequence[])new CharSequence[]{"ods", "txt", "xls"})) {
            targetFile = new File(String.valueOf(targetFile.getAbsolutePath()) + ".txt");
            this.setSelectedFile(targetFile);
        }
        if (targetFile.exists()) {
            if (ConfirmOverwriteDialog.showDialog(null)) {
                logger.debug("Overwrite");
                super.approveSelection();
            } else {
                logger.debug("Cancel overwrite");
            }
        } else {
            super.approveSelection();
        }
    }

    @Override
    public void cancelSelection() {
        logger.debug("Cancel selection.");
        super.cancelSelection();
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
        System.out.println("==== SET SELECTED FILE=================");
        System.out.println("SELECED FILE " + file);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.resetChoosableFileFilters();
        }
    }

    public static File showSelectorDialog(Component parent, File targetFile) {
        File result;
        ExportBARFileSelector selector = new ExportBARFileSelector(targetFile);
        if (selector.showDialog(parent, null) == 0) {
            logger.debug("getCurrentDirectory(): {}", (Object)selector.getCurrentDirectory());
            logger.debug("getSelectedFile() : {}", (Object)selector.getSelectedFile());
            result = selector.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }
}

