/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.util;

import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.tip.puckgui.util.AutoTextField;

public class AutoComboBox
extends JComboBox {
    private static final long serialVersionUID = 2957530556022218090L;
    private AutoTextFieldEditor autoTextFieldEditor;
    private boolean isFired;

    public AutoComboBox(List list) {
        ArrayList targetList = list == null ? new ArrayList() : list;
        this.isFired = false;
        this.autoTextFieldEditor = new AutoTextFieldEditor(targetList);
        this.setEditable(true);
        this.setModel(new DefaultComboBoxModel(targetList.toArray()){

            @Override
            protected void fireContentsChanged(Object obj, int i, int j) {
                if (!AutoComboBox.this.isFired) {
                    super.fireContentsChanged(obj, i, j);
                }
            }
        });
        this.setEditor(this.autoTextFieldEditor);
    }

    @Override
    protected void fireActionEvent() {
        if (!this.isFired) {
            super.fireActionEvent();
        }
    }

    public List getDataList() {
        return this.autoTextFieldEditor.getAutoTextFieldEditor().getDataList();
    }

    public boolean isCaseSensitive() {
        return this.autoTextFieldEditor.getAutoTextFieldEditor().isCaseSensitive();
    }

    public boolean isStrict() {
        return this.autoTextFieldEditor.getAutoTextFieldEditor().isStrict();
    }

    public void setCaseSensitive(boolean flag) {
        this.autoTextFieldEditor.getAutoTextFieldEditor().setCaseSensitive(flag);
    }

    public void setDataList(List list) {
        this.autoTextFieldEditor.getAutoTextFieldEditor().setDataList(list);
        this.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
    }

    void setSelectedValue(Object obj) {
        if (this.isFired) {
            return;
        }
        this.isFired = true;
        this.setSelectedItem(obj);
        this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
        this.isFired = false;
    }

    public void setStrict(boolean flag) {
        this.autoTextFieldEditor.getAutoTextFieldEditor().setStrict(flag);
    }

    private class AutoTextFieldEditor
    extends BasicComboBoxEditor {
        AutoTextFieldEditor(List list) {
            this.editor = new AutoTextField(list, AutoComboBox.this);
        }

        private AutoTextField getAutoTextFieldEditor() {
            return (AutoTextField)this.editor;
        }
    }
}

