/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tip.puck.PuckException;
import org.tip.puck.matrix.Matrix;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Populatable;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.RelationWorker;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Organizable;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.Sequenceable;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class SequenceStatistics<S extends Sequenceable<E>, E> {
    Segmentation segmentation;
    List<Ordinal> times;
    Organizable<S> sequences;
    S singleSequence;
    Map<S, Map<Ordinal, Map<String, Value>>> valuesBySequences;
    Map<Individual, Map<Ordinal, Map<String, Value>>> valuesByIndividuals;
    Map<Ordinal, Map<String, Double>> sumsOverSequences;
    Map<Ordinal, Map<String, Double>> sumsOverIndividuals;
    List<String> indicators;
    String pattern;
    String affiliationLabel;

    public SequenceStatistics(Segmentation segmentation, S singleSequence, SpaceTimeCriteria criteria) {
        this.times = Ordinal.getOrdinals(criteria.getDates());
        this.segmentation = segmentation;
        this.singleSequence = singleSequence;
    }

    public SequenceStatistics(Segmentation segmentation, Organizable<S> sequences, SpaceTimeCriteria criteria, List<String> indicators) {
        this.times = Ordinal.getOrdinals(criteria.getDates());
        this.pattern = criteria.getPattern();
        this.indicators = indicators;
        this.sequences = sequences;
        this.valuesBySequences = new TreeMap<S, Map<Ordinal, Map<String, Value>>>();
        for (Sequenceable sequence : sequences.toSortedList()) {
            this.valuesBySequences.put(sequence, new TreeMap());
            for (Ordinal time : this.times) {
                this.valuesBySequences.get(sequence).put(time, new TreeMap());
            }
        }
        this.sumsOverSequences = new TreeMap<Ordinal, Map<String, Double>>();
        for (Ordinal time : this.times) {
            this.sumsOverSequences.put(time, new TreeMap());
        }
        this.segmentation = segmentation;
        this.valuesByIndividuals = new TreeMap<Individual, Map<Ordinal, Map<String, Value>>>();
        for (Individual member : sequences.getIndividuals(segmentation).toSortedList()) {
            this.valuesByIndividuals.put(member, new TreeMap());
            for (Ordinal time : this.times) {
                this.valuesByIndividuals.get(member).put(time, new HashMap());
            }
        }
        this.sumsOverIndividuals = new TreeMap<Ordinal, Map<String, Double>>();
        for (Ordinal time : this.times) {
            this.sumsOverIndividuals.put(time, new TreeMap());
        }
    }

    public Map<Ordinal, Relation> completeRelations(Individual individual, String relationModelName, String dateLabel, String egoRoleName, String startDateLabel, String endDateLabel) {
        TreeMap<Ordinal, Relation> result = new TreeMap<Ordinal, Relation>();
        Ordinal previousTime = null;
        for (Ordinal time : this.times) {
            Relation relation = (Relation)individual.relations().getByModelName(relationModelName).getByTime(dateLabel, time.getYear()).getFirst();
            if (relation != null) {
                Relation previousRelation;
                result.put(time, relation);
                if (previousTime != null && result.get(previousTime) == null && (previousRelation = (Relation)individual.relations().getByModelName(relationModelName).getPredecessors(relation, individual, egoRoleName, dateLabel, startDateLabel, endDateLabel, previousTime.getYear()).getFirst()) != null) {
                    result.put(previousTime, previousRelation);
                }
            }
            previousTime = time;
        }
        return result;
    }

    public void putMemberValues(SpaceTimeCriteria criteria) {
        for (Individual member : this.sequences.getIndividuals(this.segmentation).toSortedList()) {
            Map<Ordinal, Map<String, Value>> memberValues = this.valuesByIndividuals.get(member);
            Map<Ordinal, Relation> completeRelations = this.completeRelations(member, criteria.getRelationModelName(), criteria.getDateLabel(), criteria.getEgoRoleName(), criteria.getStartDateLabel(), criteria.getEndDateLabel());
            for (Ordinal time : this.times) {
                HashMap<String, Value> valueMap = new HashMap<String, Value>();
                Value relationValue = IndividualValuator.get(member, completeRelations.get(time), null);
                String lifeStatus = IndividualValuator.lifeStatusAtYear(member, time.getYear());
                if (relationValue == null) {
                    if (time.getYear().toString().equals(member.getAttributeValue("BIRT_DATE"))) {
                        lifeStatus = "UNBORN";
                    } else if (time.getYear().toString().equals(member.getAttributeValue("DEAT_DATE"))) {
                        lifeStatus = "DEAD";
                    }
                }
                valueMap.put("LIFE_STATUS", new Value(lifeStatus));
                for (String indicator : this.indicators) {
                    if (relationValue == null) continue;
                    Relation relation = relationValue.relationValue();
                    if (indicator.equals("PLACE")) {
                        String placeValue = relation.getAttributeValue(criteria.getLocalUnitLabel());
                        if (placeValue == null) {
                            placeValue = relation.getAttributeValue(criteria.getPlaceLabel());
                        }
                        valueMap.put(indicator, Value.valueOf(placeValue));
                        continue;
                    }
                    Actor actor = relation.getActor(member, criteria.getEgoRoleName());
                    if (indicator.equals("REFERENT")) {
                        valueMap.put(indicator, Value.valueOf(actor.getReferent()));
                        continue;
                    }
                    if (indicator.equals("REFERENT_KIN")) {
                        valueMap.put(indicator, Value.valueOf(RelationWorker.getReferentRole(actor, this.pattern, this.affiliationLabel, relation)));
                        continue;
                    }
                    if (indicator.equals("REFERENT_CHAIN")) {
                        valueMap.put(indicator, Value.valueOf(RelationWorker.getReferentChainGenderString(actor, this.affiliationLabel, relation)));
                        continue;
                    }
                    if (indicator.equals("REFERENT_KIN_TYPE")) {
                        valueMap.put(indicator, Value.valueOf(RelationWorker.getReferentRoleShort(actor, this.pattern, this.affiliationLabel, relation)));
                        continue;
                    }
                    if (!indicator.equals("REFERENT_CHAIN_TYPE")) continue;
                    valueMap.put(indicator, Value.valueOf(RelationWorker.getReferentChainNumber(actor, relation)));
                }
                memberValues.put(time, valueMap);
            }
        }
    }

    public <V> Value getValue(V item, Ordinal time, String indicator) {
        Map<String, Value> stationValues;
        Value result = null;
        Map<Ordinal, Map<String, Value>> itemValues = null;
        if (item instanceof Sequence) {
            itemValues = this.valuesBySequences.get(item);
        } else if (item instanceof Individual) {
            itemValues = this.valuesByIndividuals.get(item);
        }
        if (itemValues != null && (stationValues = itemValues.get(time)) != null) {
            result = stationValues.get(indicator);
        }
        return result;
    }

    public Double sumOverSequences(Ordinal time, String indicator) {
        Double sum = this.sumsOverSequences.get(time).get(indicator);
        Double result = sum == null ? Double.valueOf(0.0) : sum;
        return result;
    }

    public Double sumOverIndividuals(Ordinal time, String indicator) {
        Double sum = this.sumsOverIndividuals.get(time).get(indicator);
        Double result = sum == null ? Double.valueOf(0.0) : sum;
        return result;
    }

    public Double meanOverSequences(Ordinal time, String indicator) {
        Double result = this.sumOverSequences(time, indicator) / new Double(this.valuesBySequences.size());
        return result;
    }

    public Double meanOverIndividuals(Individual individual, Ordinal time, String indicator) {
        Double result = this.sumOverSequences(time, indicator) / new Double(this.valuesByIndividuals.size());
        return result;
    }

    public void put(S sequence, Ordinal time, String indicator, Value value) {
        Map<String, Value> stationValues;
        Map<Ordinal, Map<String, Value>> sequenceValues = this.valuesBySequences.get(sequence);
        if (sequenceValues != null && (stationValues = sequenceValues.get(time)) != null) {
            stationValues.put(indicator, value);
            if (value.isNumber()) {
                this.sumsOverSequences.get(time).put(indicator, this.sumOverSequences(time, indicator) + new Value(value).doubleValue());
            }
        }
    }

    public void putSequenceValues() {
        for (Sequenceable sequence : this.sequences.toSortedList()) {
            for (Ordinal time : this.times) {
                Object station = sequence.getStation(time);
                if (station == null) continue;
                Map<String, Value> statistics = this.getStatistics(station, this.indicators, this.pattern);
                for (String indicator : this.indicators) {
                    Value value = statistics.get(indicator);
                    this.put(sequence, time, indicator, value);
                }
            }
        }
    }

    public Map<String, Value> getStatistics(E station, List<String> indicators, String pattern) {
        Map<String, Value> result = null;
        if (station instanceof Relation) {
            result = RelationWorker.getStatistics((Relation)station, indicators, pattern);
        }
        return result;
    }

    public List<String> indicators() {
        return this.indicators;
    }

    public String getTrend(S sequence, String indicator) {
        String result = null;
        Value lastValue = null;
        for (Ordinal time : this.times) {
            Value value = this.getValue(sequence, time, indicator);
            if (lastValue != null && value != null) {
                if (lastValue.isNotNumber() || value.isNotNumber()) break;
                int comp = value.compareTo(lastValue);
                String trend = null;
                if (comp < 0) {
                    trend = "DECLINING";
                } else if (comp > 0) {
                    trend = "AUGMENTING";
                } else if (comp == 0) {
                    trend = "CONSTANT";
                }
                if (result == null || result.equals("CONSTANT")) {
                    result = trend;
                } else if (!trend.equals("CONSTANT") && !trend.equals(result)) {
                    result = "VARIABLE";
                    break;
                }
            }
            lastValue = value;
        }
        return result;
    }

    public String getMeanTrend(String indicator) {
        String result = "";
        HashMap<String, Double> trendCounts = new HashMap<String, Double>();
        for (Sequenceable sequence : this.sequences) {
            String trend = this.getTrend(sequence, indicator);
            Double count = (Double)trendCounts.get(trend);
            if (count == null) {
                trendCounts.put(trend, 1.0);
                continue;
            }
            trendCounts.put(trend, count + 1.0);
        }
        for (String trend : trendCounts.keySet()) {
            trendCounts.put(trend, MathUtils.percent((Double)trendCounts.get(trend), new Double(this.sequences.size())));
        }
        ArrayList sortedEntries = new ArrayList(trendCounts.entrySet());
        Collections.sort(sortedEntries, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> e1, Map.Entry<String, Double> e2) {
                return e2.getValue().compareTo(e1.getValue());
            }
        });
        for (Map.Entry entry : sortedEntries) {
            result = String.valueOf(result) + (String)entry.getKey() + " " + entry.getValue() + " ";
        }
        return result;
    }

    public <V> Map<Value, Double> getMeanValueFrequencies(Map<Ordinal, Partition<V>> census, Organizable<V> sliceables) {
        TreeMap<Value, Double> result = new TreeMap<Value, Double>();
        for (Object sliceable : sliceables) {
            for (Ordinal time : this.times) {
                Value value = census.get(time).getValue(sliceable);
                if (value == null) continue;
                Double count = (Double)result.get(value);
                count = count == null ? Double.valueOf(1.0) : Double.valueOf(count + 1.0);
                result.put(value, count);
            }
        }
        for (Value value : result.keySet()) {
            if (result.get(value) != null) continue;
            result.put(value, (Double)result.get(value) / new Double(this.times.size()));
        }
        return result;
    }

    public <V> Matrix getTransitionMatrix(Map<Ordinal, Partition<V>> census, Organizable<V> sliceables) {
        TreeMap transitionMap = new TreeMap();
        ArrayList<String> values = new ArrayList<String>();
        for (Object sliceable : sliceables) {
            int i = 1;
            while (i < this.times.size()) {
                Value object1 = census.get(this.times.get(i - 1)).getValue(sliceable);
                Value object2 = census.get(this.times.get(i)).getValue(sliceable);
                if (object1 != null && object2 != null) {
                    Integer count;
                    TreeMap<String, Integer> targetMap;
                    String value1 = object1.toString();
                    String value2 = object2.toString();
                    if (!values.contains(value1)) {
                        values.add(value1);
                    }
                    if (!values.contains(value2)) {
                        values.add(value2);
                    }
                    if ((targetMap = (TreeMap<String, Integer>)transitionMap.get(value1)) == null) {
                        targetMap = new TreeMap<String, Integer>();
                        transitionMap.put(value1, targetMap);
                    }
                    count = (count = (Integer)targetMap.get(value2)) == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                    targetMap.put(value2, count);
                }
                ++i;
            }
        }
        Collections.sort(values);
        String[] labels = new String[values.size()];
        int i = 0;
        while (i < values.size()) {
            labels[i] = String.valueOf((String)values.get(i));
            ++i;
        }
        Matrix result = new Matrix(values.size(), values.size());
        result.setRowLabels(labels);
        result.setColLabels(labels);
        for (Object value1 : transitionMap.keySet()) {
            Map targetMap = (Map)transitionMap.get(value1);
            for (Object value2 : targetMap.keySet()) {
                result.augment(values.indexOf(value1), values.indexOf(value2), (Integer)targetMap.get(value2));
            }
        }
        return result;
    }

    public Map<Ordinal, Partition<Individual>> getDatedIndividualCensus(Segmentation segmentation, String censusType) {
        TreeMap<Ordinal, Partition<Individual>> result = new TreeMap<Ordinal, Partition<Individual>>();
        for (Ordinal time : this.times) {
            result.put(time, new Partition());
        }
        for (Individual member : this.sequences.getIndividuals(segmentation)) {
            for (Ordinal time : this.times) {
                Value value = this.getValue(member, time, censusType);
                if (value == null) continue;
                ((Partition)result.get(time)).put(member, value);
            }
        }
        return result;
    }

    private Individuals getIndividuals(E station) {
        Individuals result = station instanceof Populatable ? ((Populatable)station).getIndividuals() : null;
        return result;
    }

    public Map<String, Map<Ordinal, Partition<Individual>>> getDynamicIndividualCensus(SpaceTimeCriteria spaceTimeCriteria, StatisticsCriteria statisticsCriteria) {
        TreeMap<String, Map<Ordinal, Partition<Individual>>> result = new TreeMap<String, Map<Ordinal, Partition<Individual>>>();
        result.put("MIGRATIONS", new TreeMap());
        result.put("DESTINATIONS", new TreeMap());
        result.put("ORIGINS", new TreeMap());
        int i = 0;
        while (i < this.times.size() - 1) {
            Ordinal startTime = this.times.get(i);
            Ordinal endTime = this.times.get(i + 1);
            Relations filteredStartSpace = (Relations)this.singleSequence.getStation(startTime);
            Relations filteredEndSpace = (Relations)this.singleSequence.getStation(endTime);
            Relations totalStartSpace = this.segmentation.getAllRelations().getByTime(spaceTimeCriteria.getDateLabel(), startTime.getYear());
            Relations totalEndSpace = this.segmentation.getAllRelations().getByTime(spaceTimeCriteria.getDateLabel(), endTime.getYear());
            Partition<Individual> migrations = new Partition<Individual>();
            migrations.setLabel("Migrations " + startTime + "/" + endTime);
            ((Map)result.get("MIGRATIONS")).put(endTime, migrations);
            Partition<Individual> destinations = new Partition<Individual>();
            destinations.setLabel("Destinations " + startTime + "/" + endTime);
            ((Map)result.get("DESTINATIONS")).put(startTime, destinations);
            Partition<Individual> origins = new Partition<Individual>();
            origins.setLabel("Origins " + startTime + "/" + endTime);
            ((Map)result.get("ORIGINS")).put(endTime, origins);
            for (Individual individual : filteredStartSpace.getIndividuals().toSortedList()) {
                String endUnit;
                if (IndividualValuator.lifeStatusAtYear(individual, endTime.getYear()).equals("DEAD")) {
                    migrations.put(individual, new Value("DIED"));
                    continue;
                }
                if (totalEndSpace.getByIndividual(individual).isEmpty()) {
                    migrations.put(individual, new Value("UNKNOWN DESTINATION"));
                    continue;
                }
                if (filteredEndSpace.getByIndividual(individual).isEmpty()) {
                    migrations.put(individual, new Value("LEFT"));
                    for (Relation destination : totalEndSpace.getByIndividual(individual)) {
                        destinations.put(individual, RelationValuator.get(destination, "PLACE", (Object)statisticsCriteria.getPlaceParameter()));
                    }
                    continue;
                }
                Relation start = (Relation)filteredStartSpace.getByIndividual(individual).getFirst();
                Relation end = (Relation)filteredEndSpace.getByIndividual(individual).getFirst();
                String startUnit = start.getAttributeValue(this.singleSequence.idLabel());
                if (startUnit == null) {
                    startUnit = start.getAttributeValue(spaceTimeCriteria.getPlaceLabel());
                }
                if ((endUnit = end.getAttributeValue(this.singleSequence.idLabel())) == null) {
                    endUnit = start.getAttributeValue(spaceTimeCriteria.getPlaceLabel());
                }
                if (!startUnit.equals(endUnit)) {
                    migrations.put(individual, new Value("INTERNAL CHANGE"));
                    continue;
                }
                migrations.put(individual, new Value("UNCHANGED"));
            }
            for (Individual individual : filteredEndSpace.getIndividuals().toSortedList()) {
                if (IndividualValuator.lifeStatusAtYear(individual, startTime.getYear()).equals("UNBORN")) {
                    migrations.put(individual, new Value("NEWBORN"));
                    continue;
                }
                if (totalStartSpace.getByIndividual(individual).isEmpty()) {
                    migrations.put(individual, new Value("UNKNOWN ORIGIN"));
                    continue;
                }
                if (!filteredStartSpace.getByIndividual(individual).isEmpty()) continue;
                migrations.put(individual, new Value("ENTERED"));
                for (Relation origin : totalStartSpace.getByIndividual(individual)) {
                    origins.put(individual, RelationValuator.get(origin, "PLACE", (Object)statisticsCriteria.getPlaceParameter()));
                }
            }
            ++i;
        }
        return result;
    }

    public Map<Ordinal, Partition<Individual>> getDatedIndividualCensus(SpaceTimeCriteria spaceTimeCriteria, PartitionCriteria partitionCriteria) throws PuckException {
        TreeMap<Ordinal, Partition<Individual>> result = new TreeMap<Ordinal, Partition<Individual>>();
        for (Ordinal time : this.times) {
            Object relations = this.singleSequence.getStation(time);
            String label = String.valueOf(spaceTimeCriteria.getRelationModelName()) + " " + time;
            Partition<Object> partition = new Partition();
            if (partitionCriteria.getLabel().equals("REFERENT")) {
                partitionCriteria.setLabelParameter(String.valueOf(spaceTimeCriteria.getRelationModelName()) + " " + spaceTimeCriteria.getEgoRoleName() + " " + time);
                Partition<Individual> prePartition = PartitionMaker.create(label, this.getIndividuals(relations), (Relations)relations, partitionCriteria);
                for (Individual ego : prePartition.getItemsAsList()) {
                    Value alterId = prePartition.getValue(ego);
                    if (alterId == null) continue;
                    List<String> alterRoles = NetUtils.getAlterRoles(ego, (Individual)this.segmentation.getAllIndividuals().getById(alterId.intValue()), ToolBox.stringsToInts(spaceTimeCriteria.getPattern()), spaceTimeCriteria.getRelationModelNames(), spaceTimeCriteria.getChainClassification(), null, null);
                    Collections.sort(alterRoles);
                    partition.put(ego, new Value(alterRoles.toString()));
                }
            } else {
                if (partitionCriteria.getLabel().equals("AGE") || partitionCriteria.getLabel().equals("MATRISTATUS") || partitionCriteria.getLabel().equals("OCCUPATION")) {
                    partitionCriteria.setLabelParameter("" + time);
                }
                partition = PartitionMaker.create(label, this.getIndividuals(relations), (Relations)relations, partitionCriteria);
            }
            result.put(time, partition);
        }
        return result;
    }

    public Map<Ordinal, Partition<S>> getDatedSequenceCensus(String censusType, SpaceTimeCriteria criteria) {
        TreeMap<Ordinal, Partition<S>> result = new TreeMap<Ordinal, Partition<S>>();
        for (Ordinal time : this.times) {
            result.put(time, new Partition());
        }
        for (Sequenceable sequence : this.valuesBySequences.keySet()) {
            Map<Ordinal, Map<String, Value>> sequenceValues = this.valuesBySequences.get(sequence);
            for (Ordinal time : this.times) {
                Object station = sequence.getStation(time);
                Map map = null;
                if (station instanceof Relation) {
                    map = RelationValuator.get((Relation)station, censusType, this.segmentation, criteria).mapValue();
                }
                if (map == null) continue;
                sequenceValues.get(time).putAll(map);
                for (String indicator : sequenceValues.get(time).keySet()) {
                    if (this.indicators.contains(indicator)) continue;
                    this.indicators.add(indicator);
                }
                Partition partition = (Partition)result.get(time);
                Value value = (Value)map.get("Types");
                if (value == null) continue;
                partition.put(sequence, new Value(value));
            }
        }
        return result;
    }

    public <V> Partition<V> getSequenceCensus(Map<Ordinal, Partition<V>> datedPartition, Organizable<V> sliceables) {
        Partition result = new Partition();
        for (Object member : sliceables) {
            Sequence<Value> sequence = new Sequence<Value>();
            for (Ordinal time : this.times) {
                sequence.put(time, datedPartition.get(time).getValue(member));
            }
            result.put(member, new Value(sequence.toValueString()));
        }
        return result;
    }

    public Map<E, E> adjacentStations(String direction) {
        HashMap result = new HashMap();
        Ordinal former = null;
        for (Ordinal later : this.times) {
            if (former != null) {
                Ordinal current = null;
                if (direction.equals("OUT")) {
                    current = former;
                } else if (direction.equals("IN")) {
                    current = later;
                }
                for (Sequenceable house : this.sequences) {
                    Object currentRelation = house.getStation(current);
                    if (currentRelation == null) continue;
                    if (direction.equals("OUT")) {
                        result.put(currentRelation, house.getStation(later));
                        continue;
                    }
                    if (!direction.equals("IN")) continue;
                    result.put(currentRelation, house.getStation(former));
                }
            }
            former = later;
        }
        return result;
    }

    public Partition<String> getFlows(String direction, String dateLabel) {
        Partition<String> result = new Partition<String>();
        int[] maxDegrees = ToolBox.stringsToInts(this.pattern);
        Map<E, E> adjacentStations = this.adjacentStations(direction);
        for (Relation currentRelation : adjacentStations.keySet()) {
            Relation otherRelation = (Relation)adjacentStations.get(currentRelation);
            for (Actor actor : currentRelation.getDifferentwActors(otherRelation)) {
                Individual referent = actor.getReferent();
                String link = "UNKNOWN";
                if (referent != null) {
                    link = NetUtils.getAlterRole(actor.getIndividual(), referent, maxDegrees, null);
                }
                Individual otherReferent = null;
                Actor otherActor = RelationWorker.getClosestHomologue(currentRelation, actor, dateLabel, direction);
                if (otherActor != null) {
                    otherReferent = otherActor.getReferent();
                }
                String otherLink = "UNKNOWN";
                if (otherReferent != null) {
                    otherLink = NetUtils.getAlterRole(actor.getIndividual(), otherReferent, maxDegrees, null);
                }
                String change = null;
                if (referent != null && referent.equals(otherReferent)) {
                    change = "IDENTICAL";
                } else if (direction.equals("OUT")) {
                    change = String.valueOf(link) + ">" + otherLink;
                } else if (direction.equals("IN")) {
                    change = String.valueOf(otherLink) + ">" + link;
                }
                System.out.println(currentRelation + " " + otherRelation + " " + actor);
                result.put(currentRelation + "\t" + currentRelation.getTime(dateLabel) + "\t" + direction + "\t" + actor.getIndividual() + "\t" + referent + "\t" + otherReferent, new Value(change));
            }
        }
        return result;
    }
}

