/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.kinoath;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.kinoath.Booking;
import org.tip.puck.kinoath.Bookings;
import org.tip.puck.kinoath.PruningCriteria;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;

public class IndividualAroundWorker {
    private static final Logger logger = LoggerFactory.getLogger(IndividualAroundWorker.class);

    public static Individuals searchAround(Individual source, PruningCriteria criteria) {
        Individuals result = new Individuals();
        result.add(source);
        Bookings bookings = new Bookings();
        bookings.booked().add(source);
        if (criteria.getParentsDepth() > 0) {
            for (Individual parent : source.getParents()) {
                bookings.add(new Booking(parent, 1L, Booking.Direction.UP));
            }
        }
        if (criteria.getChildrenDepth() > 0) {
            for (Individual child : source.children()) {
                bookings.add(new Booking(child, 1L, Booking.Direction.DOWN));
            }
        }
        if (criteria.getPartnersDepth() > 0) {
            for (Individual partner : source.getPartners()) {
                bookings.add(new Booking(partner, 1L, Booking.Direction.ASIDE));
            }
        }
        block8: while (!bookings.isEmpty()) {
            Booking current = bookings.pop();
            if (result.contains(current.getIndividual())) continue;
            result.add(current.getIndividual());
            switch (current.getDirection()) {
                case UP: {
                    if ((long)criteria.getParentsDepth() <= current.getDepth()) break;
                    for (Individual parent : current.getIndividual().getParents()) {
                        bookings.add(new Booking(parent, current.getDepth() + 1L, Booking.Direction.UP));
                    }
                    if (!criteria.isCollaterals()) break;
                    if ((long)criteria.getParentsDepth() > current.getDepth()) {
                        for (Individual child : current.getIndividual().children()) {
                            bookings.add(new Booking(child, current.getDepth() + 1L, Booking.Direction.UP));
                        }
                    }
                    if ((long)criteria.getParentsDepth() <= current.getDepth()) break;
                    for (Individual partner : current.getIndividual().getPartners()) {
                        bookings.add(new Booking(partner, current.getDepth() + 1L, Booking.Direction.UP));
                    }
                    continue block8;
                }
                case DOWN: {
                    if ((long)criteria.getChildrenDepth() <= current.getDepth()) break;
                    for (Individual child : current.getIndividual().children()) {
                        bookings.add(new Booking(child, current.getDepth() + 1L, Booking.Direction.DOWN));
                    }
                    if (!criteria.isAffines()) break;
                    if ((long)criteria.getChildrenDepth() > current.getDepth()) {
                        for (Individual parent : current.getIndividual().getParents()) {
                            bookings.add(new Booking(parent, current.getDepth() + 1L, Booking.Direction.DOWN));
                        }
                    }
                    if ((long)criteria.getChildrenDepth() <= current.getDepth()) break;
                    for (Individual partner : current.getIndividual().getPartners()) {
                        bookings.add(new Booking(partner, current.getDepth() + 1L, Booking.Direction.DOWN));
                    }
                    continue block8;
                }
                case ASIDE: {
                    if ((long)criteria.getPartnersDepth() <= current.getDepth()) break;
                    for (Individual partner : current.getIndividual().getPartners()) {
                        bookings.add(new Booking(partner, current.getDepth() + 1L, Booking.Direction.ASIDE));
                    }
                    if ((long)criteria.getPartnersDepth() > current.getDepth()) {
                        for (Individual child : current.getIndividual().children()) {
                            bookings.add(new Booking(child, current.getDepth() + 1L, Booking.Direction.ASIDE));
                        }
                    }
                    if ((long)criteria.getPartnersDepth() <= current.getDepth()) break;
                    for (Individual parent : current.getIndividual().getParents()) {
                        bookings.add(new Booking(parent, current.getDepth() + 1L, Booking.Direction.ASIDE));
                    }
                    continue block8;
                }
            }
        }
        return result;
    }
}

