/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime.workers;

import fr.devinsy.util.StringList;
import java.util.ResourceBundle;
import org.tip.puck.PuckException;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.RelationReporter;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportList;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.workers.SequenceMaker;
import org.tip.puck.spacetime.workers.SequenceReporter;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.statistics.StatisticsCriteria;

public class SpaceTimeReporter {
    public static ReportList reportHugeAnalysis(Net net, Segmentation segmentation, SpaceTimeCriteria criteria, ResourceBundle bundle) throws PuckException {
        ReportList result = new ReportList();
        if (criteria != null) {
            StringList relationModelNames = net.relationModels().sortedNameList();
            AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(segmentation, null);
            if (criteria.isSequenceAnalysis()) {
                if (!criteria.getSequenceReportTypes().isEmpty()) {
                    Report sequenceReport = SequenceReporter.reportSequences(net, segmentation, criteria);
                    result.add(sequenceReport);
                }
                if (!criteria.getSequenceGeneralStatistics().isEmpty()) {
                    Report sequenceCensusReport = SequenceReporter.reportGeneralSequenceCensus(segmentation, criteria);
                    result.add(sequenceCensusReport);
                }
                if (!criteria.getEgoNetworksOperations().isEmpty()) {
                    Report egoNetworkReport = SequenceReporter.reportEgoNetworksCensus(segmentation, criteria);
                    result.add(egoNetworkReport);
                }
                if (!criteria.getParcoursNetworksOperations().isEmpty()) {
                    Report parcoursNetworkReport = SequenceReporter.reportParcoursNetworksCensus(segmentation, criteria);
                    result.add(parcoursNetworkReport);
                }
                if (!criteria.getTrajectoriesOperations().isEmpty()) {
                    Report trajectoriesReport = SequenceReporter.reportTrajectoriesCensus(segmentation, criteria);
                    result.add(trajectoriesReport);
                }
            } else {
                StatisticsCriteria statisticsCriteria = new StatisticsCriteria();
                PartitionCriteria placeCriteria = PartitionCriteria.createRaw("BIRT_PLACE");
                placeCriteria.setLabelParameter("Bas-Mono");
                statisticsCriteria.getPartitionCriterias().add(placeCriteria);
                statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createSizedGrouping("AGE", null, 0.0, 20.0, null));
                statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("QUARTER"));
                statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("PATRIL"));
                statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("OCCUPATION"));
                statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("MATRISTATUS"));
                statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("REFERENT"));
                statisticsCriteria.setPlaceParameter("Bas-Mono");
                Sequence<Relations> slices = SequenceMaker.createRelationSetSequence(segmentation, criteria);
                if (!criteria.getSliceReportTypes().isEmpty()) {
                    Report sliceReport = SequenceReporter.reportMembers(slices, criteria);
                    result.add(sliceReport);
                }
                if (criteria.getSliceGeneralStatistics().contains((Object)SpaceTimeCriteria.SliceGeneralStatistics.STATICS)) {
                    Report sliceStaticsReport = SequenceReporter.reportIndividualStatics(segmentation, slices, criteria, statisticsCriteria);
                    result.add(sliceStaticsReport);
                }
                if (criteria.getSliceGeneralStatistics().contains((Object)SpaceTimeCriteria.SliceGeneralStatistics.DYNAMICS)) {
                    Report sliceDynamicsReport = SequenceReporter.reportIndividualDynamics(segmentation, slices, criteria, statisticsCriteria);
                    result.add(sliceDynamicsReport);
                }
                if (!criteria.getEgoNetworksOperations().isEmpty()) {
                    Report egoNetworkReport = SequenceReporter.reportEgoNetworks(slices, statisticsCriteria, criteria);
                    result.add(egoNetworkReport);
                }
                if (!criteria.getTrajectoriesOperations().isEmpty()) {
                    Report trajectoriesReport = SequenceReporter.reportGeneralSequenceCensus(slices, statisticsCriteria, criteria);
                    result.add(trajectoriesReport);
                }
            }
        }
        return result;
    }

    public static ReportList reportReferentNetworkAnalysis(Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException {
        ReportList result = new ReportList();
        if (criteria != null) {
            if (criteria.getReferentNetworkOperations().contains((Object)SpaceTimeCriteria.ReferentNetworkOperation.REFERENT_TREES)) {
                boolean reducedTrees = false;
                Report report = SequenceReporter.reportTreeStructure(segmentation, criteria, reducedTrees);
                result.add(report);
            }
            if (criteria.getReferentNetworkOperations().contains((Object)SpaceTimeCriteria.ReferentNetworkOperation.ITINERARIES)) {
                Report report2 = SequenceReporter.reportItineraries(segmentation, criteria);
                result.add(report2);
            }
            if (criteria.getReferentNetworkOperations().contains((Object)SpaceTimeCriteria.ReferentNetworkOperation.CIRCUIT_CENSUS)) {
                for (Report report3 : RelationReporter.reportRelationCensus(segmentation, criteria)) {
                    result.add(report3);
                }
            }
            if (criteria.getReferentNetworkOperations().contains((Object)SpaceTimeCriteria.ReferentNetworkOperation.DIFFERENTIAL_CENSUS)) {
                CensusCriteria censusCriteria = new CensusCriteria();
                censusCriteria.setPattern(criteria.getPattern());
                censusCriteria.setChainClassification(criteria.getChainClassification());
                censusCriteria.setRelationAttributeLabel(criteria.getLocalUnitLabel());
                Integer[] dates = criteria.getDates();
                if (dates == null) {
                    Report report = CensusReporter.reportDifferentialCensus(segmentation, criteria, null, censusCriteria);
                    result.add(report);
                } else {
                    Integer[] integerArray = dates;
                    int n = dates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Integer date = integerArray[n2];
                        Report report = CensusReporter.reportDifferentialCensus(segmentation, criteria, date, censusCriteria);
                        result.add(report);
                        ++n2;
                    }
                }
            }
        }
        return result;
    }
}

