/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime.workers;

import org.tip.puck.PuckException;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.ExpansionMode;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.EgoRelationSequence;
import org.tip.puck.spacetime.EgoRelationSequences;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.SequenceType;
import org.tip.puck.spacetime.Sequences;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;

public class SequenceMaker {
    public static EgoRelationSequence createSequence(Individual ego, SpaceTimeCriteria criteria) {
        EgoRelationSequence result = new EgoRelationSequence(ego);
        result.putInOrder(ego.relations(), SequenceType.MOVES);
        return result;
    }

    public static EgoRelationSequence createPersonalSequence(Individual ego, SpaceTimeCriteria criteria) {
        String egoRoleName = criteria.getEgoRoleName();
        EgoRelationSequence result = new EgoRelationSequence(ego);
        Relations relations = new Relations();
        for (Relation relation : ego.relations()) {
            if (!relation.getRoleNames(ego).contains(egoRoleName)) continue;
            relations.add(relation);
        }
        result.putInOrder(relations, SequenceType.EVENTS);
        return result;
    }

    public static EgoRelationSequences createPersonalSequences(Segmentation segmentation, SpaceTimeCriteria criteria) {
        EgoRelationSequences result = new EgoRelationSequences();
        for (Individual individual : segmentation.getCurrentIndividuals().toSortedList()) {
            result.add(SequenceMaker.createPersonalSequence(individual, criteria));
        }
        return result;
    }

    public static EgoRelationSequences createBiographies(Net net, Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException {
        EgoRelationSequences result = new EgoRelationSequences();
        net.getFamilyEvents(segmentation);
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            result.add(SequenceMaker.createSequence(individual, criteria));
        }
        net.removeFamilyEvents();
        return result;
    }

    public static EgoRelationSequence createExtendedSequence(Individual individual, SpaceTimeCriteria criteria) {
        EgoRelationSequence result = new EgoRelationSequence(individual);
        result.putInOrder(individual.relations(), SequenceType.EVENTS);
        ExpansionMode expansionMode = criteria.getExpansionMode();
        FiliationType filiationType = criteria.getFiliationType();
        for (Individual relative : NetUtils.neighbors(individual, expansionMode, filiationType)) {
            result.putInOrder(relative.relations(), SequenceType.EVENTS);
        }
        return result;
    }

    public static EgoRelationSequences createExtendedBiographies(Net net, Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException {
        EgoRelationSequences result = new EgoRelationSequences();
        net.getFamilyEvents(segmentation);
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            result.add(SequenceMaker.createExtendedSequence(individual, criteria));
        }
        net.removeFamilyEvents();
        return result;
    }

    public static Sequences<Relation> createRelationSequences(Segmentation segmentation, SpaceTimeCriteria criteria) {
        Sequences<Relation> result = new Sequences<Relation>();
        for (Relation relation : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName())) {
            String stringTime;
            String stringId = relation.getAttributeValue(criteria.getLocalUnitLabel());
            if (stringId == null) continue;
            int id = Integer.parseInt(stringId);
            Sequence<Relation> house = (Sequence<Relation>)result.getById(id);
            if (house == null) {
                house = new Sequence<Relation>(criteria.getLocalUnitLabel(), id);
                result.put(house);
            }
            if ((stringTime = relation.getAttributeValue(criteria.getDateLabel())) == null) continue;
            int time = Integer.parseInt(stringTime);
            house.put(new Ordinal(time), relation);
        }
        return result;
    }

    public static Sequence<Relations> createRelationSetSequence(Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException {
        Sequence<Relations> result = new Sequence<Relations>(criteria.getLocalUnitLabel(), 0);
        Integer[] integerArray = criteria.getDates();
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            int time = integerArray[n2];
            Relations relations = new Relations();
            relations.setId(time);
            result.put(new Ordinal(time), relations);
            ++n2;
        }
        for (Relation relation : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName()).getByAttribute(criteria.getLocalUnitLabel(), null)) {
            Integer time = relation.getTime(criteria.getDateLabel());
            if (time == null || !result.getTimes().contains(new Ordinal(time))) continue;
            result.getStation(new Ordinal(time)).put(relation);
        }
        return result;
    }
}

