/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.spacetime.EventComparator;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.SequenceType;
import org.tip.puck.spacetime.workers.SequenceCensus;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;

public class EgoRelationSequence
extends Sequence<Relation> {
    Individual ego;

    public EgoRelationSequence(Individual ego) {
        this.ego = ego;
        this.id = ego.getId();
    }

    public EgoRelationSequence(Individual ego, int id) {
        this.ego = ego;
        this.id = id;
    }

    public Individual getEgo() {
        return this.ego;
    }

    public Integer getEgoAge(Integer year) {
        Integer result = year != null ? IndividualValuator.ageAtYear(this.ego, year) : null;
        return result;
    }

    public EgoRelationSequence clone() {
        EgoRelationSequence result = new EgoRelationSequence(this.ego, this.id);
        for (Ordinal key : this.stations.keySet()) {
            result.put(key, (Relation)this.getStation(key));
        }
        return result;
    }

    public void putInOrder(Relations events, SequenceType type) {
        SpaceTimeCriteria criteria = new SpaceTimeCriteria();
        ArrayList<Relation> orderedEvents = new ArrayList<Relation>();
        for (Relation event : events) {
            String startPlace = event.getAttributeValue(criteria.getStartPlaceLabel());
            String endPlace = event.getAttributeValue(criteria.getEndPlaceLabel());
            if (type == SequenceType.MOVES && (startPlace == null || endPlace == null)) continue;
            if (startPlace == null && endPlace == null) {
                startPlace = event.getAttributeValue("PLACE");
                endPlace = event.getAttributeValue("PLACE");
            }
            if (startPlace == null && endPlace == null) continue;
            orderedEvents.add(event);
        }
        Collections.sort(orderedEvents, new EventComparator(criteria));
        for (Relation event : orderedEvents) {
            this.stations.put(new Ordinal(event.getName(), this.stations.size(), SequenceCensus.getYear(event)), event);
        }
    }

    public Integer getOrder(Relation event) {
        Integer result = null;
        for (Actor actor : event.actors().getById(this.ego.getId())) {
            String orderString = actor.getAttributeValue("ORDER");
            if (!StringUtils.isNumeric((CharSequence)orderString)) continue;
            result = Integer.parseInt(orderString);
            break;
        }
        return result;
    }
}

