/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.Organizable;
import org.tip.puck.util.NumberablesHashMap;

public class Individuals
extends NumberablesHashMap<Individual>
implements Organizable<Individual> {
    public Individuals() {
    }

    public Individuals(Individuals source) {
        this.add(source);
    }

    public Individuals(int initialCapacity) {
        super(initialCapacity);
    }

    public Individuals(List<Individual> source) {
        this.add(source);
    }

    public Individuals add(Individuals source) {
        Individuals result = this.put(source);
        return result;
    }

    public Individuals add(List<Individual> source) {
        Individuals result = this.put(source);
        return result;
    }

    @Override
    public Individuals getIndividuals() {
        Individuals result = new Individuals(this);
        return result;
    }

    public List<String> firstNames() {
        HashMap buffer = new HashMap();
        for (Individual individual : this) {
            String firstName = individual.getFirstName();
            if (!StringUtils.isNotBlank((CharSequence)firstName)) continue;
            buffer.put(firstName, null);
        }
        Set firstNames = buffer.keySet();
        ArrayList<String> result = new ArrayList<String>(firstNames.size());
        for (String firstName : buffer.keySet()) {
            result.add(firstName);
        }
        Collections.sort(result);
        return result;
    }

    public StringList getAttributeLabels() {
        StringList result = new StringList();
        for (Individual individual : this) {
            for (String label : individual.attributes().labels()) {
                if (result.contains((Object)label)) continue;
                result.add((Object)label);
            }
        }
        return result;
    }

    public Individuals getByGender(Gender pattern) {
        Individuals result;
        if (pattern == null) {
            result = new Individuals(this);
        } else {
            result = new Individuals();
            for (Individual individual : this) {
                if (individual.getGender() != pattern) continue;
                result.add(individual);
            }
        }
        return result;
    }

    public Individuals getByGenderNear(Gender pattern) {
        Individuals result;
        if (pattern == null) {
            result = new Individuals(this);
        } else {
            result = new Individuals();
            for (Individual individual : this) {
                if (!individual.getGender().matchs(pattern)) continue;
                result.add(individual);
            }
        }
        return result;
    }

    public Individuals getByIds(Integer[] ids) {
        Individuals result;
        if (ids == null) {
            result = new Individuals();
        } else {
            result = new Individuals(ids.length);
            Integer[] integerArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Integer id = integerArray[n2];
                Individual individual = (Individual)this.getById(id);
                if (individual != null) {
                    result.add(individual);
                }
                ++n2;
            }
        }
        return result;
    }

    public Individuals getByIds(List<Integer> ids) {
        Individuals result;
        if (ids == null) {
            result = new Individuals();
        } else {
            result = new Individuals(ids.size());
            for (Integer id : ids) {
                Individual individual = (Individual)this.getById(id);
                if (individual == null) continue;
                result.add(individual);
            }
        }
        return result;
    }

    public Individuals getFertiles() {
        Individuals result = new Individuals();
        for (Individual individual : this) {
            if (!individual.isFertile()) continue;
            result.add(individual);
        }
        return result;
    }

    public Individuals getSteriles() {
        Individuals result = new Individuals();
        for (Individual individual : this) {
            if (!individual.isSterile()) continue;
            result.add(individual);
        }
        return result;
    }

    public List<String> lastNames() {
        HashMap buffer = new HashMap();
        for (Individual individual : this) {
            String lastName = individual.getLastName();
            if (!StringUtils.isNotBlank((CharSequence)lastName)) continue;
            buffer.put(lastName, null);
        }
        Set lastNames = buffer.keySet();
        ArrayList<String> result = new ArrayList<String>(lastNames.size());
        for (String lastName : buffer.keySet()) {
            result.add(lastName);
        }
        Collections.sort(result);
        return result;
    }

    public Individuals put(Individuals source) {
        if (source != null) {
            for (Individual individual : source) {
                this.add(individual);
            }
        }
        Individuals result = this;
        return result;
    }

    public Individuals put(List<Individual> source) {
        if (source != null) {
            for (Individual individual : source) {
                this.add(individual);
            }
        }
        Individuals result = this;
        return result;
    }

    public Individuals remove(Individuals source) {
        for (Individual individual : source) {
            this.removeById(individual.getId());
        }
        Individuals result = this;
        return result;
    }

    public Individuals searchByAttribute(String label, String pattern) {
        Individuals result = new Individuals();
        if (StringUtils.isNotBlank((CharSequence)label) && StringUtils.isNotBlank((CharSequence)pattern)) {
            for (Individual individual : this) {
                Attribute attribute = (Attribute)individual.attributes().get(label);
                if (attribute == null || attribute.getValue() == null || !attribute.getValue().matches(pattern)) continue;
                result.add(individual);
            }
        }
        return result;
    }

    public Individuals searchByName(String pattern) {
        Individuals result = new Individuals();
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            String targetPattern = pattern.toLowerCase();
            for (Individual individual : this) {
                if (individual.getName() == null || !individual.getName().toLowerCase().contains(targetPattern)) continue;
                result.add(individual);
            }
        }
        return result;
    }

    public void setAttribute(int id, String label, String value) {
        if (label != null && value != null) {
            Individual individual = (Individual)this.getById(id);
            if (individual == null) {
                individual = new Individual(id);
                this.put(individual);
            }
            if (label.equals("NAME") && StringUtils.isNotBlank((CharSequence)value) && !StringUtils.equals((CharSequence)value, (CharSequence)"null")) {
                individual.setName(value);
            }
            individual.attributes().put(label, value);
        }
    }

    public int size(Gender pattern) {
        int result;
        if (pattern == null) {
            result = this.size();
        } else {
            result = 0;
            for (Individual individual : this) {
                if (individual.getGender() != pattern) continue;
                ++result;
            }
        }
        return result;
    }

    public Individual[] toArray() {
        Individual[] result = new Individual[this.size()];
        int individualCount = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Individual individual;
            result[individualCount] = individual = (Individual)iterator.next();
            ++individualCount;
        }
        return result;
    }

    public List<Individual> toListSortedByOrder() {
        List<Individual> result = this.toList();
        Collections.sort(result, new IndividualComparator(IndividualComparator.Sorting.BIRTH_ORDER, IndividualComparator.Sorting.ID));
        return result;
    }

    public List<Individual> toListSortedByBirthYearOrOrder() {
        List<Individual> result = this.toList();
        Collections.sort(result, new IndividualComparator(IndividualComparator.Sorting.BIRTH_YEAR_OR_ORDER, IndividualComparator.Sorting.ID));
        return result;
    }

    public List<Individual> toSortedList(List<IndividualComparator.Sorting> multiSorting) {
        List<Individual> result = this.toList();
        Collections.sort(result, new IndividualComparator(multiSorting));
        return result;
    }

    public List<Individual> toSortedList(IndividualComparator.Sorting ... sortings) {
        List<Individual> result = this.toList();
        Collections.sort(result, new IndividualComparator(sortings));
        return result;
    }

    public List<Individual> toSortedList(IndividualComparator.Sorting sorting) {
        List<Individual> result = this.toList();
        Collections.sort(result, new IndividualComparator(sorting));
        return result;
    }

    public String toStringAsNameList() {
        StringList buffer = new StringList();
        for (Individual individual : this.toSortedList()) {
            buffer.append(individual.getName());
        }
        String result = buffer.toStringSeparatedBy(" ");
        return result;
    }

    public String toString() {
        return this.toSortedList().toString();
    }

    @Override
    public Individuals getIndividuals(Segmentation segmentation) {
        return segmentation.getCurrentIndividuals();
    }
}

