/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import java.util.Comparator;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator;
import org.tip.puck.util.MathUtils;

public class FamilyComparator
implements Comparator<Family> {
    private Sorting sorting;

    public FamilyComparator(Sorting sorting) {
        this.sorting = sorting;
    }

    @Override
    public int compare(Family alpha, Family bravo) {
        int result = FamilyComparator.compare(alpha, bravo, this.sorting);
        return result;
    }

    public static int compare(Family alpha, Family bravo, Sorting sorting) {
        int result;
        switch (sorting) {
            default: {
                result = MathUtils.compare(FamilyComparator.getId(alpha), FamilyComparator.getId(bravo));
                break;
            }
            case HUSBAND: {
                result = IndividualComparator.compare(FamilyComparator.getHusband(alpha), FamilyComparator.getHusband(bravo), IndividualComparator.Sorting.ID);
                if (result != 0) break;
                result = IndividualComparator.compare(FamilyComparator.getWife(alpha), FamilyComparator.getWife(bravo), IndividualComparator.Sorting.ID);
                break;
            }
            case HUSBAND_ORDER: {
                result = MathUtils.compareOrder(FamilyComparator.getHusbandOrder(alpha), FamilyComparator.getHusbandOrder(bravo));
                break;
            }
            case WIFE: {
                result = IndividualComparator.compare(FamilyComparator.getWife(alpha), FamilyComparator.getWife(bravo), IndividualComparator.Sorting.ID);
                if (result != 0) break;
                result = IndividualComparator.compare(FamilyComparator.getHusband(alpha), FamilyComparator.getHusband(bravo), IndividualComparator.Sorting.ID);
                break;
            }
            case WIFE_ORDER: {
                result = MathUtils.compareOrder(FamilyComparator.getWifeOrder(alpha), FamilyComparator.getWifeOrder(bravo));
            }
        }
        return result;
    }

    public static Individual getHusband(Family source) {
        Individual result = source == null ? null : source.getHusband();
        return result;
    }

    public static Integer getHusbandOrder(Family source) {
        Integer result = source == null ? null : source.getHusbandOrder();
        return result;
    }

    public static Integer getId(Family source) {
        Integer result = source == null ? null : Integer.valueOf(source.getId());
        return result;
    }

    public static Individual getWife(Family source) {
        Individual result = source == null ? null : source.getWife();
        return result;
    }

    public static Integer getWifeOrder(Family source) {
        Integer result = source == null ? null : source.getWifeOrder();
        return result;
    }

    public static enum Sorting {
        ID,
        HUSBAND,
        HUSBAND_ORDER,
        WIFE,
        WIFE_ORDER;

    }
}

