package org.tip.puck.spacetime.workers;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.Slice;
import org.tip.puck.spacetime.Slices;

public class SliceMaker {
	
	
	public static Slices createSlices(Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException{
		Slices result;
		
		result = new Slices(criteria);
		
		result.setRelations(segmentation.getCurrentRelations().getByModelName(result.relationModelName()));
		result.setAllRelations(segmentation.getAllRelations().getByModelName(result.relationModelName()));
		
		result.setIndividuals(segmentation.getAllIndividuals());
		
		for (int time : criteria.getDates()){
			result.put(new Slice(new Ordinal(time), result.idLabel()));
		}
		
		for (Relation relation : result.allRelations()){
			Integer time = result.time(relation);
			
			if (time!=null && result.ids().contains(time)){

				Slice slice = result.getById(time); 
				slice.allRelations().put(relation);
			}
			
		}

		for (Relation relation : result.relations()){
			
			Integer time = result.time(relation);
			
			if (time!=null && result.ids().contains(time)){

				Slice slice = result.getById(time); 
				slice.put(relation);

				// set relation population
				
				for (Actor actor : relation.actors()){
					
					Individual member = actor.getIndividual();
					slice.relationsByIndividuals().put(member,relation);
					
					String idValue = relation.getAttributeValue(result.idLabel());
					if (idValue!=null && result.ids().contains(time)){
						
						Individuals members = result.membersByRelationId().get(idValue);
						if (members == null){
							members = new Individuals();
							result.membersByRelationId().put(idValue, members);
						}
						members.put(member);

					}
				}
				
				// put relation into relation sequence
				
				String idValue = relation.getAttributeValue(result.idLabel());
				if (idValue!=null && StringUtils.isNumeric(idValue)){
					Integer id = Integer.parseInt(idValue);
					Sequence groupSequence = result.groupSequences().getById(id);
					if (groupSequence==null){
						groupSequence = new Sequence(id);
						// Temporary method, since census methods are gender sensitive (separate index for genders necessary)
						groupSequence.setEgo(new Individual(id,id+"",Gender.UNKNOWN));
						result.groupSequences().put(groupSequence);
					}
					groupSequence.put(new Ordinal(time), relation);

				} else {
					throw PuckExceptions.INVALID_PARAMETER.create("Invalid local unit label.");
				}
				
				// put relation into individual sequence
				
				for (Actor actor: relation.actors()){
					Individual ego = actor.getIndividual();
					Sequence indiSequence = result.indiSequences().getById(ego.getId());
					if (indiSequence==null){
						indiSequence = new Sequence(ego.getId());
						indiSequence.setEgo(ego);
						result.indiSequences().put(indiSequence);
					}
					indiSequence.put(new Ordinal(time), relation);
				}

			}
		}

		
		
		//
		return result;
		
	}
	
	public static Slice createSlice (Individuals source, String relationModelName, String egoRoleName, String attributeLabel, String dateLabel, Integer time){
		Slice result;
		
		result = new Slice();
		
		for (Individual ego : source){
			for (Relation relation: ego.relations().getByModelName(relationModelName)){
				if (relation.hasActor(ego,egoRoleName) && relation.hasAttributeValue(attributeLabel) && relation.hasTime(dateLabel, time)){
					result.put(ego,relation);
				}
			}
		}
		
		//
		return result;
	}


}
