package org.tip.puck.spacetime;

import java.util.List;

import org.tip.puck.net.Individuals;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.util.NumberablesHashMap;
import org.tip.puck.util.ToolBox;

public class Houses extends NumberablesHashMap<House> {
	
	String dateLabel;
	String idLabel;
	String relationModelName;
	int[] maxDepths;
	String chainClassification;
	List<String> relationModelNames;
	
	public Houses(SpaceTimeCriteria criteria){
		
		relationModelName = criteria.getRelationModelName();
		dateLabel = criteria.getDateLabel();
		idLabel = criteria.getLocalUnitLabel();
		maxDepths = ToolBox.stringsToInts(criteria.getPattern());
		chainClassification = criteria.getChainClassification();
		relationModelNames = criteria.getRelationModelNames();

	}
	
	public Individuals getMembers(){
		Individuals result;
		
		result = new Individuals();
		for (House house : this){
			result.add(house.getMembers());
		}
		
		//
		return result;
	}
	
	
	


}
