package org.tip.puck.spacetime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.util.Numberable;

public class House implements Comparable<House>, Numberable {

	int id;
	Map<Ordinal,Relation> relationsByTime;
	String idLabel;
	
	public House(){
	}
	
	public House(String idLabel, int id){
		
		this.idLabel = idLabel;
		this.id = id;
		relationsByTime = new TreeMap<Ordinal,Relation>();
		
	}
	
	public int getId() {
		return id;
	}
	
	public void setId(int id) {
		this.id = id;
	}
	
	@Override
	public String hashKey() {
		return id + "";
	}
	
	@Override
	public int compareTo(House other) {
		return id - other.id;
	}
	
	public void put(Relation relation, Ordinal time){
		relationsByTime.put(time, relation);
	}
		
	public Relation getByOrdinal(Ordinal time){
		Relation result;
		
		result = null;
		if (time !=null){
			result = relationsByTime.get(time);
		}
		
		//
		return result;
		
	}
	
	public List<Ordinal> getTimes(){
		List<Ordinal> result;
		
		result = new ArrayList<Ordinal>(relationsByTime.keySet());
		Collections.sort(result);
		
		//
		return result;
	}
	
	public String toString(){
		
		return idLabel+" "+id;
	}
	
	public Individuals getMembers (){
		Individuals result;
		
		result = new Individuals();
		for (Relation relation : relationsByTime.values()){
			result.add(relation.getIndividuals());
		}
		
		//
		return result;
	}


	

}
