package org.tip.puck.net.relations.workers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.CircuitType;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.graphs.Graph;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.House;
import org.tip.puck.spacetime.HouseStatistics;
import org.tip.puck.spacetime.Houses;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.workers.HouseMaker;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;

import fr.devinsy.util.StringList;

public class RelationReporter {
	
	public static Report reportItineraries (final Segmentation segmentation, final SpaceTimeCriteria criteria) throws PuckException{
		Report result;
		
		if ((segmentation == null) || (criteria.getRelationModelName() == null)) {
			throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
		} else {
			
			result = new Report("Itineraries "+criteria.getRelationModelName());
			
			Chronometer chrono = new Chronometer();
			
			result.setOrigin("Relation reporter");
			
			List<String> indicators = Arrays.asList(new String[]{"PLACE","REFERENT_CHAIN","REFERENT_KIN","REFERENT"});
			Houses houses = HouseMaker.createHouses(segmentation, criteria);
			HouseStatistics houseStatistics = new HouseStatistics(houses, criteria, indicators);
			houseStatistics.getMemberValues();
			
			Report report = new Report("Itineraries");
			
			String headLine1 = "MEMBER\tGENDER\t";
			String dateLine1 = "\t\t";
			for (String indicator : indicators){
				
				headLine1 += indicator;

				for (Integer year : criteria.getDates()){
					
					headLine1 += "\t";
					dateLine1 += year+"\t";
				}

//				headLine1 += "\t";
//				dateLine1 += "TREND\t";
			}
			
			report.outputs().appendln(headLine1);
			report.outputs().appendln(dateLine1);

			
			for (Individual member : houses.getMembers().toSortedList()){
				String memberLine = member+"\t"+member.getGender()+"\t";
				
				for (String indicator : indicators){
					
					for (Integer year : criteria.getDates()){
	
						Ordinal time = new Ordinal(year);
						Object value = houseStatistics.getByMember(member, time, indicator);
						
						memberLine += value+"\t";
					}
				}
				report.outputs().appendln(memberLine);
			}
			
			result.outputs().append(report);

		}
		//
		return result;
		
	}

	public static Report reportTreeStructure(final Segmentation segmentation, final SpaceTimeCriteria criteria, boolean reducedTrees) throws PuckException{
		Report result;
		
		if ((segmentation == null) || (criteria.getRelationModelName() == null)) {
			throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
		} else {
			
			result = new Report("Cluster Structure "+criteria.getRelationModelName());
			
			Chronometer chrono = new Chronometer();
			
			result.setOrigin("Relation reporter");
			
			List<String> indicators1 = Arrays.asList(new String[]{"GRAPH","SIZE","MAXDEPTH","MEANDEPTH","MEANINDEGREE","DIAMETER","NRCOMPONENTS","MAXCOMPONENT","CONCENTRATION"});			
			List<String> indicators2 = Arrays.asList(new String[]{"TREES_BY_ID","TREES_BY_GENDER","TREES_BY_KIN"});
			List<String> indicators3 = Arrays.asList(new String[]{"OWNER","OWNER_SPOUSE","MOTHER","FATHER","CHILD","SPOUSE","SIBLING","RELATIVE_AGNATIC","RELATIVE_UTERINE","RELATIVE_COGNATIC","AFFINE","UNKNOWN","NONE"});
					
			CensusCriteria censusCriteria = new CensusCriteria();
			censusCriteria.setPattern(criteria.getPattern());
			censusCriteria.setChainClassification(criteria.getChainClassification());
			censusCriteria.setRelationAttributeLabel(criteria.getLocalUnitLabel());
			censusCriteria.setRestrictionType(RestrictionType.ALL);
			censusCriteria.setSymmetryType(SymmetryType.INVERTIBLE);
			censusCriteria.setClosingRelation("TOTAL");

			Houses houses = HouseMaker.createHouses(segmentation, criteria);
		
			HouseStatistics houseStatistics1 = new HouseStatistics(houses, criteria, indicators1);
			HouseStatistics houseStatistics2 = new HouseStatistics(houses, criteria, indicators2);
			HouseStatistics houseStatistics3 = new HouseStatistics(houses, criteria, indicators3);
			HouseStatistics houseStatistics4 = new HouseStatistics(houses, criteria, new ArrayList<String>());
			HouseStatistics houseStatistics5 = new HouseStatistics(houses, criteria, new ArrayList<String>());
			HouseStatistics houseStatistics6 = new HouseStatistics(houses, criteria, null);
			
			houseStatistics1.getStatistics();
			houseStatistics2.getStatistics();
			houseStatistics3.getReferentKinCensus();	
			houseStatistics4.getAllKinCensus(segmentation, censusCriteria);	
			houseStatistics5.getReferentChainCensus();	

			List<String> indicators4 = houseStatistics4.indicators();
			List<String> indicators5 = houseStatistics5.indicators();
			
			StringList pajekBuffer = new StringList();
			
			Partition<String> inFlows = houseStatistics6.getFlows("IN");
			Partition<String> outFlows = houseStatistics6.getFlows("OUT");
			Partition<String> allFlows = new Partition<String>();
			allFlows.add(inFlows);
			allFlows.add(outFlows);
			
			Report report1 = new Report("Metrics");
			Report report2 = new Report("Morphology");
			Report report3 = new Report("Referent kin census");
			Report report4 = new Report("All kin census");
			Report report5 = new Report("Referent chain census");
			Report report6 = new Report("Flow census");
			
			for (Cluster<String> cluster : allFlows.getClusters().toListSortedByValue()){
				report6.outputs().appendln(cluster.getValue());
				for (String item : cluster.getItems()){
					report6.outputs().appendln("\t"+item);
				}
			}
			
			String headLine1 = "HOUSE\t";
			String dateLine1 = "\t";
			for (String indicator : indicators1){
				
				if (indicator.equals("GRAPH")){
					continue;
				}
				
				headLine1 += indicator;

				for (Integer year : criteria.getDates()){
					
					headLine1 += "\t";
					dateLine1 += year+"\t";
				}

				headLine1 += "\t";
				dateLine1 += "TREND\t";
			}
			
			report1.outputs().appendln(headLine1);
			report1.outputs().appendln(dateLine1);
			
			String headLine2 = "HOUSE\t";
			String dateLine2 = "\t";
			for (String indicator : indicators2){
				
				headLine2 += indicator;

				for (Integer year : criteria.getDates()){
					
					headLine2 += "\t";
					dateLine2 += year+"\t";
				}

//				headLine1 += "\t";
//				dateLine1 += "TREND\t";
			}
			
			report2.outputs().appendln(headLine2);
			report2.outputs().appendln(dateLine2);

			String headLine3 = "HOUSE\t";
			String dateLine3 = "\t";
			for (String indicator : indicators3){
				
				headLine3 += indicator;

				for (Integer year : criteria.getDates()){
					
					headLine3 += "\t";
					dateLine3 += year+"\t";
				}

				headLine3 += "\t";
				dateLine3 += "TREND\t";
			}
			
			report3.outputs().appendln(headLine3);
			report3.outputs().appendln(dateLine3);

			String headLine4 = "HOUSE\t";
			String dateLine4 = "\t";
			for (String indicator : indicators4){
				
				headLine4 += indicator;

				for (Integer year : criteria.getDates()){
					
					headLine4 += "\t";
					dateLine4 += year+"\t";
				}

				headLine4 += "\t";
				dateLine4 += "TREND\t";
			}
			
			report4.outputs().appendln(headLine4);
			report4.outputs().appendln(dateLine4);

			
			String headLine5 = "HOUSE\t";
			String dateLine5 = "\t";
			for (String indicator : indicators5){
				
				headLine5 += indicator;

				for (Integer year : criteria.getDates()){
					
					headLine5 += "\t";
					dateLine5 += year+"\t";
				}

				headLine5 += "\t";
				dateLine5 += "TREND\t";
			}
			
			report5.outputs().appendln(headLine5);
			report5.outputs().appendln(dateLine5);

			
			for (House house : houses.toSortedList()){
				
				String houseLine1 = house+"\t";
				String houseLine2 = house+"\t";
				String houseLine3 = house+"\t";
				String houseLine4 = house+"\t";
				String houseLine5 = house+"\t";

				for (String indicator : indicators1){
					
					for (Integer year : criteria.getDates()){
	
						Ordinal time = new Ordinal(year);
						Object value = houseStatistics1.get(house, time, indicator);
						
						if (indicator.equals("GRAPH")) {
							
							if (value!=null) {

								List<String> partitionLabels = new ArrayList<String>();
								pajekBuffer.addAll(PuckUtils.writePajekNetwork((Graph<Individual>)value, partitionLabels));
								pajekBuffer.appendln();

							}
							
						} else if (value != null){
							
							houseLine1 += value+"\t";
							
						} else {
							
							houseLine1 += "\t";

						}
					}
					
					if (!indicator.equals("GRAPH")) {
						
						houseLine1 += houseStatistics1.getTrend(house, indicator)+"\t";
					
					}
				}

				for (String indicator : indicators2){
					
					for (Integer year : criteria.getDates()){
	
						Ordinal time = new Ordinal(year);
						Object value = houseStatistics2.get(house, time, indicator);
						
						if (value != null){
							
							houseLine2 += value+"\t";
							
						} else {
							
							houseLine2 += "\t";

						}
					}
				}

				for (String indicator : indicators3){
					
					for (Integer year : criteria.getDates()){
	
						Ordinal time = new Ordinal(year);
						Object value = houseStatistics3.get(house, time, indicator);
						
						if (value != null){
							
							houseLine3 += value+"\t";
							
						} else {
							
							houseLine3 += "\t";

						}
					}
					houseLine3 += houseStatistics3.getTrend(house, indicator)+"\t";
				}

				for (String indicator : indicators4){
					
					for (Integer year : criteria.getDates()){
	
						Ordinal time = new Ordinal(year);
						Object value = houseStatistics4.get(house, time, indicator);
						
						if (value == null){
							value = 0;
							houseStatistics4.put(house, time, indicator, value);
						} 
						houseLine4 += value+"\t";
					}
					houseLine4 += houseStatistics4.getTrend(house, indicator)+"\t";
				}

				for (String indicator : indicators5){
					
					for (Integer year : criteria.getDates()){
	
						Ordinal time = new Ordinal(year);
						Object value = houseStatistics5.get(house, time, indicator);
						
						if (value == null){
							value = 0.;
							houseStatistics5.put(house, time, indicator, value);
						} 
						houseLine5 += value+"\t";
					}
					
					houseLine5 += houseStatistics5.getTrend(house, indicator)+"\t";
				}

				report1.outputs().appendln(houseLine1);
				report2.outputs().appendln(houseLine2);
				report3.outputs().appendln(houseLine3);
				report4.outputs().appendln(houseLine4);
				report5.outputs().appendln(houseLine5);
			}

			
			String endLine1 = "TOTAL\t";
			String endLine3 = "TOTAL\t";
			String endLine4 = "TOTAL\t";
			String endLine5 = "TOTAL\t";
			
			for (String indicator : indicators1){

				if (indicator.equals("GRAPH")) {
					continue;
				}

				for (Integer year : criteria.getDates()){

					Ordinal time = new Ordinal(year);
					Object value = houseStatistics1.getMean(time, indicator);
					
					if (value == null) {
						
						endLine1 += "\t";
						
					} else {
						
						endLine1 += value+"\t";
					}
				}
				
				endLine1 += houseStatistics1.getMeanTrend(indicator)+"\t";
			}
			report1.outputs().appendln(endLine1);
			
			for (String indicator : indicators3){

				for (Integer year : criteria.getDates()){

					Ordinal time = new Ordinal(year);
					Object value = houseStatistics3.getMean(time, indicator);
					
					if (value == null) {
						
						endLine3 += "\t";
						
					} else {
						
						endLine3 += value+"\t";
					}
				}
				
				endLine3 += houseStatistics3.getMeanTrend(indicator)+"\t";
			}
			report3.outputs().appendln(endLine3);

			for (String indicator : indicators4){

				for (Integer year : criteria.getDates()){

					Ordinal time = new Ordinal(year);
					Object value = houseStatistics4.getMean(time, indicator);
					
					if (value == null) {
						
						endLine4 += "\t";
						
					} else {
						
						endLine4 += value+"\t";
					}
				}
				
				endLine4 += houseStatistics4.getMeanTrend(indicator)+"\t";
			}
			report4.outputs().appendln(endLine4);

			for (String indicator : indicators5){

				for (Integer year : criteria.getDates()){

					Ordinal time = new Ordinal(year);
					Object value = houseStatistics5.getMean(time, indicator);
					
					if (value == null) {
						
						endLine5 += "\t";
						
					} else {
						
						endLine5 += value+"\t";
					}
				}
				
				endLine5 += houseStatistics5.getMeanTrend(indicator)+"\t";
			}
			report5.outputs().appendln(endLine5);


			if (pajekBuffer.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File("Sponsor network "), criteria.getLocalUnitLabel()), ".paj");
				ReportRawData rawData = new ReportRawData("Export Sponsor Networks to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}

			result.outputs().append(report1);
			result.outputs().append(report2);
			result.outputs().append(report3);
			result.outputs().append(report4);
			result.outputs().append(report5);
			result.outputs().append(report6);
			
			
//			chainReport.outputs().appendln(relation+"\t"+relation.actors().size()+"\t"+RelationWorker.getLinkChainsAsString(relation, "GENDER", null)+"\t"+RelationWorker.getLinkChainsAsString(relation, "ID", null)+"\t"+RelationWorker.getLinkChainsAsString(relation, "KIN", criteria.getPattern()));
//			result.outputs().append(chainReport);

			//
			result.setTimeSpent(chrono.stop().interval());
		}
	
		//
		return result;
	}

	public static List<Report> reportRelationCensus (final Segmentation segmentation, final SpaceTimeCriteria criteria) throws PuckException{
		List<Report> result;
		
		if ((segmentation == null) || (criteria.getRelationModelName() == null) || (criteria.getEgoRoleName() == null)) {
			throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected. "+segmentation+" "+criteria.getRelationModelName()+" "+criteria.getEgoRoleName());
		} else {
			result = new ArrayList<Report>();

			CensusCriteria censusCriteria = new CensusCriteria();
			censusCriteria.setCircuitType(CircuitType.RING);
			censusCriteria.setClosingRelation(criteria.getRelationModelName());
			censusCriteria.setClosingRelationEgoRole(criteria.getEgoRoleName());
			censusCriteria.setPattern(criteria.getPattern());
			censusCriteria.setRelationAttributeLabel(criteria.getLocalUnitLabel());
			censusCriteria.setDateLabel(criteria.getDateLabel());
			censusCriteria.setChainClassification(criteria.getChainClassification());
			
			Integer[] times = criteria.getDates();
			
			for (Relation relation : segmentation.getAllRelations().getByModelName(criteria.getRelationModelName())){
				relation.updateReferents(criteria.getDefaultReferentRoleName());
			}
			
			for (String alterRoleName : criteria.getRoleNames()){

				censusCriteria.setClosingRelationAlterRole(alterRoleName);

				if (times==null){

					Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
					report.setTitle("Relations "+criteria.getEgoRoleName()+" "+alterRoleName);
					result.add(report);

				} else {
					
					for (int i=0;i<times.length;i++){
						
						censusCriteria.setRelationTime(times[i]);

						Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
						report.setTitle("Relations "+criteria.getEgoRoleName()+" "+alterRoleName+" "+times[i]);
						result.add(report);
					}
				}
			}
			
		}
		
		//
		return result;
	}


}
