/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import fr.devinsy.util.StringSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.census.workers.ChainValuator;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;

public class RelationAnalysisInputDialog
extends JDialog {
    private static final long serialVersionUID = -5603095480035489834L;
    private static final Logger logger = LoggerFactory.getLogger(RelationAnalysisInputDialog.class);
    private RelationModels relationModels;
    private AttributeDescriptors attributeDescriptors;
    private final JPanel contentPanel = new JPanel();
    private SpaceTimeCriteria dialogCriteria;
    private static SpaceTimeCriteria lastCriteria = new SpaceTimeCriteria();
    private JComboBox cmbxRelationModel;
    private JComboBox cmbxDateLabel;
    private JButton okButton;
    private JPanel alterRelationModelPanel;
    private JTextField txtfldPattern;
    private JTextField txtfldAlterFilterAttributeLabel;
    private JTextField txtfldAlterFilterAttributeValue;
    private JComboBox cmbxChainClassification;
    private JComboBox cmbxDefautlReferentRoleName;
    private JComboBox cmbxAlterFilterRole;

    public RelationAnalysisInputDialog(RelationModels relationModels, AttributeDescriptors attributeDescriptors) {
        this.relationModels = relationModels;
        this.attributeDescriptors = attributeDescriptors;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Relation Analysis Input Dialog");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(RelationAnalysisInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RelationAnalysisInputDialog.this.dialogCriteria = null;
                RelationAnalysisInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 521, 494);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(100dlu;default):grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(75dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblRelationModel = new JLabel("Relation Model:");
        this.contentPanel.add((Component)lblRelationModel, "2, 2, right, default");
        this.cmbxRelationModel = new JComboBox<Object>(relationModels.nameList().toArray());
        this.contentPanel.add((Component)this.cmbxRelationModel, "4, 2, fill, default");
        JLabel lblPattern = new JLabel("Pattern:");
        this.contentPanel.add((Component)lblPattern, "2, 4, right, default");
        this.txtfldPattern = new JTextField();
        this.contentPanel.add((Component)this.txtfldPattern, "4, 4, fill, default");
        this.txtfldPattern.setColumns(10);
        JLabel lblChain = new JLabel("Chain Classification:");
        this.contentPanel.add((Component)lblChain, "2, 6, right, default");
        this.cmbxChainClassification = new JComboBox();
        this.cmbxChainClassification.setModel(new DefaultComboBoxModel<ChainValuator.ChainProperty>(ChainValuator.ChainProperty.values()));
        this.contentPanel.add((Component)this.cmbxChainClassification, "4, 6, fill, default");
        JLabel lblRelationModelNames = new JLabel("Alter Relation Models:");
        this.contentPanel.add((Component)lblRelationModelNames, "2, 8, right, top");
        JScrollPane alterRolesScrollPane = new JScrollPane();
        alterRolesScrollPane.setVerticalScrollBarPolicy(22);
        this.contentPanel.add((Component)alterRolesScrollPane, "4, 8, fill, fill");
        this.alterRelationModelPanel = new JPanel();
        alterRolesScrollPane.setViewportView(this.alterRelationModelPanel);
        this.alterRelationModelPanel.setLayout(new BoxLayout(this.alterRelationModelPanel, 1));
        JLabel lblAlterFilterRole = new JLabel("Alter Filter Role:");
        this.contentPanel.add((Component)lblAlterFilterRole, "2, 10, right, default");
        this.cmbxAlterFilterRole = new JComboBox<Object>(relationModels.roleNames().sort().toArray());
        this.contentPanel.add((Component)this.cmbxAlterFilterRole, "4, 10, fill, default");
        JLabel lblAlterFilterAttribute = new JLabel("Alter Filter Attribute Label:");
        this.contentPanel.add((Component)lblAlterFilterAttribute, "2, 12, right, default");
        this.txtfldAlterFilterAttributeLabel = new JTextField();
        this.contentPanel.add((Component)this.txtfldAlterFilterAttributeLabel, "4, 12, fill, default");
        this.txtfldAlterFilterAttributeLabel.setColumns(10);
        JLabel lblAlterFilterAttribute_1 = new JLabel("Alter Filter Attribute Value:");
        this.contentPanel.add((Component)lblAlterFilterAttribute_1, "2, 14, right, default");
        this.txtfldAlterFilterAttributeValue = new JTextField();
        this.txtfldAlterFilterAttributeValue.setColumns(10);
        this.contentPanel.add((Component)this.txtfldAlterFilterAttributeValue, "4, 14, fill, default");
        JLabel lblDefaultReferentRole = new JLabel("Default Referent Role:");
        this.contentPanel.add((Component)lblDefaultReferentRole, "2, 16, right, default");
        this.cmbxDefautlReferentRoleName = new JComboBox<Object>(relationModels.roleNames().sort().toArray());
        this.contentPanel.add((Component)this.cmbxDefautlReferentRoleName, "4, 16, fill, default");
        JLabel lblDateLabel = new JLabel("Date Label:");
        this.contentPanel.add((Component)lblDateLabel, "2, 18, right, default");
        this.cmbxDateLabel = new JComboBox<Object>(new DefaultComboBoxModel<Object>(attributeDescriptors.labels().sort().toArray()));
        this.contentPanel.add((Component)this.cmbxDateLabel, "4, 18, fill, default");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelationAnalysisInputDialog.this.dialogCriteria = null;
                RelationAnalysisInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.okButton = new JButton("Launch");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpaceTimeCriteria criteria = RelationAnalysisInputDialog.this.getCriteria();
                if (criteria.getRelationModelName() == null) {
                    String title = "Invalid input";
                    String message = "A relation model is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else if (criteria.getDateLabel() == null) {
                    String title = "Invalid input";
                    String message = "A valid date label is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    RelationAnalysisInputDialog.this.dialogCriteria = criteria;
                    RelationAnalysisInputDialog.this.setVisible(false);
                }
            }
        });
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.alterRelationModelPanel.removeAll();
        for (RelationModel model : relationModels) {
            JCheckBox checkBox = new JCheckBox(model.getName());
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    logger.debug("checkbox changed.");
                    RelationAnalysisInputDialog.this.updateAlterRelationModel();
                }
            });
            this.alterRelationModelPanel.add(checkBox);
        }
        this.updateAlterRelationModel();
        this.setCriteria(lastCriteria);
    }

    private StringList getAlterRelationModelNames() {
        StringList result = new StringList();
        Component[] componentArray = this.alterRelationModelPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            JCheckBox checkbox = (JCheckBox)component;
            if (checkbox.isSelected()) {
                result.add((Object)checkbox.getText());
            }
            ++n2;
        }
        logger.debug("alterRelationModel checked={}", (Object)result.toStringWithCommas());
        return result;
    }

    public SpaceTimeCriteria getCriteria() {
        SpaceTimeCriteria result = new SpaceTimeCriteria();
        if (this.cmbxRelationModel.getSelectedIndex() == -1) {
            result.setRelationModelName(null);
        } else {
            result.setRelationModelName((String)this.cmbxRelationModel.getSelectedItem());
        }
        result.setPattern(this.txtfldPattern.getText());
        result.setChainClassification(((ChainValuator.ChainProperty)((Object)this.cmbxChainClassification.getSelectedItem())).name());
        result.setRelationModelNames((List<String>)this.getAlterRelationModelNames());
        result.setAlterFilterRoleName((String)this.cmbxAlterFilterRole.getSelectedItem());
        result.setAlterAttributeLabel(this.txtfldAlterFilterAttributeLabel.getText());
        result.setAlterAttributeValue(this.txtfldAlterFilterAttributeValue.getText());
        result.setDefaultReferentRoleName((String)this.cmbxDefautlReferentRoleName.getSelectedItem());
        result.setDateLabel((String)this.cmbxDateLabel.getSelectedItem());
        logger.debug("[relationModelName={}][chaineClassification={}][alterRelationModelNames={}]", new Object[]{result.getRelationModelName(), result.getChainClassification(), new StringList(result.getRelationModelNames()).toStringWithCommas()});
        return result;
    }

    public SpaceTimeCriteria getDialogCriteria() {
        SpaceTimeCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(SpaceTimeCriteria source) {
        if (source != null) {
            if (this.relationModels.isEmpty()) {
                this.cmbxRelationModel.setEnabled(false);
                this.txtfldPattern.setEnabled(false);
                this.cmbxChainClassification.setEnabled(false);
                this.cmbxDefautlReferentRoleName.setEnabled(false);
                this.alterRelationModelPanel.setEnabled(false);
                this.cmbxAlterFilterRole.setEnabled(false);
                this.txtfldAlterFilterAttributeLabel.setEnabled(false);
                this.txtfldAlterFilterAttributeValue.setEnabled(false);
                this.cmbxDateLabel.setEnabled(false);
            } else {
                this.cmbxRelationModel.setEnabled(true);
                this.txtfldPattern.setEnabled(true);
                this.cmbxChainClassification.setEnabled(true);
                this.cmbxDefautlReferentRoleName.setEnabled(true);
                this.alterRelationModelPanel.setEnabled(true);
                this.cmbxAlterFilterRole.setEnabled(true);
                this.txtfldAlterFilterAttributeLabel.setEnabled(true);
                this.txtfldAlterFilterAttributeValue.setEnabled(true);
                this.cmbxDateLabel.setEnabled(true);
                this.cmbxRelationModel.setSelectedItem(source.getRelationModelName());
                this.txtfldPattern.setText(source.getPattern());
                this.cmbxChainClassification.setSelectedItem((Object)ChainValuator.ChainProperty.valueOf(source.getChainClassification()));
                Component[] componentArray = this.alterRelationModelPanel.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component component = componentArray[n2];
                    JCheckBox checkbox = (JCheckBox)component;
                    if (source.getRelationModelNames().contains(checkbox.getText())) {
                        checkbox.setSelected(true);
                    }
                    ++n2;
                }
                this.txtfldAlterFilterAttributeLabel.setText(source.getAlterFilterAttributeLabel());
                this.txtfldAlterFilterAttributeValue.setText(source.getAlterFilterAttributeValue());
                this.cmbxAlterFilterRole.setSelectedItem(source.getAlterFilterRoleName());
                this.cmbxDefautlReferentRoleName.setSelectedItem(source.getDefaultReferentRoleName());
                this.cmbxDateLabel.setSelectedItem(source.getDateLabel());
            }
        }
    }

    private void updateAlterRelationModel() {
        StringList currentRelationModelNames = this.getAlterRelationModelNames();
        StringSet roleNames = new StringSet();
        for (String relationModelName : currentRelationModelNames) {
            roleNames.addAll((Collection)this.relationModels.getByName(relationModelName).roles().nameList());
        }
        logger.debug("roleNames={}", (Object)roleNames.toStringList().toStringWithCommas());
        StringList target = new StringList();
        target.add((Object)"ALL");
        target.addAll((Collection)roleNames.toStringList().sort());
        this.cmbxAlterFilterRole.setModel(new DefaultComboBoxModel<Object>(target.toArray()));
    }

    public static void main(String[] args) {
        RelationAnalysisInputDialog.showDialog(null, null);
    }

    public static SpaceTimeCriteria showDialog(RelationModels relationModels, AttributeDescriptors attributeDescriptors) {
        RelationAnalysisInputDialog dialog = new RelationAnalysisInputDialog(relationModels, attributeDescriptors);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        SpaceTimeCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

