/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime.workers;

import org.tip.puck.PuckException;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.ExpansionMode;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.SequenceType;
import org.tip.puck.spacetime.Sequences;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;

public class SequenceMaker {
    public static Sequence createSequence(Individual ego, SpaceTimeCriteria criteria) {
        Sequence result = new Sequence(ego.getId());
        result.setEgo(ego);
        result.setDateLabel(criteria.getDateLabel());
        result.putInOrder(ego.relations(), SequenceType.MOVEMENTS_ONLY);
        return result;
    }

    public static Sequence createPersonalSequence(Individual ego, SpaceTimeCriteria criteria) {
        String egoRoleName = criteria.getEgoRoleName();
        Sequence result = new Sequence(ego.getId());
        result.setEgo(ego);
        result.setEgoRoleName(egoRoleName);
        result.setDateLabel(criteria.getDateLabel());
        Relations relations = new Relations();
        for (Relation relation : ego.relations()) {
            if (!relation.getRoleNames(ego).contains(egoRoleName)) continue;
            relations.add(relation);
        }
        result.putInOrder(relations, SequenceType.ALL_EVENTS);
        return result;
    }

    public static Sequences createPersonalSequences(Segmentation segmentation, SpaceTimeCriteria criteria) {
        Sequences result = new Sequences();
        for (Individual individual : segmentation.getCurrentIndividuals().toSortedList()) {
            result.add(SequenceMaker.createPersonalSequence(individual, criteria));
        }
        return result;
    }

    public static Sequences createBiographies(Net net, Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException {
        Sequences result = new Sequences();
        net.getFamilyEvents(segmentation);
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            result.add(SequenceMaker.createSequence(individual, criteria));
        }
        net.removeFamilyEvents();
        return result;
    }

    public static Sequence createExtendedSequence(Individual individual, SpaceTimeCriteria criteria) {
        Sequence result = new Sequence(individual.getId());
        result.setEgo(individual);
        result.setDateLabel(criteria.getDateLabel());
        result.putInOrder(individual.relations(), SequenceType.ALL_EVENTS);
        ExpansionMode expansionMode = criteria.getExpansionMode();
        FiliationType filiationType = criteria.getFiliationType();
        for (Individual relative : NetUtils.neighbors(individual, expansionMode, filiationType)) {
            result.putInOrder(relative.relations(), SequenceType.ALL_EVENTS);
        }
        return result;
    }

    public static Sequences createExtendedBiographies(Net net, Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException {
        Sequences result = new Sequences();
        net.getFamilyEvents(segmentation);
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            result.add(SequenceMaker.createExtendedSequence(individual, criteria));
        }
        net.removeFamilyEvents();
        return result;
    }
}

