/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.util.Numberable;

public class House
implements Comparable<House>,
Numberable {
    int id;
    Map<Ordinal, Relation> relationsByTime;
    String idLabel;

    public House() {
    }

    public House(String idLabel, int id) {
        this.idLabel = idLabel;
        this.id = id;
        this.relationsByTime = new TreeMap<Ordinal, Relation>();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String hashKey() {
        return String.valueOf(this.id);
    }

    @Override
    public int compareTo(House other) {
        return this.id - other.id;
    }

    public void put(Relation relation, Ordinal time) {
        this.relationsByTime.put(time, relation);
    }

    public Relation getByOrdinal(Ordinal time) {
        Relation result = null;
        if (time != null) {
            result = this.relationsByTime.get(time);
        }
        return result;
    }

    public List<Ordinal> getTimes() {
        ArrayList<Ordinal> result = new ArrayList<Ordinal>(this.relationsByTime.keySet());
        Collections.sort(result);
        return result;
    }

    public String toString() {
        return String.valueOf(this.idLabel) + " " + this.id;
    }

    public Individuals getMembers() {
        Individuals result = new Individuals();
        for (Relation relation : this.relationsByTime.values()) {
            result.add(relation.getIndividuals());
        }
        return result;
    }
}

