/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.partitions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.Chains;
import org.tip.puck.census.workers.ChainValuator;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.NodeValuator;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.FamilyValuator;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Interval;
import org.tip.puck.partitions.Intervals;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.spacetime.Slice;
import org.tip.puck.spacetime.workers.SliceMaker;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.Value;
import org.tip.puck.util.Values;

public class PartitionMaker {
    private static final Logger logger = LoggerFactory.getLogger(PartitionMaker.class);
    private static final double MAX_INTERVALS = 10000.0;
    private static final double MIN_VALUE = 0.0;
    private static final double MAX_VALUE = 4.4942328371557893E307;

    public static Partition<Individual> create(Net source, PartitionCriteria criteria) throws PuckException {
        Partition<Individual> result = source == null || criteria == null ? null : PartitionMaker.create(String.valueOf(source.getLabel()) + " " + criteria.getLabel(), source.individuals(), criteria);
        return result;
    }

    public static Partition<Family> create(String title, Families source, PartitionCriteria criteria) throws PuckException {
        Partition<Family> result;
        if (source == null || criteria == null) {
            result = null;
        } else {
            result = new Partition<Family>();
            result.setLabel(title);
            result.setCriteria(criteria);
            NumberedValues values = FamilyValuator.get(source, criteria.getLabel(), (Object)criteria.getLabelParameter());
            NumberedValues partitionValues = PartitionMaker.getPartitionValues(values, criteria);
            for (Family family : source) {
                result.put(family, (Value)partitionValues.get(family.getId()));
            }
        }
        return result;
    }

    public static Partition<Individual> create(String title, Individuals source, PartitionCriteria criteria) throws PuckException {
        Partition<Individual> result;
        if (source == null || criteria == null) {
            result = null;
        } else {
            result = new Partition<Individual>();
            result.setLabel(title);
            result.setCriteria(criteria);
            if (criteria.getRelationModelName() != null && criteria.getEgoRoleName() != null && criteria.getTime() != null) {
                Slice slice = SliceMaker.createSlice(source, criteria.getRelationModelName(), criteria.getEgoRoleName(), criteria.getLabel(), "TIME", criteria.getTime());
                NumberedValues values = RelationValuator.get(slice, criteria.getLabel(), (Object)criteria.getLabelParameter());
                NumberedValues partitionValues = PartitionMaker.getPartitionValues(values, criteria);
                for (Individual individual : slice.members()) {
                    result.put(individual, (Value)partitionValues.get(individual.getId()));
                }
            } else {
                NumberedValues values = IndividualValuator.get(source, criteria.getLabel(), (Object)criteria.getLabelParameter());
                NumberedValues partitionValues = PartitionMaker.getPartitionValues(values, criteria);
                for (Individual individual : source) {
                    result.put(individual, (Value)partitionValues.get(individual.getId()));
                }
            }
        }
        return result;
    }

    public static Partition<Individual> create(String title, Individuals individuals, Relations relations, PartitionCriteria criteria) throws PuckException {
        Partition<Individual> result;
        if (individuals == null || relations == null || criteria == null) {
            result = null;
        } else {
            result = new Partition<Individual>();
            result.setLabel(title);
            result.setCriteria(criteria);
            NumberedValues values = null;
            if (RelationValuator.getAttributeLabels(relations).contains(criteria.getLabel())) {
                values = RelationValuator.getByIndividuals(relations, criteria.getLabel(), criteria.getLabelParameter());
            } else if (IndividualValuator.getAttributeLabels(individuals).contains((Object)criteria.getLabel())) {
                values = IndividualValuator.get(individuals, criteria.getLabel(), (Object)criteria.getLabelParameter());
            } else {
                System.err.println("partition label *" + criteria.getLabel() + "* is not recognized");
            }
            NumberedValues partitionValues = PartitionMaker.getPartitionValues(values, criteria);
            if (partitionValues != null) {
                for (Individual individual : individuals) {
                    result.put(individual, (Value)partitionValues.get(individual.getId()));
                }
            }
        }
        return result;
    }

    public static Partition<Individual> create(String title, Slice source, PartitionCriteria criteria) throws PuckException {
        Partition<Individual> result;
        if (source == null || criteria == null) {
            result = null;
        } else {
            result = new Partition<Individual>();
            result.setLabel(title);
            result.setCriteria(criteria);
            NumberedValues values = null;
            if (source.isStateLabel(criteria.getLabel())) {
                values = RelationValuator.get(source, criteria.getLabel(), (Object)criteria.getLabelParameter());
            } else if (source.isIndividualLabel(criteria.getLabel())) {
                values = IndividualValuator.get(source.members(), criteria.getLabel(), (Object)criteria.getLabelParameter());
            } else {
                System.err.println("partition label " + criteria.getLabel() + " is not recognized");
            }
            NumberedValues partitionValues = PartitionMaker.getPartitionValues(values, criteria);
            for (Individual individual : source.members()) {
                result.put(individual, (Value)partitionValues.get(individual.getId()));
            }
        }
        return result;
    }

    public static <E> Partition<Node<E>> create(String title, Graph<E> source, PartitionCriteria criteria) throws PuckException {
        Partition<Node<E>> result;
        if (source == null || criteria == null) {
            result = null;
        } else {
            result = new Partition<Node<E>>();
            result.setLabel(title);
            result.setCriteria(criteria);
            Values values = NodeValuator.get(source, criteria.getLabel());
            Values partitionValues = PartitionMaker.getPartitionValues(values, criteria);
            List<Node<E>> nodes = source.getNodes().toListSortedById();
            int index = 0;
            while (index < source.nodeCount()) {
                result.put(nodes.get(index), (Value)partitionValues.get(index));
                ++index;
            }
        }
        return result;
    }

    public static Partition<Value> create(String title, List<Value> values) {
        Partition<Value> result = new Partition<Value>();
        result.setLabel(title);
        for (Value value : values) {
            result.put(value, value);
        }
        return result;
    }

    public static Partition<Chain> create(String title, Partition<Chain> source, PartitionCriteria criteria) throws PuckException {
        Partition<Chain> result;
        if (source == null || criteria == null) {
            result = null;
        } else {
            result = new Partition<Chain>();
            result.setLabel(title);
            result.setCriteria(criteria);
            for (Cluster<Chain> cluster : source.getClusters()) {
                result.putAll(cluster.getItems(), ChainValuator.get(cluster.getFirstItem(), criteria.getLabel(), (Object)criteria.getLabelParameter()));
            }
        }
        return result;
    }

    public static <E> Partition<E> create(String title, Cluster<E> source, PartitionCriteria criteria) throws PuckException {
        Partition<Object> result;
        block5: {
            E firstItem;
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (source != null && criteria != null) break block4;
                            result = null;
                            break block5;
                        }
                        result = new Partition<Object>();
                        result.setLabel(title);
                        result.setCriteria(criteria);
                        result.putClusters();
                        firstItem = source.getFirstItem();
                        if (!(firstItem instanceof Chain)) break block6;
                        Chains map = new Chains(source.getItems());
                        NumberedValues values = ChainValuator.get(map, criteria.getLabel(), (Object)criteria.getLabelParameter());
                        NumberedValues partitionValues = PartitionMaker.getPartitionValues(values, criteria);
                        for (Chain e : map) {
                            result.put(e, (Value)partitionValues.get(e.getId()));
                        }
                        result.put(firstItem, ChainValuator.get((Chain)firstItem, criteria.getLabel(), (Object)criteria.getLabelParameter()));
                        break block5;
                    }
                    if (!(firstItem instanceof Individual)) break block7;
                    Individuals map = new Individuals(source.getItems());
                    NumberedValues values = IndividualValuator.get(map, criteria.getLabel(), (Object)criteria.getLabelParameter());
                    NumberedValues partitionValues = PartitionMaker.getPartitionValues(values, criteria);
                    for (Individual e : map) {
                        result.put(e, (Value)partitionValues.get(e.getId()));
                    }
                    break block5;
                }
                if (!(firstItem instanceof Family)) break block8;
                Families map = new Families(source.getItems());
                NumberedValues values = FamilyValuator.get(map, criteria.getLabel(), (Object)criteria.getLabelParameter());
                NumberedValues partitionValues = PartitionMaker.getPartitionValues(values, criteria);
                for (Family e : map) {
                    result.put(e, (Value)partitionValues.get(e.getId()));
                }
                break block5;
            }
            if (!(firstItem instanceof Relation)) break block5;
            Relations map = new Relations(source.getItems());
            NumberedValues values = RelationValuator.get(map, criteria.getLabel(), (Object)criteria.getLabelParameter());
            NumberedValues partitionValues = PartitionMaker.getPartitionValues(values, criteria);
            for (Relation e : map) {
                result.put(e, (Value)partitionValues.get(e.getId()));
            }
        }
        return result;
    }

    public static Partition<Relation> create(String title, Relations source, PartitionCriteria criteria) throws PuckException {
        Partition<Relation> result;
        if (source == null || criteria == null) {
            result = null;
        } else {
            result = new Partition<Relation>();
            result.setLabel(title);
            result.setCriteria(criteria);
            NumberedValues values = RelationValuator.get(source, criteria.getLabel(), (Object)criteria.getLabelParameter());
            NumberedValues partitionValues = PartitionMaker.getPartitionValues(values, criteria);
            for (Relation relation : source) {
                result.put(relation, (Value)partitionValues.get(relation.getId()));
            }
        }
        return result;
    }

    public static Partition<Individual> create(String title, Individuals individuals, NumberedValues values, PartitionCriteria criteria) throws PuckException {
        Partition<Individual> result;
        if (individuals == null || values == null || criteria == null) {
            result = null;
        } else {
            result = new Partition<Individual>();
            result.setLabel(title);
            result.setCriteria(criteria);
            NumberedValues partitionValues = PartitionMaker.getPartitionValues(values, criteria);
            Iterator iterator = values.keySet().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                if (partitionValues.get(id) != null && ((Value)partitionValues.get(id)).isList()) {
                    result.setPseudo(true);
                    List list = ((Value)partitionValues.get(id)).listValue();
                    if (list.size() == 0) {
                        result.put((Individual)individuals.getById(id), new Value("-"));
                        continue;
                    }
                    for (Object partialValue : list) {
                        if (partialValue == null) {
                            result.put((Individual)individuals.getById(id), null);
                            continue;
                        }
                        if (partialValue instanceof String) {
                            result.put((Individual)individuals.getById(id), new Value((String)partialValue));
                            continue;
                        }
                        if (partialValue instanceof String[]) {
                            result.put((Individual)individuals.getById(id), new Value(Arrays.toString((String[])partialValue)));
                            continue;
                        }
                        result.put((Individual)individuals.getById(id), new Value(partialValue.toString()));
                    }
                    continue;
                }
                result.put((Individual)individuals.getById(id), (Value)partitionValues.get(id));
            }
        }
        return result;
    }

    public static Partition<Relation> create(String title, Relations individuals, NumberedValues values, PartitionCriteria criteria) throws PuckException {
        Partition<Relation> result;
        if (individuals == null || values == null || criteria == null) {
            result = null;
        } else {
            result = new Partition<Relation>();
            result.setLabel(title);
            result.setCriteria(criteria);
            NumberedValues partitionValues = PartitionMaker.getPartitionValues(values, criteria);
            Iterator iterator = values.keySet().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                if (partitionValues.get(id) != null && ((Value)partitionValues.get(id)).isList()) {
                    List list = ((Value)partitionValues.get(id)).listValue();
                    if (list.size() == 0) {
                        result.put((Relation)individuals.getById(id), new Value("-"));
                        continue;
                    }
                    for (Object partialValue : list) {
                        if (partialValue == null) {
                            result.put((Relation)individuals.getById(id), null);
                            continue;
                        }
                        if (partialValue instanceof String) {
                            result.put((Relation)individuals.getById(id), new Value((String)partialValue));
                            continue;
                        }
                        if (partialValue instanceof String[]) {
                            result.put((Relation)individuals.getById(id), new Value(Arrays.toString((String[])partialValue)));
                            continue;
                        }
                        result.put((Relation)individuals.getById(id), new Value(partialValue.toString()));
                    }
                    continue;
                }
                result.put((Relation)individuals.getById(id), (Value)partitionValues.get(id));
            }
        }
        return result;
    }

    public static Partition<Individual> createBinarization(Net source, String label, String pattern) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(source, PartitionCriteria.createBinarization(label, null, pattern));
        return result;
    }

    public static Partition<Individual> createBinarization(Net source, String label, String labelParameter, String pattern) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(source, PartitionCriteria.createBinarization(label, labelParameter, pattern));
        return result;
    }

    public static Partition<Individual> createBinarization(String title, Individuals source, String label, String pattern) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(title, source, PartitionCriteria.createBinarization(label, null, pattern));
        return result;
    }

    public static Partition<Individual> createBinarization(String title, Individuals source, String label, String labelParameter, String pattern) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(title, source, PartitionCriteria.createBinarization(label, labelParameter, pattern));
        return result;
    }

    public static <E> Partition<E> createCleaned(Partition<E> source, PartitionCriteria.SizeFilter filter) {
        Partition<E> result;
        if (source == null) {
            result = null;
        } else if (filter == null) {
            result = PartitionMaker.createCopy(source);
        } else {
            switch (filter) {
                case NONE: {
                    result = PartitionMaker.createCopy(source);
                    break;
                }
                case TRIM: {
                    List<Cluster<E>> clusters = source.getClusters().toListSortedByValue();
                    int startIndex = 0;
                    boolean ended = false;
                    int index = 0;
                    while (!ended) {
                        if (index < clusters.size()) {
                            Cluster<E> cluster = clusters.get(index);
                            if (cluster.isNotEmpty()) {
                                ended = true;
                                startIndex = index;
                                continue;
                            }
                            ++index;
                            continue;
                        }
                        ended = true;
                        startIndex = 0;
                    }
                    int endIndex = 0;
                    boolean ended2 = false;
                    int index2 = clusters.size() - 1;
                    while (!ended2) {
                        if (index2 >= 0) {
                            Cluster<E> cluster = clusters.get(index2);
                            if (cluster.isNotEmpty()) {
                                ended2 = true;
                                endIndex = index2;
                                continue;
                            }
                            ++index2;
                            continue;
                        }
                        ended2 = true;
                        endIndex = 0;
                    }
                    result = new Partition(source.getLabel());
                    int clusterIndex = startIndex;
                    while (clusterIndex <= endIndex) {
                        Cluster<E> cluster = clusters.get(clusterIndex);
                        result.putAll(cluster.getItems(), cluster.getValue());
                        ++clusterIndex;
                    }
                    break;
                }
                case EMPTY: {
                    result = new Partition(source.getLabel());
                    for (Cluster<E> cluster : source.getClusters()) {
                        if (!cluster.isNotEmpty()) continue;
                        result.putAll(cluster.getItems(), cluster.getValue());
                    }
                    break;
                }
                case HOLES: {
                    if (source.getClusters().isNumericOrNull()) {
                        result = new Partition(source.getLabel());
                        List<Cluster<E>> clusters = source.getClusters().toListSortedByValue();
                        Cluster<E> maxCluster = Collections.max(clusters);
                        if (maxCluster.getValue() == null) {
                            result = PartitionMaker.createCopy(source);
                            break;
                        }
                        int count = 0;
                        int clusterIndex = 0;
                        while (clusterIndex < clusters.size()) {
                            Cluster<E> cluster = clusters.get(clusterIndex);
                            if (cluster.getValue() == null) {
                                result.putAll(cluster.getItems(), cluster.getValue());
                            } else {
                                int currentCount = cluster.getValue().intValue();
                                while (count < currentCount) {
                                    result.putCluster(new Value(count));
                                    ++count;
                                }
                                result.putAll(cluster.getItems(), cluster.getValue());
                                ++count;
                            }
                            ++clusterIndex;
                        }
                        break;
                    }
                    result = PartitionMaker.createCopy(source);
                    break;
                }
                default: {
                    result = PartitionMaker.createCopy(source);
                }
            }
        }
        return result;
    }

    public static <E> Partition<E> createCleaned(Partition<E> source, PartitionCriteria.ValueFilter filter) {
        Partition<E> result;
        if (source == null) {
            result = null;
        } else if (filter == null) {
            result = PartitionMaker.createCopy(source);
        } else {
            switch (filter) {
                case NONE: {
                    result = PartitionMaker.createCopy(source);
                    break;
                }
                case NULL: {
                    result = new Partition(source.getLabel());
                    for (Cluster<E> cluster : source.getClusters()) {
                        if (cluster.getValue() == null) continue;
                        result.putAll(cluster.getItems(), cluster.getValue());
                    }
                    break;
                }
                case ZERO: {
                    result = new Partition(source.getLabel());
                    for (Cluster<E> cluster : source.getClusters()) {
                        Value value = cluster.getValue();
                        if (value == null || !value.isNotNumber() && value.doubleValue() == 0.0) continue;
                        result.putAll(cluster.getItems(), cluster.getValue());
                    }
                    break;
                }
                default: {
                    result = PartitionMaker.createCopy(source);
                }
            }
        }
        return result;
    }

    public static <E> Partition<E> createCopy(Partition<E> source) {
        Partition<E> result;
        if (source == null) {
            result = null;
        } else {
            result = new Partition<E>(source.getLabel());
            for (Cluster<E> cluster : source.getClusters()) {
                result.putAll(cluster.getItems(), cluster.getValue());
            }
        }
        return result;
    }

    public static Partition<Individual> createCountedGrouping(Net source, String label, Double start, Double count, Double end) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(source, PartitionCriteria.createCountedGrouping(label, null, start, count, end));
        return result;
    }

    public static Partition<Individual> createCountedGrouping(Net source, String label, String labelParameter, Double start, Double count, Double end) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(source, PartitionCriteria.createCountedGrouping(label, labelParameter, start, count, end));
        return result;
    }

    public static Partition<Individual> createCountedGrouping(String title, Individuals source, String label, Double start, Double count, Double end) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(title, source, PartitionCriteria.createCountedGrouping(label, null, start, count, end));
        return result;
    }

    public static Partition<Individual> createCountedGrouping(String title, Individuals source, String label, String labelParameter, Double start, Double count, Double end) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(title, source, PartitionCriteria.createCountedGrouping(label, labelParameter, start, count, end));
        return result;
    }

    public static Partition<Individual> createGrouping(Net source, String label, Intervals intervals) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(source, PartitionCriteria.createGrouping(label, null, intervals));
        return result;
    }

    public static Partition<Individual> createGrouping(Net source, String label, String steps) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(source, PartitionCriteria.createGrouping(label, null, PartitionMaker.getIntervals(steps)));
        return result;
    }

    public static Partition<Individual> createGrouping(String title, Individuals source, String label, Intervals intervals) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(title, source, PartitionCriteria.createGrouping(label, null, intervals));
        return result;
    }

    public static Partition<Individual> createGrouping(String title, Individuals source, String label, String steps) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(title, source, PartitionCriteria.createGrouping(label, null, PartitionMaker.getIntervals(steps)));
        return result;
    }

    public static Partition<Individual> createGrouping(String title, Individuals source, String label, String labelParameter, Intervals intervals) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(title, source, PartitionCriteria.createGrouping(label, labelParameter, intervals));
        return result;
    }

    public static Partition<Individual> createGrouping(String title, Individuals source, String label, String labelParameter, String steps) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(title, source, PartitionCriteria.createGrouping(label, labelParameter, PartitionMaker.getIntervals(steps)));
        return result;
    }

    public static <E> Map<Value, Integer> getPartitionNumbersMap(Partition<E> source) {
        HashMap<Value, Integer> result;
        if (source == null || source.isNumeric()) {
            result = null;
        } else {
            result = new HashMap<Value, Integer>();
            List<Cluster<E>> clusterList = source.getClusters().toListSortedByValue();
            int i = 1;
            while (i <= clusterList.size()) {
                Cluster<E> cluster = clusterList.get(i - 1);
                if (cluster.getValue() == null) {
                    result.put(cluster.getValue(), 0);
                } else {
                    result.put(cluster.getValue(), i);
                }
                ++i;
            }
        }
        return result;
    }

    public static <E> Partition<E> createNumerized(Partition<E> source, Map<Value, Integer> partitionNumbersMap) {
        Partition<E> result;
        if (source == null) {
            result = null;
        } else if (source.isNumeric()) {
            result = source;
        } else {
            result = new Partition();
            result.setLabel(source.getLabel());
            List<Cluster<E>> clusterList = source.getClusters().toListSortedByValue();
            int i = 1;
            while (i <= clusterList.size()) {
                Value intValue = new Value(0);
                Cluster<E> cluster = clusterList.get(i - 1);
                if (cluster.getValue() != null) {
                    intValue = partitionNumbersMap != null ? (partitionNumbersMap.get(cluster.getValue()) != null ? new Value(partitionNumbersMap.get(cluster.getValue())) : new Value(0)) : new Value(i);
                }
                result.putAll(cluster.getItems(), intValue);
                ++i;
            }
        }
        return result;
    }

    public static Partition<Individual> createRaw(Net source, String label) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(source, PartitionCriteria.createRaw(label, null));
        return result;
    }

    public static Partition<Individual> createRaw(Net source, String label, String labelParameter) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(source, PartitionCriteria.createRaw(label, labelParameter));
        return result;
    }

    public static Partition<Individual> createRaw(String title, Individuals source) throws PuckException {
        return PartitionMaker.create(title, source, PartitionCriteria.createRaw(title));
    }

    public static Partition<Individual> createRaw(String title, Individuals source, String label) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(title, source, PartitionCriteria.createRaw(label, null));
        return result;
    }

    public static Partition<Relation> createRaw(String title, Relations source, String label) throws PuckException {
        Partition<Relation> result = PartitionMaker.create(title, source, PartitionCriteria.createRaw(label, null));
        return result;
    }

    public static Partition<Individual> createRaw(String title, Individuals source, String label, String labelParameter) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(title, source, PartitionCriteria.createRaw(label, labelParameter));
        return result;
    }

    public static Partition<Relation> createRaw(String title, Relations source, String label, String labelParameter) throws PuckException {
        Partition<Relation> result = PartitionMaker.create(title, source, PartitionCriteria.createRaw(label, labelParameter));
        return result;
    }

    public static Partition<Individual> createSizedGrouping(Net source, String label, Double start, Double size, Double end) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(source, PartitionCriteria.createSizedGrouping(label, null, start, size, end));
        return result;
    }

    public static Partition<Individual> createSizedGrouping(Net source, String label, String labelParameter, Double start, Double size, Double end) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(source, PartitionCriteria.createSizedGrouping(label, labelParameter, start, size, end));
        return result;
    }

    public static Partition<Individual> createSizedGrouping(String title, Individuals source, String label, Double start, Double size, Double end) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(title, source, PartitionCriteria.createSizedGrouping(label, null, start, size, end));
        return result;
    }

    public static Partition<Individual> createSizedGrouping(String title, Individuals source, String label, String labelParameter, Double start, Double size, Double end) throws PuckException {
        Partition<Individual> result = PartitionMaker.create(title, source, PartitionCriteria.createSizedGrouping(label, labelParameter, start, size, end));
        return result;
    }

    public static Value getBinarizedValue(Value sourceValue, String pattern) {
        Value result;
        if (sourceValue == null) {
            result = null;
        } else if (StringUtils.isEmpty((CharSequence)pattern)) {
            result = new Value("nonnull");
        } else {
            String targetPattern = pattern.replaceAll("\\*", ".*").replaceAll("\\+", "PLUS").replaceAll("\\-", "MINUS");
            String sourcePattern = sourceValue.stringValue().replaceAll("\\*", ".*").replaceAll("\\+", "PLUS").replaceAll("\\-", "MINUS");
            result = sourcePattern.matches(targetPattern) ? new Value(pattern) : null;
        }
        return result;
    }

    public static Value getPartializedValue(Value sourceValue) {
        Value result;
        if (sourceValue == null) {
            result = null;
        } else {
            ArrayList<String> list = new ArrayList<String>();
            String string = sourceValue.stringValue().replace("[", "").replace("]", "");
            String[] partializedString = string.split(",");
            String trunkString = "[";
            int i = 0;
            while (i < partializedString.length) {
                String partialString = String.valueOf(trunkString) + partializedString[i];
                trunkString = String.valueOf(partialString) + ", ";
                list.add(String.valueOf(partialString) + "]");
                ++i;
            }
            result = new Value(list);
        }
        return result;
    }

    public static NumberedValues getBinarizedValues(NumberedValues source, String pattern) {
        NumberedValues result;
        if (source == null) {
            result = null;
        } else if (pattern == null) {
            result = source;
        } else {
            result = new NumberedValues(source.size());
            for (Integer id : source.keySet()) {
                Value sourceValue = (Value)source.get(id);
                Value targetValue = PartitionMaker.getBinarizedValue(sourceValue, pattern);
                result.put(id, targetValue);
            }
        }
        return result;
    }

    public static Values getBinarizedValues(Values source, String pattern) {
        Values result;
        if (source == null) {
            result = null;
        } else if (pattern == null) {
            result = source;
        } else {
            result = new Values(source.size());
            for (Value sourceValue : source) {
                result.add(PartitionMaker.getBinarizedValue(sourceValue, pattern));
            }
        }
        return result;
    }

    public static Values getPartializedValues(Values source) {
        Values result;
        if (source == null) {
            result = null;
        } else {
            result = new Values(source.size());
            for (Value sourceValue : source) {
                result.add(PartitionMaker.getPartializedValue(sourceValue));
            }
        }
        return result;
    }

    public static NumberedValues getPartializedValues(NumberedValues source) {
        NumberedValues result;
        if (source == null) {
            result = null;
        } else {
            result = new NumberedValues(source.size());
            for (Integer id : source.keySet()) {
                Value sourceValue = (Value)source.get(id);
                Value targetValue = PartitionMaker.getPartializedValue(sourceValue);
                result.put(id, targetValue);
            }
        }
        return result;
    }

    public static Value getGroupingValue(Value sourceValue, Intervals intervals) {
        Interval interval;
        Value result = sourceValue == null || sourceValue.isNotNumber() ? null : ((interval = intervals.find(sourceValue.doubleValue())) == null ? null : new Value(interval));
        return result;
    }

    public static NumberedValues getGroupingValues(NumberedValues source, Intervals intervals) {
        NumberedValues result;
        if (source == null) {
            result = null;
        } else if (intervals == null) {
            result = source;
        } else {
            result = new NumberedValues(source.size());
            for (Integer id : source.keySet()) {
                Value sourceValue = (Value)source.get(id);
                Value targetValue = PartitionMaker.getGroupingValue(sourceValue, intervals);
                result.put(id, targetValue);
            }
        }
        return result;
    }

    public static Values getGroupingValues(Values source, Intervals intervals) {
        Values result;
        if (source == null) {
            result = null;
        } else if (intervals == null) {
            result = source;
        } else {
            result = new Values(source.size());
            for (Value sourceValue : source) {
                result.add(PartitionMaker.getGroupingValue(sourceValue, intervals));
            }
        }
        return result;
    }

    public static Intervals getIntervals(String steps) {
        Intervals result = new Intervals();
        if (StringUtils.isNotBlank((CharSequence)steps)) {
            String[] strings;
            ArrayList<Double> values = new ArrayList<Double>();
            String[] stringArray = strings = steps.split("[\\s]+");
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (NumberUtils.isNumber((String)string)) {
                    values.add(Double.parseDouble(string));
                }
                ++n2;
            }
            Collections.sort(values);
            if (values.size() == 1) {
                Interval interval = new Interval((Double)values.get(0), Interval.EndpointStatus.INCLUDED, (Double)values.get(0), Interval.EndpointStatus.INCLUDED);
                result.add(interval);
            } else if (values.size() > 1) {
                int index = 0;
                while (index < values.size() - 1) {
                    Interval interval = index == values.size() - 1 ? new Interval((Double)values.get(index), Interval.EndpointStatus.INCLUDED, (Double)values.get(index + 1), Interval.EndpointStatus.INCLUDED) : new Interval((Double)values.get(index), Interval.EndpointStatus.INCLUDED, (Double)values.get(index + 1), Interval.EndpointStatus.EXCLUDED);
                    result.add(interval);
                    ++index;
                }
            }
        }
        return result;
    }

    public static Intervals getIntervalsByCount(Double start, Double size, Double end) throws PuckException {
        Intervals result = PartitionMaker.getIntervalsByCount(start, size, end, 0.0, 4.4942328371557893E307);
        return result;
    }

    public static Intervals getIntervalsByCount(Double start, Double count, Double end, Double min, Double max) throws PuckException {
        Intervals result;
        if (count == null) {
            result = PartitionMaker.getIntervalsByCount(start, 1.0, end, min, max);
        } else {
            if (count <= 0.0) {
                throw new IllegalArgumentException("Illegal count value (zero or negative).");
            }
            if (min == null && max == null) {
                result = new Intervals();
            } else if (min != null && max != null && min > max) {
                result = PartitionMaker.getIntervalsByCount(start, count, end, max, min);
            } else if (start != null && end != null && start > end) {
                result = PartitionMaker.getIntervalsByCount(end, count, start, min, max);
            } else {
                if (min == null && max != null) {
                    throw new IllegalArgumentException("Undefined min value is impossible if max value is defined.");
                }
                if (min != null && max == null) {
                    throw new IllegalArgumentException("Undefined max value is impossible if min value is defined.");
                }
                if (start == null && min == null && end == null && max == null) {
                    result = new Intervals();
                } else if (start == null && min != null && end == null && max != null) {
                    result = PartitionMaker.getIntervalsBySize(min, (max - min) / count, max);
                } else if (start != null && end == null && min == null && max == null) {
                    result = new Intervals();
                } else if (start == null && end != null && min == null && max == null) {
                    result = new Intervals();
                } else {
                    double targetStart = start == null ? min.doubleValue() : start.doubleValue();
                    double targetEnd = end == null ? max.doubleValue() : end.doubleValue();
                    double targetSize = MathUtils.isDecimalInteger(targetStart) && MathUtils.isDecimalInteger(targetEnd) ? Math.abs(Math.ceil((targetEnd - targetStart) / count)) : (targetEnd - targetStart) / count;
                    result = PartitionMaker.getIntervalsBySize(targetStart, targetSize, targetEnd, min, max);
                }
            }
        }
        return result;
    }

    public static Intervals getIntervalsBySize(double start, double size, double end) {
        Intervals result = new Intervals();
        if (start < end) {
            double value = start;
            while (value < end) {
                Interval interval = value + size < end ? new Interval(value, Interval.EndpointStatus.INCLUDED, value + size, Interval.EndpointStatus.EXCLUDED) : new Interval(value, Interval.EndpointStatus.INCLUDED, end, Interval.EndpointStatus.INCLUDED);
                result.add(interval);
                value += size;
            }
        } else if (start > end) {
            double value = end;
            while (value > start) {
                Interval interval = value - size > start ? new Interval(value - size, Interval.EndpointStatus.INCLUDED, value, Interval.EndpointStatus.EXCLUDED) : new Interval(start, Interval.EndpointStatus.INCLUDED, value, Interval.EndpointStatus.INCLUDED);
                result.add(interval);
                value -= size;
            }
            Collections.reverse(result);
        } else {
            Interval interval = new Interval(start, Interval.EndpointStatus.INCLUDED, end, Interval.EndpointStatus.INCLUDED);
            result.add(interval);
        }
        return result;
    }

    public static Intervals getIntervalsBySize(Double start, Double size, Double end, Double min, Double max) throws PuckException {
        Intervals result;
        if (size == null) {
            result = PartitionMaker.getIntervalsBySize(start, 1.0, end, min, max);
        } else {
            if (size <= 0.0) {
                throw new IllegalArgumentException("Illegal size value (negative or zero).");
            }
            if (min != null && max != null && min > max) {
                result = PartitionMaker.getIntervalsBySize(start, size, end, max, min);
            } else if (start != null && end != null && start > end) {
                result = PartitionMaker.getIntervalsBySize(end, size, start, min, max);
            } else {
                if (min == null && max != null) {
                    throw new IllegalArgumentException("Undefined min value is impossible if max value is defined.");
                }
                if (min != null && max == null) {
                    throw new IllegalArgumentException("Undefined max value is impossible if min value is defined.");
                }
                if (start == null && min == null && end == null && max == null) {
                    result = new Intervals();
                } else if (start == null && min != null && end == null && max != null) {
                    result = PartitionMaker.getIntervalsBySize(min, size, max);
                } else if (start != null && end == null && min == null && max == null) {
                    result = new Intervals();
                    result.add(new Interval(start, Interval.EndpointStatus.INCLUDED, start + size, Interval.EndpointStatus.EXCLUDED));
                } else if (start == null && end != null && min == null && max == null) {
                    result = new Intervals();
                    result.add(new Interval(end - size, Interval.EndpointStatus.INCLUDED, end, Interval.EndpointStatus.EXCLUDED));
                } else {
                    double targetStart;
                    double targetEnd = end == null ? max.doubleValue() : end.doubleValue();
                    double intervalCount = (targetEnd - (targetStart = start == null ? min.doubleValue() : start.doubleValue())) / size;
                    if (intervalCount > 10000.0) {
                        throw PuckExceptions.OVERFLOW.create("Too numerous intervals: " + intervalCount + " > " + 10000.0 + ".", new Object[0]);
                    }
                    result = PartitionMaker.getIntervalsBySize(targetStart, size, targetEnd);
                    if (min != null && start != null && min < start) {
                        result.add(new Interval(min, Interval.EndpointStatus.INCLUDED, start, Interval.EndpointStatus.EXCLUDED));
                    }
                    if (max != null && end != null && max > end) {
                        result.add(new Interval(end, Interval.EndpointStatus.EXCLUDED, max, Interval.EndpointStatus.INCLUDED));
                    }
                }
            }
        }
        return result;
    }

    public static NumberedValues getPartitionValues(NumberedValues values, PartitionCriteria criteria) throws PuckException {
        NumberedValues result;
        if (values == null) {
            result = null;
        } else if (criteria == null) {
            result = values;
        } else {
            switch (criteria.getType()) {
                case RAW: {
                    result = values;
                    break;
                }
                case BINARIZATION: {
                    result = PartitionMaker.getBinarizedValues(values, criteria.getPattern());
                    break;
                }
                case FREE_GROUPING: {
                    result = PartitionMaker.getGroupingValues(values, criteria.getIntervals());
                    break;
                }
                case COUNTED_GROUPING: {
                    Intervals intervals = PartitionMaker.getIntervalsByCount(criteria.getStart(), criteria.getCount(), criteria.getEnd(), values.min(), values.max());
                    result = PartitionMaker.getGroupingValues(values, intervals);
                    break;
                }
                case SIZED_GROUPING: {
                    Intervals intervals = PartitionMaker.getIntervalsBySize(criteria.getStart(), criteria.getSize(), criteria.getEnd(), values.min(), values.max());
                    result = PartitionMaker.getGroupingValues(values, intervals);
                    break;
                }
                case PARTIALIZATION: {
                    result = PartitionMaker.getPartializedValues(values);
                    break;
                }
                default: {
                    result = new NumberedValues();
                }
            }
        }
        return result;
    }

    public static Values getPartitionValues(Values source, PartitionCriteria criteria) throws PuckException {
        Values result;
        if (source == null) {
            result = null;
        } else if (criteria == null) {
            result = source;
        } else {
            switch (criteria.getType()) {
                case RAW: {
                    result = source;
                    break;
                }
                case BINARIZATION: {
                    result = PartitionMaker.getBinarizedValues(source, criteria.getPattern());
                    break;
                }
                case FREE_GROUPING: {
                    result = PartitionMaker.getGroupingValues(source, criteria.getIntervals());
                    break;
                }
                case COUNTED_GROUPING: {
                    Intervals intervals = PartitionMaker.getIntervalsByCount(criteria.getStart(), criteria.getCount(), criteria.getEnd(), source.min(), source.max());
                    result = PartitionMaker.getGroupingValues(source, intervals);
                    break;
                }
                case SIZED_GROUPING: {
                    Intervals intervals = PartitionMaker.getIntervalsBySize(criteria.getStart(), criteria.getSize(), criteria.getEnd(), source.min(), source.max());
                    result = PartitionMaker.getGroupingValues(source, intervals);
                    break;
                }
                case PARTIALIZATION: {
                    result = PartitionMaker.getPartializedValues(source);
                    break;
                }
                default: {
                    result = new Values();
                }
            }
        }
        return result;
    }
}

