/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import org.apache.commons.lang3.StringUtils;

public class NetNodeType {
    private Scope scope;
    private String relationModelName;

    public NetNodeType(Scope scope) {
        this.scope = scope;
        this.relationModelName = null;
    }

    public NetNodeType(String relationModelName) {
        if (StringUtils.isBlank((CharSequence)relationModelName)) {
            throw new IllegalArgumentException("Relation Model Name is missing.");
        }
        this.scope = Scope.RELATIONS;
        this.relationModelName = relationModelName;
    }

    public String getRelationModelName() {
        return this.relationModelName;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setRelationModelName(String relationModelName) {
        this.relationModelName = relationModelName;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public static boolean isCanonical(NetNodeType source) {
        boolean result = source == null || source.getScope() == Scope.RELATIONS;
        return result;
    }

    public static boolean isFamilies(NetNodeType source) {
        boolean result = source == null || source.getScope() == Scope.FAMILIES;
        return result;
    }

    public static boolean isIndividuals(NetNodeType source) {
        boolean result = source == null || source.getScope() == Scope.INDIVIDUALS;
        return result;
    }

    public static enum Scope {
        INDIVIDUALS,
        FAMILIES,
        RELATIONS;

    }
}

