/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.iur;

import com.vividsolutions.jts.geom.Coordinate;
import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.geo2.Geography2;
import org.tip.puck.geo2.io.GEOTXTFile;
import org.tip.puck.io.iur.IURTXTFamilyLine;
import org.tip.puck.io.iur.IURTXTGeographyLine;
import org.tip.puck.io.iur.IURTXTIndividualLine;
import org.tip.puck.io.iur.IURTXTLabelsLine;
import org.tip.puck.io.iur.IURTXTRelationLine;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.util.LogHelper;

public class IURTXTFile {
    private static final Logger logger = LoggerFactory.getLogger(IURTXTFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 2048;
    public static final String BIRTH_ORDER_LABEL = "ORD";
    public static final String HUSBAND_ORDER_LABEL = "HUSB_ORD";
    public static final String WIFE_ORDER_LABEL = "WIFE_ORD";
    public static final String DEFAULT_ROLE_NAME = "MEMBER";

    public static Net load(File file) throws PuckException {
        Net result = IURTXTFile.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net load(File file, String charsetName) throws PuckException {
        Net result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = IURTXTFile.read(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static Net read(BufferedReader in) throws PuckException {
        Net result = new Net();
        IURTXTFile.readCorpusAttributes(result.attributes(), in);
        IURTXTFile.readIndividuals(result, in);
        IURTXTFile.readFamilies(result, in);
        logger.debug("Read relations.");
        boolean ended = false;
        while (!ended) {
            if (IURTXTFile.readRelations(result, in)) continue;
            ended = true;
        }
        logger.debug("Read geography2.");
        Geography2 geography = GEOTXTFile.readGeography(in);
        if (geography != null) {
            result.setGeography2(geography);
        }
        return result;
    }

    public static IURTXTLabelsLine readCorpusAttributeLabelsLine(BufferedReader in) throws PuckException {
        IURTXTLabelsLine result;
        try {
            in.mark(2048);
            String line = IURTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^[Ii][Dd]\\t.*$") || line.matches("^\\d.*$")) {
                in.reset();
                result = null;
            } else {
                String[] tokens = line.split("\\t");
                result = new IURTXTLabelsLine();
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    result.add(token);
                    ++n2;
                }
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading labels line.", new Object[0]);
        }
        return result;
    }

    public static void readCorpusAttributes(Attributes target, BufferedReader in) throws PuckException {
        IURTXTLabelsLine valuesLine;
        logger.debug("Read corpus attributes.");
        IURTXTLabelsLine labelsLine = IURTXTFile.readCorpusAttributeLabelsLine(in);
        if (labelsLine != null && (valuesLine = IURTXTFile.readLabelsLine(in)) != null) {
            int valueCount = 0;
            while (valueCount < valuesLine.size()) {
                String label = (String)labelsLine.get(valueCount);
                String value = (String)valuesLine.get(valueCount);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    target.put(label, value);
                }
                ++valueCount;
            }
        }
    }

    public static void readFamilies(Net target, BufferedReader in) throws PuckException {
        logger.debug("Read families.");
        IURTXTLabelsLine labelsLine = IURTXTFile.readLabelsLine(in);
        boolean ended = false;
        while (!ended) {
            UnionStatus status;
            Individual mother;
            Individual father;
            IURTXTFamilyLine source = IURTXTFile.readFamilyLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            if (source.getId() == 0) continue;
            if (source.getFatherId() == 0) {
                father = null;
            } else {
                father = (Individual)target.individuals().getById(source.getFatherId());
                if (father == null) {
                    father = target.createIndividual(source.getFatherId());
                }
            }
            if (source.getMotherId() == 0) {
                mother = null;
            } else {
                mother = (Individual)target.individuals().getById(source.getMotherId());
                if (mother == null) {
                    mother = target.createIndividual(source.getMotherId());
                }
            }
            switch (source.getStatus()) {
                case 'U': {
                    status = UnionStatus.UNMARRIED;
                    break;
                }
                case 'M': {
                    status = UnionStatus.MARRIED;
                    break;
                }
                case 'D': {
                    status = UnionStatus.DIVORCED;
                    break;
                }
                default: {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Unknown union status [" + source.getStatus() + "]", new Object[0]);
                }
            }
            Family family = target.createFamily(source.getId(), father, mother, status);
            if (StringUtils.isNotBlank((CharSequence)source.getChildIds())) {
                String[] ids;
                String[] stringArray = ids = source.getChildIds().split("[ .,;]+");
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String childId = stringArray[n2];
                    if (NumberUtils.isNumber((String)childId)) {
                        Individual child = (Individual)target.individuals().getById(Integer.parseInt(childId));
                        if (child == null) {
                            child = target.createIndividual(Integer.parseInt(childId));
                        }
                        if (child.getOriginFamily() == null) {
                            child.setOriginFamily(family);
                            family.getChildren().add(child);
                        } else {
                            throw PuckExceptions.BAD_FILE_FORMAT.create("Child [" + child.getId() + "] defined in two different families [" + child.getOriginFamily().getId() + "][" + family.getId() + "]", new Object[0]);
                        }
                    }
                    ++n2;
                }
            }
            int valueCount = 0;
            while (valueCount < source.attributeValues().size()) {
                String label = (String)labelsLine.get(valueCount + 5);
                String value = source.attributeValues().get(valueCount);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    if (label.equals(HUSBAND_ORDER_LABEL) && StringUtils.isNumeric((CharSequence)value)) {
                        family.setHusbandOrder(new Integer(value));
                    } else if (label.equals(WIFE_ORDER_LABEL) && StringUtils.isNumeric((CharSequence)value)) {
                        family.setWifeOrder(new Integer(value));
                    } else {
                        family.attributes().put(label, value);
                    }
                }
                ++valueCount;
            }
        }
    }

    public static IURTXTFamilyLine readFamilyLine(BufferedReader in) throws PuckException {
        IURTXTFamilyLine result;
        try {
            in.mark(2048);
            String line = IURTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                String[] tokens = line.split("\\t");
                result = new IURTXTFamilyLine();
                result.setId(Double.valueOf(tokens[0]).intValue());
                if (tokens.length > 1) {
                    String statusToken = tokens[1].trim().toUpperCase();
                    if (statusToken.length() == 0) {
                        result.setStatus('U');
                    } else if (statusToken.length() == 1) {
                        result.setStatus(statusToken.charAt(0));
                    } else {
                        throw PuckExceptions.BAD_FILE_FORMAT.create("Bad union status [" + tokens[1] + "].", new Object[0]);
                    }
                }
                if (tokens.length > 2) {
                    if (StringUtils.isBlank((CharSequence)tokens[2])) {
                        result.setFatherId(0);
                    } else if (NumberUtils.isNumber((String)tokens[2])) {
                        result.setFatherId(Double.valueOf(tokens[2]).intValue());
                    } else {
                        throw PuckExceptions.BAD_FILE_FORMAT.create("Bad father id value [" + tokens[2] + "].", new Object[0]);
                    }
                }
                if (tokens.length > 3) {
                    if (StringUtils.isBlank((CharSequence)tokens[3])) {
                        result.setMotherId(0);
                    } else if (NumberUtils.isNumber((String)tokens[3])) {
                        result.setMotherId(Double.valueOf(tokens[3]).intValue());
                    } else {
                        throw PuckExceptions.BAD_FILE_FORMAT.create("Bad mother id value [" + tokens[3] + "].", new Object[0]);
                    }
                }
                if (tokens.length > 4 && StringUtils.isNotBlank((CharSequence)tokens[4])) {
                    result.setChildIds(tokens[4]);
                }
                int tokenCount = 5;
                while (tokenCount < tokens.length) {
                    result.attributeValues().add(tokens[tokenCount]);
                    ++tokenCount;
                }
            } else {
                in.reset();
                result = null;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading family line.", new Object[0]);
        }
        return result;
    }

    @Deprecated
    public static boolean readGeography(Net target, BufferedReader in) throws PuckException {
        boolean result;
        IURTXTLabelsLine labelsLine = IURTXTFile.readLabelsLine(in);
        if (labelsLine == null || labelsLine.size() != 1 || !((String)labelsLine.get(0)).equalsIgnoreCase("GEOGRAPHY")) {
            result = false;
        } else {
            logger.debug("Geography loading...");
            Geography geography = new Geography();
            Place world = new Place(GeoLevel.INTERCONTINENTAL, "World");
            geography.put(world);
            target.setGeography(geography);
            boolean ended = false;
            while (!ended) {
                IURTXTGeographyLine source = IURTXTFile.readGeographyLine(in);
                if (source == null) {
                    ended = true;
                    continue;
                }
                if (source.id() == 0 || !StringUtils.isNotBlank((CharSequence)source.getName())) continue;
                Coordinate coordinate = null;
                if (source.getLatitude() != null && source.getLongitude() != null) {
                    coordinate = new Coordinate(Double.parseDouble(source.getLongitude()), Double.parseDouble(source.getLatitude()));
                }
                Place place = new Place(source.id(), source.getName(), "", "", "", source.getCountryCode(), coordinate);
                Place supPlace = geography.get(source.getCountryCode(), GeoLevel.COUNTRY);
                if (supPlace == null) {
                    supPlace = new Place(GeoLevel.COUNTRY, source.getCountryCode());
                    geography.put(supPlace);
                    geography.put(source.getCountryCode(), supPlace);
                }
                place.setSup(supPlace);
                place.setLevel(GeoLevel.TOWN);
                geography.put(place);
                geography.put(source.getName(), place);
                Place homonym = new Place(GeoLevel.HOMONYM, source.getName());
                homonym.setSup(place);
                geography.put(homonym);
                geography.put(source.getName(), homonym);
            }
            logger.debug("Geography loaded.");
            result = true;
        }
        return result;
    }

    @Deprecated
    public static IURTXTGeographyLine readGeographyLine(BufferedReader in) throws PuckException {
        IURTXTGeographyLine result;
        try {
            in.mark(2048);
            String line = IURTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                String[] tokens = line.split("\\t");
                result = new IURTXTGeographyLine();
                result.setId(Double.valueOf(tokens[0]).intValue());
                result.setName(tokens[1]);
                if (tokens.length > 2) {
                    result.setCountryCode(tokens[2]);
                }
                if (tokens.length > 3) {
                    result.setLongitude(tokens[3]);
                    result.setLatitude(tokens[4]);
                }
            } else {
                in.reset();
                result = null;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
        }
        return result;
    }

    public static IURTXTIndividualLine readIndividualLine(BufferedReader in) throws PuckException {
        IURTXTIndividualLine result;
        try {
            in.mark(2048);
            String line = IURTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                String[] tokens = line.split("\\t");
                result = new IURTXTIndividualLine();
                if (!NumberUtils.isNumber((String)tokens[0])) {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Individual id is not number [" + line + "].", new Object[0]);
                }
                result.setId(Double.valueOf(tokens[0]).intValue());
                if (tokens.length > 1) {
                    result.setName(tokens[1]);
                }
                if (tokens.length > 2 && tokens[2].length() > 0) {
                    result.setGender(tokens[2].charAt(0));
                } else {
                    result.setGender('X');
                }
                int tokenCount = 3;
                while (tokenCount < tokens.length) {
                    result.attributeValues().add(tokens[tokenCount]);
                    ++tokenCount;
                }
            } else {
                in.reset();
                result = null;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
        }
        return result;
    }

    public static void readIndividuals(Net target, BufferedReader in) throws PuckException {
        logger.debug("Read individuals.");
        IURTXTLabelsLine labelsLine = IURTXTFile.readLabelsLine(in);
        boolean ended = false;
        while (!ended) {
            Individual individual;
            IURTXTIndividualLine source = IURTXTFile.readIndividualLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            if (source.getId() == 0) continue;
            try {
                individual = target.createIndividual(source.getId());
            }
            catch (PuckException exception) {
                throw PuckExceptions.BAD_FILE_FORMAT.create("Individual [" + source.getId() + "] define twice.", new Object[0]);
            }
            if (!StringUtils.isBlank((CharSequence)source.getName())) {
                individual.setName(source.getName());
            }
            if (Gender.valueOf(source.getGender()) != Gender.UNKNOWN) {
                individual.setGender(Gender.valueOf(source.getGender()));
            }
            int valueIndex = 0;
            while (valueIndex < source.attributeValues().size()) {
                String label = (String)labelsLine.get(valueIndex + 3);
                String value = source.attributeValues().get(valueIndex);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    value = value.trim();
                    if (label.equals(BIRTH_ORDER_LABEL) && StringUtils.isNumeric((CharSequence)value)) {
                        individual.setBirthOrder(new Integer(value));
                    } else {
                        individual.attributes().put(label, value);
                    }
                }
                ++valueIndex;
            }
        }
    }

    public static IURTXTLabelsLine readLabelsLine(BufferedReader in) throws PuckException {
        IURTXTLabelsLine result;
        try {
            in.mark(2048);
            String line = IURTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                in.reset();
                result = null;
            } else {
                String[] tokens = line.split("\\t");
                result = new IURTXTLabelsLine();
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    result.add(token);
                    ++n2;
                }
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading labels line.", new Object[0]);
        }
        return result;
    }

    public static String readNotEmptyLine(BufferedReader in) throws PuckException {
        String result;
        try {
            boolean ended = false;
            result = null;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    result = null;
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                ended = true;
                result = line;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
        }
        return result;
    }

    public static IURTXTRelationLine readRelationLine(BufferedReader in) throws PuckException {
        IURTXTRelationLine result;
        try {
            in.mark(2048);
            String line = IURTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                String[] tokens = line.split("\\t");
                result = new IURTXTRelationLine();
                result.setId(Double.valueOf(tokens[0]).intValue());
                result.setName(tokens[1]);
                int tokenCount = 2;
                while (tokenCount < tokens.length) {
                    result.values().add((Object)tokens[tokenCount]);
                    ++tokenCount;
                }
            } else {
                in.reset();
                result = null;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
        }
        return result;
    }

    public static boolean readRelations(Net target, BufferedReader in) throws PuckException {
        boolean result;
        try {
            in.mark(2048);
            IURTXTLabelsLine labelsLine = IURTXTFile.readLabelsLine(in);
            if (labelsLine == null) {
                result = false;
            } else if (labelsLine.size() != 1 || ((String)labelsLine.get(0)).equalsIgnoreCase("GEOGRAPHY") || ((String)labelsLine.get(0)).equalsIgnoreCase("FAMILY")) {
                logger.debug(labelsLine + ": This block is not a relation. Rewind");
                result = false;
                in.reset();
            } else {
                logger.debug("Relations loading...");
                String relationModelName = (String)labelsLine.get(0);
                RelationModel model = target.relationModels().getByName(relationModelName);
                if (model != null) {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Relation model [" + relationModelName + "] is defined twice.", new Object[0]);
                }
                model = new RelationModel(relationModelName);
                target.relationModels().add(model);
                logger.debug("Relation model=" + model.getName());
                labelsLine = IURTXTFile.readLabelsLine(in);
                if (labelsLine != null && labelsLine.size() > 1) {
                    int labelIndex = 2;
                    while (labelIndex < labelsLine.size()) {
                        String label = (String)labelsLine.get(labelIndex);
                        if (!label.startsWith("#") && !label.startsWith("$")) {
                            model.roles().add(new Role(label, 0));
                        }
                        ++labelIndex;
                    }
                    if (labelsLine != null && labelsLine.size() > 2) {
                        HashMap<Integer, Relation> relationTypedIdIndex = new HashMap<Integer, Relation>();
                        boolean ended = false;
                        while (!ended) {
                            IURTXTRelationLine source = IURTXTFile.readRelationLine(in);
                            if (source == null) {
                                ended = true;
                                continue;
                            }
                            if (source.id() == 0 || !StringUtils.isNotBlank((CharSequence)source.getName())) continue;
                            Relation relation = (Relation)relationTypedIdIndex.get(source.id());
                            if (relation == null) {
                                relation = target.createRelation(source.id(), source.getName(), model);
                                relationTypedIdIndex.put(source.id(), relation);
                            }
                            Actor lastActor = null;
                            int attributeCount = 0;
                            while (attributeCount < source.values().size()) {
                                String label = (String)labelsLine.get(attributeCount + 2);
                                String value = (String)source.values().get(attributeCount);
                                if (StringUtils.isNotBlank((CharSequence)value) && !label.toUpperCase().equals("ID")) {
                                    if (label.toUpperCase().equals("NAME") || label.toUpperCase().equals("#NAME")) {
                                        relation.setName(value);
                                    } else if (label.startsWith("#")) {
                                        relation.attributes().add(new Attribute(label.substring(1), value));
                                    } else if (label.startsWith("$")) {
                                        String trunkLabel = label.substring(1);
                                        if (lastActor == null) {
                                            logger.debug("line=[{}]", (Object)source.toString());
                                            throw PuckExceptions.BAD_FILE_FORMAT.create("actor missing in this line.", new Object[0]);
                                        }
                                        lastActor.setAttribute(trunkLabel, value);
                                        if (trunkLabel.equals("REF")) {
                                            Individual referent = (Individual)target.individuals().getById(Integer.parseInt(value));
                                            lastActor.setReferent(referent);
                                        }
                                    } else {
                                        String[] ids;
                                        String[] stringArray = ids = value.split("[ .,;]+");
                                        int n = ids.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String id = stringArray[n2];
                                            lastActor = target.createRelationActor(relation, Integer.parseInt(id), label);
                                            ++n2;
                                        }
                                    }
                                }
                                ++attributeCount;
                            }
                        }
                    }
                }
                logger.debug("Relations loaded.");
                result = true;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            throw PuckExceptions.IO_ERROR.create(exception, "Error on readRelation.", new Object[0]);
        }
        logger.debug("Done.");
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET_NAME));
                IURTXTFile.write(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
    }

    public static String toString(IURTXTFamilyLine source) {
        String result = source == null ? "[null]" : String.format("[id=%d][status=%c][fatherId=%d][motherId=%d][childIds=%s][attributeValues=%s]", source.getId(), Character.valueOf(source.getStatus()), source.getFatherId(), source.getMotherId(), source.getChildIds(), LogHelper.toString(source.attributeValues()));
        return result;
    }

    public static String toString(IURTXTIndividualLine source) {
        String result = source == null ? "[null]" : String.format("[id=%d][name=%s][gender=%c][attributeValues=%s]", source.getId(), source.getName(), Character.valueOf(source.getGender()), LogHelper.toString(source.attributeValues()));
        return result;
    }

    public static String toString(IURTXTLabelsLine source) {
        String result;
        if (source == null) {
            result = "[null]";
        } else {
            StringList buffer = new StringList();
            buffer.append("[");
            for (String label : source) {
                buffer.append(label);
                buffer.append(",");
            }
            buffer.removeLast();
            buffer.append("]");
            result = buffer.toString();
        }
        return result;
    }

    public static void write(PrintWriter out, IURTXTFamilyLine source) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(String.format("%d\t%c\t%d\t%d", source.getId(), Character.valueOf(source.getStatus()), source.getFatherId(), source.getMotherId()));
        buffer.append("\t");
        if (source.getChildIds() != null) {
            buffer.append(source.getChildIds());
        }
        for (String value : source.attributeValues()) {
            buffer.append("\t");
            buffer.append(value);
        }
        out.println(buffer.toString());
    }

    public static void write(PrintWriter out, IURTXTIndividualLine source) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(String.format("%d\t%s\t%c", source.getId(), source.getName(), Character.valueOf(source.getGender())));
        for (String value : source.attributeValues()) {
            buffer.append("\t");
            buffer.append(value);
        }
        out.println(buffer.toString());
    }

    public static void write(PrintWriter out, IURTXTLabelsLine source) {
        StringBuffer buffer = new StringBuffer(192);
        for (String value : source) {
            buffer.append(value);
            buffer.append("\t");
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        out.println(buffer.toString());
    }

    public static void write(PrintWriter out, IURTXTRelationLine source) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(String.format("%d\t%s", source.id(), source.getName()));
        for (String value : source.values()) {
            buffer.append("\t");
            buffer.append(value);
        }
        out.println(buffer.toString());
    }

    public static void write(PrintWriter out, Net source) throws PuckException {
        if (!source.attributes().isEmpty()) {
            IURTXTFile.writeCorpusAttributes(out, source.attributes());
        }
        IURTXTFile.writeIndividuals(out, source.individuals());
        IURTXTFile.writeFamilies(out, source.families());
        logger.debug("Write families blocks.");
        IURTXTFile.writeRelations(out, source.relationModels(), source.relations());
        if (source.getGeography2() != null) {
            logger.debug("Write geography block.");
            GEOTXTFile.writeGeography(out, source.getGeography2());
        }
    }

    public static void writeCorpusAttributes(PrintWriter out, Attributes source) {
        if (source != null && !source.isEmpty()) {
            logger.debug("Write corpus attributes block.");
            IURTXTLabelsLine labelsLine = new IURTXTLabelsLine();
            labelsLine.addAll(source.labels().sort());
            IURTXTFile.write(out, labelsLine);
            IURTXTLabelsLine valuesLine = new IURTXTLabelsLine();
            logger.debug("Write corpus attributes data.");
            for (String label : labelsLine) {
                String value = source.getValue(label);
                if (value == null) {
                    valuesLine.add("");
                    continue;
                }
                valuesLine.add(value.replace('\t', ' '));
            }
            IURTXTFile.write(out, valuesLine);
        }
        out.println();
    }

    public static void writeFamilies(PrintWriter out, Families source) throws PuckException {
        logger.debug("Write families block.");
        IURTXTLabelsLine labelsLine = new IURTXTLabelsLine();
        labelsLine.add("Id");
        labelsLine.add("Status");
        labelsLine.add("FatherId");
        labelsLine.add("MotherId");
        labelsLine.add("Children");
        labelsLine.add(HUSBAND_ORDER_LABEL);
        labelsLine.add(WIFE_ORDER_LABEL);
        labelsLine.addAll(source.getAttributeLabels().sort());
        IURTXTFile.write(out, labelsLine);
        logger.debug("Write families data.");
        for (Family family : source.toSortedList()) {
            char status;
            IURTXTFamilyLine target = new IURTXTFamilyLine();
            target.setId(family.getId());
            switch (family.getUnionStatus()) {
                case UNMARRIED: {
                    status = 'U';
                    break;
                }
                case MARRIED: {
                    status = 'M';
                    break;
                }
                case DIVORCED: {
                    status = 'D';
                    break;
                }
                default: {
                    throw PuckExceptions.INVALID_PARAMETER.create("Unknown union status code  [" + family.getUnionStatus().toString() + "]", new Object[0]);
                }
            }
            target.setStatus(status);
            if (family.getFather() == null) {
                target.setFatherId(0);
            } else {
                target.setFatherId(family.getFather().getId());
            }
            if (family.getMother() == null) {
                target.setMotherId(0);
            } else {
                target.setMotherId(family.getMother().getId());
            }
            StringList buffer = new StringList();
            for (Individual individual : family.getChildren()) {
                buffer.append(individual.getId());
                buffer.append(';');
            }
            buffer.removeLast();
            target.setChildIds(buffer.toString());
            String husbandOrderValue = family.getHusbandOrder() == null ? "" : String.valueOf(family.getHusbandOrder());
            target.attributeValues().add(husbandOrderValue);
            String wifeOrderValue = family.getWifeOrder() == null ? "" : String.valueOf(family.getWifeOrder());
            target.attributeValues().add(wifeOrderValue);
            if (!family.attributes().isEmpty()) {
                int labelCount = 7;
                while (labelCount < labelsLine.size()) {
                    String label = (String)labelsLine.get(labelCount);
                    String value = family.getAttributeValue(label);
                    if (value == null) {
                        target.attributeValues().add("");
                    } else {
                        target.attributeValues().add(value);
                    }
                    ++labelCount;
                }
            }
            IURTXTFile.write(out, target);
        }
        out.println();
    }

    public static void writeIndividuals(PrintWriter out, Individuals source) {
        logger.debug("Write individuals block.");
        IURTXTLabelsLine labelsLine = new IURTXTLabelsLine();
        labelsLine.add("Id");
        labelsLine.add("Name");
        labelsLine.add("Gender");
        labelsLine.add(BIRTH_ORDER_LABEL);
        labelsLine.addAll(source.getAttributeLabels().sort());
        IURTXTFile.write(out, labelsLine);
        logger.debug("Write individuals data.");
        for (Individual individual : source.toSortedList()) {
            IURTXTIndividualLine target = new IURTXTIndividualLine();
            target.setId(individual.getId());
            target.setName(individual.getName());
            target.setGender(individual.getGender().toChar());
            String birthOrderValue = individual.getBirthOrder() == null ? "" : String.valueOf(individual.getBirthOrder());
            target.attributeValues().add(birthOrderValue);
            if (!individual.attributes().isEmpty()) {
                int labelIndex = 4;
                while (labelIndex < labelsLine.size()) {
                    String label = (String)labelsLine.get(labelIndex);
                    String value = individual.getAttributeValue(label);
                    if (value == null) {
                        target.attributeValues().add("");
                    } else {
                        target.attributeValues().add(value.replace('\t', ' '));
                    }
                    ++labelIndex;
                }
            }
            IURTXTFile.write(out, target);
        }
        out.println();
    }

    public static void writeRelations(PrintWriter out, RelationModels models, Relations source) {
        for (RelationModel relationModel : models) {
            Relations relations = source.getByModel(relationModel);
            out.println(relationModel.getName());
            logger.debug("Find labels.");
            IURTXTLabelsLine labelsLine = new IURTXTLabelsLine();
            labelsLine.add("Id");
            labelsLine.add("Name");
            labelsLine.addAll(relationModel.roles().nameList());
            for (String attributeLabel : relations.getAttributeLabels().sort()) {
                labelsLine.add("#" + attributeLabel);
            }
            for (String attributeLabel : AttributeWorker.getExogenousAttributeDescriptors(relations.getActors()).labels()) {
                labelsLine.add("$" + attributeLabel);
            }
            IURTXTFile.write(out, labelsLine);
            if (!relations.isEmpty()) {
                for (Relation relation : relations.toSortedList()) {
                    IURTXTRelationLine target = new IURTXTRelationLine();
                    target.setId(relation.getTypedId());
                    target.setName(relation.getName());
                    for (Role role : relationModel.roles()) {
                        Actors actors = relation.actors().getByRole(role);
                        StringList buffer = new StringList();
                        for (Actor actor : actors.toSortedList()) {
                            if (!actor.attributes().isEmpty()) continue;
                            buffer.append(actor.getId());
                            buffer.append(';');
                        }
                        buffer.removeLast();
                        target.values().add((Object)buffer.toString());
                    }
                    if (!relation.attributes().isEmpty()) {
                        int labelCount = 2 + relationModel.roles().size();
                        while (labelCount < labelsLine.size()) {
                            String label = (String)labelsLine.get(labelCount);
                            if (label.startsWith("#")) {
                                String value = relation.getAttributeValue(label.substring(1));
                                if (value == null) {
                                    target.values().add((Object)"");
                                } else {
                                    target.values().add((Object)value.replace('\t', ' '));
                                }
                            } else {
                                target.values().add((Object)"");
                            }
                            ++labelCount;
                        }
                    }
                    IURTXTFile.write(out, target);
                    for (Actor actor : relation.actors().toSortedList()) {
                        if (actor.attributes().isEmpty()) continue;
                        IURTXTRelationLine target2 = new IURTXTRelationLine();
                        target2.setId(relation.getTypedId());
                        target2.setName(relation.getName());
                        for (Role role : relationModel.roles()) {
                            if (actor.getRole() == role) {
                                target2.values().add((Object)String.valueOf(actor.getId()));
                                continue;
                            }
                            target2.values().add((Object)"");
                        }
                        if (!relation.attributes().isEmpty()) {
                            int labelCount = 2 + relationModel.roles().size();
                            while (labelCount < labelsLine.size()) {
                                String label = (String)labelsLine.get(labelCount);
                                if (label.startsWith("#")) {
                                    target2.values().add((Object)"");
                                } else if (label.startsWith("$")) {
                                    String value = actor.getAttributeValue(label.substring(1));
                                    if (value == null) {
                                        target2.values().add((Object)"");
                                    } else {
                                        target2.values().add((Object)value.replace('\t', ' '));
                                    }
                                }
                                ++labelCount;
                            }
                        }
                        IURTXTFile.write(out, target2);
                    }
                }
            }
            out.println();
        }
    }
}

