/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.tip.puck.cli.Command;
import org.tip.puck.cli.EvoAlliance;
import org.tip.puck.cli.PruneAllianceGen;
import org.tip.puck.cli.RandomAllianceGen;
import org.tip.puck.cli.RunAllianceGen;
import org.tip.puck.cli.RunMAS;

public class CLI {
    private Options options;
    private CommandLine cline;

    private void printHelpMessage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("evo", this.options);
    }

    private void printErrorMessage(String msg) {
        System.err.println(msg);
        this.printHelpMessage();
    }

    public void run(String[] args) {
        GnuParser parser = new GnuParser();
        this.options = new Options();
        this.options.addOption("inet", true, "input net file");
        this.options.addOption("onet", true, "output net file");
        this.options.addOption("onet2", true, "second output net file");
        this.options.addOption("odir", true, "output directory");
        this.options.addOption("prg", true, "generator program file");
        this.options.addOption("oprg", true, "generator output program file");
        this.options.addOption("ocsv", true, "output csv file");
        this.options.addOption("sim", true, "kinship simulation config file");
        try {
            this.cline = parser.parse(this.options, args);
            String cmd = args[0];
            Command cmdObj = null;
            if (cmd.equals("help")) {
                this.printHelpMessage();
            } else if (cmd.equals("evo")) {
                cmdObj = new EvoAlliance();
            } else if (cmd.equals("prune")) {
                cmdObj = new PruneAllianceGen();
            } else if (cmd.equals("run")) {
                cmdObj = new RunAllianceGen();
            } else if (cmd.equals("random")) {
                cmdObj = new RandomAllianceGen();
            } else if (cmd.equals("mas")) {
                cmdObj = new RunMAS();
            } else {
                this.printErrorMessage("Command '" + cmd + "' does not exist.");
            }
            if (cmdObj != null && !((Command)cmdObj).run(this.cline)) {
                this.printErrorMessage(cmdObj.getErrorMessage());
            }
        }
        catch (ParseException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "unkown error";
            }
            this.printErrorMessage(msg);
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        new CLI().run(args);
    }
}

