/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.ChainFinder;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.partitions.Partition;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.util.NumberablesHashMap;

public class Sequences
extends NumberablesHashMap<Sequence> {
    String label;

    public String getLabel() {
        return this.label;
    }

    public Sequence getByEgo(Individual ego) {
        Sequence result = null;
        for (Sequence sequence : this) {
            if (sequence.getEgo() != ego) continue;
            result = sequence;
            break;
        }
        return result;
    }

    public Individuals egos() {
        Individuals result = new Individuals();
        for (Sequence sequence : this) {
            result.put(sequence.getEgo());
        }
        return result;
    }

    public Sequence getByEgoId(int egoId) {
        Sequence result = null;
        for (Sequence sequence : this) {
            if (sequence.getEgo() == null || sequence.getEgo().getId() != egoId) continue;
            result = sequence;
            break;
        }
        return result;
    }

    public Partition<Chain> getChildHostKinshipChains(int maxDepth, int maxOrder, String chainClassification) {
        Partition<Chain> result = new Partition<Chain>();
        for (Sequence sequence : this) {
            for (Relation event : sequence.childMigrationsWithoutParents()) {
                for (Individual host : event.getIndividuals("HOST")) {
                    Partition<Chain> chains = ChainFinder.findChains(sequence.getEgo(), host, maxDepth, maxOrder, chainClassification);
                    if (chains.size() == 0) {
                        result.put(new Chain(sequence.getEgo(), host), null);
                        continue;
                    }
                    result.add(chains);
                }
            }
        }
        return result;
    }

    public void addRenumbered(Sequence sequence) {
        sequence.setId(this.size());
        this.add(sequence);
    }

    public int getNrEvents() {
        int result = 0;
        for (Sequence sequence : this) {
            result += sequence.getEvents().size();
        }
        return result;
    }
}

