/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.KinType;

public class MemoryCriteria {
    private int nrInformants;
    private double[][][][] memoryProbs = new double[2][2][3][2];
    private double distanceFactor;
    private double maleAcceptance;
    private double femaleAcceptance;
    private FiliationType distanceType;
    private int maxDistance;
    private double distanceWeight;

    public double getDistanceWeight() {
        return this.distanceWeight;
    }

    public void setDistanceWeight(double distanceWeight) {
        this.distanceWeight = distanceWeight;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(int maxDistance) {
        this.maxDistance = maxDistance;
    }

    public FiliationType getDistanceType() {
        return this.distanceType;
    }

    public void setDistanceType(FiliationType distanceType) {
        this.distanceType = distanceType;
    }

    public MemoryCriteria() {
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                int k = 0;
                while (k < 3) {
                    int l = 0;
                    while (l < 2) {
                        this.memoryProbs[i][j][k][l] = 1.0;
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.nrInformants = 100;
        this.distanceFactor = 1.0;
        this.maleAcceptance = 1.0;
        this.femaleAcceptance = 1.0;
        this.maxDistance = 0;
        this.distanceWeight = 1.0;
    }

    private int genderToInt(Gender gender) {
        switch (gender) {
            case MALE: {
                return 0;
            }
            case FEMALE: {
                return 1;
            }
        }
        return -1;
    }

    private int kinTypeToInt(KinType kinType) {
        switch (kinType) {
            case PARENT: {
                return 0;
            }
            case CHILD: {
                return 1;
            }
            case SPOUSE: {
                return 2;
            }
        }
        return -1;
    }

    private static Gender intToGender(int val) {
        switch (val) {
            case 0: {
                return Gender.MALE;
            }
            case 1: {
                return Gender.FEMALE;
            }
        }
        return Gender.UNKNOWN;
    }

    private static KinType intToKinType(int val) {
        switch (val) {
            case 0: {
                return KinType.PARENT;
            }
            case 1: {
                return KinType.CHILD;
            }
            case 2: {
                return KinType.SPOUSE;
            }
        }
        return KinType.UNKNOWN;
    }

    public static String describe(int ego, int alter, int ktype, int informant) {
        Gender egoGender = MemoryCriteria.intToGender(ego);
        Gender alterGender = MemoryCriteria.intToGender(alter);
        KinType kinType = MemoryCriteria.intToKinType(ktype);
        Gender informantGender = MemoryCriteria.intToGender(informant);
        String desc = "";
        switch (egoGender) {
            case MALE: {
                desc = String.valueOf(desc) + "man's ";
                break;
            }
            case FEMALE: {
                desc = String.valueOf(desc) + "woman's ";
            }
        }
        switch (kinType) {
            case PARENT: {
                desc = String.valueOf(desc) + "parent(";
                break;
            }
            case CHILD: {
                desc = String.valueOf(desc) + "child(";
                break;
            }
            case SPOUSE: {
                desc = String.valueOf(desc) + "spouse(";
            }
        }
        switch (alterGender) {
            case MALE: {
                desc = String.valueOf(desc) + "male)";
                break;
            }
            case FEMALE: {
                desc = String.valueOf(desc) + "female)";
            }
        }
        switch (informantGender) {
            case MALE: {
                desc = String.valueOf(desc) + ": male informant";
                break;
            }
            case FEMALE: {
                desc = String.valueOf(desc) + ": female informant";
            }
        }
        return desc;
    }

    public double getMemory(Gender egoGender, Gender alterGender, KinType kinType, Gender informantGender) {
        int i = this.genderToInt(egoGender);
        int j = this.genderToInt(alterGender);
        int k = this.kinTypeToInt(kinType);
        int l = this.genderToInt(informantGender);
        return this.memoryProbs[i][j][k][l];
    }

    public double getMemory(int egoGender, int alterGender, int kinType, int informantGender) {
        return this.memoryProbs[egoGender][alterGender][kinType][informantGender];
    }

    public void setMemoryProb(Gender egoGender, Gender alterGender, KinType kinType, Gender informantGender, double prob) {
        int i1 = this.genderToInt(egoGender);
        int j1 = this.genderToInt(alterGender);
        int k1 = this.kinTypeToInt(kinType);
        int l1 = this.genderToInt(informantGender);
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                int k = 0;
                while (k < 3) {
                    int l = 0;
                    while (l < 2) {
                        if (!(i1 >= 0 && i != i1 || j1 >= 0 && j != j1 || k1 >= 0 && k != k1 || l1 >= 0 && l != l1)) {
                            this.memoryProbs[i][j][k][l] = prob;
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public double getDistanceFactor() {
        return this.distanceFactor;
    }

    public void setDistanceFactor(double distanceFactor) {
        this.distanceFactor = distanceFactor;
    }

    public int getNrInformants() {
        return this.nrInformants;
    }

    public void setNrInformants(int nrInformants) {
        this.nrInformants = nrInformants;
    }

    public double getMaleAcceptance() {
        return this.maleAcceptance;
    }

    public double getFemaleAcceptance() {
        return this.femaleAcceptance;
    }

    public void setMaleAcceptance(double maleAcceptance) {
        this.maleAcceptance = maleAcceptance;
    }

    public void setFemaleAcceptance(double femaleAcceptance) {
        this.femaleAcceptance = femaleAcceptance;
    }
}

