/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.Arrays;
import org.tip.puck.net.Individual;
import org.tip.puck.net.KinType;

public class KinLink {
    private Individual source;
    private Individual target;
    private KinType type;

    private KinLink() {
    }

    public KinLink(Individual v, Individual w, KinType kinType, boolean sym) {
        if (sym || v.getId() < w.getId()) {
            this.source = v;
            this.target = w;
            this.type = kinType;
        } else {
            this.source = w;
            this.target = v;
            this.type = kinType.inverse();
        }
    }

    public boolean equals(Object o) {
        return Arrays.equals(this.getKey(), ((KinLink)o).getKey());
    }

    public Individual getTarget() {
        return this.target;
    }

    public Individual getSource() {
        return this.source;
    }

    private int[] getKey() {
        int[] key = new int[]{this.source.getId(), this.target.getId()};
        return key;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getKey());
    }

    private KinLink inverse() {
        KinLink e = new KinLink();
        e.source = this.target;
        e.target = this.source;
        e.type = this.invType();
        return e;
    }

    public KinLink inverse(Individual v) {
        if (v == this.target) {
            return this.inverse();
        }
        return this;
    }

    private KinType invType() {
        KinType result;
        switch (this.type) {
            case SPOUSE: {
                result = KinType.SPOUSE;
                break;
            }
            case CHILD: {
                result = KinType.PARENT;
                break;
            }
            case PARENT: {
                result = KinType.CHILD;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public KinType getType() {
        return this.type;
    }
}

