/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.roles.RoleDefinition;
import org.tip.puck.net.relations.roles.RoleDefinitions;
import org.tip.puck.net.relations.roles.RoleRelationMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportTXTFile;

public class RoleRelationsTXTFile {
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 1024;
    private static final Logger logger = LoggerFactory.getLogger(ReportTXTFile.class);

    public static Report save(File file, RelationModel source) throws PuckException {
        Report result;
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET_NAME));
                result = RoleRelationsTXTFile.write(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return result;
    }

    public static Report write(PrintWriter out, RelationModel source) throws PuckException {
        Report result = new Report("Export log");
        RoleDefinitions definitions = RoleRelationMaker.createRoleDefinitions(source.getRoleRelations(), source.getRules(), result);
        RoleRelationMaker.compareDefinitions(source.getRoleRelations().getOriginalDefinitions(), definitions, source.getRoleRelations(), result);
        for (RoleDefinition definition : definitions.toSortedList()) {
            out.println(definition.toString());
        }
        return result;
    }

    public static StringList load(File file, String charsetName) throws PuckException {
        StringList result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = RoleRelationsTXTFile.read(in);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static StringList read(BufferedReader in) throws PuckException {
        StringList result = new StringList();
        boolean ended = false;
        while (!ended) {
            String source = RoleRelationsTXTFile.readNotEmptyLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            result.append(source);
        }
        return result;
    }

    public static String readNotEmptyLine(BufferedReader in) throws PuckException {
        String result;
        try {
            boolean ended = false;
            result = null;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    result = null;
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                ended = true;
                result = line;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
        }
        return result;
    }
}

