/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tip.puck.net.AlterAge;
import org.tip.puck.net.Gender;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.roles.MetaRole;
import org.tip.puck.net.relations.roles.RoleActor;
import org.tip.puck.net.relations.roles.RoleDefinition;

public class RoleDefinitions
extends ArrayList<RoleDefinition> {
    private static final long serialVersionUID = 1L;

    private static boolean neutralEquals(RoleDefinition alpha, RoleDefinition beta) {
        return alpha.getSelfTerm().equals(beta.getSelfTerm()) && alpha.getRoleName().equals(beta.getRoleName()) && alpha.getAlterTerm().equals(beta.getAlterTerm()) && alpha.getAlterGender() == beta.getAlterGender() && alpha.getAlterAge() == beta.getAlterAge();
    }

    public RoleDefinitions get(String letters, Gender egoGender) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition definition : this) {
            if (!definition.getLetters().equals(letters) || definition.getEgoGender() != egoGender) continue;
            result.add(definition);
        }
        if (result.isEmpty() && !egoGender.isUnknown()) {
            for (RoleDefinition definition : this) {
                if (!definition.getLetters().equals(letters) || !egoGender.specifies(definition.getEgoGender())) continue;
                result.add(definition);
            }
        }
        if (result.isEmpty() && egoGender.isUnknown()) {
            for (RoleDefinition definition : this) {
                if (!definition.getLetters().equals(letters) || !definition.getEgoGender().specifies(egoGender)) continue;
                result.add(definition);
            }
        }
        return result;
    }

    private RoleDefinition getBySelfAndGeneratorTerm(Role selfTerm, Role generatorTerm, Map<String, RoleActor> elementaryTerms, StringList subReport) {
        RoleDefinition result = null;
        RoleActor generator = elementaryTerms.get(generatorTerm.toString());
        if (generator != null) {
            RoleDefinitions definitions = this.getBySelfTermAndRole(selfTerm, generator.getRole());
            if (!definitions.isEmpty()) {
                result = (RoleDefinition)definitions.get(0);
            } else {
                subReport.appendln("No term defined as " + generator.getRole() + " of " + selfTerm);
            }
        } else {
            subReport.appendln("No term defined as " + generatorTerm + " of " + selfTerm);
        }
        return result;
    }

    private RoleDefinitions getBySelfTermAndRole(Role selfTerm, MetaRole metaRole) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition definition : this) {
            if (!definition.getSelfTerm().equals(selfTerm) || !definition.getAlter().getRole().matches(metaRole)) continue;
            result.add(definition);
        }
        return result;
    }

    RoleDefinition reinvert(RoleActor alter, Role inverseTerm, Map<String, RoleActor> elementaryTerms, StringList subReport) {
        RoleDefinition result = null;
        Role selfTerm = new Role(alter.getSelfName());
        RoleActor inverse = elementaryTerms.get(inverseTerm);
        if (inverse != null) {
            result = new RoleDefinition(selfTerm, alter.cloneAs(inverse.getRole().getName()));
            subReport.appendln(String.valueOf(alter.getName()) + " defined as " + inverse.getRole() + " of " + selfTerm);
        } else {
            RoleDefinitions inverseTermDefinitions = this.getByAlterTerm(inverseTerm);
            if (!inverseTermDefinitions.isEmpty()) {
                RoleDefinition inverseTermDefinition = (RoleDefinition)inverseTermDefinitions.get(0);
                Role mediusSelfTerm = inverseTermDefinition.getSelfTerm();
                MetaRole mediusAlterRole = inverseTermDefinition.getRole();
                MetaRole inverseMediusAlterRole = new MetaRole(mediusAlterRole.invertName(), mediusAlterRole.getAlterGender(), mediusAlterRole.getEgoGender(), mediusAlterRole.getAlterAge().invert());
                RoleDefinitions mediusDefinitions = this.getBySelfTermAndRole(selfTerm, inverseMediusAlterRole);
                if (!mediusDefinitions.isEmpty()) {
                    Role inverseMediusAlterTerm = ((RoleDefinition)mediusDefinitions.get(0)).getAlterTerm();
                    RoleActor mediusSelf = elementaryTerms.get(mediusSelfTerm.toString());
                    if (mediusSelf != null) {
                        RoleActor inverseMediusSelf = alter.cloneAs(mediusSelf.getRole().invertName());
                        result = new RoleDefinition(inverseMediusAlterTerm, inverseMediusSelf);
                        subReport.appendln(String.valueOf(alter.getName()) + " defined as " + inverseMediusSelf.getRole() + " of " + inverseMediusAlterTerm + " ... " + alter);
                    } else {
                        subReport.appendln("No term defined as inverse of " + mediusSelfTerm);
                    }
                } else {
                    subReport.appendln("No term defined as " + inverseMediusAlterRole + " of " + selfTerm);
                }
            }
        }
        return result;
    }

    RoleDefinition recompose(Role selfTerm, Role alterTerm, Role generatorTerm, Map<String, RoleActor> elementaryTerms, StringList subReport) {
        RoleDefinition result = null;
        RoleActor generator = elementaryTerms.get(generatorTerm.toString());
        if (generator != null) {
            result = new RoleDefinition(selfTerm, new RoleActor(alterTerm, generator.getRole(), alterTerm.getSelfName()));
            subReport.appendln(alterTerm + " defined as " + generator.getRole() + " of " + selfTerm);
        } else {
            RoleDefinitions generatorDefinitions = this.getByAlterTerm(generatorTerm);
            if (!generatorDefinitions.isEmpty()) {
                RoleDefinition generatorDefinition = (RoleDefinition)generatorDefinitions.get(0);
                Role mediusTerm = generatorDefinition.getSelfTerm();
                RoleActor elementaryGenerator = generatorDefinition.getAlter();
                RoleDefinition mediusDefinition = this.getBySelfAndGeneratorTerm(selfTerm, mediusTerm, elementaryTerms, subReport);
                if (mediusDefinition != null) {
                    result = new RoleDefinition(mediusDefinition.getAlterTerm(), new RoleActor(alterTerm, elementaryGenerator.getRole(), alterTerm.getSelfName()));
                    subReport.appendln(alterTerm + " defined as " + elementaryGenerator.getRole() + " of " + mediusDefinition.getAlterTerm());
                }
            } else {
                subReport.appendln("Undefined generator term " + generatorTerm);
            }
        }
        return result;
    }

    public RoleDefinitions getByAlter(RoleActor alter) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition definition : this) {
            if (!definition.getAlter().equals(alter)) continue;
            result.add(definition);
        }
        return result;
    }

    public RoleDefinitions getBySelfTerm(Role selfTerm) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition definition : this) {
            if (!definition.getSelfTerm().equals(selfTerm)) continue;
            result.add(definition);
        }
        return result;
    }

    public RoleDefinitions getByAlterTerm(Role alterTerm) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition definition : this) {
            if (!definition.getAlterTerm().equals(alterTerm)) continue;
            result.add(definition);
        }
        return result;
    }

    public List<RoleDefinition> toSortedList() {
        ArrayList<RoleDefinition> result = new ArrayList<RoleDefinition>(this);
        Collections.sort(result);
        return result;
    }

    public void put(RoleDefinition definition) {
        boolean addable = true;
        for (RoleDefinition otherDefinition : this.toSortedList()) {
            if (!RoleDefinitions.neutralEquals(definition, otherDefinition)) continue;
            addable = false;
            if (otherDefinition.getEgoGender().isUnknown()) continue;
            if (definition.getEgoGender().isUnknown()) {
                this.remove(otherDefinition);
                this.addNew(definition);
                continue;
            }
            if (definition.getEgoGender() == otherDefinition.getEgoGender()) continue;
            this.remove(otherDefinition);
            RoleDefinition newDefinition = definition.clone();
            newDefinition.getAlter().getRole().setEgoGender(Gender.UNKNOWN);
            this.addNew(newDefinition);
        }
        if (addable) {
            this.add(definition);
        }
    }

    public boolean addNew(RoleDefinition definition) {
        boolean result = this.contains(definition) ? false : this.add(definition);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.toString().equals(((RoleDefinition)other).toString());
    }

    public boolean hasAlter(Role alterRole) {
        boolean result = false;
        for (RoleDefinition definition : this) {
            if (!definition.getAlter().getIndividual().equals(alterRole)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasAlterWithGender(Role alterRole, Gender gender) {
        boolean result = false;
        for (RoleDefinition definition : this) {
            if (!definition.getAlter().getIndividual().equals(alterRole) || definition.getAlter().getRole().getAlterGender() != gender) continue;
            result = true;
            break;
        }
        return result;
    }

    public RoleDefinitions compress() {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition definition : this) {
            boolean addable = true;
            for (RoleDefinition other : result.toSortedList()) {
                if (definition.specifies(other)) {
                    addable = false;
                    break;
                }
                if (other.specifies(definition)) {
                    result.remove(other);
                    continue;
                }
                if (other.isEgoGenderComplement(definition)) {
                    result.remove(other);
                    result.put(definition.cloneWithEgoGender(Gender.UNKNOWN));
                    addable = false;
                    break;
                }
                if (other.isAlterGenderComplement(definition)) {
                    result.remove(other);
                    result.put(definition.cloneWithAlterGender(Gender.UNKNOWN));
                    addable = false;
                    break;
                }
                if (!other.isAlterAgeComplement(definition)) continue;
                result.remove(other);
                result.put(definition.cloneWithAlterAge(AlterAge.UNKNOWN));
                addable = false;
                break;
            }
            if (!addable) continue;
            result.put(definition);
        }
        return result;
    }

    @Override
    public String toString() {
        String result = "";
        String separator = "";
        for (RoleDefinition definition : this) {
            if (!result.equals("")) {
                separator = ";";
            }
            result = String.valueOf(result) + separator + definition.getAlter() + " [" + definition.getSelfTerm() + "]";
        }
        return result;
    }

    public StringList toSortedStringList() {
        StringList result = new StringList();
        for (RoleDefinition definition : this) {
            result.append(definition.toString());
        }
        Collections.sort(result);
        return result;
    }
}

