/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import org.tip.puck.util.Numberable;

public class Role
implements Comparable<Role>,
Numberable {
    protected String name;
    protected int defaultCardinality;
    protected int id;
    String selfName;

    public Role() {
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String hashKey() {
        String result = String.valueOf(this.name) + this.id;
        return result;
    }

    public Role(Role role) {
        if (role == null) {
            this.name = "";
            this.defaultCardinality = 0;
        } else {
            this.name = role.getName();
            this.defaultCardinality = role.getDefaultCardinality();
        }
    }

    public Role clone() {
        return new Role(this);
    }

    public Role(String name) {
        this.name = name;
        this.defaultCardinality = 0;
    }

    public Role(String name, int defaultCardinality) {
        this.name = name;
        this.defaultCardinality = defaultCardinality;
    }

    public boolean equals(Object role) {
        boolean result = role != null && this.name.equals(((Role)role).name);
        return result;
    }

    public static boolean equalOrBothNull(Role alpha, Role beta) {
        return alpha == null && beta == null || alpha != null && alpha.equals(beta);
    }

    public int getDefaultCardinality() {
        return this.defaultCardinality;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasName(String name) {
        return this.name != null && this.name.equals(name);
    }

    public void setDefaultCardinality(int defaultCardinality) {
        this.defaultCardinality = defaultCardinality;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Role other) {
        int result = other == null || this.name == null || other.name == null ? 0 : (this.hasName(this.selfName) && !other.hasName(this.selfName) ? -1 : (!this.hasName(this.selfName) && other.hasName(this.selfName) ? 1 : this.name.compareTo(other.name)));
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getSelfName() {
        return this.selfName;
    }

    public boolean hasSelfName() {
        return this.name.equals(this.selfName);
    }

    public void setSelfName(String selfName) {
        this.selfName = selfName;
    }
}

