/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.mas;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.tip.puck.mas.Agent;
import org.tip.puck.mas.MASConfig;
import org.tip.puck.mas.WeightFactor;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;

public class MAS {
    private Vector<Agent> livingAgents = new Vector();
    private Vector<Agent> livingMen = new Vector();
    private Vector<Agent> livingWomen = new Vector();
    private Vector<Agent> allAgents = new Vector();
    private Vector<Family> currentMarriages = new Vector();
    private Vector<Family> allMarriages = new Vector();
    private List<WeightFactor> weightFactors = new LinkedList<WeightFactor>();
    private Random randGen = new Random();
    private int curId = 1;
    private int curFamilyId = 0;
    private int curCycle = 0;
    private int years;
    private int initialPopulation;
    private int maxAge;
    private double fertilityRate;
    private int cousin1Marriages = 0;
    private int agnaticCousin1Marriages = 0;
    private int uterineCousin1Marriages = 0;
    private double cousins = 0.0;
    private int samples = -1;
    private Agent[] mothers;
    private Agent[] fathers;
    private double[] weights;

    public void addFactor(WeightFactor factor) {
        this.weightFactors.add(factor);
    }

    public WeightFactor getFactor(String factorName) {
        WeightFactor result = null;
        for (WeightFactor factor : this.weightFactors) {
            if (!factor.factorName().equals(factorName)) continue;
            result = factor;
            break;
        }
        return result;
    }

    private boolean testProb(double p) {
        if (p <= 0.0) {
            return false;
        }
        if (p >= 1.0) {
            return true;
        }
        double r = this.randGen.nextDouble();
        return r <= p;
    }

    public void initializePopulation(int size) {
        int i = 0;
        while (i < size) {
            Agent a = this.birth(null, null);
            a.setBirth(-this.randGen.nextInt(this.maxAge));
            ++i;
        }
    }

    public void run() {
        this.curCycle = 0;
        this.initializePopulation(this.initialPopulation);
        int i = 0;
        while (i < this.years) {
            this.cycle();
            ++this.curCycle;
            ++i;
        }
    }

    private Agent birth(Agent mother, Agent father) {
        if (mother != null && father != null && !mother.isPartnerOf(father)) {
            if (mother.getCurrentMarriage() != null) {
                this.divorce(mother);
            }
            if (father.getCurrentMarriage() != null) {
                this.divorce((Agent)father.getCurrentMarriage().getWife());
            }
            this.marriage(father, mother);
        }
        Gender gender = Gender.MALE;
        if (this.testProb(0.5)) {
            gender = Gender.FEMALE;
        }
        Family origFamily = null;
        if (mother != null) {
            origFamily = mother.getCurrentMarriage();
        }
        Agent child = new Agent(this, this.curId++, gender, this.curCycle, origFamily);
        this.livingAgents.add(child);
        this.allAgents.add(child);
        if (gender.isMale()) {
            this.livingMen.add(child);
        } else if (gender.isFemale()) {
            this.livingWomen.add(child);
        }
        if (mother != null) {
            mother.getCurrentMarriage().getChildren().add(child);
        }
        if (mother != null) {
            mother.setTimeOfLastChildBirth(this.curCycle);
        }
        if (father != null) {
            father.setTimeOfLastChildBirth(this.curCycle);
        }
        child.updateCousins();
        return child;
    }

    private void marriage(Agent husband, Agent wife) {
        Family marriage = new Family(this.curFamilyId++, husband, wife);
        marriage.setMarried(true);
        this.currentMarriages.add(marriage);
        this.allMarriages.add(marriage);
        husband.setCurrentMarriage(marriage);
        wife.setCurrentMarriage(marriage);
        husband.addPersonalFamily(marriage);
        wife.addPersonalFamily(marriage);
        husband.addPartner(wife);
        wife.addPartner(husband);
        if (husband.hasCousin(wife, 1)) {
            ++this.cousin1Marriages;
            husband.setAttribute("COUSINMARRIAGE", String.valueOf(wife.getId()));
            wife.setAttribute("COUSINMARRIAGE", String.valueOf(husband.getId()));
            marriage.setAttribute("COUSINMARRIAGE", "true");
        }
        if (husband.hasAgnaticCousin(wife, 1)) {
            ++this.agnaticCousin1Marriages;
        }
        if (husband.hasUterineCousin(wife, 1)) {
            ++this.uterineCousin1Marriages;
        }
    }

    private void divorce(Agent wife) {
        this.endMarriage((Agent)wife.getCurrentMarriage().getHusband());
        this.endMarriage(wife);
    }

    private void endMarriage(Agent agent) {
        if (agent.getCurrentMarriage() != null) {
            this.currentMarriages.remove(agent.getCurrentMarriage());
            if (agent.isMale()) {
                Agent wife = (Agent)agent.getCurrentMarriage().getWife();
                wife.setCurrentMarriage(null);
            } else if (agent.isFemale()) {
                Agent husband = (Agent)agent.getCurrentMarriage().getHusband();
                husband.setCurrentMarriage(null);
            }
            agent.setCurrentMarriage(null);
        }
    }

    private void death(Agent agent) {
        this.endMarriage(agent);
        if (agent.isMale()) {
            this.livingMen.remove(agent);
        } else if (agent.isFemale()) {
            this.livingWomen.remove(agent);
        }
        this.livingAgents.remove(agent);
        this.cousins += (double)agent.firstCousins().size();
        agent.die();
    }

    private double computeWeight(Agent mother, Agent father) {
        double weight = 1.0;
        for (WeightFactor factor : this.weightFactors) {
            weight *= factor.factor(mother, father);
        }
        return weight;
    }

    private void generateBirth() {
        double totalWeight = 0.0;
        int i = 0;
        while (i < this.samples) {
            Agent mother = null;
            Agent father = null;
            while (mother == null || this.isIncest(mother, father)) {
                int indexMother = this.randGen.nextInt(this.livingWomen.size());
                int indexFather = this.randGen.nextInt(this.livingMen.size());
                mother = this.livingWomen.get(indexMother);
                father = this.livingMen.get(indexFather);
            }
            double weight = this.computeWeight(mother, father);
            totalWeight += weight;
            this.mothers[i] = mother;
            this.fathers[i] = father;
            this.weights[i] = weight;
            ++i;
        }
        double pos = this.randGen.nextDouble() * totalWeight;
        totalWeight = 0.0;
        int i2 = 0;
        while (i2 < this.samples) {
            Agent mother = this.mothers[i2];
            Agent father = this.fathers[i2];
            if ((totalWeight += this.weights[i2]) > pos) {
                this.birth(mother, father);
                return;
            }
            ++i2;
        }
    }

    private void cycle() {
        double pop = this.livingAgents.size();
        double birthsPerYear = pop / 2.0 * (1.0 / (double)this.maxAge) * this.fertilityRate;
        double bpyInteger = Math.floor(birthsPerYear);
        double bpyFrac = birthsPerYear - bpyInteger;
        int birthsThisYear = (int)bpyInteger;
        if (this.testProb(bpyFrac)) {
            ++birthsThisYear;
        }
        int i = 0;
        while (i < birthsThisYear) {
            this.generateBirth();
            ++i;
        }
        LinkedList<Agent> deathList = new LinkedList<Agent>();
        for (Agent a : this.livingAgents) {
            if (a.getAge() < this.maxAge) continue;
            deathList.add(a);
        }
        for (Agent a : deathList) {
            this.death(a);
        }
    }

    private boolean isIncest(Agent mother, Agent father) {
        if (father.getMother() == mother) {
            return true;
        }
        if (mother.getFather() == father) {
            return true;
        }
        if (mother.getFather() == father.getFather() && mother.getFather() != null) {
            return true;
        }
        if (mother.getMother() == father.getMother() && mother.getMother() != null) {
            return true;
        }
        if (father.getFather() != null && father.getFather().getMother() == mother) {
            return true;
        }
        if (father.getMother() != null && father.getMother().getMother() == mother) {
            return true;
        }
        if (mother.getFather() != null && mother.getFather().getFather() == father) {
            return true;
        }
        return mother.getMother() != null && mother.getMother().getFather() == father;
    }

    public void writeDemographicData(String filePath) {
        try {
            FileWriter outFile = new FileWriter(filePath);
            PrintWriter out = new PrintWriter(outFile);
            out.println("id, mother_age, father_age");
            for (Agent agent : this.allAgents) {
                out.println(String.format("%d,%d,%d", agent.getId(), agent.getAgeOfMotherAtBirth(), agent.getAgeOfFatherAtBirth()));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getCurCycle() {
        return this.curCycle;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public double getFertilityRate() {
        return this.fertilityRate;
    }

    public void setFertilityRate(double fertilityRate) {
        this.fertilityRate = fertilityRate;
    }

    public Net toNet() {
        Net net = new Net();
        for (Individual individual : this.allAgents) {
            ((Agent)individual).setAttributes();
            net.individuals().put(individual);
        }
        for (Family family : this.allMarriages) {
            Family family2 = net.families().getBySpouses(family.getHusband(), family.getWife());
            if (family2 != null) {
                family2.getChildren().add(family.getChildren());
                continue;
            }
            net.families().put(family);
        }
        return net;
    }

    public String toString() {
        String str = "years: " + this.years + "\n";
        str = String.valueOf(str) + "initial population: " + this.initialPopulation + "\n";
        str = String.valueOf(str) + "fertility rate: " + this.fertilityRate + "\n";
        str = String.valueOf(str) + "max age: " + this.maxAge + "\n";
        str = String.valueOf(str) + "samples: " + this.samples + "\n";
        return str;
    }

    public Vector<Agent> getAllAgents() {
        return this.allAgents;
    }

    public int getYears() {
        return this.years;
    }

    public void setYears(int years) {
        this.years = years;
    }

    public int getInitialPopulation() {
        return this.initialPopulation;
    }

    public void setInitialPopulation(int initalPopulation) {
        this.initialPopulation = initalPopulation;
    }

    public double calcMeanSiblings() {
        double sum = 0.0;
        double count = 0.0;
        for (Agent a : this.allAgents) {
            sum += (double)a.calcNumberOfSiblings();
            count += 1.0;
        }
        return sum / count;
    }

    public double calcMeanFullSiblings() {
        double sum = 0.0;
        double count = 0.0;
        for (Agent a : this.allAgents) {
            sum += (double)a.calcNumberOfFullSiblings();
            count += 1.0;
        }
        return sum / count;
    }

    public int getSamples() {
        return this.samples;
    }

    public void setSamples(int samples) {
        this.samples = samples;
        if (samples > 0) {
            this.mothers = new Agent[samples];
            this.fathers = new Agent[samples];
            this.weights = new double[samples];
        }
    }

    public static void main(String[] args) {
        MASConfig config = new MASConfig();
        config.fromFile("experiments/mas/example.txt");
        MAS mas = config.getMas();
        System.out.println(mas);
        mas.run();
        System.out.println("\n\nall marriages: " + mas.allMarriages.size());
        System.out.println("cousin1Marriages: " + mas.cousin1Marriages);
        System.out.println("agnaticCousin1Marriages: " + mas.agnaticCousin1Marriages);
        System.out.println("uterineCousin1Marriages: " + mas.uterineCousin1Marriages);
        System.out.println("meanSiblings: " + mas.calcMeanSiblings());
        System.out.println("meanFullSiblings: " + mas.calcMeanFullSiblings());
        System.out.println("meanCousins: " + mas.cousins / (double)mas.allAgents.size());
    }
}

