/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.iurtxts;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckgui.util.GenericFileFilter;

public class ImportIURTXTSFileSelector
extends JFileChooser {
    private static final long serialVersionUID = -8964093490968127709L;
    private static final Logger logger = LoggerFactory.getLogger(ImportIURTXTSFileSelector.class);

    public ImportIURTXTSFileSelector(File sourceDirectory) {
        File targetDirectory = sourceDirectory == null ? null : (sourceDirectory.isDirectory() ? sourceDirectory : sourceDirectory.getParentFile());
        this.setCurrentDirectory(targetDirectory);
        this.setDialogTitle("Import from IURTXTS format");
        this.setFileSelectionMode(0);
        this.setAcceptAllFileFilterUsed(false);
        this.setApproveButtonText("Import");
        this.setDialogType(2);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("IUR TXT Splitted files (*.iurs.txt)", "iurs.txt");
        this.addChoosableFileFilter(defaultFileFilter);
        this.setFileFilter(defaultFileFilter);
    }

    @Override
    public void cancelSelection() {
        logger.debug("Cancel selection.");
        super.cancelSelection();
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
        System.out.println("==== SET SELECTED FILE=================");
        System.out.println("SELECED FILE " + file);
    }

    public static File showSelectorDialog(Component parent, File targetFile) {
        File result;
        ImportIURTXTSFileSelector selector = new ImportIURTXTSFileSelector(targetFile);
        if (selector.showDialog(parent, null) == 0) {
            logger.debug("getCurrentDirectory(): {}", (Object)selector.getCurrentDirectory());
            logger.debug("getSelectedFile() : {}", (Object)selector.getSelectedFile());
            result = selector.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }
}

