/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.report.Report;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puckgui.NetGUI;

public class HomonymReportInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(HomonymReportInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private NetGUI netGUI;
    private JPanel contentPane;
    private static int lastNrPartsValue = 0;
    private static int lastMaxCountValue = 1;
    private JSpinner spinnerNumberOfNameParts;
    private JSpinner spinnerMinimalNumberOfNames;

    public HomonymReportInputWindow(final NetGUI netGUI) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(HomonymReportInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.netGUI = netGUI;
        this.setTitle("List Homonyms");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 365, 200);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblNameparts = new JLabel("<html><div style=\"text-align:right\">Name parts<br/>(0 = Full name) </div></html>");
        panel.add((Component)lblNameparts, "2, 4, right, default");
        this.spinnerNumberOfNameParts = new JSpinner();
        this.spinnerNumberOfNameParts.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        panel.add((Component)this.spinnerNumberOfNameParts, "4, 4");
        JLabel lblMinimalNumberOf = new JLabel("<html><div style=\"text-align:right\">Minimal number<br/>of names </div></html>");
        panel.add((Component)lblMinimalNumberOf, "2, 6, center, default");
        this.spinnerMinimalNumberOfNames = new JSpinner();
        this.spinnerMinimalNumberOfNames.setModel(new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1)));
        panel.add((Component)this.spinnerMinimalNumberOfNames, "4, 6");
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HomonymReportInputWindow.this.dispose();
            }
        });
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int nrParts = (Integer)HomonymReportInputWindow.this.spinnerNumberOfNameParts.getValue();
                    int maxCount = (Integer)HomonymReportInputWindow.this.spinnerMinimalNumberOfNames.getValue();
                    lastNrPartsValue = nrParts;
                    lastMaxCountValue = maxCount;
                    Report report = StatisticsReporter.reportHomonyms(netGUI.getSegmentation(), nrParts, maxCount);
                    netGUI.addReportTab(report);
                    HomonymReportInputWindow.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(HomonymReportInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
        this.spinnerMinimalNumberOfNames.setValue(lastMaxCountValue);
        this.spinnerNumberOfNameParts.setValue(lastNrPartsValue);
    }
}

