/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.workers.AddChildRolesCriteria;
import org.tip.puck.net.workers.AttributeDescriptors;

public class AddChildRolesInputDialog
extends JDialog {
    private static final long serialVersionUID = -5603095480035489834L;
    private static final Logger logger = LoggerFactory.getLogger(AddChildRolesInputDialog.class);
    private RelationModels relationModels;
    private AttributeDescriptors attributeDescriptors;
    private final JPanel contentPanel = new JPanel();
    private AddChildRolesCriteria dialogCriteria;
    private static AddChildRolesCriteria lastCriteria = new AddChildRolesCriteria();
    private JComboBox cmbbxRelationModel;
    private JComboBox cmbbxEgoRole;
    private JComboBox cmbbxDateLabel;
    private JSpinner spnnrMaxAge;
    private JButton okButton;
    private JPanel alterRolesPanel;

    public AddChildRolesInputDialog(RelationModels relationModels, AttributeDescriptors attributeDescriptors) {
        this.relationModels = relationModels;
        this.attributeDescriptors = attributeDescriptors;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Add Child Roles Input Dialog");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(AddChildRolesInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AddChildRolesInputDialog.this.dialogCriteria = null;
                AddChildRolesInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 420, 376);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(100dlu;default):grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(100dlu;default):grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblRelationModel = new JLabel("Relation Model:");
        this.contentPanel.add((Component)lblRelationModel, "2, 2, right, default");
        this.cmbbxRelationModel = new JComboBox<Object>(relationModels.nameList().toArray());
        this.cmbbxRelationModel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    AddChildRolesInputDialog.this.setRelationModel(AddChildRolesInputDialog.this.cmbbxRelationModel.getSelectedIndex(), null, null);
                }
            }
        });
        this.contentPanel.add((Component)this.cmbbxRelationModel, "4, 2, fill, default");
        JLabel lblEgoRole = new JLabel("Ego Role:");
        this.contentPanel.add((Component)lblEgoRole, "2, 4, right, default");
        this.cmbbxEgoRole = new JComboBox();
        this.contentPanel.add((Component)this.cmbbxEgoRole, "4, 4, fill, default");
        JLabel lblAlterRoles = new JLabel("Alter Roles:");
        this.contentPanel.add((Component)lblAlterRoles, "2, 6, right, top");
        JScrollPane alterRolesScrollPane = new JScrollPane();
        alterRolesScrollPane.setVerticalScrollBarPolicy(22);
        this.contentPanel.add((Component)alterRolesScrollPane, "4, 6, fill, fill");
        this.alterRolesPanel = new JPanel();
        alterRolesScrollPane.setViewportView(this.alterRolesPanel);
        this.alterRolesPanel.setLayout(new BoxLayout(this.alterRolesPanel, 1));
        JLabel lblDateLabel = new JLabel("Date Label:");
        this.contentPanel.add((Component)lblDateLabel, "2, 8, right, default");
        this.cmbbxDateLabel = new JComboBox();
        this.contentPanel.add((Component)this.cmbbxDateLabel, "4, 8, fill, default");
        JLabel lblMaxAge = new JLabel("Max Age:");
        this.contentPanel.add((Component)lblMaxAge, "2, 10, right, default");
        this.spnnrMaxAge = new JSpinner();
        this.spnnrMaxAge.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        this.contentPanel.add((Component)this.spnnrMaxAge, "4, 10");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddChildRolesInputDialog.this.dialogCriteria = null;
                AddChildRolesInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.okButton = new JButton("Launch");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddChildRolesCriteria criteria = AddChildRolesInputDialog.this.getCriteria();
                if (criteria.getRelationModelName() == null) {
                    String title = "Invalid input";
                    String message = "A relation model is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else if (criteria.getEgoRoleName() == null) {
                    String title = "Invalid input";
                    String message = "An ego role is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else if (criteria.getAlterRoleNames().isEmpty()) {
                    String title = "Invalid input";
                    String message = "Almost one alter role is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else if (criteria.getDateLabel() == null) {
                    String title = "Invalid input";
                    String message = "A valid date label is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    AddChildRolesInputDialog.this.dialogCriteria = criteria;
                    AddChildRolesInputDialog.this.setVisible(false);
                }
            }
        });
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setCriteria(lastCriteria);
    }

    public AddChildRolesCriteria getCriteria() {
        int currentEgoRoleIndex;
        AddChildRolesCriteria result = new AddChildRolesCriteria();
        int currentRelationModelIndex = this.cmbbxRelationModel.getSelectedIndex();
        if (currentRelationModelIndex != -1) {
            result.setRelationModelName(((RelationModel)this.relationModels.get(currentRelationModelIndex)).getName());
        }
        if ((currentEgoRoleIndex = this.cmbbxEgoRole.getSelectedIndex()) != -1) {
            result.setEgoRoleName(((Role)((RelationModel)this.relationModels.get(currentRelationModelIndex)).roles().get(currentEgoRoleIndex)).getName());
        }
        logger.debug("EgoRoleName=" + result.getEgoRoleName());
        result.getAlterRoleNames().clear();
        Component[] componentArray = this.alterRolesPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (((JCheckBox)component).isSelected()) {
                result.getAlterRoleNames().add((Object)((JCheckBox)component).getText());
            }
            ++n2;
        }
        result.setMaxAge((Integer)this.spnnrMaxAge.getValue());
        int currentDateLabelIndex = this.cmbbxDateLabel.getSelectedIndex();
        if (currentDateLabelIndex != -1) {
            result.setDateLabel(this.attributeDescriptors.findByRelationModelName(((RelationModel)this.relationModels.get(currentRelationModelIndex)).getName()).sort().getByIndex(currentDateLabelIndex).getLabel());
        }
        logger.debug(result.toString());
        return result;
    }

    public AddChildRolesCriteria getDialogCriteria() {
        AddChildRolesCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(AddChildRolesCriteria source) {
        if (source != null) {
            if (this.relationModels.isEmpty()) {
                this.cmbbxRelationModel.setEnabled(false);
                this.cmbbxEgoRole.setEnabled(false);
                this.cmbbxDateLabel.setEnabled(false);
            } else {
                this.cmbbxRelationModel.setEnabled(true);
                this.cmbbxEgoRole.setEnabled(true);
                this.cmbbxDateLabel.setEnabled(true);
                RelationModel currentRelationModel = this.relationModels.getByName(source.getRelationModelName());
                if (currentRelationModel == null) {
                    currentRelationModel = (RelationModel)this.relationModels.get(0);
                }
                this.setRelationModel(this.relationModels.indexOf(currentRelationModel), source.getEgoRoleName(), source.getDateLabel());
            }
        }
    }

    private void setRelationModel(int currentRelationModelIndex, String egoRoleName, String dateLabel) {
        RelationModel currentRelationModel = (RelationModel)this.relationModels.get(currentRelationModelIndex);
        if (currentRelationModel.roles().isEmpty()) {
            this.cmbbxEgoRole.setEnabled(false);
            this.cmbbxDateLabel.setEnabled(false);
        } else {
            this.cmbbxEgoRole.setModel(new DefaultComboBoxModel<Object>(currentRelationModel.roles().toNameList().toArray()));
            Role currentEgoRole = currentRelationModel.roles().getByName(egoRoleName);
            if (currentEgoRole == null) {
                currentEgoRole = (Role)currentRelationModel.roles().get(0);
            }
            this.cmbbxEgoRole.setSelectedIndex(currentRelationModel.roles().indexOf(currentEgoRole));
            this.alterRolesPanel.removeAll();
            for (Role role : currentRelationModel.roles()) {
                this.alterRolesPanel.add(new JCheckBox(role.getName()));
            }
            StringList currentLabels = this.attributeDescriptors.findByRelationModelName(currentRelationModel.getName()).labels().sort();
            if (currentLabels.isEmpty()) {
                this.cmbbxDateLabel.setEnabled(false);
            } else {
                this.cmbbxDateLabel.setModel(new DefaultComboBoxModel<Object>(currentLabels.toArray()));
                int currentDateLabelIndex = currentLabels.indexOf((Object)dateLabel);
                if (currentDateLabelIndex == -1) {
                    currentDateLabelIndex = 0;
                }
                this.cmbbxDateLabel.setSelectedIndex(currentDateLabelIndex);
            }
        }
    }

    public static void main(String[] args) {
        AddChildRolesInputDialog.showDialog(null, null);
    }

    public static AddChildRolesCriteria showDialog(RelationModels relationModels, AttributeDescriptors attributeDescriptors) {
        AddChildRolesInputDialog dialog = new AddChildRolesInputDialog(relationModels, attributeDescriptors);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        AddChildRolesCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

