/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckgui.util.ImageTransferable;

public class GUIToolBox {
    private static final Logger logger = LoggerFactory.getLogger(GUIToolBox.class);

    public static List<String> availableLookAndFeels() {
        ArrayList<String> result = new ArrayList<String>();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
            result.add(info.getName());
            ++n2;
        }
        return result;
    }

    public static void copyToClipboard(Image source) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard != null) {
            ImageTransferable selection = new ImageTransferable(source);
            clipboard.setContents(selection, null);
        }
    }

    public static BufferedImage crop(BufferedImage source) {
        BufferedImage result;
        if (source == null) {
            result = null;
        } else {
            int lastLine;
            int lastColumn;
            int firstColumn;
            int firstLine = 0;
            while (firstLine < source.getHeight() && GUIToolBox.isWhiteLine(source, firstLine)) {
                ++firstLine;
            }
            if (firstLine == source.getHeight()) {
                firstLine = 0;
                firstColumn = 0;
                lastColumn = source.getWidth() - 1;
                lastLine = source.getHeight() - 1;
            } else {
                lastLine = source.getHeight() - 1;
                while (firstLine > 0 && GUIToolBox.isWhiteLine(source, lastLine)) {
                    --lastLine;
                }
                firstColumn = 0;
                while (firstColumn < source.getWidth() && GUIToolBox.isWhiteColumn(source, firstColumn)) {
                    ++firstColumn;
                }
                lastColumn = source.getWidth() - 1;
                while (lastColumn > 0 && GUIToolBox.isWhiteColumn(source, lastColumn)) {
                    --lastColumn;
                }
            }
            result = new BufferedImage(lastColumn - firstColumn + 1, lastLine - firstLine + 1, 2);
            result.getGraphics().drawImage(source, -firstColumn, -firstLine, null);
        }
        return result;
    }

    public static boolean isWhiteColumn(BufferedImage source, int column) {
        int line = 0;
        boolean ended = false;
        boolean result = false;
        while (!ended) {
            if (line < source.getHeight()) {
                if (source.getRGB(column, line) == Color.white.getRGB()) {
                    ++line;
                    continue;
                }
                ended = true;
                result = false;
                continue;
            }
            ended = true;
            result = true;
        }
        return result;
    }

    public static boolean isWhiteLine(BufferedImage source, int line) {
        int column = 0;
        boolean ended = false;
        boolean result = false;
        while (!ended) {
            if (column < source.getWidth()) {
                if (source.getRGB(column, line) == Color.white.getRGB()) {
                    ++column;
                    continue;
                }
                ended = true;
                result = false;
                continue;
            }
            ended = true;
            result = true;
        }
        return result;
    }

    public static void saveScreenshot(Component source, File target) throws IOException {
        BufferedImage targetImage = GUIToolBox.crop(GUIToolBox.takeScreenshot(source));
        ImageIO.write((RenderedImage)targetImage, "png", target);
    }

    public static BufferedImage takeScreenshot(Component source) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), 1);
        Graphics2D imageGraphics = result.createGraphics();
        source.paint(imageGraphics);
        return result;
    }
}

