/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import java.util.List;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.report.Report;
import org.tip.puck.util.Chronometer;

public class RelationModelReporter {
    private RelationModelReporter() {
    }

    public static Report reportControl(RelationModel model, ControlType controlType) {
        Report result;
        switch (controlType) {
            case GENERAL_CHECK: {
                result = RelationModelReporter.reportGeneral(model);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static Report reportControls(RelationModel model) {
        Chronometer chrono = new Chronometer();
        Report report = RelationModelReporter.reportControls(model, ControlType.values());
        Report result = new Report("Problems");
        result.outputs().appendln("Relation Model " + model.getName());
        result.outputs().appendln();
        result.outputs().append(report.outputs());
        if (report.status() == 0) {
            result.outputs().appendln("No problems found.");
        }
        result.setStatus(report.status());
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportControls(RelationModel model, ControlType ... controlTypes) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Checks for possible undefinedRoles (special features).");
        result.setOrigin("Relation Model Reporter");
        result.setTarget(model.getName());
        ControlType[] controlTypeArray = controlTypes;
        int n = controlTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ControlType type = controlTypeArray[n2];
            result.inputs().add(type.toString(), "true");
            ++n2;
        }
        int problemCount = 0;
        ControlType[] controlTypeArray2 = controlTypes;
        int n3 = controlTypes.length;
        n = 0;
        while (n < n3) {
            ControlType controlType = controlTypeArray2[n];
            Report report = RelationModelReporter.reportControl(model, controlType);
            if (report != null && report.status() != 0) {
                problemCount += report.status();
                result.outputs().append(report.outputs());
                result.outputs().appendln();
            }
            ++n;
        }
        result.setStatus(problemCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportControls(RelationModel model, List<ControlType> controls) {
        Report result = RelationModelReporter.reportControls(model, controls.toArray(new ControlType[0]));
        return result;
    }

    public static Report reportGeneral(RelationModel model) {
        Chronometer chrono = new Chronometer();
        Report result = new Report("General");
        result.outputs().appendln("General control of " + model.getName());
        result.outputs().appendln();
        result.setStatus(0);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static enum ControlType {
        GENERAL_CHECK;

    }
}

