/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.roles.RoleRelationMaker;
import org.tip.puck.net.relations.roles.RoleRelations;

public class RelationModel {
    private String name;
    private Roles roles;
    private RoleRelations roleRelations;
    private List<RoleRelationMaker.RoleRelationRule> rules;

    public RelationModel(RelationModel source) {
        this.name = source.getName();
        this.roles = new Roles(source.roles());
    }

    public RelationModel(String name) {
        this.name = name;
        this.roles = new Roles();
    }

    public RelationModel(String name, List<RoleRelationMaker.RoleRelationRule> rules) {
        this.name = name;
        this.roles = new Roles();
        this.rules = rules;
    }

    public String getName() {
        return this.name;
    }

    public Role role(Individual indi) {
        Role result;
        if (indi == null) {
            result = null;
        } else {
            result = this.roles.getByName(indi.getName());
            if (result == null) {
                result = new Role(indi.getName());
                this.roles.add(result);
            }
        }
        return result;
    }

    public Role role(String item) {
        Role result;
        if (StringUtils.isEmpty((CharSequence)item)) {
            result = null;
        } else {
            String roleName = item.trim();
            result = this.roles.getByName(roleName);
            if (result == null) {
                result = new Role(roleName);
                this.roles.add(result);
            }
        }
        return result;
    }

    public Roles roles() {
        return this.roles;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RoleRelations getRoleRelations() {
        return this.roleRelations;
    }

    public void setRoleRelations(RoleRelations roleRelations) {
        this.roleRelations = roleRelations;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        boolean result = this.name.equals(((RelationModel)obj).getName());
        return result;
    }

    public List<RoleRelationMaker.RoleRelationRule> getRules() {
        return this.rules;
    }
}

