/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.iur;

import java.io.File;
import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckManager;
import org.tip.puck.io.iur.IURDetector;
import org.tip.puck.io.iur.IURODSFile;
import org.tip.puck.io.iur.IURTXTFile;
import org.tip.puck.io.iur.IURXLSFile;
import org.tip.puck.net.Net;

public class IURFile {
    private static final Logger logger = LoggerFactory.getLogger(IURFile.class);

    public static boolean isIUR(File source) {
        boolean result = IURFile.isIUR(source, PuckManager.DEFAULT_CHARSET_NAME);
        return result;
    }

    public static boolean isIUR(File source, String charsetName) {
        boolean result = IURDetector.isIUR(source, charsetName);
        return result;
    }

    public static Net load(File source, String charsetName) throws PuckException {
        Net result;
        if (source == null) {
            throw new InvalidParameterException("Null parameter");
        }
        String fileName = source.getName().toLowerCase();
        if (fileName.endsWith(".ods")) {
            result = IURODSFile.load(source);
        } else if (fileName.endsWith(".txt")) {
            result = IURTXTFile.load(source, charsetName);
        } else if (fileName.endsWith(".xls")) {
            result = IURXLSFile.load(source);
        } else {
            throw new InvalidParameterException("Unknown extension.");
        }
        return result;
    }

    public static void save(File target, Net source) throws PuckException {
        if (source == null) {
            throw new InvalidParameterException("Null parameter");
        }
        String fileName = target.getName().toLowerCase();
        if (fileName.endsWith(".ods")) {
            IURODSFile.save(target, source);
        } else if (fileName.endsWith(".txt")) {
            IURTXTFile.save(target, source);
        } else if (fileName.endsWith(".xls")) {
            IURXLSFile.save(target, source);
        } else {
            throw new InvalidParameterException("Unknown extension.");
        }
    }
}

