/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.evo;

import java.io.IOException;
import java.io.OutputStreamWriter;
import org.tip.puck.evo.GPNodeDynStatus;
import org.tip.puck.evo.GPNodeType;
import org.tip.puck.evo.ProgSet;

public class GPNode {
    public GPNodeType type;
    public double val;
    public int var;
    public int fun;
    public int arity;
    public GPNode[] params = new GPNode[4];
    public double curval;
    protected GPNode parent;
    public int curpos;
    public int stoppos;
    public int condpos;
    public int branching;
    public GPNodeDynStatus dynStatus;
    public int evals;
    public int lastEval;

    public void initVal(double val, GPNode parent) {
        this.type = GPNodeType.VAL;
        this.parent = parent;
        this.val = val;
        this.arity = 0;
        this.condpos = -1;
        this.stoppos = 0;
        this.dynStatus = GPNodeDynStatus.UNUSED;
    }

    public void initVar(int var, GPNode parent) {
        this.type = GPNodeType.VAR;
        this.parent = parent;
        this.var = var;
        this.arity = 0;
        this.condpos = -1;
        this.stoppos = 0;
        this.dynStatus = GPNodeDynStatus.UNUSED;
    }

    public void initFun(int fun, GPNode parent) {
        this.type = GPNodeType.FUN;
        this.parent = parent;
        this.fun = fun;
        this.arity = this.funArity(fun);
        this.condpos = this.funCondPos(fun);
        this.stoppos = this.arity;
        this.dynStatus = GPNodeDynStatus.UNUSED;
    }

    private int funCondPos(int fun) {
        switch (fun) {
            case 7: {
                return 1;
            }
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
        }
        return -1;
    }

    private int funArity(int fun) {
        switch (fun) {
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
        }
        return 0;
    }

    public void write(OutputStreamWriter out, ProgSet progSet, boolean evalStats) throws IOException {
        if (this.type == GPNodeType.VAL) {
            out.write("" + this.val);
        } else if (this.type == GPNodeType.VAR) {
            out.write("$" + progSet.getVariableNames().get(this.var));
        } else if (this.type == GPNodeType.FUN) {
            switch (this.fun) {
                case 0: {
                    out.write("+");
                    break;
                }
                case 1: {
                    out.write("-");
                    break;
                }
                case 2: {
                    out.write("*");
                    break;
                }
                case 3: {
                    out.write("/");
                    break;
                }
                case 7: {
                    out.write("ZER");
                    break;
                }
                case 4: {
                    out.write("==");
                    break;
                }
                case 5: {
                    out.write(">");
                    break;
                }
                case 6: {
                    out.write("<");
                    break;
                }
                case 8: {
                    out.write("EXP");
                    break;
                }
                case 9: {
                    out.write("LOG");
                    break;
                }
                case 10: {
                    out.write("ABS");
                    break;
                }
                case 11: {
                    out.write("MIN");
                    break;
                }
                case 12: {
                    out.write("MAX");
                    break;
                }
                case 13: {
                    out.write("ODD");
                    break;
                }
                default: {
                    out.write("F??");
                    break;
                }
            }
        } else {
            out.write("???");
        }
        if (evalStats) {
            out.write(" " + this.evals + " " + this.lastEval);
        }
    }
}

