/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInformation {
    private static final Logger logger = LoggerFactory.getLogger(BuildInformation.class);
    private static String BUILD_INFORMATION_FILE = "/build_information.properties";
    private String productName;
    private String majorRevision;
    private String minorRevision;
    private String buildNumber;
    private String buildDate;
    private String generator;
    private String author;

    public BuildInformation() {
        Properties build = new Properties();
        try {
            build.load(BuildInformation.class.getResource(BUILD_INFORMATION_FILE).openStream());
            this.productName = build.getProperty("product.name", "n/a");
            this.majorRevision = build.getProperty("product.revision.major", "n/a");
            this.minorRevision = build.getProperty("product.revision.minor", "n/a");
            this.buildNumber = build.getProperty("product.revision.build", "n/a");
            this.buildDate = build.getProperty("product.revision.date", "n/a");
            this.generator = build.getProperty("product.revision.generator", "n/a");
            this.author = build.getProperty("product.revision.author", "n/a");
        }
        catch (IOException exception) {
            logger.error("Error loading the build.properties file: " + exception.getMessage());
            logger.error(ExceptionUtils.getStackTrace((Throwable)exception));
            this.productName = "n/a";
            this.majorRevision = "n/a";
            this.minorRevision = "n/a";
            this.buildNumber = "n/a";
            this.buildDate = "n/a";
            this.generator = "n/a";
            this.author = "n/a";
        }
    }

    public String author() {
        return this.author;
    }

    public String buildDate() {
        return this.buildDate;
    }

    public String buildNumber() {
        return this.buildNumber;
    }

    public String generator() {
        return this.generator;
    }

    public String majorRevision() {
        return this.majorRevision;
    }

    public String minorRevision() {
        return this.minorRevision;
    }

    public String productName() {
        return this.productName;
    }

    public String toString() {
        String result = String.format("%s %s.%s.%s built on %s by %s", this.productName, this.majorRevision, this.minorRevision, this.buildNumber, this.buildDate, this.author);
        return result;
    }

    public String version() {
        String result = String.format("%s.%s.%s", this.majorRevision, this.minorRevision, this.buildNumber);
        return result;
    }

    public static boolean isDefined() {
        boolean result = BuildInformation.class.getResource(BUILD_INFORMATION_FILE) != null;
        return result;
    }
}

