/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences;

import java.util.ArrayList;
import java.util.List;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Populatable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.sequences.EgoSequences;
import org.tip.puck.sequences.Ordinal;
import org.tip.puck.sequences.Sequenceable;
import org.tip.puck.sequences.Sequenceables;
import org.tip.puck.sequences.workers.SequenceCriteria;
import org.tip.puck.sequences.workers.SequenceMaker;
import org.tip.puck.util.NumberablesHashMap;

public class Sequences<S extends Sequenceable<E>, E>
extends NumberablesHashMap<S>
implements Sequenceables<S, E> {
    String label;

    public Sequences() {
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isPopulatable() {
        boolean result = false;
        for (Sequenceable sequence : this) {
            for (Object station : sequence.getStations().values()) {
                if (station == null) continue;
                if (station instanceof Populatable) {
                    result = true;
                }
                return result;
            }
        }
        return result;
    }

    public Sequences(List<S> sequences) {
        for (Sequenceable sequence : sequences) {
            this.add(sequence);
        }
    }

    @Override
    public Individuals getIndividuals(Segmentation segmentation) throws PuckException {
        Individuals result = new Individuals();
        for (Sequenceable sequence : this) {
            if (sequence instanceof Populatable) {
                for (Individual individual : ((Populatable)((Object)sequence)).getIndividuals()) {
                    if (!segmentation.getCurrentIndividuals().contains(individual)) continue;
                    result.add(individual);
                }
                continue;
            }
            throw PuckExceptions.INVALID_PARAMETER.create(sequence + " is not populatable", new Object[0]);
        }
        return result;
    }

    @Override
    public Individuals getIndividuals() throws PuckException {
        Individuals result = new Individuals();
        for (Sequenceable sequence : this) {
            if (sequence instanceof Populatable) {
                for (Individual individual : ((Populatable)((Object)sequence)).getIndividuals()) {
                    result.add(individual);
                }
                continue;
            }
            throw PuckExceptions.INVALID_PARAMETER.create(sequence + " is not populatable", new Object[0]);
        }
        return result;
    }

    public EgoSequences getIndividualStateSequences(Segmentation segmentation, SequenceCriteria criteria) throws PuckException {
        EgoSequences result = new EgoSequences();
        for (Individual member : this.getIndividuals(segmentation).toSortedList()) {
            result.put(SequenceMaker.createPersonalStateSequence(member, criteria));
        }
        return result;
    }

    @Override
    public List<E> getStations(Ordinal time) {
        ArrayList result = new ArrayList();
        for (Sequenceable sequence : this) {
            result.add(sequence.getStation(time));
        }
        return result;
    }

    public void addRenumbered(S sequence) {
        sequence.setId(this.size());
        this.add(sequence);
    }
}

