/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.partitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Value;

public class MultiPartition<E> {
    Integer sum = 0;
    Map<Value, Integer> rowSums;
    Map<Value, Integer> colSums;
    private String label;
    Map<Value, Partition<E>> rows = new HashMap<Value, Partition<E>>();
    List<Value> colValues = new ArrayList<Value>();

    public MultiPartition() {
        this.rowSums = new HashMap<Value, Integer>();
        this.colSums = new HashMap<Value, Integer>();
    }

    public void put(Partition<E> partition, Value value1) {
        this.rows.put(value1, partition);
        for (Cluster<E> cluster : partition.getClusters()) {
            Value colValue = cluster.getValue();
            if (this.colValues.contains(colValue)) continue;
            this.colValues.add(cluster.getValue());
        }
    }

    public List<Value> rowValues() {
        ArrayList<Value> result = new ArrayList<Value>(this.rows.keySet());
        return result;
    }

    public Collection<Value> sortedRowValues() {
        List<Value> result = this.rowValues();
        Collections.sort(result);
        return result;
    }

    public Collection<Value> rowValuesSortedBySize() {
        List<Value> result = this.rowValues();
        Collections.sort(result, Collections.reverseOrder(new PartitionComparator(this)));
        return result;
    }

    public Collection<Value> sortedColValues() {
        List result = (List)this.colValues();
        Collections.sort(result);
        return result;
    }

    public Collection<Value> colValues() {
        return this.colValues;
    }

    public Cluster<E> getCluster(Value value1, Value value2) {
        return this.rows.get(value1).getCluster(value2);
    }

    public Partition<E> getRow(Value value1) {
        return this.rows.get(value1);
    }

    public int colSum(Value colValue) {
        Integer colSum = this.colSums.get(colValue);
        int result = colSum == null ? 0 : colSum;
        return result;
    }

    public int rowSum(Value rowValue) {
        Integer rowSum = this.rowSums.get(rowValue);
        int result = rowSum == null ? 0 : rowSum;
        return result;
    }

    public int colCount() {
        return this.colValues.size();
    }

    public int rowCount() {
        return this.rows.size();
    }

    public void count() {
        for (Value rowValue : this.rowValues()) {
            Partition<E> partition = this.rows.get(rowValue);
            int rowSum = partition.clusteredItemsCount();
            this.rowSums.put(rowValue, rowSum);
            this.sum = this.sum + rowSum;
            for (Cluster<E> cluster : partition.getClusters()) {
                Value colValue = cluster.getValue();
                int colSum = this.colSum(colValue) + cluster.count();
                this.colSums.put(colValue, colSum);
            }
        }
    }

    public int frequency(Value value1, Value value2) {
        Cluster<E> cluster = this.getCluster(value1, value2);
        int result = cluster == null ? 0 : cluster.count();
        return result;
    }

    public double rowPercentage(Value value1, Value value2) {
        return MathUtils.percent(this.frequency(value1, value2), this.rowSums.get(value1));
    }

    public double colPercentage(Value value1, Value value2) {
        return MathUtils.percent(this.frequency(value1, value2), this.colSums.get(value2));
    }

    public int sum() {
        int result = this.sum == null ? 0 : this.sum;
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Value getColValue(int i) {
        return this.colValues.get(i);
    }

    class PartitionComparator<E>
    implements Comparator<Value> {
        MultiPartition<E> partitions;

        public PartitionComparator(MultiPartition<E> partitions) {
            this.partitions = partitions;
        }

        @Override
        public int compare(Value first, Value second) {
            return new Integer(this.partitions.getRow(first).itemsCount()).compareTo(this.partitions.getRow(second).itemsCount());
        }
    }
}

