/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.params;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.tip.puck.params.Param;
import org.tip.puck.params.ParamException;

public class Params {
    private Map<String, Param> params = new HashMap<String, Param>();

    public void addParam(String name, Param param) {
        this.params.put(name, param);
    }

    public Param getParam(String name) throws ParamException {
        if (!this.paramExists(name)) {
            throw new ParamException("Param: '" + name + "' does not exist.");
        }
        return this.params.get(name);
    }

    public boolean paramExists(String name) {
        return this.params.containsKey(name);
    }

    public static Params load(String filePath) throws NumberFormatException, IOException {
        String strLine;
        Params newParams = new Params();
        FileInputStream fstream = new FileInputStream(filePath);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((strLine = br.readLine()) != null) {
            String[] tokens = strLine.split(" ");
            if (tokens.length == 2) {
                double value = Double.parseDouble(tokens[1]);
                Param param = new Param(value);
                newParams.addParam(tokens[0], param);
                continue;
            }
            if (tokens.length != 3) continue;
            double minValue = Double.parseDouble(tokens[1]);
            double maxValue = Double.parseDouble(tokens[2]);
            Param param = new Param(minValue, maxValue);
            newParams.addParam(tokens[0], param);
        }
        in.close();
        return newParams;
    }
}

