/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tip.puck.net.Individual;
import org.tip.puck.net.KinType;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.workers.RelationValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.ToolBox;

public class RelationEnvironment {
    private Individual ego;
    private String egoRoleName;
    private List<String> roleNames;
    private List<String> relationModelNames;
    private Map<Individual, List<String>> relationsByAlter;
    private Map<String, Set<Individual>> altersByRoles;
    private Map<Individual, List<String>> rolesByAlter;
    private Map<Individual, List<Relation>> eventsByAlter;
    private Map<Integer, List<Individual>> coverage;
    private List<String> impersonalRelations;
    private String impersonalLabel = "NOHOST";
    private int threshold;

    public RelationEnvironment(Collection<Relation> stations, Individual ego, String egoRoleName, List<String> roleNames, List<String> relationModelNames) {
        this.ego = ego;
        this.egoRoleName = egoRoleName;
        this.roleNames = roleNames;
        this.relationModelNames = relationModelNames;
        this.altersByRoles = new HashMap<String, Set<Individual>>();
        this.altersByRoles.put("ALL", new HashSet());
        this.altersByRoles.put("SELECTED", new HashSet());
        for (String alterRoleName : roleNames) {
            this.altersByRoles.put(alterRoleName, new HashSet());
        }
        this.rolesByAlter = new HashMap<Individual, List<String>>();
        this.eventsByAlter = new HashMap<Individual, List<Relation>>();
        this.coverage = new TreeMap<Integer, List<Individual>>();
        for (Relation station : stations) {
            if (!station.hasRole(ego, egoRoleName)) continue;
            if (RelationValuator.isBirth(station)) {
                for (Individual parent : ego.getParents()) {
                    if (station.getIndividuals().contains(parent)) continue;
                    station.actors().add(new Actor(parent, new Role("OTHER")));
                }
            }
            for (Actor actor : station.actors()) {
                List<String> roleNameList;
                Individual alter = actor.getIndividual();
                String roleName = actor.getRole().getName();
                if (roleName.equals(egoRoleName) && alter == ego) continue;
                this.altersByRoles.get("ALL").add(alter);
                if (!this.altersByRoles.containsKey(roleName)) {
                    this.altersByRoles.put(roleName, new HashSet());
                }
                this.altersByRoles.get(actor.getRole().getName()).add(alter);
                if (roleNames.contains(roleName)) {
                    this.altersByRoles.get("SELECTED").add(alter);
                }
                if ((roleNameList = this.rolesByAlter.get(alter)) == null) {
                    roleNameList = new ArrayList<String>();
                    this.rolesByAlter.put(alter, roleNameList);
                }
                roleNameList.add(roleName);
                List<Relation> eventList = this.eventsByAlter.get(alter);
                if (eventList == null) {
                    eventList = new ArrayList<Relation>();
                    this.eventsByAlter.put(alter, eventList);
                }
                if (eventList.contains(station)) continue;
                eventList.add(station);
            }
        }
        for (Individual alter : this.eventsByAlter.keySet()) {
            Integer cov = this.eventsByAlter.get(alter).size();
            List<Individual> list = this.coverage.get(cov);
            if (list == null) {
                list = new ArrayList<Individual>();
                this.coverage.put(cov, list);
            }
            if (list.contains(alter)) continue;
            list.add(alter);
        }
    }

    public void setAlterRelations(Collection<Relation> stations, Individual ego, String egoRoleName, String alterRoleName, List<String> relationModelNames, String pattern, String chainClassification) {
        this.relationsByAlter = NetUtils.getAlterRelations1(ego, this.altersByRoles.get(alterRoleName), ToolBox.stringsToInts(pattern), relationModelNames, chainClassification, null, null);
        this.impersonalRelations = new ArrayList<String>();
        for (Relation event : stations) {
            String impersonalRelation = this.impersonalRelation(event);
            if (impersonalRelation == null) continue;
            this.impersonalRelations.add(impersonalRelation);
        }
        KinType[] kinTypeArray = KinType.values();
        int n = kinTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KinType kinType = kinTypeArray[n2];
            for (Individual alter : ego.getKin(kinType)) {
                if (this.relationsByAlter.get(alter) != null) continue;
                ArrayList<String> list = new ArrayList<String>();
                list.add(kinType.toString());
                this.relationsByAlter.put(alter, list);
            }
            ++n2;
        }
    }

    public String impersonalRelation(Relation event) {
        String result = null;
        Actor egoActor = event.actors().get(this.ego.getId(), this.egoRoleName);
        if (egoActor != null && egoActor.attributes() != null) {
            result = egoActor.getAttributeValue(this.impersonalLabel);
        }
        return result;
    }

    public Set<Individual> getAltersByRole(String roleName) {
        Set<Individual> result = this.altersByRoles.get(roleName);
        return result;
    }

    public List<String> getRelationsByRole(String roleName) {
        ArrayList<String> result = new ArrayList<String>();
        for (Individual alter : this.altersByRoles.get(roleName)) {
            if (this.relationsByAlter.get(alter).size() == 0) {
                result.add("UNKNOWN");
                System.err.println("Unknown relation of " + this.ego + " to " + roleName + " " + alter);
                continue;
            }
            for (String relation : this.relationsByAlter.get(alter)) {
                if (result.contains(relation)) continue;
                result.add(relation);
            }
        }
        return result;
    }

    public Integer getMaxCoverage() {
        Integer result = this.coverage.size() > 0 ? (Integer)((TreeMap)this.coverage).lastKey() : Integer.valueOf(0);
        return result;
    }

    public List<Individual> getMaxCoverageAlters() {
        List<Individual> result = this.coverage.size() > 1 ? this.coverage.get(this.getMaxCoverage()) : new ArrayList<Individual>();
        return result;
    }

    public List<String> getMaxCoverageRelations() {
        ArrayList<String> relations = new ArrayList<String>();
        for (Individual alter : this.getMaxCoverageAlters()) {
            for (String relation : this.relationsByAlter.get(alter)) {
                if (relations.contains(relation)) continue;
                relations.add(relation);
            }
        }
        return relations;
    }

    public double getMeanCoverage() {
        double result = 0.0;
        if (this.coverage.size() > 0) {
            double sum = 0.0;
            for (int i : this.coverage.keySet()) {
                result += (double)i;
                sum += 1.0;
            }
            result = MathUtils.percent(result, sum);
        }
        return result;
    }

    public List<String> getImpersonalRelations() {
        return this.impersonalRelations;
    }

    public Set<Individual> getAllAlters() {
        return this.altersByRoles.get("ALL");
    }

    public Map<Individual, List<String>> getRelationsByAlter() {
        return this.relationsByAlter;
    }

    public List<String> getRelationsByAlter(Individual alter) {
        return this.relationsByAlter.get(alter);
    }

    public List<String> getRolessByAlter(Individual alter) {
        return this.rolesByAlter.get(alter);
    }

    public String getEgoRoleName() {
        return this.egoRoleName;
    }

    public List<String> getRoleNames() {
        return this.roleNames;
    }

    public Individual getEgo() {
        return this.ego;
    }

    public List<String> getRelationModelNames() {
        return this.relationModelNames;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

