/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Links;
import org.tip.puck.graphs.Nodes;
import org.tip.puck.graphs.RootedLinks;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;

public class Node<E>
implements Comparable<Node<E>> {
    public static final int NO_ID = -1;
    private int id;
    private E referent;
    private String tag;
    private double weight;
    private double secondWeight;
    private Attributes attributes;
    private RootedLinks<E> edges;
    private RootedLinks<E> outArcs;
    private RootedLinks<E> inArcs;
    private String label;

    public Node(int id, E referent) {
        this.id = id;
        this.referent = referent;
        this.outArcs = new RootedLinks(this);
        this.inArcs = new RootedLinks(this);
        this.edges = new RootedLinks(this);
    }

    public double addArcWeight(Node<E> otherNode, double value) {
        Link<E> link = this.outArcs.getLinkWith(otherNode);
        if (link == null) {
            link = this.addArcWith(otherNode);
        }
        double result = link.addWeight(value);
        return result;
    }

    public Link<E> addArcWith(Node<E> otherNode) {
        Link<E> result = this.addArcWith(otherNode, 0.0);
        return result;
    }

    public Link<E> addArcWith(Node<E> otherNode, double weight) {
        Link<E> result = new Link<E>(this, otherNode, Link.LinkType.ARC, weight);
        this.outArcs.add(result);
        otherNode.getInArcs().add(result);
        return result;
    }

    public double addEdgeWeight(Node<E> otherNode, double value) {
        Link<E> link = this.getEdgeWith(otherNode);
        if (link == null) {
            link = this.addEdgeWith(otherNode);
        }
        double result = link.addWeight(value);
        return result;
    }

    public Link<E> addEdgeWith(Node<E> otherNode) {
        Link<E> result = this.addEdgeWith(otherNode, 0.0);
        return result;
    }

    public Link<E> addEdgeWith(Node<E> otherNode, double weight) {
        Link<E> result = new Link<E>(this, otherNode, Link.LinkType.EDGE, weight);
        this.edges.add(result);
        if (otherNode != this) {
            otherNode.getEdges().add(result);
        }
        return result;
    }

    public Nodes<E> getAllNeighbors(Nodes<E> nodes, int limit) {
        HashMap result = new HashMap();
        Nodes<E> interior = new Nodes<E>();
        Nodes ego = new Nodes();
        ego.add(this);
        result.put(0, ego);
        int i = 1;
        while (i <= limit) {
            Nodes<E> neighbors = new Nodes<E>();
            Nodes<E> source = i < limit ? ((Nodes)result.get(i - 1)).getDirectNeighbors() : nodes;
            for (Node<E> neighbor : source) {
                if (interior.contains(neighbor)) continue;
                neighbors.add(neighbor);
                interior.add(neighbor);
            }
            result.put(i, neighbors);
            ++i;
        }
        return interior;
    }

    public double getArcWeight(Node<E> otherNode) {
        Link<E> link = this.getArcWith(otherNode);
        double result = link == null ? 0.0 : link.getWeight();
        return result;
    }

    public Link<E> getArcWith(Node<E> otherNode) {
        Link<E> result = this.outArcs.getLinkWith(otherNode);
        return result;
    }

    public int getDegree() {
        return this.getLinks().size();
    }

    public int getDegreeWithoutLoops() {
        int result = 0;
        for (Link link : this.getLinks()) {
            if (link.isLoop()) continue;
            ++result;
        }
        return result;
    }

    public Nodes<E> getInNodes() {
        Nodes result = new Nodes();
        for (Link link : this.getInLinks()) {
            result.add(link.getOtherNode(this));
        }
        return result;
    }

    public Nodes<E> getOtherNodes() {
        Nodes result = new Nodes();
        for (Link link : this.getLinks()) {
            result.add(link.getOtherNode(this));
        }
        return result;
    }

    public int tieCountWithoutLoops() {
        int result = this.getDirectNeighbors().size();
        return result;
    }

    public int tieCount() {
        int result = this.getOtherNodes().size();
        return result;
    }

    public Nodes<E> getDirectNeighbors() {
        Nodes result = new Nodes();
        for (Link link : this.getLinks()) {
            Node other = link.getOtherNode(this);
            if (other == this) continue;
            result.add(other);
        }
        return result;
    }

    public Nodes<E> getOutNodes() {
        Nodes result = new Nodes();
        for (Link link : this.getOutLinks()) {
            result.add(link.getOtherNode(this));
        }
        return result;
    }

    public int getEdgeDegree() {
        return this.getEdges().size();
    }

    public double getEdgeForce() {
        double result = 0.0;
        for (Link<E> edge : this.getEdges()) {
            result += edge.getWeight();
        }
        return result;
    }

    public RootedLinks<E> getEdges() {
        return this.edges;
    }

    public double getEdgeWeight(Node<E> otherNode) {
        Link<E> link = this.getEdgeWith(otherNode);
        double result = link == null ? 0.0 : link.getWeight();
        return result;
    }

    public Link<E> getEdgeWith(Node<E> otherNode) {
        Link<E> result = this.edges.getLinkWith(otherNode);
        return result;
    }

    public double getForce() {
        double result = 0.0;
        for (Link link : this.getLinks()) {
            result += link.getWeight();
        }
        return result;
    }

    public int getId() {
        return this.id;
    }

    public RootedLinks<E> getInArcs() {
        return this.inArcs;
    }

    public RootedLinks<E> getInArcsByTag(String pattern) {
        RootedLinks<E> result = new RootedLinks<E>(this);
        for (Link<E> arc : this.inArcs) {
            for (String tag : arc.getTags()) {
                if (!StringUtils.equals((CharSequence)tag, (CharSequence)pattern)) continue;
                result.add(arc);
            }
        }
        return result;
    }

    public RootedLinks<E> getOutArcsByTag(String pattern) {
        RootedLinks<E> result = new RootedLinks<E>(this);
        for (Link<E> arc : this.outArcs) {
            for (String tag : arc.getTags()) {
                if (!StringUtils.equals((CharSequence)tag, (CharSequence)pattern)) continue;
                result.add(arc);
            }
        }
        return result;
    }

    public int getInDegree() {
        return this.inArcs.size();
    }

    public RootedLinks<E> getInferiorEdges() {
        RootedLinks<E> result = new RootedLinks<E>(this);
        for (Link<E> edge : this.edges) {
            if (edge.getOtherNode(this).getId() < this.getId()) continue;
            result.add(edge);
        }
        return result;
    }

    public double getInForce() {
        double result = 0.0;
        for (Link<E> arc : this.getInArcs()) {
            result += arc.getWeight();
        }
        return result;
    }

    public Links<E> getInLinks() {
        Links<Link<E>> result = new Links<Link<E>>();
        result.addAll(this.inArcs.getLinks());
        result.addAll(this.edges.getLinks());
        return result;
    }

    public String getLabel() {
        String result = this.label != null ? this.label : (this.referent == null ? "node " + this.id : this.referent.toString());
        return result;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        String result = this.getLabel();
        if (result == null && this.referent != null) {
            result = this.referent.toString();
        }
        return result;
    }

    public Links<E> getLinks() {
        Links<Link<E>> result = new Links<Link<E>>();
        result.addAll(this.inArcs.getLinks());
        for (Link<E> outArc : this.outArcs.getLinks()) {
            if (result.contains(outArc)) continue;
            result.add(outArc);
        }
        result.addAll(this.edges.getLinks());
        return result;
    }

    public int getLoopDegree() {
        Link<E> loop = this.getLoopLink();
        int result = loop == null ? 0 : 1;
        return result;
    }

    public double getLoopForce() {
        Link<E> loop = this.getLoopLink();
        double result = loop == null ? 0.0 : loop.getWeight();
        return result;
    }

    public Link<E> getLoopLink() {
        boolean ended = false;
        int linkIndex = 0;
        Links<E> links = this.getOutLinks();
        Link result = null;
        while (!ended) {
            if (linkIndex < links.size()) {
                Link link = (Link)links.get(linkIndex);
                if (link.isLoop()) {
                    ended = true;
                    result = link;
                    continue;
                }
                ++linkIndex;
                continue;
            }
            ended = true;
            result = null;
        }
        return result;
    }

    public Double getMaxLinkWeight() {
        Double result;
        Links<E> links = this.getLinks();
        if (links.isEmpty()) {
            result = null;
        } else {
            result = Double.MIN_NORMAL;
            for (Link link : links) {
                if (!(link.getWeight() > result)) continue;
                result = link.getWeight();
            }
        }
        return result;
    }

    public Map<Integer, Nodes<E>> getNeighbors(Nodes<E> nodes, int limit) {
        HashMap<Integer, Nodes<E>> result = new HashMap<Integer, Nodes<E>>();
        int i = 0;
        while (i < limit) {
            if (i == 0) {
                result.put(0, new Nodes());
                ((Nodes)result.get(0)).add(this);
            } else if (i < limit) {
                result.put(i, ((Nodes)result.get(i - 1)).getDirectNeighbors());
            }
            ++i;
        }
        return result;
    }

    public boolean[] getNeighborStatus(Node<E> neighbor, int limit) {
        boolean[] result = new boolean[limit];
        Nodes<E> source = new Nodes<E>();
        source.add(this);
        int i = 0;
        while (i < limit) {
            if (source.contains(neighbor)) {
                result[i] = true;
            }
            source = source.getDirectNeighbors();
            ++i;
        }
        return result;
    }

    public RootedLinks<E> getOutArcs() {
        return this.outArcs;
    }

    public int getOutDegree() {
        return this.outArcs.size();
    }

    public double getOutForce() {
        double result = 0.0;
        for (Link<E> arc : this.getOutArcs()) {
            result += arc.getWeight();
        }
        return result;
    }

    public double getForceBalance() {
        return this.getInForce() - this.getOutForce();
    }

    public Links<E> getOutLinks() {
        Links<Link<E>> result = new Links<Link<E>>();
        result.addAll(this.outArcs.getLinks());
        result.addAll(this.edges.getLinks());
        return result;
    }

    public E getReferent() {
        return this.referent;
    }

    public double getSecondWeight() {
        return this.secondWeight;
    }

    public String getTag() {
        return this.tag;
    }

    public double getWeight() {
        return this.weight;
    }

    public double incArcWeight(Node<E> otherNode) {
        double result = this.addArcWeight(otherNode, 1.0);
        return result;
    }

    public double incWeight() {
        double result = this.incWeight(1.0);
        return result;
    }

    public double incWeight(double value) {
        this.weight += value;
        double result = this.weight;
        return result;
    }

    public double incEdgeWeight(Node<E> otherNode) {
        double result = this.addEdgeWeight(otherNode, 1.0);
        return result;
    }

    public void setArcWeight(Node<E> otherNode, double weight) {
        Link<E> link = this.getArcWith(otherNode);
        if (link == null) {
            link = this.addArcWith(otherNode);
        }
        link.setWeight(weight);
    }

    public void setEdgeWeight(Node<E> otherNode, double weight) {
        Link<E> link = this.getEdgeWith(otherNode);
        if (link == null) {
            link = this.addEdgeWith(otherNode);
        }
        link.setWeight(weight);
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setReferent(E referent) {
        this.referent = referent;
    }

    public void setSecondWeight(double secondWeight) {
        this.secondWeight = secondWeight;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public int compareTo(Node<E> other) {
        int result = other == null ? 1 : new Integer(this.getId()).compareTo(other.getId());
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = obj != null && this.getId() == ((Node)obj).getId();
        return result;
    }

    public void setAttribute(String label, String value) {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        this.attributes().put(label, value);
    }

    public Attributes attributes() {
        return this.attributes;
    }

    public String getAttributeValue(String label) {
        Attribute attribute;
        String result = this.attributes == null ? null : ((attribute = (Attribute)this.attributes().get(label)) == null ? null : attribute.getValue());
        return result;
    }

    public void removeLinksToNode(Node<E> node) {
        this.inArcs.removeLinkToNode(node);
        this.outArcs.removeLinkToNode(node);
        this.edges.removeLinkToNode(node);
    }

    public double getOrientation() {
        double inStrength = this.getInForce();
        double outStrength = this.getOutForce();
        double result = (inStrength - outStrength) / (inStrength + outStrength);
        return result;
    }

    public double getMaxInWeight() {
        double result = 0.0;
        for (Link<E> arc : this.getInArcs()) {
            double weight = arc.getWeight();
            if (!(weight > result)) continue;
            result = weight;
        }
        return result;
    }

    public double getMaxOutWeight() {
        double result = 0.0;
        for (Link<E> arc : this.getOutArcs()) {
            double weight = arc.getWeight();
            if (!(weight > result)) continue;
            result = weight;
        }
        return result;
    }

    public Nodes<E> getMaxPredecessors() {
        Nodes<E> result = new Nodes<E>();
        double maxWeight = 0.0;
        for (Link<E> arc : this.getInArcs()) {
            double weight = arc.getWeight();
            if (weight > maxWeight) {
                result = new Nodes();
                maxWeight = weight;
            }
            if (!(weight >= maxWeight)) continue;
            result.add(arc.getOtherNode(this));
            maxWeight = weight;
        }
        return result;
    }

    public Nodes<E> getMaxSuccessors() {
        Nodes<E> result = new Nodes<E>();
        double maxWeight = 0.0;
        for (Link<E> arc : this.getOutArcs()) {
            double weight = arc.getWeight();
            if (weight > maxWeight) {
                result = new Nodes();
                maxWeight = weight;
            }
            if (!(weight >= maxWeight)) continue;
            result.add(arc.getOtherNode(this));
            maxWeight = weight;
        }
        return result;
    }
}

