/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.generators;

import java.util.HashMap;
import java.util.Map;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;

public class PGraphNode {
    private Individual wife;
    private Individual husband;
    private PGraphNode wifeLink;
    private PGraphNode husbandLink;
    private Family family;
    private Map<PGraphNode, Integer> descendants;
    private Map<PGraphNode, Integer> originalDescendants;
    private int outDegree;
    private int outDegreeF;
    private int outDegreeM;

    public PGraphNode(Individual wife, Individual husband, PGraphNode wifeLink, PGraphNode husbandLink) {
        this.wife = wife;
        this.husband = husband;
        this.wifeLink = wifeLink;
        this.husbandLink = husbandLink;
        this.descendants = new HashMap<PGraphNode, Integer>();
        this.outDegree = 0;
    }

    public PGraphNode(Individual wife, Individual husband) {
        this(wife, husband, null, null);
    }

    public Family getFamily() {
        return this.family;
    }

    public PGraphNode(Family family) {
        this(family.getWife(), family.getHusband());
        this.family = family;
    }

    public PGraphNode(Individual individual) {
        this(null, null);
        if (individual.isFemale()) {
            this.wife = individual;
        } else {
            this.husband = individual;
        }
    }

    public PGraphNode(PGraphNode m) {
        this(m.wife, m.husband, m.wifeLink, m.husbandLink);
    }

    public void addDescendant(PGraphNode origin, int distance) {
        if (this.wifeLink != null) {
            this.wifeLink.addDescendant(origin, distance + 1);
        }
        if (this.husbandLink != null) {
            this.husbandLink.addDescendant(origin, distance + 1);
        }
        if (this == origin) {
            return;
        }
        if (this.descendants.containsKey(origin)) {
            Integer curDistance = this.descendants.get(origin);
            if (curDistance > distance) {
                this.descendants.put(origin, distance);
            }
        } else {
            this.descendants.put(origin, distance);
        }
    }

    public void clearDescendants() {
        this.descendants.clear();
    }

    public void storeOriginalDescendants() {
        this.originalDescendants = new HashMap<PGraphNode, Integer>(this.descendants);
    }

    public int generationalDistance(PGraphNode m) {
        if (this == m) {
            return 0;
        }
        if (this.descendants.containsKey(m)) {
            return this.descendants.get(m);
        }
        return -1;
    }

    public int originalGenerationalDistance(PGraphNode m) {
        if (this == m) {
            return 0;
        }
        if (this.originalDescendants.containsKey(m)) {
            return this.originalDescendants.get(m);
        }
        return -1;
    }

    public boolean hasDescendant(PGraphNode m) {
        return this.descendants.containsKey(m);
    }

    public double distance(PGraphNode m) {
        double dist = 0.0;
        if (this.wifeLink != m.wifeLink) {
            dist += 0.5;
        }
        if (this.husbandLink != m.husbandLink) {
            dist += 0.5;
        }
        return dist;
    }

    public void incOutDegree() {
        ++this.outDegree;
    }

    public int numberOfDescendants() {
        return this.descendants.size();
    }

    public String hashKey() {
        String wifeStr = "?";
        String husbandStr = "?";
        if (this.wife != null) {
            wifeStr = "" + this.wife.getId();
        }
        if (this.husband != null) {
            husbandStr = "" + this.husband.getId();
        }
        return String.valueOf(wifeStr) + " [+] " + husbandStr;
    }

    public String toString() {
        String wifeStr = "?";
        String husbandStr = "?";
        if (this.wife != null) {
            wifeStr = "" + this.wife.getId();
        }
        if (this.husband != null) {
            husbandStr = "" + this.husband.getId();
        }
        return String.valueOf(wifeStr) + " [+] " + husbandStr;
    }

    public Individual getWife() {
        return this.wife;
    }

    public void setWife(Individual wife) {
        this.wife = wife;
    }

    public Individual getHusband() {
        return this.husband;
    }

    public void setHusband(Individual husband) {
        this.husband = husband;
    }

    public PGraphNode getWifeLink() {
        return this.wifeLink;
    }

    public void setWifeLink(PGraphNode wifeLink) {
        this.wifeLink = wifeLink;
    }

    public PGraphNode getHusbandLink() {
        return this.husbandLink;
    }

    public void setHusbandLink(PGraphNode husbandLink) {
        this.husbandLink = husbandLink;
    }

    public Map<PGraphNode, Integer> getDescendants() {
        return this.descendants;
    }

    public int getOutDegree() {
        return this.outDegree;
    }

    public int getOutDegreeF() {
        return this.outDegreeF;
    }

    public void incOutDegreeF() {
        ++this.outDegreeF;
    }

    public int getOutDegreeM() {
        return this.outDegreeM;
    }

    public void incOutDegreeM() {
        ++this.outDegreeM;
    }
}

