/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck;

import java.text.MessageFormat;
import org.tip.puck.PuckException;
import org.tip.puck.util.ExceptionUtil;

public enum PuckExceptions {
    FORMAT_CONFLICT(10, "BAR/IUR format conflict."),
    OVERFLOW(9, "Limit exceeded."),
    UNRESOLVED_KIN(8, "Unresolved kin."),
    UNSUPPORTED_FILE_FORMAT(7, "Unsupported file format."),
    NOT_A_FILE(6, "The target is not file."),
    UNSUPPORTED_ENCODING(5, "Unsupported Encoding."),
    FILE_NOT_FOUND(4, "File not found."),
    IO_ERROR(3, "Input/Output error."),
    BAD_FILE_FORMAT(2, "Bad file format."),
    INVALID_PARAMETER(1, "Invalid parameter.");

    private int code;
    private String message;

    private PuckExceptions(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public PuckException create() {
        PuckException result = this.create(null, "", new Object[0]);
        return result;
    }

    public PuckException create(Exception exception) {
        PuckException result = this.create(exception, "", new Object[0]);
        return result;
    }

    public PuckException create(Exception exception, String format, Object ... arguments) {
        String extendedMessage = MessageFormat.format(String.valueOf(this.message) + " " + format, arguments);
        PuckException result = PuckException.getInstance(ExceptionUtil.getCaller(((Object)((Object)this)).getClass().getName()), this.code, extendedMessage, exception);
        return result;
    }

    public PuckException create(String format, Object ... values) {
        PuckException result = this.create(null, format, values);
        return result;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static PuckExceptions valueOf(String string) {
        return Enum.valueOf(PuckExceptions.class, string);
    }
}

